/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.cache;

import com.igumnov.common.Strings;
import com.igumnov.common.cache.CacheInterface;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCache
implements CacheInterface {
    private static JedisPool jedisPool;
    private static double cacheDefaultTTL;

    public void init(double defaultTTL, String host, int port) {
        cacheDefaultTTL = defaultTTL;
        jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port);
    }

    @Override
    public Object put(String key, Object value, double ttl, String ... tag) {
        try (Jedis jedis = jedisPool.getResource();){
            try {
                jedis.set(key, Strings.serializeObject((Serializable)value));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (ttl != 0.0) {
                jedis.expireAt(key, System.currentTimeMillis() / 1000L + (long)ttl);
            }
            if (tag != null) {
                for (String t : tag) {
                    jedis.sadd(t, new String[]{key});
                }
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Object get(String key) {
        Throwable throwable = null;
        try (Jedis jedis = jedisPool.getResource();){
            String val = jedis.get(key);
            try {
                if (val != null) {
                    Object object = Strings.deserializeObject(val);
                    return object;
                }
                Object var5_7 = null;
                return var5_7;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void removeByTag(String tag) {
        try (Jedis jedis = jedisPool.getResource();){
            Set keys = jedis.smembers(tag);
            String[] strs = new String[keys.size()];
            int i = 0;
            for (String key : keys) {
                jedis.del(key);
                strs[i] = key;
                ++i;
            }
            if (i > 0) {
                jedis.srem(tag, strs);
            }
        }
    }

    @Override
    public Object remove(String key) {
        try (Jedis jedis = jedisPool.getResource();){
            String ret = jedis.get(key);
            jedis.del(key);
            if (ret != null) {
                try {
                    Object object = Strings.deserializeObject(ret);
                    return object;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object var5_8 = null;
            return var5_8;
        }
    }

    @Override
    public Object put(String key, Object value, String ... tag) {
        return this.put(key, value, cacheDefaultTTL, tag);
    }
}

