/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.cache;

import com.igumnov.common.Task;
import com.igumnov.common.cache.CacheInterface;
import com.igumnov.common.cache.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MemoryCache
implements CacheInterface {
    private Map<String, Value> cache = new HashMap<String, Value>();
    private Map<String, HashSet<String>> cacheTag = new HashMap<String, HashSet<String>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Queue<Value> queue = new LinkedList<Value>();
    private Queue<Value> queueExpired = new ConcurrentLinkedQueue<Value>();
    private int cacheSize;
    private double cacheDefaultTTL;

    public void init(int size, double defaultTTL) {
        this.cacheSize = size;
        this.cacheDefaultTTL = defaultTTL;
        Task.schedule(() -> {
            while (!this.queueExpired.isEmpty()) {
                this.remove(this.queueExpired.poll().getKey());
            }
        }, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value, double ttl, String ... tag) {
        Value obj = new Value();
        double objTTL = ttl == 0.0 ? this.cacheDefaultTTL : ttl;
        obj.setObject(value);
        for (String t : tag) {
            obj.getTags().add(t);
        }
        obj.setExpireBy((long)(objTTL * 1000.0) + System.currentTimeMillis());
        obj.setKey(key);
        try {
            this.lock.writeLock().lock();
            if (this.cache.get(key) == null) {
                this.queue.add(obj);
            }
            this.cache.put(key, obj);
            for (String t : obj.getTags()) {
                HashSet<String> tagList = this.cacheTag.get(t);
                if (tagList == null) {
                    tagList = new HashSet();
                    this.cacheTag.put(t, tagList);
                }
                tagList.add(key);
            }
            if (this.queue.size() > this.cacheSize) {
                this.delete(this.queue.poll());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    private void delete(Value obj) {
        if (!obj.isRemoved()) {
            this.cache.remove(obj.getKey());
            for (String tag : obj.getTags()) {
                HashSet<String> objs = this.cacheTag.get(tag);
                if (objs == null) continue;
                objs.remove(obj.getKey());
                if (objs.size() != 0) continue;
                this.cacheTag.remove(tag);
            }
            obj.setRemoved(true);
        }
    }

    @Override
    public Object get(String key) {
        Value ret = null;
        try {
            this.lock.readLock().lock();
            ret = this.cache.get(key);
            if (ret != null && ret.getExpireBy() < System.currentTimeMillis()) {
                this.queueExpired.add(ret);
                ret = null;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (ret == null) {
            return null;
        }
        return ret.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByTag(String tag) {
        try {
            this.lock.writeLock().lock();
            LinkedList<Value> deleteList = new LinkedList<Value>();
            HashSet<String> objects = this.cacheTag.get(tag);
            if (objects != null) {
                for (String object : objects) {
                    Value obj = this.cache.get(object);
                    if (obj == null) continue;
                    deleteList.push(obj);
                }
                for (Value value : deleteList) {
                    this.delete(value);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(String key) {
        Object ret = null;
        try {
            this.lock.writeLock().lock();
            Value obj = this.cache.get(key);
            if (obj != null) {
                this.delete(obj);
                ret = obj.getObject();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return ret;
    }

    @Override
    public Object put(String key, Object value, String ... tag) {
        return this.put(key, value, 0.0, tag);
    }
}

