/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.reflection.ReflectionException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Reflection {
    public static ArrayList<String> getClassNamesFromPackage(String packageName) throws IOException, URISyntaxException {
        ArrayList<String> names;
        block3: {
            URL packageURL;
            block4: {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                names = new ArrayList<String>();
                packageURL = classLoader.getResource(packageName = packageName.replace(".", "/"));
                if (packageURL == null) break block3;
                if (!packageURL.getProtocol().equals("jar")) break block4;
                String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
                JarFile jf = new JarFile(jarFileName);
                Enumeration<JarEntry> jarEntries = jf.entries();
                while (jarEntries.hasMoreElements()) {
                    String entryName = jarEntries.nextElement().getName();
                    if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() + 5) continue;
                    entryName = entryName.substring(packageName.length(), entryName.lastIndexOf(46));
                    names.add(entryName);
                }
                break block3;
            }
            URI uri = new URI(packageURL.toString());
            File folder = new File(uri.getPath());
            File[] contenuti = folder.listFiles();
            if (contenuti == null) break block3;
            for (File actual : contenuti) {
                String entryName = actual.getName();
                if (entryName.lastIndexOf(46) != -1) {
                    entryName = entryName.substring(0, entryName.lastIndexOf(46));
                    names.add(packageName.replace("/", ".") + "." + entryName);
                    continue;
                }
                ArrayList<String> ret = Reflection.getClassNamesFromPackage(packageName.replace("/", ".") + "." + entryName);
                names.addAll(ret);
            }
        }
        return names;
    }

    public static void setField(Object object, String fieldName, Object value) throws IllegalAccessException, ReflectionException {
        boolean noField = true;
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            field.set(object, value);
            noField = false;
        }
        if (noField) {
            throw new ReflectionException("No field");
        }
    }

    public static Object getFieldValue(Object object, String fieldName) throws IllegalAccessException, ReflectionException {
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            return field.get(object);
        }
        throw new ReflectionException("No field");
    }

    public static String stackTraceToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

