/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.Dependency;
import com.igumnov.common.File;
import com.igumnov.common.Log;
import com.igumnov.common.dependency.DependencyException;
import com.igumnov.common.orm.DDLHistory;
import com.igumnov.common.orm.Transaction;
import com.igumnov.common.reflection.ReflectionException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.dbcp2.BasicDataSource;

public class ORM {
    private static BasicDataSource ds;

    public static void connectionPool(String driverClass, String url, String user, String password, int minPoolSize, int maxPoolSize) throws DependencyException {
        ds = new BasicDataSource();
        ds.setDriverClassName(driverClass);
        ds.setUrl(url);
        if (user != null) {
            ds.setUsername(user);
            ds.setPassword(password);
        }
        ds.setInitialSize(minPoolSize);
        ds.setMaxTotal(maxPoolSize);
        Dependency.bind("dataSource", ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyDDL(String sqlFolder) throws SQLException, IOException, ReflectionException, IllegalAccessException, InstantiationException {
        Connection con = null;
        int i = 1;
        ResultSet tables = null;
        try {
            block23: {
                con = ds.getConnection();
                DatabaseMetaData dbm = con.getMetaData();
                tables = dbm.getTables(null, null, "DDLHISTORY", null);
                if (tables.next()) {
                    ArrayList<Object> ret = ORM.findBy("true order by id desc limit 1", DDLHistory.class, new Object[0]);
                    i = 1 + ((DDLHistory)ret.get(0)).getId();
                } else {
                    ResultSet tables2 = null;
                    try {
                        tables2 = dbm.getTables(null, null, "DDLHistory", null);
                        if (tables2.next()) {
                            ArrayList<Object> ret = ORM.findBy("true order by id desc limit 1", DDLHistory.class, new Object[0]);
                            i = 1 + ((DDLHistory)ret.get(0)).getId();
                            break block23;
                        }
                        try (Statement stmt = null;){
                            stmt = con.createStatement();
                            String sql = "CREATE TABLE DDLHistory (id INT PRIMARY KEY, applyDate DATE)";
                            stmt.execute(sql);
                            Log.debug(sql);
                        }
                    }
                    finally {
                        if (tables2 != null) {
                            tables.close();
                        }
                    }
                }
            }
            tables.close();
        }
        finally {
            if (con != null) {
                con.close();
            }
            if (tables != null) {
                tables.close();
            }
        }
        try {
            while (true) {
                Connection c = ds.getConnection();
                try {
                    c.setAutoCommit(false);
                    File.readLines(sqlFolder + "/" + i + ".sql").forEach(line -> {
                        Statement stmt = null;
                        try {
                            stmt = c.createStatement();
                            Log.debug(line);
                            stmt.execute((String)line);
                        }
                        catch (SQLException e) {
                            Log.error("SQL error: ", e);
                        }
                        finally {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (Exception e) {
                                Log.error("SQL error: ", e);
                            }
                        }
                    });
                    c.commit();
                    DDLHistory ddl = new DDLHistory();
                    ddl.setId(i);
                    ddl.setApplyDate(new Date());
                    ORM.insert(ddl);
                }
                finally {
                    if (c != null) {
                        c.setAutoCommit(true);
                        c.close();
                    }
                }
                ++i;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return;
        }
    }

    public static Transaction beginTransaction() throws SQLException {
        return new Transaction(ds.getConnection());
    }

    public static Object update(Object obj) throws IllegalAccessException, SQLException {
        Transaction tx = ORM.beginTransaction();
        Object ret = tx.update(obj);
        tx.commit();
        return ret;
    }

    public static Object insert(Object obj) throws IllegalAccessException, SQLException, ReflectionException {
        Transaction tx = ORM.beginTransaction();
        Object ret = tx.insert(obj);
        tx.commit();
        return ret;
    }

    public static ArrayList<Object> findBy(String where, Class classObject, Object ... params) throws SQLException, IllegalAccessException, InstantiationException, ReflectionException, IOException {
        Transaction tx = ORM.beginTransaction();
        ArrayList<Object> ret = tx.findBy(where, classObject, params);
        tx.commit();
        return ret;
    }

    public static Object findOne(Class className, Object primaryKey) throws SQLException, ReflectionException, InstantiationException, IllegalAccessException, IOException {
        Transaction tx = ORM.beginTransaction();
        Object ret = tx.findOne(className, primaryKey);
        tx.commit();
        return ret;
    }

    public static int deleteBy(String where, Class classObject, Object ... params) throws SQLException {
        Transaction tx = ORM.beginTransaction();
        int ret = tx.deleteBy(where, classObject, params);
        tx.commit();
        return ret;
    }

    public static ArrayList<HashMap<String, Object>> selectQuery(String sqlQuery, Object ... params) throws SQLException {
        Transaction tx = ORM.beginTransaction();
        ArrayList<HashMap<String, Object>> ret = tx.selectQuery(sqlQuery, params);
        tx.commit();
        return ret;
    }

    public static int delete(Object obj) throws IllegalAccessException, SQLException {
        Transaction tx = ORM.beginTransaction();
        int ret = tx.delete(obj);
        tx.commit();
        return ret;
    }

    public static ArrayList<Object> findAll(Class classObject) throws SQLException, ReflectionException, InstantiationException, IllegalAccessException, IOException {
        Transaction tx = ORM.beginTransaction();
        ArrayList<Object> ret = tx.findAll(classObject);
        tx.commit();
        return ret;
    }
}

