/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.File;
import com.igumnov.common.Reflection;
import java.io.IOException;
import java.util.Date;

public class Log {
    public static final int TRACE = 0;
    public static final int DEBUG = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int ERROR = 4;
    private static int logLevel = 3;
    private static boolean stdout = true;
    private static String file = null;

    public static void setLogLevel(int l) {
        logLevel = l;
    }

    public static void disableStdout() {
        stdout = false;
    }

    public static void file(String fileName) {
        file = fileName;
    }

    public static void info(String message) {
        if (logLevel <= 3) {
            Log.out(message, 3);
        }
    }

    public static void error(String message) {
        if (logLevel <= 4) {
            Log.out(message, 4);
        }
    }

    public static void trace(String message) {
        if (logLevel <= 0) {
            Log.out(message, 0);
        }
    }

    public static void debug(String message) {
        if (logLevel <= 1) {
            Log.out(message, 1);
        }
    }

    public static void warn(String message) {
        if (logLevel <= 2) {
            Log.out(message, 2);
        }
    }

    public static void info(String message, Exception e) {
        if (logLevel <= 3) {
            Log.out(message + " " + Reflection.stackTraceToString(e), 3);
        }
    }

    public static void error(String message, Exception e) {
        if (logLevel <= 4) {
            Log.out(message + " " + Reflection.stackTraceToString(e), 4);
        }
    }

    public static void trace(String message, Exception e) {
        if (logLevel <= 0) {
            Log.out(message + " " + Reflection.stackTraceToString(e), 0);
        }
    }

    public static void debug(String message, Exception e) {
        if (logLevel <= 1) {
            Log.out(message + " " + Reflection.stackTraceToString(e), 1);
        }
    }

    public static void warn(String message, Exception e) {
        if (logLevel <= 2) {
            Log.out(message + " " + Reflection.stackTraceToString(e), 2);
        }
    }

    private static void out(String message, int level) {
        String levelTxt;
        switch (level) {
            case 1: {
                levelTxt = "DEBUG";
                break;
            }
            case 0: {
                levelTxt = "TRACE";
                break;
            }
            case 3: {
                levelTxt = "INFO";
                break;
            }
            case 4: {
                levelTxt = "ERROR";
                break;
            }
            case 2: {
                levelTxt = "WARN";
                break;
            }
            default: {
                levelTxt = "UNKNOWN";
            }
        }
        String line = new Date() + " " + levelTxt + " " + message;
        if (stdout) {
            System.out.println(line);
        }
        if (file != null) {
            try {
                File.appendLine(line, file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

