/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.webserver;

import com.igumnov.common.JSON;
import com.igumnov.common.webserver.RestControllerInterface;
import com.igumnov.common.webserver.RestControllerSimpleInterface;
import com.igumnov.common.webserver.WebServerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestControllerHandler
extends HttpServlet {
    private RestControllerInterface restController;
    private RestControllerSimpleInterface restControllerSimple;
    private Class postBody;

    public RestControllerHandler(RestControllerSimpleInterface i) {
        this.restControllerSimple = i;
    }

    public RestControllerHandler(RestControllerInterface i, Class pb) {
        this.restController = i;
        this.postBody = pb;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object postObject = null;
        Object responseObj = null;
        int status = 200;
        if (request.getMethod().equals("POST") || request.getMethod().equals("PUT")) {
            StringBuilder jb = new StringBuilder();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                responseObj = e;
                status = 400;
            }
            postObject = JSON.parse(jb.toString(), this.postBody);
        }
        try {
            responseObj = this.restController != null ? this.restController.response(request, postObject) : this.restControllerSimple.response(request);
        }
        catch (WebServerException e) {
            responseObj = e;
            status = 400;
        }
        String ret = JSON.toString(responseObj);
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(status);
        PrintWriter out = response.getWriter();
        out.write(ret);
    }
}

