/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.webserver;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.thymeleaf.Arguments;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;

public class MessageResolver
implements IMessageResolver {
    private Properties properties = new Properties();

    public MessageResolver(String fileName) throws IOException {
        FileInputStream input = new FileInputStream(fileName);
        this.properties.load(input);
    }

    public String getName() {
        return "WebServer Message Resolver";
    }

    public Integer getOrder() {
        return 1;
    }

    public MessageResolution resolveMessage(Arguments arguments, String key, Object[] messageParameters) {
        String messageValue = this.properties.getProperty(key);
        if (messageValue == null) {
            return null;
        }
        if (messageParameters == null || messageParameters.length == 0) {
            return new MessageResolution(messageValue);
        }
        MessageFormat messageFormat = new MessageFormat(messageValue);
        return new MessageResolution(messageFormat.format(messageParameters));
    }

    public void initialize() {
    }
}

