/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.webserver;

import com.igumnov.common.webserver.ControllerContext;
import com.igumnov.common.webserver.ControllerInterface;
import com.igumnov.common.webserver.WebServerException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;

public class ControllerHandler
extends HttpServlet {
    private TemplateEngine templateEngine;
    private ControllerInterface controller;

    public ControllerHandler(TemplateEngine t, ControllerInterface c) {
        this.templateEngine = t;
        this.controller = c;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String templateName = null;
        int status = 200;
        try {
            templateName = this.controller.process(request, model);
            if (templateName.startsWith("redirect:")) {
                response.sendRedirect(response.encodeRedirectURL(templateName.substring(9)));
                return;
            }
        }
        catch (WebServerException e) {
            status = 400;
        }
        ControllerContext context = new ControllerContext(model, request.getServletContext());
        String ret = this.templateEngine.process(templateName, (IContext)context);
        response.setContentType("text/html; charset=utf-8");
        response.setStatus(status);
        PrintWriter out = response.getWriter();
        out.write(ret);
    }
}

