/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.time;

import com.igumnov.common.time.TimeException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Timer {
    private long startValue = 0L;
    private long accamulator = 0L;
    private long repeatCount = 0L;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void start() throws TimeException {
        try {
            this.lock.writeLock().lock();
            if (this.startValue != 0L) {
                this.resetValues();
                throw new TimeException("stop should be call before");
            }
            this.startValue = System.nanoTime();
            ++this.repeatCount;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop() throws TimeException {
        try {
            this.lock.writeLock().lock();
            if (this.startValue == 0L) {
                throw new TimeException("startProcedure should be call before");
            }
            long timerStartValueOld = this.startValue;
            long timerAccamulatorOld = this.accamulator;
            this.resetValues();
            long l = TimeUnit.MILLISECONDS.convert(System.nanoTime() - timerStartValueOld + timerAccamulatorOld, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void resetValues() {
        try {
            this.lock.writeLock().lock();
            this.startValue = 0L;
            this.accamulator = 0L;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pause() throws TimeException {
        try {
            this.lock.writeLock().lock();
            if (this.startValue == 0L && this.accamulator == 0L) {
                this.resetValues();
                throw new TimeException("startProcedure should be call before");
            }
            long timerStartValueOld = this.startValue;
            this.startValue = 0L;
            this.accamulator += System.nanoTime() - timerStartValueOld;
            long l = TimeUnit.MILLISECONDS.convert(this.accamulator, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void resume() throws TimeException {
        try {
            this.lock.writeLock().lock();
            if (this.startValue == 0L && this.accamulator == 0L) {
                throw new TimeException("startProcedure should be call before");
            }
            if (this.startValue != 0L && this.accamulator == 0L) {
                throw new TimeException("pause should be call before");
            }
            this.startValue = System.nanoTime();
            ++this.repeatCount;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getRepeatCount() {
        try {
            this.lock.readLock().lock();
            long l = this.repeatCount;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getTotlaTime() {
        try {
            this.lock.readLock().lock();
            long l = TimeUnit.MILLISECONDS.convert(this.accamulator, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getAverageTime() {
        try {
            this.lock.readLock().lock();
            long l = TimeUnit.MILLISECONDS.convert(this.accamulator / this.repeatCount, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

