/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common.orm;

import com.igumnov.common.Log;
import com.igumnov.common.Reflection;
import com.igumnov.common.orm.Id;
import com.igumnov.common.reflection.ReflectionException;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class Transaction {
    private Connection connection;

    public Transaction(Connection c) throws SQLException {
        this.connection = c;
        c.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        try {
            this.connection.commit();
        }
        finally {
            try {
                this.connection.setAutoCommit(false);
            }
            finally {
                this.connection.close();
            }
        }
    }

    public void rollback() throws SQLException {
        try {
            this.connection.rollback();
        }
        finally {
            try {
                this.connection.setAutoCommit(false);
            }
            finally {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object update(Object obj) throws IllegalAccessException, SQLException {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        String pkField = null;
        Object pkFieldValue = null;
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            boolean noAnnotation = true;
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(Id.class)) continue;
                noAnnotation = false;
                pkField = field.getName();
                field.setAccessible(true);
                pkFieldValue = field.get(obj);
            }
            if (!noAnnotation) continue;
            field.setAccessible(true);
            fields.put(field.getName(), field.get(obj));
        }
        Set fieldsSet = fields.keySet();
        String names = fieldsSet.stream().collect(Collectors.joining("=?,", "", "=?"));
        String sql = "update  " + obj.getClass().getSimpleName() + " set " + names + " where " + pkField + "=?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            Iterator it = fieldsSet.iterator();
            int i = 1;
            while (it.hasNext()) {
                Object value = fields.get(it.next());
                preparedStatement.setObject(i, value);
                ++i;
            }
            preparedStatement.setObject(i, pkFieldValue);
            Log.debug(sql);
            preparedStatement.executeUpdate();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insert(Object obj) throws IllegalAccessException, SQLException, ReflectionException {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        boolean autoGenerated = false;
        String autoGeneratedField = null;
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            boolean noAnnotation = true;
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                Boolean autoIncremental;
                if (!annotation.annotationType().equals(Id.class) || !(autoIncremental = Boolean.valueOf(((Id)annotation).autoIncremental())).booleanValue()) continue;
                noAnnotation = false;
                autoGenerated = true;
                autoGeneratedField = field.getName();
            }
            if (!noAnnotation) continue;
            field.setAccessible(true);
            fields.put(field.getName(), field.get(obj));
        }
        Set fieldsSet = fields.keySet();
        String names = fieldsSet.stream().collect(Collectors.joining(","));
        String values = fieldsSet.stream().map(it -> "?").collect(Collectors.joining(","));
        String sql = "insert into " + obj.getClass().getSimpleName() + "(" + names + ") values (" + values + ")";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = !autoGenerated ? this.connection.prepareStatement(sql) : this.connection.prepareStatement(sql, 1);
            Iterator it2 = fieldsSet.iterator();
            int i = 1;
            while (it2.hasNext()) {
                preparedStatement.setObject(i, fields.get(it2.next()));
                ++i;
            }
            Log.debug(sql);
            preparedStatement.executeUpdate();
            if (autoGenerated) {
                ResultSet tableKeys = preparedStatement.getGeneratedKeys();
                tableKeys.next();
                Object autoGeneratedID = tableKeys.getObject(1);
                Reflection.setField(obj, autoGeneratedField, autoGeneratedID);
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Object> findBy(String where, Class classObject, Object ... params) throws SQLException, IllegalAccessException, InstantiationException, ReflectionException, IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        String names = "";
        for (Field field : classObject.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            if (names.length() > 0) {
                names = names + ",";
            }
            names = names + field.getName();
        }
        String sql = where == null ? "select " + names + " from  " + classObject.getSimpleName() : "select " + names + " from  " + classObject.getSimpleName() + " where " + where;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            int i = 1;
            for (Object param : params) {
                preparedStatement.setObject(i, param);
                ++i;
            }
            Log.debug(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object row = classObject.newInstance();
                for (Field field : classObject.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    Object value = resultSet.getObject(field.getName());
                    if (value instanceof Clob) {
                        int intValueOfChar;
                        Reader reader = ((Clob)value).getCharacterStream();
                        String targetString = "";
                        while ((intValueOfChar = reader.read()) != -1) {
                            targetString = targetString + (char)intValueOfChar;
                        }
                        reader.close();
                        Reflection.setField(row, field.getName(), targetString);
                        continue;
                    }
                    Reflection.setField(row, field.getName(), value);
                }
                ret.add(row);
            }
            resultSet.close();
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public Object findOne(Class className, Object primaryKey) throws SQLException, ReflectionException, InstantiationException, IllegalAccessException, IOException {
        String pkName = null;
        for (Field field : className.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(Id.class)) continue;
                pkName = field.getName();
            }
        }
        return this.findBy(pkName + "=?", className, primaryKey).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteBy(String where, Class classObject, Object ... params) throws SQLException {
        String sql = "delete from " + classObject.getSimpleName() + " where " + where;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(sql);
            int i = 1;
            for (Object param : params) {
                preparedStatement.setObject(i, param);
                ++i;
            }
            Log.debug(sql);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int delete(Object obj) throws IllegalAccessException, SQLException {
        String pkName = null;
        Object pkValue = null;
        for (Field field : obj.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(Id.class)) continue;
                pkName = field.getName();
                field.setAccessible(true);
                pkValue = field.get(obj);
            }
        }
        return this.deleteBy(pkName + "=?", obj.getClass(), pkValue);
    }

    public ArrayList<Object> findAll(Class classObject) throws SQLException, ReflectionException, InstantiationException, IllegalAccessException, IOException {
        return this.findBy(null, classObject, new Object[0]);
    }
}

