/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.reflection.ReflectionException;
import com.igumnov.common.webserver.BinaryHandler;
import com.igumnov.common.webserver.BinaryInterface;
import com.igumnov.common.webserver.ControllerHandler;
import com.igumnov.common.webserver.ControllerInterface;
import com.igumnov.common.webserver.MessageResolver;
import com.igumnov.common.webserver.RestControllerHandler;
import com.igumnov.common.webserver.RestControllerInterface;
import com.igumnov.common.webserver.RestControllerSimpleInterface;
import com.igumnov.common.webserver.StringHandler;
import com.igumnov.common.webserver.StringInterface;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;

public class WebServer {
    private static TemplateEngine templateEngine;
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    private static Server server;
    private static ArrayList<ContextHandler> handlers;
    private static String templateFolder;
    private static ServerConnector connector;
    private static ServerConnector https;
    private static ConstraintSecurityHandler securityHandler;
    private static ServletContextHandler servletContext;
    private static HashLoginService loginService;
    private static QueuedThreadPool threadPool;

    private WebServer() {
    }

    public static void setPoolSize(int min, int max) {
        threadPool = new QueuedThreadPool(max, min);
    }

    public static void init(String hostName, int port) {
        server = threadPool != null ? new Server((ThreadPool)threadPool) : new Server();
        connector = new ServerConnector(server);
        connector.setHost(hostName);
        connector.setPort(port);
    }

    public static void https(int port, String keystoreFile, String storePassword, String managerPassword) {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(port);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystoreFile);
        sslContextFactory.setKeyStorePassword(storePassword);
        sslContextFactory.setKeyManagerPassword(managerPassword);
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        https.setPort(port);
    }

    public static void start() throws Exception {
        if (https == null) {
            server.setConnectors(new Connector[]{connector});
        } else {
            server.setConnectors(new Connector[]{connector, https});
        }
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        Handler[] list = new Handler[handlers.size()];
        list = handlers.toArray(list);
        contexts.setHandlers(list);
        server.setHandler((Handler)contexts);
        server.start();
    }

    public static void stop() throws Exception {
        server.stop();
    }

    public static void addHandler(String name, StringInterface i) {
        WebServer.addServlet(new StringHandler(i), name);
    }

    public static void addBinaryHandler(String name, BinaryInterface i) {
        WebServer.addServlet(new BinaryHandler(i), name);
    }

    public static void addRestController(String name, Class c, RestControllerInterface i) {
        WebServer.addServlet(new RestControllerHandler(i, c), name);
    }

    public static void addRestController(String name, RestControllerSimpleInterface i) {
        WebServer.addServlet(new RestControllerHandler(i), name);
    }

    public static void addStaticContentHandler(String name, String folder) {
        ContextHandler context = new ContextHandler();
        context.setContextPath(name);
        ResourceHandler rh = new ResourceHandler();
        rh.setDirectoriesListed(true);
        rh.setResourceBase(folder);
        context.setHandler((Handler)rh);
        handlers.add(context);
    }

    public static void addClassPathHandler(String name, final String classPath) {
        ContextHandler context = new ContextHandler();
        context.setContextPath(name);
        ResourceHandler rh = new ResourceHandler(){

            public Resource getResource(String path) throws MalformedURLException {
                Resource resource = Resource.newClassPathResource((String)path);
                if (resource == null || !resource.exists()) {
                    resource = Resource.newClassPathResource((String)(classPath + path));
                }
                return resource;
            }
        };
        rh.setDirectoriesListed(true);
        rh.setResourceBase("/");
        context.setHandler((Handler)rh);
        handlers.add(context);
    }

    public static void addTemplates(String folder, long cacheTTL, String localeFile) throws IOException {
        templateFolder = folder;
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver();
        templateResolver.setTemplateMode("LEGACYHTML5");
        templateResolver.setPrefix("/");
        templateResolver.setSuffix(".html");
        templateResolver.setCacheTTLMs(Long.valueOf(cacheTTL));
        templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        if (localeFile != null) {
            templateEngine.addMessageResolver((IMessageResolver)new MessageResolver(localeFile));
        }
        templateEngine.addDialect((IDialect)new LayoutDialect());
    }

    public static void addController(String name, ControllerInterface i) {
        WebServer.addServlet(new ControllerHandler(templateEngine, i), name);
    }

    public static void addRestrictRule(String path, String[] roles) {
        Constraint constraint = new Constraint();
        constraint.setName("FORM");
        constraint.setRoles(roles);
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec(path);
        securityHandler.addConstraintMapping(constraintMapping);
    }

    public static void addAllowRule(String path) {
        Constraint constraint = new Constraint();
        constraint.setName("FORM");
        constraint.setAuthenticate(false);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec(path);
        securityHandler.addConstraintMapping(constraintMapping);
    }

    public static void security(final String loginPage, String loginErrorPage, String logoutUrl) {
        securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService((LoginService)loginService);
        FormAuthenticator authenticator = new FormAuthenticator(loginPage, loginErrorPage, false);
        securityHandler.setAuthenticator((Authenticator)authenticator);
        servletContext = new ServletContextHandler(3);
        servletContext.setSecurityHandler((SecurityHandler)securityHandler);
        servletContext.addServlet(new ServletHolder((Servlet)new DefaultServlet(){

            protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                request.getSession().invalidate();
                response.sendRedirect(response.encodeRedirectURL(loginPage));
            }
        }), logoutUrl);
        handlers.add((ContextHandler)servletContext);
    }

    private static void addServlet(HttpServlet s, String name) {
        if (servletContext == null) {
            servletContext = new ServletContextHandler();
        }
        if (templateFolder != null) {
            servletContext.setResourceBase(templateFolder);
        }
        servletContext.addServlet(new ServletHolder((Servlet)s), name);
    }

    public static void addUserWithEncryptedPassword(String username, String password, String[] groups) throws ReflectionException, IllegalAccessException {
        loginService.putUser(username, Credential.Crypt.getCredential((String)password), groups);
    }

    public static void addUser(String username, String password, String[] groups) {
        loginService.putUser(username, Credential.Crypt.getCredential((String)Credential.Crypt.crypt((String)username, (String)password)), groups);
    }

    static {
        handlers = new ArrayList();
        loginService = new HashLoginService();
        threadPool = null;
    }
}

