/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;

public class URL {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";

    public static String getAllToString(String url) throws IOException {
        java.net.URL urlObj = new java.net.URL(url);
        StringBuilder ret = new StringBuilder();
        try (InputStreamReader stream = new InputStreamReader(urlObj.openStream(), "UTF-8");){
            BufferedReader reader = new BufferedReader(stream);
            int c = reader.read();
            while (c != -1) {
                ret.append((char)c);
                c = reader.read();
            }
        }
        return ret.toString();
    }

    public static String getAllToString(String url, String method, Map<String, Object> postParams, String postBody) throws IOException {
        java.net.URL u = new java.net.URL(url);
        StringBuilder postData = new StringBuilder();
        if (postParams != null) {
            for (Map.Entry<String, Object> param : postParams.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
        }
        if (postBody != null) {
            postData.append(postBody);
        }
        byte[] postDataBytes = postData.toString().getBytes("UTF-8");
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder ret = new StringBuilder();
        int c = ((Reader)in).read();
        while (c != -1) {
            ret.append((char)c);
            c = ((Reader)in).read();
        }
        conn.disconnect();
        return ret.toString();
    }
}

