/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Task {
    private static ScheduledExecutorService executorSheduler = Executors.newScheduledThreadPool(10);
    private static int shedulerPoolSize = 10;
    private static ExecutorService executor = Executors.newFixedThreadPool(10);
    private static int poolSize = 10;

    public static Future<?> startProcedure(Runnable procedure) {
        Future<?> future = executor.submit(procedure);
        return future;
    }

    public static Future<Object> startFunction(Callable<Object> function) {
        Future<Object> future = executor.submit(function);
        return future;
    }

    public static void setThreadPoolSize(int size) {
        if (poolSize != size) {
            executor.shutdown();
            executor = Executors.newFixedThreadPool(size);
            poolSize = size;
        }
    }

    public static void setShedulerPoolSize(int size) {
        if (poolSize != size) {
            executorSheduler.shutdown();
            executorSheduler = Executors.newScheduledThreadPool(size);
            shedulerPoolSize = size;
        }
    }

    public static void schedule(Runnable procedure, double repeatAfterSeconds) {
        executorSheduler.schedule(() -> {
            try {
                procedure.run();
            }
            finally {
                Task.schedule(procedure, repeatAfterSeconds);
            }
        }, (long)(repeatAfterSeconds * 1000.0), TimeUnit.MILLISECONDS);
    }
}

