/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;

public class Folder {
    public static void deleteWithContent(String dirName) {
        File folder = new File(dirName);
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Folder.deleteWithContent(f.getPath());
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static void copyWithContent(String sourceDirName, String targetDirName) throws IOException {
        abstract class MyFileVisitor
        implements FileVisitor<Path> {
            boolean isFirst = true;
            Path ptr;

            MyFileVisitor() {
            }
        }
        MyFileVisitor copyVisitor = new MyFileVisitor(){
            {
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!this.isFirst) {
                    Path target;
                    this.ptr = target = this.ptr.resolve(dir.getName(dir.getNameCount() - 1));
                }
                Files.copy(dir, this.ptr, StandardCopyOption.COPY_ATTRIBUTES);
                this.isFirst = false;
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path target = this.ptr.resolve(file.getFileName());
                Files.copy(file, target, StandardCopyOption.COPY_ATTRIBUTES);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Path target;
                this.ptr = target = this.ptr.getParent();
                return FileVisitResult.CONTINUE;
            }
        };
        copyVisitor.ptr = Paths.get(targetDirName, new String[0]);
        Files.walkFileTree(Paths.get(sourceDirName, new String[0]), copyVisitor);
    }
}

