/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.Task;
import com.igumnov.common.cache.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Cache {
    private static Map<String, Value> cache = new HashMap<String, Value>();
    private static Map<String, HashSet<String>> cacheTag = new HashMap<String, HashSet<String>>();
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static Queue<Value> queue = new LinkedList<Value>();
    private static Queue<Value> queueExpired = new ConcurrentLinkedQueue<Value>();
    private static int cacheSize;
    private static double cacheDefaultTTL;

    public static void init(int size, double defaultTTL) {
        cacheSize = size;
        cacheDefaultTTL = defaultTTL;
        Task.schedule(() -> {
            while (!queueExpired.isEmpty()) {
                Cache.remove(queueExpired.poll().getKey());
            }
        }, 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object put(String key, Object value, double ttl, String ... tag) {
        Value obj = new Value();
        double objTTL = ttl == 0.0 ? cacheDefaultTTL : ttl;
        obj.setObject(value);
        for (String t : tag) {
            obj.getTags().add(t);
        }
        obj.setExpireBy((long)(objTTL * 1000.0) + System.currentTimeMillis());
        obj.setKey(key);
        try {
            lock.writeLock().lock();
            if (cache.get(key) == null) {
                queue.add(obj);
            }
            cache.put(key, obj);
            for (String t : obj.getTags()) {
                HashSet<String> tagList = cacheTag.get(t);
                if (tagList == null) {
                    tagList = new HashSet();
                    cacheTag.put(t, tagList);
                }
                tagList.add(key);
            }
            if (queue.size() > cacheSize) {
                Cache.delete(queue.poll());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return value;
    }

    private static void delete(Value obj) {
        if (!obj.isRemoved()) {
            cache.remove(obj.getKey());
            for (String tag : obj.getTags()) {
                HashSet<String> objs = cacheTag.get(tag);
                if (objs == null) continue;
                objs.remove(obj.getKey());
                if (objs.size() != 0) continue;
                cacheTag.remove(tag);
            }
            obj.setRemoved(true);
        }
    }

    public static Object get(String key) {
        Value ret = null;
        try {
            lock.readLock().lock();
            ret = cache.get(key);
            if (ret != null && ret.getExpireBy() < System.currentTimeMillis()) {
                queueExpired.add(ret);
                ret = null;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        if (ret == null) {
            return null;
        }
        return ret.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByTag(String tag) {
        try {
            lock.writeLock().lock();
            LinkedList<Value> deleteList = new LinkedList<Value>();
            HashSet<String> objects = cacheTag.get(tag);
            if (objects != null) {
                for (String object : objects) {
                    Value obj = cache.get(object);
                    if (obj == null) continue;
                    deleteList.push(obj);
                }
                for (Value value : deleteList) {
                    Cache.delete(value);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static Object remove(String key) {
        Object ret = null;
        try {
            lock.writeLock().lock();
            Value obj = cache.get(key);
            if (obj != null) {
                Cache.delete(obj);
                ret = obj.getObject();
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return ret;
    }

    public static Object put(String key, Object value, String ... tag) {
        return Cache.put(key, value, 0.0, tag);
    }
}

