/*
 * Decompiled with CFR 0.152.
 */
package com.igumnov.common;

import com.igumnov.common.time.TimeException;
import com.igumnov.common.time.Timer;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Benchmark {
    private static ReentrantReadWriteLock timersLock = new ReentrantReadWriteLock();
    private static HashMap<String, Timer> timers = new HashMap();
    protected static final String timerDefaultName = "com.igumnov.common.timer";

    public static void timerStart(String name) throws TimeException {
        try {
            timersLock.writeLock().lock();
            if (timers.containsKey(name)) {
                timers.get(name);
                throw new TimeException("timer already started");
            }
            Timer timer = new Timer();
            timers.put(name, timer);
            timer.start();
        }
        finally {
            timersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timerPause(String name) throws TimeException {
        try {
            timersLock.readLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            long l = timer.pause();
            return l;
        }
        finally {
            timersLock.readLock().unlock();
        }
    }

    public static void timerResume(String name) throws TimeException {
        try {
            timersLock.readLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            timer.resume();
        }
        finally {
            timersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timerStop(String name) throws TimeException {
        try {
            timersLock.writeLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            long ret = timer.stop();
            timers.remove(name);
            long l = ret;
            return l;
        }
        finally {
            timersLock.writeLock().unlock();
        }
    }

    public static void timerStart() throws TimeException {
        Benchmark.timerStart(timerDefaultName);
    }

    public static long timerStop() throws TimeException {
        return Benchmark.timerStop(timerDefaultName);
    }

    public static long timerPause() throws TimeException {
        return Benchmark.timerPause(timerDefaultName);
    }

    public static void timerResume() throws TimeException {
        Benchmark.timerResume(timerDefaultName);
    }

    public static void timerBegin(String name) throws TimeException {
        try {
            timersLock.writeLock().lock();
            if (timers.containsKey(name)) {
                Timer timer = timers.get(name);
                timer.resume();
            } else {
                Timer timer = new Timer();
                timers.put(name, timer);
                timer.start();
            }
        }
        finally {
            timersLock.writeLock().unlock();
        }
    }

    public static long timerEnd(String name) throws TimeException {
        return Benchmark.timerPause(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timerGetRepeatCount(String name) throws TimeException {
        try {
            timersLock.readLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            long l = timer.getRepeatCount();
            return l;
        }
        finally {
            timersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timerGetAverageTime(String name) throws TimeException {
        try {
            timersLock.readLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            long l = timer.getAverageTime();
            return l;
        }
        finally {
            timersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timerGetTotalTime(String name) throws TimeException {
        try {
            timersLock.readLock().lock();
            if (!timers.containsKey(name)) {
                throw new TimeException("startProcedure should be call before");
            }
            Timer timer = timers.get(name);
            long l = timer.getTotlaTime();
            return l;
        }
        finally {
            timersLock.readLock().unlock();
        }
    }
}

