		document.addEventListener('DOMContentLoaded', function() {
			
			var getDocHeight = function() {
				var D = document;
				return Math.max(D.body.scrollHeight, D.documentElement.scrollHeight, D.body.offsetHeight, D.documentElement.offsetHeight, D.body.clientHeight, D.documentElement.clientHeight);
			}
			var scrollToAnchor = function(link, isConnSummary) {
				var getBoundsTop, duration, chosenElement;

				if (isConnSummary) {
					chosenElement = document.getElementById(link);
					getBoundsTop = chosenElement.getBoundingClientRect().top;
					duration = 500;
				} else {
					chosenElement = document.querySelector('#' + link);
					getBoundsTop = chosenElement.getBoundingClientRect().top;
					duration = arguments.length <= 1 || arguments[1] === undefined ? 500 : arguments[1];
				}

				var mili = 15,
					scrollPosition = window.scrollY,
					scrollTarget = scrollPosition + (getBoundsTop - 44),
					scrollCount = 0,
					scrollStep = Math.PI / (duration / mili),
					scrollDirection = scrollTarget > scrollPosition ? 1 : -1,
					cosParameter = Math.abs(scrollTarget - scrollPosition) / 2,
					docHeight = getDocHeight(),
					marginOfError = Math.ceil(cosParameter - cosParameter * Math.cos(1 * scrollStep)),
					scrollMargin;

				var scrollInterval = setInterval(function() {
					var reachedEdge = scrollDirection > 0 ? window.scrollY + window.innerHeight >= docHeight - 1 : window.scrollY < 1;

					if (Math.abs(scrollTarget - window.scrollY) > marginOfError && !reachedEdge) {
						scrollCount += 1;
						scrollMargin = cosParameter - cosParameter * Math.cos(scrollCount * scrollStep);
						window.scrollTo(0, scrollPosition + scrollMargin * scrollDirection);
					} else {
						clearInterval(scrollInterval);

						if (isConnSummary) {
							chosenElement.classList.add('shake');
							chosenElement.classList.add('is-paused');

							setTimeout(function() {
								chosenElement.classList.remove('is-paused');
							}, 0);
						}
					}
				}, mili);
			};

			var browserVersion = detectIE();

			// Shared Variables
			var navHeight = 44;
			var recommendationItems = document.getElementsByClassName('recommendation-toggle');
			var hasClass = function(el, cls) {
				return el.className && new RegExp("(\\s|^)" + cls + "(\\s|$)").test(el.className);
			};
			var checkForOpenArchiveDetails = function() {
				// Check if any archive details sections are open
				var currentVisibleArchive = document.querySelectorAll('.archive-details.show').length;

				if (currentVisibleArchive === 0) {
					return true;
				} else {
					return false;
				}
			};
			var toggleHideShowClasses = function(el, isTrue, subStringForHide, subStringForShow) {
				var stringForHide = subStringForHide || 'hide';
				var stringForShow = subStringForShow || 'show';

				if (isTrue) {
					el.classList.remove(stringForHide);
					el.classList.add(stringForShow);
				} else {
					el.classList.remove(stringForShow);
					el.classList.add(stringForHide);
				}
			};


			// Jump To Item
			var jumpToItems = document.querySelectorAll('.jump-item');
            var innerList = document.querySelectorAll('.inner--list--hide')[0];
            var archiveScrollBy = function(e) {
				e.preventDefault();

				var id,
					archiveDetail,
					archiveDetailCurrentLocation,
					archiveDetailTop,
					scrollToPosition,
					anchor = e.target.closest('a');

                if (anchor.tagName === "SPAN") {
                	anchor = anchor.parentElement;
                }

				var resultsSection, isHidden, archiveAnchor;

				if (anchor.href) {
					id = anchor.href.split('#')[1];
					archiveDetail = document.getElementById(id);
					archiveDetailCurrentLocation = archiveDetail.getBoundingClientRect();
					archiveDetailTop = archiveDetailCurrentLocation.top;
					scrollToPosition = archiveDetailTop - navHeight;

					if (hasClass(archiveDetail,'archive')) {
						resultsSection = archiveDetail.querySelector('.archive-details');
						isHidden = hasClass(resultsSection, 'hide');

						if (isHidden) {
							toggleHideShowClasses(resultsSection, isHidden);
							archiveAnchor = resultsSection.previousElementSibling.querySelector('.archive-toggle');
							archiveAnchor.text = "CLOSE_DETAILS";

							// we want to the opposite of the function
							// because it will return true if all closed
							if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
								collapseAnchor.classList.remove('disabled');
							}
						}
					}
					
					if (browserVersion) {
						window.scrollBy(0, scrollToPosition);
					} else {
						scrollToAnchor(id);
					}
                    
                    innerList.style.display = 'none';
                    
                    setTimeout(function() {
                    	innerList.removeAttribute('style');
                    }, 1000);
				}
			};

			for (var h = 0; h < jumpToItems.length; h++) {
				var jumpToItem = jumpToItems[h];
				jumpToItem.addEventListener('click', archiveScrollBy, false);
			}

			// Toggle Fixed/Non-Fixed Jump To
			var scrolledElement = document.querySelector('.nav-wrapper');
			var listener = function() {
				var y = window.pageYOffset;
				var scrolledElementClientRect = scrolledElement.getBoundingClientRect();
				var top = scrolledElementClientRect.top;
				var toBeFixed = y >= top;

				toggleHideShowClasses(scrolledElement, toBeFixed, 'na-fixed', 'fixed');
			};

			window.addEventListener('scroll', listener, false);

			var showArchiveDetail = function(e) {
				// use preventDefault to allow us to use window.scrollBy
				e.preventDefault();

				var id, table, resultsSection,
					isHidden, target, anchor;

				if (e.target.href) {
					id = e.target.href.split('#')[1];
					resultsSection = document.getElementById(id);
					anchor = resultsSection.previousElementSibling.querySelector('.archive-toggle');
					isHidden = hasClass(resultsSection, 'hide');

					if (isHidden) {
						toggleHideShowClasses(resultsSection, isHidden);

						anchor.text = "CLOSE_DETAILS";

						// we want to the opposite of the function
						// because it will return true if all closed
						if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
							collapseAnchor.classList.remove('disabled');
						}
					}

					if (browserVersion) {
						var navCurrentLocation = resultsSection.getBoundingClientRect();
						navCurrentLocation = navCurrentLocation.top - navHeight;
						window.scrollBy(0, navCurrentLocation);
					} else {
						scrollToAnchor(id);
					}
				}
			};


			// Expand | Collapse Toggle
			var expandAnchor = document.getElementsByClassName('expand-all')[0];
			var collapseAnchor = document.getElementsByClassName('collapse-all')[0];
			var archiveListItem = document.getElementsByClassName('archive');
			var archiveDetailContent = document.getElementsByClassName('archive-details');
			var archiveAnchor = document.getElementsByClassName('archive-toggle');
			var toggleAllContents = function(e) {
				var anchor = e.target.closest('a'),
					toggleAnchor = anchor.parentElement.getElementsByClassName('disabled')[0],
					isExpandAll = hasClass(anchor, 'expand-all'),
					archiveListLength = archiveListItem.length,
					archiveListLengthAt0 = archiveListLength - 1;

				// prevent default behavior
				e.preventDefault();

				for (var arc = 0; arc < archiveListLength; arc++) {
					var currentAnchor = archiveAnchor[arc];
					var currentContent = currentAnchor.closest('.archive').getElementsByClassName('archive-details')[0];
					var isCurrentContentHidden = hasClass(currentContent, 'hide');
					var toExpandAll = isExpandAll && isCurrentContentHidden;
					var toCollapseAll = !isExpandAll && !isCurrentContentHidden;

					toggleHideShowClasses(currentContent, isExpandAll);

					if (isExpandAll) {
						currentAnchor.text = "CLOSE_DETAILS";

						if (arc === archiveListLengthAt0) {
							expandAnchor.classList.add('disabled');
						}
					} else {
						currentAnchor.text = "SHOW_DETAILS";

						if (checkForOpenArchiveDetails()) {
							collapseAnchor.classList.add('disabled');
						}
					}
				}

				// disable other toggle anchor
				if (toggleAnchor) {
					toggleAnchor.classList.remove('disabled');
					anchor.classList.add('disabled');
				}
			};

			expandAnchor.addEventListener('click', toggleAllContents);
			collapseAnchor.addEventListener('click', toggleAllContents);


			// Toggle Archive Detail Sections
			var toggleArchiveDetailSections = function(e) {
				e.preventDefault();

				var obj = {
						className: "archive-details",
						closeArchiveDetail: "CLOSE_DETAILS",
						showArchiveDetail: "SHOW_DETAILS"
					};

				var el = e.target.closest('.archive').getElementsByClassName(obj.className)[0];
				var isHidden = hasClass(el, 'hide');

				toggleHideShowClasses(el, isHidden);

				if (isHidden) {
					e.target.text = obj.closeArchiveDetail;

					// removed disabled on collapse anchor
					if (!checkForOpenArchiveDetails() && hasClass(collapseAnchor, 'disabled')) {
						collapseAnchor.classList.remove('disabled');
					}
					var currentHiddenArchive = document.querySelectorAll('.archive-details.hide').length;
					if(currentHiddenArchive===0) {
						expandAnchor.classList.add('disabled');
					}
				} else {
					e.target.text = obj.showArchiveDetail;

					// Hide nested archive detail sections also
					var nestedArchiveAnchors = el.getElementsByClassName('recommendation-toggle');
					for (var i=0; i < nestedArchiveAnchors.length; i++) {
						closeNestedArchiveDetailSections(nestedArchiveAnchors[i]);
					}

					// removed disabled on expand anchor
					if (hasClass(expandAnchor, 'disabled')) {
						expandAnchor.classList.remove('disabled');
					}

					if (checkForOpenArchiveDetails()) {
						collapseAnchor.classList.add('disabled');
					}
				}
			};

			var closeNestedArchiveDetailSections = function(targetElement) {
				var obj = {
						className: "archive-details",
						closeArchiveDetail: "CLOSE_DETAILS",
						showArchiveDetail: "SHOW_DETAILS"
					};

				var el = targetElement.closest('.archive').getElementsByClassName(obj.className)[0];

				var isHidden = hasClass(el, 'hide');

				if (!isHidden) {
					toggleHideShowClasses(el, isHidden);
					targetElement.text = obj.showArchiveDetail;

					// Hide nested archive detail sections also
					var nestedArchiveAnchors = el.getElementsByClassName('recommendation-toggle');
					for (var i=0; i < nestedArchiveAnchors.length; i++) {
						closeNestedArchiveDetailSections(nestedArchiveAnchors[i]);
					}
				}

			};

			// Toggle Archive Details
			for (var i = 0; i < recommendationItems.length; i++) {
				var anchorArchive = recommendationItems[i];
				anchorArchive.addEventListener('click', function(e) {
					toggleArchiveDetailSections(e);
				}, false);
			}

		}, false);
		