/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

public class JSONInventoryReportWriter
implements ReportWriter {
    private SortedMap<String, String> scanOptions = null;
    private List<String> projects = null;
    private List<String> sharedLibProjectNames = null;
    private ArchiveInventory inventory = null;
    public static final String[] skipOptionArr = new String[0];
    public static final Set<String> skipOption = new HashSet<String>(Arrays.asList(skipOptionArr));
    OrderedJSONObject rootObject = new OrderedJSONObject();
    String returnString;

    public JSONInventoryReportWriter(ArchiveInventory inv, List<String> arrayOfProjects, List<String> sharedLibProjectNames, SortedMap<String, String> scanOptions) {
        this.projects = arrayOfProjects;
        this.sharedLibProjectNames = sharedLibProjectNames;
        Collections.sort(this.projects);
        this.inventory = inv;
        this.scanOptions = scanOptions;
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    @Override
    public void writeReport() {
        ReportUtility.writeJSONHeader(this.rootObject, "inventory", "4.0", this.getAllOptions());
        this.inventory.toJSON(this.rootObject, this.projects, this.sharedLibProjectNames);
        try {
            String jsonString = this.rootObject.serialize(true);
            this.returnString = jsonString = jsonString.replace("\\/", "/");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JSONArray getAllOptions() {
        JSONArray allOptions = new JSONArray();
        for (String key : this.scanOptions.keySet()) {
            if (skipOption.contains(key)) continue;
            allOptions.add(this.scanOptions.get(key));
        }
        return allOptions;
    }
}

