/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.html;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.technology.AbstractTechnology;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLEvaluationReportWriter
implements ReportWriter {
    protected StringBuilder jsBuffer = new StringBuilder();
    private List<String> footnoteEntries = new ArrayList<String>();
    private int numColumns = 1;
    private String author = Messages.getString("TECH_EVAL_REPORT_AUTHOR");
    private static final String CHECKMARK = "&#10003;";
    private static final String DIV_CHECKMARK = "<div class=\"checkmark\" role=\"img\" aria-label=\"checkmark\">&#10003;</div>";
    private final boolean[] showColumn = new boolean[8];
    private final boolean[] supportedPlatforms = new boolean[]{true, true, true, true, true, true, true, true, true};
    private SortedMap<String, TechSummary> listOfTechSummaries = null;
    private List<String> projects = null;
    private SortedMap<String, String> scanOptions = null;
    boolean isConsolidated = false;
    int targetAppSeverColumnIndex = -1;
    Set<String> ruleIdsWithResults;
    private boolean hasSingleSummaryTable = false;
    boolean isSourceScanner = false;
    public static String[] productEnum;
    public static Map<String, String> productEnumToId;
    public static final Map<String, String> TECH_RULE_TO_ANALYSIS;
    public static final String DETECT_JAXRPC = "TechName_JAXRPCNotAppProvided";
    public static final String DETECT_JAXRPC_PREVALIDATED = "TechName_JAXRPCPrevalidated";
    public static final String DETECT_JAXRPC_PREVALIDATED_APPPROVIDED = "TechName_JAXRPCPrevalidatedAppProvided";
    String returnString;

    static {
        productEnumToId = new LinkedHashMap<String, String>();
        TECH_RULE_TO_ANALYSIS = new HashMap<String, String>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("OpenLiberty", "LibOpen");
        map.put("WASLibertyCore", "LibCore");
        map.put("WASLibertyProfile", "Liberty");
        map.put("WASFullProfile", "tWAS");
        map.put("WASNDLiberty", "LibND");
        map.put("WASNDFullProfile", "tWASND");
        map.put("WASZOSLiberty", "LibzOS");
        map.put("WASZOSFull", "tWASzOS");
        productEnumToId = Collections.unmodifiableMap(map);
        productEnum = productEnumToId.keySet().toArray(new String[0]);
        TECH_RULE_TO_ANALYSIS.put(DETECT_JAXRPC, "DetectJAXRPCInvalid");
        TECH_RULE_TO_ANALYSIS.put(DETECT_JAXRPC_PREVALIDATED, "DetectJAXRPCPrevalidated");
        TECH_RULE_TO_ANALYSIS.put(DETECT_JAXRPC_PREVALIDATED_APPPROVIDED, "DetectJAXRPCPrevalidatedAppProvided");
    }

    public HTMLEvaluationReportWriter(Set<String> ruleIdsWithResults, int targetAppSeverColumnIndex, List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, SortedMap<String, String> scanOptions) {
        this(arrayOfProjects, listOfTechSummaries, productsToShow, scanOptions);
        this.isConsolidated = true;
        this.targetAppSeverColumnIndex = targetAppSeverColumnIndex;
        this.ruleIdsWithResults = ruleIdsWithResults;
    }

    public HTMLEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, SortedMap<String, String> scanOptions) {
        this(arrayOfProjects, listOfTechSummaries, productsToShow);
        this.scanOptions = scanOptions;
        this.author = Messages.getString("TECH_EVAL_REPORT_AUTHOR_BINARY_SCANNER");
    }

    public HTMLEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow) {
        this.projects = arrayOfProjects;
        Collections.sort(this.projects);
        this.listOfTechSummaries = listOfTechSummaries;
        this.hasSingleSummaryTable = listOfTechSummaries.size() == 1;
        for (String product : productsToShow) {
            if (product.equals(Messages.getString("OpenLiberty"))) {
                this.showColumn[0] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyCore"))) {
                this.showColumn[1] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyProfile"))) {
                this.showColumn[2] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASFullProfile"))) {
                this.showColumn[3] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASNDLiberty"))) {
                this.showColumn[4] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASNDFullProfile"))) {
                this.showColumn[5] = true;
                ++this.numColumns;
                continue;
            }
            if (product.equals(Messages.getString("WASZOSLiberty"))) {
                this.showColumn[6] = true;
                ++this.numColumns;
                continue;
            }
            if (!product.equals(Messages.getString("WASZOSFull"))) continue;
            this.showColumn[7] = true;
            ++this.numColumns;
        }
    }

    public void setIsSourceScanner(boolean isSourceScanner) {
        this.isSourceScanner = isSourceScanner;
    }

    private void writeJumpTo(StringBuilder sb) {
        sb.append("<div class=\"nav-wrapper na-fixed noprint\" role=\"navigation\" aria-label=\"Report Navigation Menu\">\n");
        sb.append("  <nav class=\"jump-to-nav\" aria-label=\"Report Navigation Menu Links\">\n");
        sb.append("  <ul>\n");
        sb.append("    <li>\n");
        sb.append("<a href=\"#\">");
        sb.append(Messages.getString("INVENTORY_REPORT_JUMP_TO_APPLICATION"));
        sb.append("<div class=\"scroll-bottom-caret show\">v</div>");
        sb.append("</a>\n");
        sb.append("      <ul class=\"inner--list--hide\">\n");
        sb.append("        <li id=\"backToTopNav\">");
        sb.append("<a href=\"#top\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("ANALYSIS_REPORT_BACK_TO_TOP"));
        sb.append("</a>");
        sb.append("</li>\n");
        sb.append("        <li><a href=\"#summary\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("CONSOLIDATED_REPORT_EVAL"));
        sb.append("</a>");
        sb.append("</li>\n");
        sb.append("        <li><a href=\"#details\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("TECH_EVAL_BREAKDOWN"));
        sb.append("</a>");
        sb.append("</li>\n");
        int i = 0;
        for (String nextProject : this.projects) {
            sb.append("<li><a href=\"#app");
            sb.append(i);
            sb.append("\" class=\"jump-item\">");
            int index = nextProject.lastIndexOf(47);
            if (index > -1) {
                sb.append(ReportUtility.encodeHTMLEntities(nextProject.substring(index + 1)));
            } else {
                sb.append(ReportUtility.encodeHTMLEntities(nextProject));
            }
            sb.append("</a></li>\n");
            ++i;
        }
        sb.append("      </ul>\n");
        sb.append("    </li>\n");
        sb.append("  </ul>\n");
        sb.append("  </nav>\n");
        sb.append("</div>\n");
    }

    private void writeBody(StringBuilder sb) {
        sb.append("<body id=\"top\" class=\"evaluate\">\n");
        sb.append("<div id=\"wrapper\" class=\"wrapper\" role=\"main\">\n");
        this.writeBodyHeader(sb);
        String achive = this.projects.get(0).replaceFirst(".*/", "");
        if (this.hasSingleSummaryTable) {
            TechSummary ts = this.listOfTechSummaries.values().iterator().next();
            sb.append(this.buildTechTable(ts, achive));
        } else {
            this.writeTopSummaryTable(sb);
            this.writeTechnologyDetailsSection(sb);
        }
        this.writeFootnote(sb);
        if (!this.hasSingleSummaryTable) {
            this.writeEmbeddedJS(sb);
        }
        sb.append("</div>\n");
        sb.append("</body>\n");
    }

    protected void writeFootnote(StringBuilder sb) {
        if (!this.footnoteEntries.isEmpty()) {
            int size = this.footnoteEntries.size();
            int i = 0;
            while (i < size) {
                int footnoteNum = i + 1;
                String footnoteLink = "<sup ID=footnote" + footnoteNum + ">" + footnoteNum + " " + this.footnoteEntries.get(i) + "</sup>";
                sb.append("<p class=\"disclaimer\">");
                sb.append(footnoteLink);
                sb.append("</p>");
                ++i;
            }
        }
    }

    private void writeBodyHeader(StringBuilder sb) {
        if (!this.hasSingleSummaryTable) {
            this.writeJumpTo(sb);
        }
        sb.append("<h1>");
        sb.append(Messages.getString("TECH_EVAL_REPORT_TITLE"));
        sb.append("</h1>\n");
        sb.append("<p class=\"date-time\"><span class=\"date\">");
        sb.append(ReportUtility.getCreatedDate());
        sb.append("</span></p>\n");
        sb.append("<p class=\"courier archivePath\">");
        int i = 0;
        while (i < this.projects.size() - 1) {
            sb.append(ReportUtility.encodeHTMLEntities(this.projects.get(i)));
            sb.append("<br>\n");
            ++i;
        }
        sb.append(ReportUtility.encodeHTMLEntities(this.projects.get(this.projects.size() - 1)));
        sb.append("</p>\n");
        if (this.scanOptions != null && this.scanOptions.keySet().size() > 0) {
            ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_SCAN_OPTIONS_LABEL"), ReportUtility.getOptions(this.scanOptions, true));
            String excludedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludePackages"));
            String includedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("includePackages"));
            String excludedFiles = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludeFiles"));
            if (excludedPackages != null) {
                ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_EXCLUDED_PACKAGES_LABEL"), excludedPackages);
            }
            if (includedPackages != null) {
                ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_INCLUDED_PACKAGES_LABEL"), includedPackages);
            }
            if (excludedFiles != null) {
                ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_EXCLUDED_FILES_LABEL"), excludedFiles);
            }
        }
        sb.append("<div id=\"summary\" class=\"header-sections\">\n");
        sb.append("<h2>");
        sb.append(Messages.getString("CONSOLIDATED_REPORT_EVAL"));
        sb.append("</h2>\n");
        sb.append("<p>");
        if (!this.hasSingleSummaryTable) {
            sb.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_REPORT_SUMMARY_CHART_HEADER"), "<a class=\"blueAnchor\" href=\"#details\">" + Messages.getString("TECH_EVAL_BREAKDOWN") + "</a>"));
        } else {
            sb.append(Messages.getString("TECH_EVAL_REPORT_HEADER"));
        }
        sb.append("</p>\n");
        sb.append("<p>");
        sb.append(Messages.getString("TECH_EVAL_REPORT_HEADER_DETAILED_ANALYSIS"));
        sb.append("</p>\n");
        sb.append("</div>");
    }

    private String buildTableHeader(boolean[] platformSupport, String archiveName) {
        StringBuilder tableHeaderSB = new StringBuilder();
        int i = 0;
        while (i < productEnum.length) {
            if (this.showColumn[i]) {
                boolean isSupported = platformSupport[i];
                String id = "id=\"" + ReportUtility.encodeHTMLEntities(archiveName.replace(' ', '_')) + "_" + productEnumToId.get(productEnum[i]) + "\"";
                String tableColumnHeaderCell = isSupported ? "<th class=\"highlight\" " + id + ">" + Messages.getString(productEnum[i]) + "</th>" : "<th " + id + ">" + Messages.getString(productEnum[i]) + "</th>";
                tableHeaderSB.append(tableColumnHeaderCell);
            }
            ++i;
        }
        return tableHeaderSB.toString();
    }

    protected void writeTopSummaryTable(StringBuilder sb) {
        sb.append("<div class=\"floating-box-wider\">");
        sb.append("<table summary=\"");
        sb.append(Messages.getString("TECH_EVAL_REPORT_TABLE_SUMMARY"));
        sb.append("\">\n");
        sb.append("<thead>\n");
        sb.append("<tr>\n");
        sb.append("<th>");
        sb.append(Messages.getString("TECH_EVAL_APPLICATION"));
        sb.append("</th>\n");
        sb.append(this.buildTableHeader(!this.isConsolidated ? this.supportedPlatforms : this.listOfTechSummaries.entrySet().iterator().next().getValue().getSupportedPlatforms(), "Summary"));
        sb.append("</tr>\n");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        int i = 0;
        while (i < this.projects.size()) {
            TechSummary techSummary = (TechSummary)this.listOfTechSummaries.get(this.projects.get(i));
            sb.append("<tr>\n");
            sb.append("<td>\n");
            String listId = !this.isConsolidated ? "app" + i : "evaluation";
            sb.append("<a class=\"blueAnchor jump-item\" href=\"#").append(listId).append("\">");
            sb.append(techSummary.getProjectNames().get(0).replaceFirst(".*/", ""));
            sb.append("</a>\n");
            sb.append("</td>\n");
            int index = 0;
            boolean[] blArray = techSummary.getSupportedPlatforms();
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isChecked = blArray[n2];
                if (this.showColumn[index]) {
                    boolean isSupported = !this.isConsolidated ? this.supportedPlatforms[index] : isChecked;
                    String checked = isChecked ? DIV_CHECKMARK : "";
                    String tableRowContentCell = isSupported ? "<td class=\"highlight\">" + checked + "</td>" : "<td>" + checked + "</td>";
                    sb.append(tableRowContentCell);
                }
                ++index;
                ++n2;
            }
            sb.append("</tr>\n");
            ++i;
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("</div>");
    }

    private String buildRow(String techRuleId, String[] rules, String label, String referredToAs, int[] rowXs, boolean[] platformsSupported, String headerID, String archiveName) {
        String tableRowHeaderCell;
        int footNoteIndex;
        String ruleId;
        StringBuilder row = new StringBuilder();
        if (TECH_RULE_TO_ANALYSIS.containsKey(techRuleId)) {
            if (this.ruleIdsWithResults != null) {
                ruleId = this.getRuleId(new String[]{TECH_RULE_TO_ANALYSIS.get(techRuleId)});
                if (referredToAs != null) {
                    footNoteIndex = this.footnoteEntries.indexOf(referredToAs);
                    if (footNoteIndex == -1) {
                        this.footnoteEntries.add(referredToAs);
                        footNoteIndex = 1;
                    } else {
                        ++footNoteIndex;
                    }
                    tableRowHeaderCell = "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\"><a class=\"blueAnchor jump-item\" href=\"#analyze_" + ReportUtility.encodeHTMLEntities(ruleId) + "\">" + label + " " + footNoteIndex + "</a></td>";
                } else {
                    tableRowHeaderCell = "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\"><a class=\"blueAnchor jump-item\" href=\"#analyze_" + ReportUtility.encodeHTMLEntities(ruleId) + "\">" + label + "</a></td>";
                }
            } else if (referredToAs != null) {
                int footNoteIndex2 = this.footnoteEntries.indexOf(referredToAs) + 1;
                tableRowHeaderCell = "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "<sup><a class=\"footnotetech\" href=\"#footnote" + footNoteIndex2 + "\">" + footNoteIndex2 + "</a></sup></td>";
            } else {
                tableRowHeaderCell = "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "</td>";
            }
        } else if (referredToAs != null) {
            String footnoteContent = Messages.getFormattedMessage(Messages.getString("ReportWriter_Technology_Also_Known_As"), label, referredToAs);
            footNoteIndex = this.footnoteEntries.indexOf(footnoteContent) + 1;
            tableRowHeaderCell = "<td headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "<sup><a class=\"footnotetech\" href=\"#footnote" + footNoteIndex + "\">" + footNoteIndex + "</a></sup></td>";
        } else {
            tableRowHeaderCell = this.targetAppSeverColumnIndex != -1 && rowXs[this.targetAppSeverColumnIndex] == -1 ? ((ruleId = this.getRuleId(rules)) != null ? "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\"><a class=\"blueAnchor jump-item\" href=\"#analyze_" + ReportUtility.encodeHTMLEntities(ruleId) + "\">" + label + "</a></td>" : "<td class=\"targetPlatform\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "</td>") : "<td headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "</td>";
        }
        row.append("<tr>");
        row.append(tableRowHeaderCell);
        int i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i]) {
                boolean isChecked = rowXs[i] != -1;
                boolean isSupported = platformsSupported[i];
                String checked = isChecked ? DIV_CHECKMARK : "";
                String tableRowContentCell = isSupported ? "<td class=\"highlight\" headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + " " + ReportUtility.encodeHTMLEntities(archiveName.replace(' ', '_')) + "_" + productEnumToId.get(productEnum[i]) + "\">" + checked + "</td>" : "<td headers=\"" + ReportUtility.encodeHTMLEntities(headerID) + " " + ReportUtility.encodeHTMLEntities(archiveName.replace(' ', '_')) + "_" + productEnumToId.get(productEnum[i]) + "\">" + checked + "</td>";
                row.append(tableRowContentCell);
            }
            ++i;
        }
        row.append("</tr>\n");
        return row.toString();
    }

    private String getRuleId(String[] rules) {
        String baseRuleName = null;
        HashMap<String, List<String>> baseNamesToPossibleNameEndings = new HashMap<String, List<String>>();
        String[] stringArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String currentRule = stringArray[n2];
            if (this.ruleIdsWithResults.contains(currentRule)) {
                return currentRule;
            }
            Matcher m = Pattern.compile("(?:AppProvidedJava|Java|XML|UsageJava|Manifest)$").matcher(currentRule);
            String ending = "";
            if (m.find()) {
                ending = m.group();
            }
            if (!(baseRuleName = currentRule.replace(ending, "")).equals(currentRule)) {
                ArrayList<String> ruleEndings;
                if (this.ruleIdsWithResults.contains(baseRuleName)) {
                    return baseRuleName;
                }
                if (!baseNamesToPossibleNameEndings.containsKey(baseRuleName)) {
                    ruleEndings = new ArrayList<String>(Arrays.asList("Java", "XML", "AppProvidedJava", "UsageJava"));
                    baseNamesToPossibleNameEndings.put(baseRuleName, ruleEndings);
                } else {
                    ruleEndings = (ArrayList<String>)baseNamesToPossibleNameEndings.get(baseRuleName);
                }
                ruleEndings.remove(ending);
            }
            ++n2;
        }
        return this.findRule(baseNamesToPossibleNameEndings);
    }

    private String findRule(Map<String, List<String>> baseNamesToPossibleNameEndings) {
        for (Map.Entry<String, List<String>> entity : baseNamesToPossibleNameEndings.entrySet()) {
            List<String> possibleEndings = entity.getValue();
            for (String ending : possibleEndings) {
                String potentialRuleId = String.valueOf(entity.getKey()) + ending;
                if (!this.ruleIdsWithResults.contains(potentialRuleId)) continue;
                return potentialRuleId;
            }
        }
        return null;
    }

    private String buildLineBreak(String label, String headerID) {
        String tableLineBreakCell = "<th colspan=\"" + this.numColumns + "\" id=\"" + ReportUtility.encodeHTMLEntities(headerID) + "\">" + label + "</th>";
        StringBuilder row = new StringBuilder();
        row.append("<tr class=\"banner\">");
        row.append(tableLineBreakCell);
        row.append("</tr>\n");
        return row.toString();
    }

    private void writeEmbeddedJS(StringBuilder sb) {
        String js = ReportUtility.getSharedJS();
        if (js != null) {
            sb.append("<script type=\"text/javascript\">\n");
            String minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                sb.append(minifiedJS);
            }
            sb.append("</script>\n");
        }
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    public int getNumberOfColumns() {
        return this.numColumns;
    }

    @Override
    public void writeReport() {
        StringBuilder sb = new StringBuilder(65536);
        this.getFootNotesAndDetermineOverallSupportedPlatforms();
        ReportUtility.writeHtmlTag(sb);
        ReportUtility.writeHeader(sb, Messages.getString("TECH_EVAL_REPORT_TITLE"), this.author, false, this.numColumns, this.isSourceScanner);
        this.writeBody(sb);
        sb.append("</html>\n");
        this.returnString = sb.toString();
    }

    private void writeTechnologyDetailsSection(StringBuilder sb) {
        sb.append("<div tabindex=\"0\" id=\"details\" class=\"header-sections\">\n");
        sb.append("<h2>\n");
        sb.append(Messages.getString("TECH_EVAL_BREAKDOWN"));
        sb.append("</h2>\n");
        sb.append("<div class=\"expand-collapse-holder noprint\">\n");
        sb.append("<a href=\"#\" class=\"expand-all almighty\">Expand all</a>\n");
        sb.append("<a href=\"#\" class=\"collapse-all almighty disabled\">Collapse all</a>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("<div class=\"inventory-details-by-app clear\">\n");
        sb.append("<ul>\n");
        int index = 0;
        for (String key : this.projects) {
            TechSummary summary = (TechSummary)this.listOfTechSummaries.get(key);
            String archiveName = summary.getProjectNames().get(0).replaceFirst(".*/", "").replace(' ', '_');
            sb.append("<li id=\"app");
            sb.append(index);
            sb.append("\" class=\"archive\">\n");
            sb.append("<div class=\"archive-title\">\n");
            sb.append("<h3>").append(ReportUtility.encodeHTMLEntities(archiveName)).append("</h3>");
            sb.append("<div class=\"js-toggle-actions noprint\">\n");
            sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
            sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
            sb.append("</a>");
            sb.append("</div>");
            sb.append("</div>");
            sb.append("<div class=\"archive-details shared hide\">");
            sb.append(this.buildTechTable(summary, archiveName));
            sb.append("</div>");
            sb.append("</li>\n");
            ++index;
        }
        sb.append("</ul>\n");
        sb.append("</div>");
    }

    protected String buildTechTable(TechSummary summary, String archiveName) {
        StringBuilder tableSB = new StringBuilder();
        tableSB.append("<table summary=\"");
        tableSB.append(Messages.getString("TECH_EVAL_REPORT_TECHNOLOGY_TABLE_SUMMARY"));
        tableSB.append("\">\n");
        tableSB.append("<thead>\n");
        tableSB.append("<tr>\n");
        tableSB.append("<th>&nbsp;</th>\n");
        tableSB.append(this.buildTableHeader(summary.getSupportedPlatforms(), archiveName));
        tableSB.append("</tr>\n");
        tableSB.append("</thead>\n");
        tableSB.append("<tbody>\n");
        TreeMap<TechSummary.OrderedTech, TreeSet<TechSummary.OrderedTech>> mapOfRowHeaderToTechnologies = summary.getMapOfRowHeaderToTechnologies();
        for (Map.Entry<TechSummary.OrderedTech, TreeSet<TechSummary.OrderedTech>> techLineBreakEntity : mapOfRowHeaderToTechnologies.entrySet()) {
            String label = techLineBreakEntity.getKey().getTech().getName();
            label = label.substring(12, label.length());
            String headerID = String.valueOf(archiveName.replace(' ', '_')) + "_" + label.replaceAll("\\s+", "");
            String row = this.buildLineBreak(label, headerID);
            tableSB.append(row);
            TreeSet<TechSummary.OrderedTech> setOfTech = techLineBreakEntity.getValue();
            for (TechSummary.OrderedTech orderedTech : setOfTech) {
                AbstractTechnology tech = orderedTech.getTech();
                row = this.buildRow(tech.getId(), tech.getRulesToTrigger(), tech.getName(), tech.getReferredToAs(), tech.getSupport(), summary.getSupportedPlatforms(), headerID, archiveName);
                tableSB.append(row);
            }
        }
        tableSB.append("</tbody>\n");
        tableSB.append("</table>\n");
        return tableSB.toString();
    }

    protected void getFootNotesAndDetermineOverallSupportedPlatforms() {
        SortedSet<Object> setOfFootNotes;
        if (this.hasSingleSummaryTable) {
            TechSummary ts = this.listOfTechSummaries.values().iterator().next();
            setOfFootNotes = ts.getFootNotes();
        } else {
            setOfFootNotes = new TreeSet();
            for (TechSummary summary : this.listOfTechSummaries.values()) {
                setOfFootNotes.addAll(summary.getFootNotes());
                boolean[] platformsSupportedByApp = summary.getSupportedPlatforms();
                int i = 0;
                while (i < platformsSupportedByApp.length) {
                    this.supportedPlatforms[i] = !platformsSupportedByApp[i] ? false : this.supportedPlatforms[i];
                    ++i;
                }
            }
        }
        this.footnoteEntries = new ArrayList<String>(setOfFootNotes);
    }

    protected boolean isPlatformFullySupported(int index) {
        if (this.hasSingleSummaryTable) {
            TechSummary ts = this.listOfTechSummaries.values().iterator().next();
            return ts.getSupportedPlatforms()[index];
        }
        return this.supportedPlatforms[index];
    }
}

