/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.utilities.RewriteUtility;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;

public class RewriteGradleConfigWriter {
    static String configTemplate = "plugins {\n    id 'java'\n    id 'maven-publish'\n    id '%s' version '%s'\n}\n\nrewrite {\n    activeRecipe(\n%s    )\n}\n\nrepositories {\n    mavenCentral()\n}\n\ndependencies {\n%s}";

    public static String buildRewriteConfig(LinkedHashMap<String, LinkedHashSet<String>> rulesToRecipes, SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules, boolean showAllHelp) {
        TreeSet<RewriteUtility.RewriteDependency> rewriteDependencies = new TreeSet<RewriteUtility.RewriteDependency>(new RewriteUtility.RewriteDependencyComparator());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkedHashSet<String>> entry : rulesToRecipes.entrySet()) {
            String ruleId = entry.getKey();
            LinkedHashSet<String> recipes = entry.getValue();
            AnalysisRule rule = (AnalysisRule)mapOfIdToAnalysisRules.get(ruleId);
            if (rule == null || !showAllHelp && rule.getResults().isEmpty()) continue;
            String defaultRecipe = (String)recipes.iterator().next();
            LinkedHashSet<Object> subRecipes = new LinkedHashSet();
            if (RewriteUtility.recipesToSplit.contains(defaultRecipe)) {
                subRecipes = RewriteUtility.getSubRecipes(defaultRecipe);
            } else {
                subRecipes = new LinkedHashSet();
                subRecipes.add(defaultRecipe);
            }
            String missingDependencyComment = null;
            RewriteUtility.RewriteDependency recipeDependency = RewriteUtility.RewriteDependency.resolveRecipeDependency(defaultRecipe);
            if (recipeDependency != null) {
                rewriteDependencies.add(recipeDependency);
            } else {
                missingDependencyComment = Messages.getString("RewriteConfigWriter_Dependecy_Maybe_Required");
            }
            for (String string : subRecipes) {
                sb.append("        // ").append(rule.getRuleName()).append("\n");
                if (missingDependencyComment != null) {
                    sb.append("        // ").append(missingDependencyComment).append("\n");
                }
                sb.append("        '").append(string).append("',\n");
            }
        }
        String activeRecipes = sb.toString();
        if (!activeRecipes.isEmpty()) {
            activeRecipes = String.valueOf(activeRecipes.substring(0, activeRecipes.length() - 2)) + "\n";
        }
        sb.setLength(0);
        for (RewriteUtility.RewriteDependency recipeDependency : rewriteDependencies) {
            sb.append("        rewrite('").append(recipeDependency.getGroupId()).append(":").append(recipeDependency.getArtifactId()).append(":").append(recipeDependency.getVersion()).append("')\n");
        }
        String dependency = sb.toString();
        sb.setLength(0);
        return String.format(configTemplate, "org.openrewrite.rewrite", RewriteUtility.getRepoVersion("rewrite-gradle-plugin"), activeRecipes, dependency);
    }
}

