/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class RewriteUtility {
    public static final String REWRITE_RESOURCE_JSON = "/resources/rewrite_resource.json";
    public static JSONObject rewriteData = null;
    public static final LinkedHashMap<String, String> recipePrioritySet = new LinkedHashMap();
    public static final Set<String> recipesToSplit = new HashSet<String>();

    static {
        recipesToSplit.add("org.openrewrite.java.migrate.Java8toJava11");
        recipesToSplit.add("org.openrewrite.java.migrate.UpgradeToJava17");
        recipesToSplit.add("org.openrewrite.java.migrate.UpgradeToJava21");
        recipePrioritySet.put("org.openrewrite.java.liberty.RemoveWas2LibertyNonPortableJndiLookup", "RemoveWas2LibertyNonPortableJndiLookup");
        recipePrioritySet.put("org.openrewrite.java.liberty.WebSphereUnavailableSSOMethods", "WebSphereUnavailableSSOMethods");
        recipePrioritySet.put("org.openrewrite.java.liberty.ServerName", "ServerName");
        recipePrioritySet.put("org.openrewrite.xml.liberty.AppDDNamespaceRule", "AppDDNamespaceRule");
        recipePrioritySet.put("org.openrewrite.xml.liberty.EJBDDNamespaceRule", "EJBDDNamespaceRule");
        recipePrioritySet.put("org.openrewrite.xml.liberty.WebDDNamespaceRule", "WebDDNamespaceRule");
        recipePrioritySet.put("org.openrewrite.xml.liberty.PersistenceXmlLocationRule", "PersistenceXmlLocationRule");
        recipePrioritySet.put("org.openrewrite.xml.liberty.ConnectorDDNamespaceRule", "ConnectorDDNamespaceRule");
        recipePrioritySet.put("org.openrewrite.xml.liberty.WebBeansXmlRule", "WebBeansXmlRule");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREDoNotUseSunNetSslInternalWwwProtocolHttpsHandler", "JREDoNotUseSunNetSslInternalWwwProtocolHttpsHandler");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREDoNotUseSunNetSslInternalSslProvider", "JREDoNotUseSunNetSslInternalSslProvider");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREDoNotUseSunNetSslInternalWwwProtocol", "JREDoNotUseSunNetSslInternalWwwProtocol");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREDoNotUseSunNetSslAPIs", "JREDoNotUseSunNetSslAPIs");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREWrapperInterface", "JREWrapperInterface");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREJdbcInterfaceNewMethods", "JREJdbcInterfaceNewMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.MXBeanRule", "MXBeanRule");
        recipePrioritySet.put("org.openrewrite.java.migrate.Java8toJava11", "Java11GeneralInfoAndPotentialIssues");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedSecurityManagerMethods", "RemovedSecurityManagerMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.Krb5LoginModuleClass", "Krb5LoginModuleClass");
        recipePrioritySet.put("org.openrewrite.java.migrate.JREThrowableFinalMethods", "JREThrowableFinalMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedPolicy", "RemovedPolicyClass");
        recipePrioritySet.put("org.openrewrite.java.migrate.ThreadStopDestroy", "ThreadStopDestroy");
        recipePrioritySet.put("org.openrewrite.java.migrate.UseJavaUtilBase64", "RemovedSunBASE64EncoderDecoder");
        recipePrioritySet.put("org.openrewrite.java.migrate.ReferenceCloneMethod", "ReferenceCloneMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.ReplaceAWTGetPeerMethod", "DetectAWTGetPeerMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.ReplaceLocalizedStreamMethods", "RemovedLocalizedStreamMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.InternalBindPackages", "InternalBindPackages");
        recipePrioritySet.put("org.openrewrite.java.migrate.ReplaceComSunAWTUtilitiesMethods", "ReplaceComSunAWTUtilitiesMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.ArrayStoreExceptionToTypeNotPresentException", "ClassGetAnnotationMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.IllegalArgumentExceptionToAlreadyConnectedException", "DatagramChannelSendMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.ChangeDefaultKeyStore", "DetectDefaultKeyStoreChange");
        recipePrioritySet.put("org.openrewrite.java.migrate.UpgradeToJava17", "Java17GeneralInfoAndPotentialIssues");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedFileIOFinalizeMethods", "RemovedFileIOFinalizeMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedZipFinalizeMethods", "RemovedZipFinalizeMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedSSLSessionGetPeerCertificateChainMethodImpl", "RemovedSSLSessionGetPeerCertificateChainMethodImpl");
        recipePrioritySet.put("org.openrewrite.java.migrate.DeprecatedCountStackFramesMethod", "DeprecatedCountStackFramesMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.DeprecatedLogRecordThreadID", "DeprecatedLogRecordMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.Jre17AgentMainPreMainPublic", "jre17AgentMainPreMainPublic");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedLegacySunJSSEProviderName", "RemovedLegacySunJSSEProviderName");
        recipePrioritySet.put("org.openrewrite.java.migrate.SunNetSslPackageUnavailable", "SunNetSslPackageUnavailable");
        recipePrioritySet.put("org.openrewrite.java.migrate.DeprecatedJavaxSecurityCert", "DeprecatedJavaxSecurityCert");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedRMIConnectorServerCredentialTypesConstant", "RemovedRMIConnectorServerCredentialTypesConstant");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedToolProviderConstructor", "RemovedToolProviderConstructor");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedModifierAndConstantBootstrapsConstructors", "RemovedModifierAndConstantBootstrapsConstructors");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedRuntimeTraceMethods", "RemovedRuntimeTraceMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.UpgradeToJava21", "Java21GeneralInfoAndPotentialIssues");
        recipePrioritySet.put("org.openrewrite.java.migrate.DeleteDeprecatedFinalize", "DeleteDeprecatedFinalize");
        recipePrioritySet.put("org.openrewrite.java.migrate.RemovedSubjectMethods", "DeprecatedJavaxSecurityAuth");
        recipePrioritySet.put("org.openrewrite.java.migrate.javax.HttpSessionInvalidate", "HttpSessionInvalidateMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.javaee7.OpenJPAPersistenceProvider", "OpenJPAPersistenceProvider");
        recipePrioritySet.put("org.openrewrite.java.migrate.javax.openJPAToEclipseLink", "OpenJPAToEclipseLink");
        recipePrioritySet.put("org.openrewrite.java.migrate.BeansXmlNamespace", "BeansXmlNamespace");
        recipePrioritySet.put("org.openrewrite.java.migrate.JpaCacheProperties", "JpaCacheProperties");
        recipePrioritySet.put("org.openrewrite.java.migrate.javaee8.ServletIsRequestedSessionIdFromURL", "ServletIsRequestedSessionIdFromURL");
        recipePrioritySet.put("org.openrewrite.java.migrate.javaee8.ApacheDefaultProvider", "ApacheDefaultProvider");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.JavaxMigrationToJakarta", "JakartaEE9PackageRenameRule");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.ApplicationPathWildcardNoLongerAccepted", "ApplicationPathWildcardNoLongerAccepted");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.UpdateApacheWSSecurityPackages", "UpdateApacheWSSecurityPackages");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedJakartaFacesResourceResolver", "RemovedJakartaFacesResourceResolver");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedStateManagerMethods", "RemovedStateManagerMethods");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.DeprecatedCDIAPIsRemoved40", "DeprecatedCDIAPIsRemoved40");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.FacesManagedBeansRemoved", "FacesManagedBeansRemoved");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedIsParmetersProvidedMethod", "RemovedIsParmetersProvidedMethod");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedUIComponentConstant", "RemovedUIComponentConstant");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedJakartaFacesExpressionLanguageClasses", "RemovedJakartaFacesExpressionLanguageClasses");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovalsServletJakarta10", "RemovalsServletJakarta10");
        recipePrioritySet.put("org.openrewrite.java.migrate.BeanDiscovery", "BeansXmlNoVersionNowImplicit");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.FacesJNDINamesChanged", "FacesJNDINamesChanged");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.RemovedSOAPElementFactory", "RemovedSOAPElementFactory");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.WsWsocServerContainerDeprecation", "WsWsocServerContainerDeprecation");
        recipePrioritySet.put("org.openrewrite.java.migrate.jakarta.ServletCookieBehaviorChangeRFC6265", "ServletCookieBehaviorChangeRFC6265");
    }

    private static JSONObject loadRewriteData() {
        String rewriteDataStr = ReportUtility.loadFileAsString(REWRITE_RESOURCE_JSON);
        try {
            rewriteData = JSONObject.parse(rewriteDataStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rewriteData;
    }

    public static LinkedHashSet<String> getSubRecipes(String recipeId) {
        JSONObject recipeListsObject;
        JSONArray recipesArr;
        LinkedHashSet<String> subRecipes = new LinkedHashSet<String>();
        if (rewriteData == null) {
            RewriteUtility.loadRewriteData();
        }
        if ((recipesArr = (JSONArray)(recipeListsObject = (JSONObject)rewriteData.get("recipe_lists")).get(recipeId)) != null) {
            int i = 0;
            while (i < recipesArr.size()) {
                subRecipes.add((String)recipesArr.get(i));
                ++i;
            }
        }
        return subRecipes;
    }

    public static String getRepoVersion(String repo) {
        String version = "";
        if (rewriteData == null) {
            RewriteUtility.loadRewriteData();
        }
        JSONObject repoVersions = (JSONObject)rewriteData.get("repo_versions");
        version = (String)repoVersions.get(repo);
        return version;
    }

    public static enum RewriteDependency {
        LIBERTY("org.openrewrite.recipe", "rewrite-liberty", RewriteUtility.getRepoVersion("rewrite-liberty"), "org\\.openrewrite\\.\\w+\\.liberty\\..*"),
        MIGRATE_JAVA("org.openrewrite.recipe", "rewrite-migrate-java", RewriteUtility.getRepoVersion("rewrite-migrate-java"), "org\\.openrewrite\\.java\\.migrate\\..*");

        private final String groupId;
        private final String artifactId;
        private final String version;
        protected Pattern recipePattern = null;
        private static final Map<String, RewriteDependency> lookupArtifact;
        protected static Map<String, RewriteDependency> knownRecipeDependencies;

        static {
            lookupArtifact = new HashMap<String, RewriteDependency>();
            knownRecipeDependencies = new HashMap<String, RewriteDependency>();
            for (RewriteDependency dependency : EnumSet.allOf(RewriteDependency.class)) {
                lookupArtifact.put(dependency.artifactId, dependency);
            }
        }

        private RewriteDependency(String groupId, String artifactId, String version, String recipeRegex) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.recipePattern = Pattern.compile(recipeRegex);
        }

        public static RewriteDependency resolveRecipeDependency(String recipeId) {
            if (knownRecipeDependencies.containsKey(recipeId)) {
                return knownRecipeDependencies.get(recipeId);
            }
            for (RewriteDependency dependency : EnumSet.allOf(RewriteDependency.class)) {
                if (!dependency.recipePattern.matcher(recipeId).matches()) continue;
                knownRecipeDependencies.put(recipeId, dependency);
                return dependency;
            }
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("RewriteConfigWriter_Unknown_Recipe"), recipeId));
            knownRecipeDependencies.put(recipeId, null);
            return null;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.artifactId;
        }
    }

    public static class RewriteDependencyComparator
    implements Comparator<RewriteDependency> {
        @Override
        public int compare(RewriteDependency e1, RewriteDependency e2) {
            return e1.getArtifactId().compareTo(e2.getArtifactId());
        }
    }
}

