/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.ta;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.ta.ArchiveInfo;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;

public class WebsphereProfile {
    private String name = "";
    private String profilePath = null;
    private String cellName = "";
    private TreeSet<OrderedJSONObject> servers = null;
    private TreeSet<String> clusterNames = null;
    private final TreeSet<String> applicationPaths;
    private TreeSet<OrderedJSONObject> appToClusterMapping = null;
    private boolean isStandalone = true;
    private String webSphereVersion = "";
    private String javaVersion = "";
    private final TreeSet<String> assessmentUnitNames;
    private final ArchiveInfo archive;
    private boolean hasConfig = false;
    private Locale locale = null;
    private TreeSet<OrderedJSONObject> sharedLibraries = null;
    private TreeSet<OrderedJSONObject> serverClasspath = null;
    private TreeSet<OrderedJSONObject> websphereVariables = null;
    private TreeSet<OrderedJSONObject> clusterInfos = null;
    private String libraryName = null;
    private final boolean stopOnMissingBinary;
    private final boolean stopOnMissingSharedLibrary;
    private JSONArray appArray = null;

    public WebsphereProfile(String name2, String profilePath, TreeSet<String> assessmentUnitNames, ArchiveInfo archiveInfo, String libraryName, boolean stopOnMissingBinary, boolean stopOnMissingSharedLibrary) {
        this.name = name2;
        this.profilePath = profilePath;
        this.servers = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.clusterNames = new TreeSet();
        this.appToClusterMapping = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.assessmentUnitNames = assessmentUnitNames;
        this.archive = archiveInfo;
        this.locale = ReportUtility.getLocale();
        this.applicationPaths = new TreeSet();
        this.appArray = new JSONArray();
        this.sharedLibraries = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.serverClasspath = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.websphereVariables = new TreeSet<OrderedJSONObject>(new ScopedJsonComparator());
        this.clusterInfos = new TreeSet<OrderedJSONObject>(new ClusterInfoJsonComparator());
        this.libraryName = libraryName;
        this.stopOnMissingBinary = stopOnMissingBinary;
        this.stopOnMissingSharedLibrary = stopOnMissingSharedLibrary;
    }

    public WebsphereProfile(String name2, String profilePath, String cellName, TreeSet<String> applicationPaths, boolean isStandalone, String webSphereVersion, String javaVersion, TreeSet<String> assessmentUnitNames, ArchiveInfo archiveInfo, boolean hasConfig, boolean stopOnMissingBinary, boolean stopOnMissingSharedLibrary) {
        this.name = name2;
        this.profilePath = profilePath;
        this.cellName = cellName;
        this.servers = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.clusterNames = new TreeSet();
        this.applicationPaths = applicationPaths;
        this.appToClusterMapping = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.isStandalone = isStandalone;
        this.webSphereVersion = webSphereVersion;
        this.javaVersion = javaVersion;
        this.assessmentUnitNames = assessmentUnitNames;
        this.archive = archiveInfo;
        this.locale = ReportUtility.getLocale();
        this.hasConfig = hasConfig;
        this.appArray = new JSONArray();
        this.sharedLibraries = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.serverClasspath = new TreeSet<OrderedJSONObject>(new JsonComparator());
        this.websphereVariables = new TreeSet<OrderedJSONObject>(new ScopedJsonComparator());
        this.clusterInfos = new TreeSet<OrderedJSONObject>(new ClusterInfoJsonComparator());
        this.stopOnMissingBinary = stopOnMissingBinary;
        this.stopOnMissingSharedLibrary = stopOnMissingSharedLibrary;
    }

    public OrderedJSONObject toJSONObject() {
        OrderedJSONObject json = new OrderedJSONObject();
        json.put("name", this.name);
        json.put("profilePath", this.profilePath);
        json.put("cellName", this.cellName);
        JSONArray serversJsonArray = new JSONArray();
        if (this.servers != null) {
            serversJsonArray.addAll(this.servers);
        }
        json.put("servers", serversJsonArray);
        JSONArray clusterNamesJsonArray = new JSONArray();
        if (this.clusterNames != null) {
            clusterNamesJsonArray.addAll(this.clusterNames);
        }
        json.put("clusterNames", clusterNamesJsonArray);
        JSONArray applicationsJsonArray = new JSONArray();
        if (this.applicationPaths != null) {
            applicationsJsonArray.addAll(this.applicationPaths);
        }
        JSONArray clusterInfosJsonArray = new JSONArray();
        if (this.clusterInfos != null) {
            clusterInfosJsonArray.addAll(this.clusterInfos);
        }
        json.put("clusterInfo", clusterInfosJsonArray);
        json.put("applications", applicationsJsonArray);
        JSONArray appToClusterMappingJsonArray = new JSONArray();
        if (this.appToClusterMapping != null) {
            appToClusterMappingJsonArray.addAll(this.appToClusterMapping);
        }
        json.put("appsInfo", appToClusterMappingJsonArray);
        json.put("isStandalone", (Object)this.isStandalone);
        json.put("webSphereVersion", this.webSphereVersion);
        json.put("javaVersion", this.javaVersion);
        json.put("appsFound", (Object)(this.applicationPaths != null && !this.applicationPaths.isEmpty() ? 1 : 0));
        JSONArray sharedLibrariesJsonArray = new JSONArray();
        if (this.sharedLibraries != null) {
            sharedLibrariesJsonArray.addAll(this.sharedLibraries);
        }
        json.put("sharedLibraries", sharedLibrariesJsonArray);
        JSONArray serverClasspathJsonArray = new JSONArray();
        if (this.serverClasspath != null) {
            serverClasspathJsonArray.addAll(this.serverClasspath);
        }
        json.put("serverClasspath", serverClasspathJsonArray);
        JSONArray websphereVariablesJsonArray = new JSONArray();
        if (this.websphereVariables != null) {
            websphereVariablesJsonArray.addAll(this.websphereVariables);
        }
        json.put("webSphereVariables", websphereVariablesJsonArray);
        JSONArray appArray = new JSONArray();
        if (!this.hasConfig) {
            json.put("appArray", applicationsJsonArray);
        } else {
            json.put("appArray", appArray);
        }
        json.put("archive", this.archive.toJSONObject());
        json.put("ignoreMissingSharedLibrary", (Object)(!this.stopOnMissingSharedLibrary ? 1 : 0));
        json.put("ignoreMissingBinary", (Object)(!this.stopOnMissingBinary ? 1 : 0));
        json.put("scanBinaryLocation", (Object)(!this.hasConfig ? 1 : 0));
        json.put("hasConfig", (Object)this.hasConfig);
        json.put("locale", this.locale.getLanguage());
        JSONArray appArrayJson = new JSONArray();
        if (this.assessmentUnitNames != null) {
            appArrayJson.addAll(this.assessmentUnitNames);
        }
        json.put("assessUnitNames", appArrayJson);
        return json;
    }

    public void addAppToClusterInfo(OrderedJSONObject obj) {
        this.appToClusterMapping.add(obj);
    }

    public void addServer(OrderedJSONObject obj) {
        this.servers.add(obj);
    }

    public void addSharedLibrary(OrderedJSONObject obj) {
        this.sharedLibraries.add(obj);
    }

    public void addServerClassPath(OrderedJSONObject obj) {
        this.serverClasspath.add(obj);
    }

    public void addCluster(String name2) {
        this.clusterNames.add(name2);
    }

    public String getName() {
        return this.name;
    }

    public TreeSet<String> getAppPaths() {
        return this.applicationPaths;
    }

    public void addApp(File file) {
        this.addApp(file, false, false);
    }

    public void addApp(File file, boolean isSharedLib, boolean isOutsideLib) {
        String absPath = file.getAbsolutePath();
        if (!this.hasConfig) {
            absPath = absPath.replace("\\", "/");
        }
        this.applicationPaths.add(absPath);
        String prefix = "";
        if (this.libraryName != null) {
            prefix = String.valueOf(this.libraryName) + "-";
        }
        if (isOutsideLib) {
            this.assessmentUnitNames.add(file.getName());
        } else {
            this.assessmentUnitNames.add(String.valueOf(prefix) + file.getName());
        }
        if (isSharedLib) {
            this.appArray.add(absPath);
        }
    }

    public void addWebsphereVariable(OrderedJSONObject obj) {
        this.websphereVariables.add(obj);
    }

    public void addClusterInfo(OrderedJSONObject obj) {
        this.clusterInfos.add(obj);
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    class ClusterInfoJsonComparator
    implements Comparator<OrderedJSONObject> {
        ClusterInfoJsonComparator() {
        }

        @Override
        public int compare(OrderedJSONObject e1, OrderedJSONObject e2) {
            String key = "clusterName";
            return ((String)e1.get(key)).compareTo((String)e2.get(key));
        }
    }

    class JsonComparator
    implements Comparator<OrderedJSONObject> {
        JsonComparator() {
        }

        @Override
        public int compare(OrderedJSONObject e1, OrderedJSONObject e2) {
            String key = e1.containsKey("name") ? "name" : "server";
            return ((String)e1.get(key)).compareTo((String)e2.get(key));
        }
    }

    class ScopedJsonComparator
    implements Comparator<OrderedJSONObject> {
        ScopedJsonComparator() {
        }

        @Override
        public int compare(OrderedJSONObject e1, OrderedJSONObject e2) {
            int result = ((String)e1.get("name")).compareTo((String)e2.get("name"));
            if (result == 0 && e1.containsKey("scope")) {
                result = ((String)e1.get("scope")).compareTo((String)e2.get("scope"));
            }
            return result;
        }
    }
}

