/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.inventory;

import com.ibm.ws.report.Messages;
import java.util.ArrayList;
import java.util.List;

public class AppPackage {
    private String name;
    private List<Issue> listOfIssues = new ArrayList<Issue>();
    private List<String> listOfDuplicateLocations = new ArrayList<String>();
    private List<String> listOfJavaEEImpLocations = new ArrayList<String>();
    private List<String> listOfWSLocations = new ArrayList<String>();
    private List<String> listOfOSLocations = new ArrayList<String>();
    private List<String> listOfMissingDepLocations = new ArrayList<String>();
    private List<String> listOfSharedLibraryDependencies = new ArrayList<String>();
    private List<String> listOfSystemLevelProperties = new ArrayList<String>();
    private String affectServers;

    public AppPackage(String name2) {
        this.name = name2;
    }

    public List<Issue> getIssues() {
        return this.listOfIssues;
    }

    public void addIssue(Issue issue) {
        this.listOfIssues.add(issue);
    }

    public String getName() {
        return this.name;
    }

    public String getAffectServers() {
        return this.affectServers;
    }

    public void setAffectServers(String server) {
        this.affectServers = server;
    }

    public List<String> getLocations(Issue issue) {
        switch (issue) {
            case DUPLICATE_CLASS: {
                return this.listOfDuplicateLocations;
            }
            case JAVA_EE_SE_CLASS: {
                return this.listOfJavaEEImpLocations;
            }
            case WAS_CLASS: {
                return this.listOfWSLocations;
            }
            case OSS_CLASS: {
                return this.listOfOSLocations;
            }
            case MISSING_DEP: {
                return this.listOfMissingDepLocations;
            }
            case SHARED_LIB_DEPENDENCIES: {
                return this.listOfSharedLibraryDependencies;
            }
            case SYSTEM_LEVEL_PROPERTIES: {
                return this.listOfSystemLevelProperties;
            }
        }
        return null;
    }

    public void addLocation(Issue issue, String location) {
        switch (issue) {
            case DUPLICATE_CLASS: {
                this.listOfDuplicateLocations.add(location);
                break;
            }
            case JAVA_EE_SE_CLASS: {
                this.listOfJavaEEImpLocations.add(location);
                break;
            }
            case WAS_CLASS: {
                this.listOfWSLocations.add(location);
                break;
            }
            case OSS_CLASS: {
                this.listOfOSLocations.add(location);
                break;
            }
            case MISSING_DEP: {
                this.listOfMissingDepLocations.add(location);
                break;
            }
            case SHARED_LIB_DEPENDENCIES: {
                this.listOfSharedLibraryDependencies.add(location);
                break;
            }
            case SYSTEM_LEVEL_PROPERTIES: {
                this.listOfSystemLevelProperties.add(location);
            }
        }
    }

    public static enum Issue {
        DUPLICATE_CLASS("DuplicatePackages", null, null, null, null, null, "INVENTORY_REPORT_TABLE_SUMMARY_DUPLICATE_JAR_CONTENTS"),
        DUPLICATE_CLASS_WITHIN("DuplicatePackages", "INVENTORY_REPORT_DUP_PACKAGES_WITHIN_DETAILS", "INVENTORY_REPORT_DUP_PACKAGES_WITHIN_DESC", "INVENTORY_REPORT_DUP_PACKAGES_WITHIN_DESC_TXT", "INVENTORY_REPORT_DUP_PACKAGES_WITHIN_REC", "INVENTORY_REPORT_DUP_PACKAGES_WITHIN_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_DUPLICATE_JAR_CONTENTS"),
        DUPLICATE_CLASS_ACROSS("DuplicatePackages", "INVENTORY_REPORT_DUP_PACKAGES_ACROSS_DETAILS", "INVENTORY_REPORT_DUP_PACKAGES_ACROSS_DESC", "INVENTORY_REPORT_DUP_PACKAGES_ACROSS_DESC_TXT", "INVENTORY_REPORT_DUP_PACKAGES_ACROSS_REC", "INVENTORY_REPORT_DUP_PACKAGES_ACROSS_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_DUPLICATE_JAR_CONTENTS"),
        JAVA_EE_SE_CLASS("JavaEEImplementationsAlreadyProvided", "INVENTORY_REPORT_JAVA_IMP_DETAILS", "INVENTORY_REPORT_JAVA_IMP_DESC", "INVENTORY_REPORT_JAVA_IMP_DESC_TXT", "INVENTORY_REPORT_JAVA_IMP_REC", "INVENTORY_REPORT_JAVA_IMP_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_DUPLICATE_JAR_CONTENTS"),
        OSS_CLASS("ThirdPartyImplementation", "INVENTORY_REPORT_OS_IMP_DETAILS", "INVENTORY_REPORT_OS_IMP_DESC", "INVENTORY_REPORT_OS_IMP_DESC_TXT", "INVENTORY_REPORT_OS_IMP_REC", "INVENTORY_REPORT_OS_IMP_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_OSS_CONTENTS"),
        WAS_CLASS("WebSphereImplementation", "INVENTORY_REPORT_WS_IMP_DETAILS", "INVENTORY_REPORT_WS_IMP_DESC", "INVENTORY_REPORT_WS_IMP_DESC_TXT", "INVENTORY_REPORT_WS_IMP_REC", "INVENTORY_REPORT_WS_IMP_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_DUPLICATE_JAR_CONTENTS"),
        MISSING_DEP("MissingDep", "INVENTORY_REPORT_MISSING_DEP_DETAILS", "INVENTORY_REPORT_MISSING_DEP_DESC", "INVENTORY_REPORT_MISSING_DEP_DESC_TXT", "INVENTORY_REPORT_MISSING_DEP_REC", "INVENTORY_REPORT_MISSING_DEP_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_MISSING_DEPENDENCIES"),
        UNUSED_ARCHIVES("Unused", "INVENTORY_REPORT_NOT_REF_ARCH_DETAILS", "INVENTORY_REPORT_NOT_REF_ARCH_DESC", "INVENTORY_REPORT_NOT_REF_ARCH_DESC_TXT", "INVENTORY_REPORT_NOT_REF_ARCH_REC", "INVENTORY_REPORT_NOT_REF_ARCH_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_ARCHIVES_NOT_REFERENCED"),
        SHARED_LIB_DEPENDENCIES("SharedLibDependencies", "INVENTORY_REPORT_SL_DEP_DETAILS", "INVENTORY_REPORT_SL_DEP_DESC", "INVENTORY_REPORT_SL_DEP_DESC_TXT", "INVENTORY_REPORT_SL_DEP_REC", "INVENTORY_REPORT_SL_DEP_REC_TXT", "INVENTORY_REPORT_TABLE_SUMMARY_SHARED_LIB_DEPENDENCIES"),
        SYSTEM_LEVEL_PROPERTIES("DetectSystemLevelProperties", "INVENTORY_REPORT_SYSTEM_LEVEL_PROPERTIES_DETAILS", "INVENTORY_REPORT_SYSTEM_LEVEL_PROPERTIES_DESC", null, "INVENTORY_REPORT_SYSTEM_LEVEL_PROPERTIES_RECOMMENDATION", null, "INVENTORY_REPORT_TABLE_SUMMARY_JVM_PROPS");

        private final String ruleName;
        private final String title;
        private final String desc;
        private final String txtDesc;
        private final String rec;
        private final String txtRec;
        private final String tableSummary;

        private Issue(String ruleName, String title, String desc, String txtDesc, String rec, String txtRec, String tableSummary) {
            this.ruleName = ruleName;
            this.title = title;
            this.desc = desc;
            this.txtDesc = txtDesc;
            this.rec = rec;
            this.txtRec = txtRec;
            this.tableSummary = tableSummary;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public String getTitle() {
            return Messages.getString(this.title);
        }

        public String getDescription() {
            return Messages.getString(this.desc);
        }

        public String getTextDescription() {
            return Messages.getString(this.txtDesc);
        }

        public String getRecommendation() {
            return Messages.getString(this.rec);
        }

        public String getTextRecommendation() {
            return Messages.getString(this.txtRec);
        }

        public String getTableSummary() {
            return Messages.getString(this.tableSummary);
        }
    }
}

