/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities.eetechnologies;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.binary.utilities.eetechnologies.Technology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JAXRSTechnology
extends Technology {
    public static final String JAXRS_1_1 = "jaxrs-1.1";
    public static final String JAXRS_2_0 = "jaxrs-2.0";
    public static final String JAXRS_2_1 = "jaxrs-2.1";
    public static final String RESTFUL_WS_3_0 = "restfulWS-3.0";
    public static final String CDI_1_0 = "cdi-1.0";

    public JAXRSTechnology(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion sourceJavaEEVersion, ReportInputData.JavaEEVersion targetJavaEEVersion) {
        super(sourceAppServer, targetAppServer, sourceJavaEEVersion, targetJavaEEVersion);
    }

    @Override
    public List<String> getRules() {
        ArrayList<String> rules = new ArrayList<String>();
        if (this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE6 && this.isWasToLiberty()) {
            rules.add("/rules/liberty/Was2LibertyJAXRS11List.xml");
        } else {
            if (this.includeEE7() || this.isWasToLiberty() && this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE7) {
                if (this.sourceJavaEEVersion == ReportInputData.JavaEEVersion.EE7 && this.isWasToLiberty()) {
                    rules.add("/rules/liberty/Was2LibertyJAXRS11List.xml");
                }
                if (this.targetJavaEEVersion == ReportInputData.JavaEEVersion.EE7) {
                    rules.add("/rules/java/JavaEE6JAXRSList.xml");
                }
                if (this.targetAppServer == ReportInputData.AppServer.WAS90) {
                    rules.add("/rules/java/JavaEE7JAXRSTWAS90List.xml");
                }
                rules.add("/rules/java/JavaEE7JAXRSList.xml");
            }
            if (this.includeEE8()) {
                rules.add("/rules/java/JavaEE8JAXRS21List.xml");
            }
            if (this.includeEE9()) {
                rules.add("/rules/java/JakartaEE9RestfulWSList.xml");
            }
        }
        return rules;
    }

    @Override
    public List<String> getRules(Set<String> features, ConfigFeatureVersionInfo cfvi, Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures) {
        ArrayList<String> rules = new ArrayList<String>();
        if (this.targetAppServer == ReportInputData.AppServer.WAS90) {
            if (this.containsFeatureOrLater(features, CDI_1_0)) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE7JAXRSTWAS90List.xml"));
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE7JAXRSList.xml"));
            } else {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE6JAXRSList.xml"));
            }
        } else {
            if (features.contains(JAXRS_1_1) && this.isWasToLiberty()) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/liberty/Was2LibertyJAXRS11List.xml"));
            }
            if (this.isSourceBefore(ReportInputData.JavaEEVersion.EE7) && this.reportToRuleIds.containsKey("/rules/java/JavaEE7JAXRSList.xml") && this.containsFeatureOrLater(features, JAXRS_2_0)) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE7JAXRSList.xml"));
            }
            if (this.isSourceBefore(ReportInputData.JavaEEVersion.EE8) && this.reportToRuleIds.containsKey("/rules/java/JavaEE8JAXRS21List.xml") && this.containsFeatureOrLater(features, JAXRS_2_1)) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JavaEE8JAXRS21List.xml"));
            }
            if (this.isSourceBefore(ReportInputData.JavaEEVersion.EE9) && this.reportToRuleIds.containsKey("/rules/java/JakartaEE9RestfulWSList.xml") && this.containsFeatureOrLater(features, RESTFUL_WS_3_0)) {
                rules.addAll((Collection)this.reportToRuleIds.get("/rules/java/JakartaEE9RestfulWSList.xml"));
            }
        }
        return rules;
    }

    @Override
    public List<String> getAllRules() {
        ArrayList<String> rules = new ArrayList<String>();
        rules.add("/rules/liberty/Was2LibertyJAXRS11List.xml");
        rules.add("/rules/java/JavaEE6JAXRSList.xml");
        rules.add("/rules/java/JavaEE7JAXRSList.xml");
        rules.add("/rules/java/JavaEE8JAXRS21List.xml");
        rules.add("/rules/java/JakartaEE9RestfulWSList.xml");
        return rules;
    }
}

