/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class DetectExcessClassFiles
extends DetectFile {
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.ExcessClassFiles";
    protected static final Pattern[] classFiles = new Pattern[]{Pattern.compile(".*(?<=\\/WEB-INF\\/classes\\/).*\\.class")};
    Map<String, Integer> classFileTotalsPerArchive = new HashMap<String, Integer>();

    public DetectExcessClassFiles() {
        this("DetectExcessClassFiles", RULE_DESC, classFiles, false);
    }

    public DetectExcessClassFiles(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        super(ruleName, desc, files, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> matches = store.getMatchingFileNames(classFiles[0], false, true);
        if (matches.size() > 0) {
            String topArchiveName = ReportUtility.getFirstArchiveName(matches.iterator().next());
            if (topArchiveName.endsWith(".ear")) {
                for (String match : matches) {
                    if (!(match = ReportUtility.getLastArchiveFileName(match)).endsWith(".war")) continue;
                    int count = this.classFileTotalsPerArchive.containsKey(match) ? this.classFileTotalsPerArchive.get(match) : 0;
                    this.classFileTotalsPerArchive.put(match, count + 1);
                }
            } else {
                this.classFileTotalsPerArchive.put(topArchiveName, matches.size());
            }
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        Set<String> archiveNames = this.classFileTotalsPerArchive.keySet();
        int excessiveClassThreshold = store.getHiddenJunitFlag() ? 10 : 1000;
        for (String archiveName : archiveNames) {
            int excessClassFilesTotal = this.classFileTotalsPerArchive.get(archiveName);
            if (excessClassFilesTotal <= excessiveClassThreshold) continue;
            String fileTotal = Integer.toString(excessClassFilesTotal);
            this.detailResults.add(new DetailResult("DetectExcessClassFiles", archiveName, null, fileTotal));
        }
        return this.detailResults;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.classFileTotalsPerArchive.clear();
    }
}

