/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class TomcatContextParameter
extends DetectElement {
    protected static final String RULE_NAME = "TomcatContextParameter";
    protected static final String RULE_DESC = "appconversion.tomcat.rule.xml.context.parameter";
    protected static final String PARAM_NAME_KEY = "param-name";
    protected static final String PARAM_VALUE_KEY = "param-value";
    protected static final String NAME_KEY = "name";
    protected static final String VALUE_KEY = "value";
    protected static final String OVERRIDE_KEY = "override";
    protected static final String[] WEB_XML_FILENAMES = new String[]{"WEB-INF/web.xml"};
    protected static final String[] WEB_XML_TAGS = new String[]{"context-param"};
    protected static final String[] CONTEXT_XML_FILENAMES = new String[]{"META-INF/context.xml"};
    protected static final String[] CONTEXT_XML_TAGS = new String[]{"Parameter"};
    protected static final String[] CONTEXT_XML_PARENT_TAGS = new String[]{"Context"};
    protected static final String[] ALL_FILENAMES = new String[]{WEB_XML_FILENAMES[0], CONTEXT_XML_FILENAMES[0]};
    private List<ParameterInfo> webXMLElements;
    private List<ParameterInfo> contextXMLElements;
    private DetectElement detectContextParameter = new DetectElement("TomcatContextParameter", "appconversion.tomcat.rule.xml.context.parameter", CONTEXT_XML_TAGS, CONTEXT_XML_FILENAMES, null, null, false, null, null, null, false, null, null, null, false, CONTEXT_XML_PARENT_TAGS, false){

        @Override
        protected boolean includeInResults(Node node, String key, XMLResource resource) {
            TomcatContextParameter.this.contextXMLElements.add(new ParameterInfo(node, key, resource.getNodeLineNumber(node)));
            return false;
        }
    };

    public TomcatContextParameter() {
        super(RULE_NAME, Messages.getRuleDescription(RULE_DESC), WEB_XML_TAGS, WEB_XML_FILENAMES, null, null, false, null, null, null, false);
        this.webXMLElements = new ArrayList<ParameterInfo>();
        this.contextXMLElements = new ArrayList<ParameterInfo>();
    }

    @Override
    public String[] getFileNames() {
        return ALL_FILENAMES;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.detectContextParameter.analyze(store, detectOnce);
    }

    @Override
    public boolean includeInResults(Node node, String key, XMLResource resource) {
        this.webXMLElements.add(new ParameterInfo(node));
        return false;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        for (ParameterInfo contextElement : this.contextXMLElements) {
            boolean found = false;
            int i = 0;
            while (!found && i < this.webXMLElements.size()) {
                ParameterInfo webElement = this.webXMLElements.get(i);
                if (contextElement.name != null && contextElement.name.equals(webElement.name)) {
                    if (!(contextElement.override || contextElement.value != null && contextElement.value.equals(webElement.value))) {
                        finalResults.add(new DetailResult(RULE_NAME, contextElement.key, Messages.getRuleDescription(RULE_DESC), CONTEXT_XML_TAGS[0], 1, null, contextElement.line));
                    }
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            finalResults.add(new DetailResult(RULE_NAME, contextElement.key, Messages.getRuleDescription(RULE_DESC), CONTEXT_XML_TAGS[0], 1, null, contextElement.line));
        }
        return finalResults;
    }

    private class ParameterInfo {
        private final String name;
        private boolean override;
        private final String value;
        private String key;
        private int line;

        ParameterInfo(Node contextParamNode) {
            this.name = XMLRuleUtil.getAttributeOrChildNodeValue(contextParamNode, TomcatContextParameter.PARAM_NAME_KEY);
            this.value = XMLRuleUtil.getAttributeOrChildNodeValue(contextParamNode, TomcatContextParameter.PARAM_VALUE_KEY);
        }

        ParameterInfo(Node parameterNode, String key, int line) {
            this.key = key;
            this.line = line;
            Node nameNode = parameterNode.getAttributes().getNamedItem(TomcatContextParameter.NAME_KEY);
            Node valueNode = parameterNode.getAttributes().getNamedItem(TomcatContextParameter.VALUE_KEY);
            Node overrideNode = parameterNode.getAttributes().getNamedItem(TomcatContextParameter.OVERRIDE_KEY);
            this.name = nameNode == null ? null : nameNode.getNodeValue();
            this.value = valueNode == null ? null : valueNode.getNodeValue();
            this.override = overrideNode == null || !"false".equalsIgnoreCase(overrideNode.getNodeValue());
        }
    }
}

