/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Set;
import java.util.regex.Pattern;

public class Java17GeneralInfoAndPotentialIssues
extends DetectFile {
    protected static String RULE_NAME = "Java17GeneralInfoAndPotentialIssues";
    protected static final String RULE_DESC = "appconversion.jre.17.Java17GeneralInfoAndPotentialIssues";
    private static final Pattern fileName = Pattern.compile(".*\\.class$");

    public Java17GeneralInfoAndPotentialIssues() {
        super(RULE_NAME, RULE_DESC, (Pattern[])null, true);
        this.setRecipes(new String[]{"org.openrewrite.java.migrate.UpgradeToJava17"});
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> classFiles = store.getMatchingFileNames(fileName);
        if (!classFiles.isEmpty()) {
            this.detailResults.add(new DetailResult(this.ruleName, ReportUtility.getFirstArchiveName(classFiles.iterator().next()), this.ruleDescription, Messages.getCategoryDescription("appconversion.jre.17.category")));
        }
    }
}

