/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class InjectionTarget
extends DetectElement {
    protected static final String RULE_NAME = "InjectionTarget";
    protected static final String RULE_DESC = "appconversion.javaee7.servlet.InjectionTarget";
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml", "META-INF/web-fragment.xml"};
    protected static final String namespace = "*";
    protected static final String[] tags = new String[]{"injection-target"};
    protected Map<String, Set<String>> webFragRefNames = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> webRefNames = new HashMap<String, Set<String>>();
    protected Map<String, Set<DetailResult>> refNamesToResults = new HashMap<String, Set<DetailResult>>();

    public InjectionTarget() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, null, namespace, false, null, null, null, false);
    }

    public InjectionTarget(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.webFragRefNames.clear();
        this.webRefNames.clear();
        this.refNamesToResults.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        Set<String> refNames = this.refNamesToResults.keySet();
        for (String refName : refNames) {
            Set<DetailResult> results = this.refNamesToResults.get(refName);
            for (DetailResult nextResult : results) {
                Set<String> names;
                String webXmlFileName;
                String fileName = nextResult.getFileName();
                int index = fileName.lastIndexOf(".war");
                if (index <= -1 || !this.webRefNames.containsKey(webXmlFileName = String.valueOf(fileName.substring(0, index + 4)) + "/WEB-INF/web.xml") || (names = this.webRefNames.get(webXmlFileName)) == null || !names.contains(refName)) continue;
                finalResults.add(nextResult);
            }
        }
        return finalResults;
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource resource) {
        Node parentNode = result.getParentNode();
        String name2 = XMLRuleUtil.getNodeValue(parentNode, "res-ref-name");
        if (name2 == null) {
            return false;
        }
        if (key.endsWith("/web-fragment.xml")) {
            Set<Object> refNames;
            if (this.webFragRefNames.containsKey(key)) {
                refNames = this.webFragRefNames.get(key);
                refNames.add(name2);
            } else {
                refNames = new HashSet<String>();
                refNames.add(name2);
                this.webFragRefNames.put(key, refNames);
            }
            String criteria = result.getLocalName();
            DetailResult newResult = new DetailResult(this.ruleName, key, this.ruleDescription, criteria, 1, null, resource.getNodeLineNumber(result));
            if (this.refNamesToResults.containsKey(name2)) {
                Set<DetailResult> specificResults = this.refNamesToResults.get(name2);
                specificResults.add(newResult);
            } else {
                HashSet<DetailResult> specificResults = new HashSet<DetailResult>();
                specificResults.add(newResult);
                this.refNamesToResults.put(name2, specificResults);
            }
        } else if (key.endsWith("/web.xml")) {
            if (this.webRefNames.containsKey(key)) {
                Set<String> refNames = this.webRefNames.get(key);
                refNames.add(name2);
            } else {
                HashSet<String> refNames = new HashSet<String>();
                refNames.add(name2);
                this.webRefNames.put(key, refNames);
            }
        }
        return false;
    }
}

