/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Node;

public class EJBExceptionMismatch
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "EJBExceptionMismatch";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.exception.mismatch";
    static final List<String> REMOTE_EXCEPTIONS = new ArrayList<String>(){
        {
            this.add("java/rmi/RemoteException");
            this.add("RemoteException");
        }
    };
    protected static final String[] classnames = new String[]{"javax.ejb.SessionBean", "javax.ejb.EntityBean", "javax.ejb.MessageDrivenBean"};
    protected static final String[] homeAndRemoteClassnames = new String[]{"javax.ejb.EJBHome", "javax.ejb.EJBLocalHome", "javax.ejb.EJBObject", "javax.ejb.EJBLocalObject"};
    protected static final String[] interfaceElements = new String[]{"home", "local", "local-home", "remote"};
    private static final String[] tags = new String[]{"ejb-class"};
    private static final String[] ejbJarFileName = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    private TreeMap<String, List<String>> ejbFQMethodToExceptions = new TreeMap();
    private Map<String, ArrayList<String>> ejbBeanToInterface = new HashMap<String, ArrayList<String>>();
    DetectClass _detectEJBs = null;
    DetectClass _detectEJBInterfaces = null;
    DetectElement _detectEJBClassElement = null;

    public EJBExceptionMismatch() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public EJBExceptionMismatch(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this._detectEJBs = new DetectClass(ruleName, desc, null, false, false, flagOnce, null, classnames, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                EJBExceptionMismatch.this.ejbFQMethodToExceptions.putAll(data.getQualifiedMethodNameToExceptions());
                return false;
            }
        };
        this._detectEJBInterfaces = new DetectClass(ruleName, desc, null, false, false, flagOnce, homeAndRemoteClassnames, null, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                EJBExceptionMismatch.this.ejbFQMethodToExceptions.putAll(data.getQualifiedMethodNameToExceptions());
                return false;
            }
        };
        this._detectEJBClassElement = new DetectElement(ruleName, desc, tags, ejbJarFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String ejbClassName = XMLRuleUtil.getTextWithoutWhitespace(node);
                if (ejbClassName != null) {
                    String archiveName = ReportUtility.getFirstArchiveName(fileName);
                    StringBuilder sb = new StringBuilder();
                    sb.append(archiveName);
                    sb.append('.');
                    sb.append(ejbClassName);
                    String fqClassName = sb.toString();
                    Node parentNode = node.getParentNode();
                    String[] stringArray = interfaceElements;
                    int n = interfaceElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        String elementValue = XMLRuleUtil.getNodeValue(parentNode, element);
                        if (elementValue != null) {
                            ArrayList interfaceList = null;
                            sb.setLength(0);
                            sb.append(archiveName);
                            sb.append('.');
                            sb.append(elementValue);
                            String fqElementValue = sb.toString();
                            if (EJBExceptionMismatch.this.ejbBeanToInterface.containsKey(fqClassName)) {
                                interfaceList = (ArrayList)EJBExceptionMismatch.this.ejbBeanToInterface.get(fqClassName);
                                interfaceList.add(fqElementValue);
                            } else {
                                interfaceList = new ArrayList();
                                interfaceList.add(fqElementValue);
                                EJBExceptionMismatch.this.ejbBeanToInterface.put(fqClassName, interfaceList);
                            }
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._detectEJBs.analyze(store, detectOnce);
        this._detectEJBInterfaces.analyze(store, detectOnce);
        this._detectEJBClassElement.analyze(store, false);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectEJBs.clearResults();
        this._detectEJBClassElement.clearResults();
        this._detectEJBInterfaces.clearResults();
        this.ejbBeanToInterface.clear();
        this.ejbFQMethodToExceptions.clear();
    }

    @Override
    public String[] getFileNames() {
        return ejbJarFileName;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"*"};
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        for (Map.Entry<String, ArrayList<String>> e : this.ejbBeanToInterface.entrySet()) {
            String beanClass = e.getKey();
            Map<String, List<String>> beanImplementationMethods = this.getByPrefix(this.ejbFQMethodToExceptions, String.valueOf(beanClass) + ".");
            beanImplementationMethods = this.getMethodName(beanImplementationMethods);
            for (String interfaceClass : e.getValue()) {
                SortedMap<String, List<String>> interfaceMethods = this.getByPrefix(this.ejbFQMethodToExceptions, String.valueOf(interfaceClass) + ".");
                for (Map.Entry f : interfaceMethods.entrySet()) {
                    String methodName = (String)f.getKey();
                    if (!beanImplementationMethods.containsKey(methodName = methodName.substring(methodName.lastIndexOf(46) + 1))) continue;
                    ArrayList remoteExceptionRemoved = new ArrayList((Collection)f.getValue());
                    remoteExceptionRemoved.removeAll(REMOTE_EXCEPTIONS);
                    Collections.sort(remoteExceptionRemoved);
                    LinkedList beanClassExceptions = new LinkedList(beanImplementationMethods.get(methodName));
                    beanClassExceptions.removeAll(REMOTE_EXCEPTIONS);
                    Collections.sort(beanClassExceptions);
                    if (beanClassExceptions.equals(remoteExceptionRemoved)) continue;
                    this.detailResults.add(new DetailResult(this.ruleName, beanClass, this.ruleDescription, Messages.getFormattedMessage(Messages.getString("Report_Criteria_Method_Throws_Clause_Mismatch"), methodName, beanClass, ((String)f.getKey()).toString())));
                }
            }
        }
        return this.detailResults;
    }

    public SortedMap<String, List<String>> getByPrefix(NavigableMap<String, List<String>> myMap, String prefix) {
        return myMap.subMap(prefix, String.valueOf(prefix) + '\uffff');
    }

    public Map<String, List<String>> getMethodName(Map<String, List<String>> myMap) {
        HashMap<String, List<String>> methodToExceptions = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> e : myMap.entrySet()) {
            String keyName = e.getKey();
            List<String> exceptionValues = e.getValue();
            keyName = keyName.substring(keyName.lastIndexOf(46) + 1);
            methodToExceptions.put(keyName, exceptionValues);
        }
        return methodToExceptions;
    }
}

