/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DetectSubresourceLocatorMethods
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectSubresourceLocatorMethods";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee9.restfulws.DetectSubresourceLocatorMethods";
    protected static final String classNameJavax = "javax.ws.rs.Path";
    protected static final String classNameJakarta = "jakarta.ws.rs.Path";
    protected static final String[] classNames = new String[]{"javax.ws.rs.Path", "jakarta.ws.rs.Path"};
    protected Map<String, Map<String, Integer>> mapOfClassesToResourceLocators = new HashMap<String, Map<String, Integer>>();

    public DetectSubresourceLocatorMethods() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "method", null, null);
    }

    public DetectSubresourceLocatorMethods(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        List<AnnotationInfo> annoInfos = ad.getAnnotationInformation();
        if (annoInfos.size() == 1) {
            AnnotationInfo annoInfo = annoInfos.get(0);
            String attributeValue = annoInfo.getAttributeValue();
            Map<String, Integer> resourceLocatorPathsCount = this.mapOfClassesToResourceLocators.get(key);
            if (resourceLocatorPathsCount == null) {
                resourceLocatorPathsCount = new HashMap<String, Integer>();
                this.mapOfClassesToResourceLocators.put(key, resourceLocatorPathsCount);
            }
            if (!resourceLocatorPathsCount.containsKey(attributeValue)) {
                resourceLocatorPathsCount.put(attributeValue, 1);
            } else {
                resourceLocatorPathsCount.put(attributeValue, resourceLocatorPathsCount.get(attributeValue) + 1);
            }
            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, data.getClassName(), 1, attributeValue, ad.getLineNumber()));
        }
        return false;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> results = super.getResults(store);
        Iterator<DetailResult> it = results.iterator();
        while (it.hasNext()) {
            DetailResult result = it.next();
            String locatorPath = result.getReference();
            String classPath = result.getFileName();
            Map<String, Integer> resourceLocatorPathsCount = this.mapOfClassesToResourceLocators.get(classPath);
            int count = resourceLocatorPathsCount.get(locatorPath);
            if (count > 1) {
                resourceLocatorPathsCount.put(locatorPath, 0);
                continue;
            }
            it.remove();
        }
        return results;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.mapOfClassesToResourceLocators.clear();
    }
}

