/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectDefaultMessageListenerContainer
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectDefaultMessageListenerContainer";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.defaultMessageListenerContainer";
    protected static final String TRANSACTION_MANAGER_ATTRIBUTE_VALUE = "transactionManager";
    protected static final String TASK_EXECUTOR_ATTRIBUTE_VALUE = "taskExecutor";
    protected static final String propertyValues_Regex = "transactionManager|taskExecutor";
    protected static final List<String> propsNeeded = Arrays.asList("transactionManager", "taskExecutor");
    protected static final String[] beanElement = new String[]{"bean"};
    protected static final String[] xmlFileNames = new String[]{".xml"};
    protected static final DetectRule.XMLFileType xmlFileType = DetectRule.XMLFileType.SPRING;
    protected static final String CLASS_ATTRIBUTE_VALUE = "org\\.springframework\\.jms\\.listener\\.DefaultMessageListenerContainer";
    protected static final DetectRule.FlagOnce flagOnce = DetectRule.FlagOnce.NONE;

    public DetectDefaultMessageListenerContainer() {
        this(RULE_NAME, RULE_DESC, beanElement, xmlFileNames, xmlFileType, null, "class", CLASS_ATTRIBUTE_VALUE, null, flagOnce, null, null);
    }

    public DetectDefaultMessageListenerContainer(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, String namespace, String attributeName, String attributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnce, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, namespace, attributeName, attributeValue, attributeNamespace, flagOnce, validateNamespace, documentNamespace);
    }

    @Override
    public void clearResults() {
        super.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        HashSet<String> propsFound = new HashSet<String>();
        Element parentNode = ((Attr)node).getOwnerElement();
        List<Element> elementResults = XMLRuleUtil.getChildElementsByAttributeValue(parentNode, null, "property", "name", propertyValues_Regex);
        if (elementResults != null) {
            for (Element e : elementResults) {
                String attributeValue = e.getAttribute("name");
                propsFound.add(attributeValue);
                if (propsFound.size() != propsNeeded.size()) continue;
                return false;
            }
        }
        return true;
    }
}

