/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DetectElement
extends DetectRule {
    private static final String CLASS_NAME = DetectElement.class.getName();
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule);
    protected String namespace = "*";
    protected String[] tags = null;
    protected String[] parentTags = null;
    protected String[] xmlFiles = null;
    protected String value = null;
    protected String[] values = null;
    protected String documentNamespace = null;
    protected String documentNamespaceToValidate = null;
    protected boolean onlyValidateDocumentNamespaceIfPresent = false;
    protected boolean flagNoRootNode = false;
    protected String missingChildElement = null;
    protected String missingChildElementValue = null;
    protected String missingChildElementAttribute = null;
    protected String missingChildElementAttributeValue = null;
    protected boolean flagNotEmpty = false;
    protected boolean flagDuplicate = false;
    protected boolean noTag = false;
    protected boolean flagRootNode = false;
    protected DetectRule.XMLFileType xmlFileType = null;

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        this(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, null, null, null, false, null, false);
    }

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        this(ruleName, desc, tags, fileNames, value, namespace, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        this(ruleName, desc, tags, fileNames, false, value, namespace, flagOnceType, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, boolean flagRootNode, String value, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        this(ruleName, desc, tags, fileNames, DetectRule.XMLFileType.ALL, false, value, namespace, flagOnceType, false, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, boolean flagRootNode, String value, String namespace, DetectRule.FlagOnce flagOnceType, boolean hideResult, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        this(ruleName, desc, tags, fileNames, xmlFileType, flagRootNode, value, namespace, flagOnceType, hideResult, docNamespace, false, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    public DetectElement(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, boolean flagRootNode, String value, String namespace, DetectRule.FlagOnce flagOnceType, boolean hideResult, String docNamespace, boolean flagNoRootNode, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.tags = tags;
        this.parentTags = parentTags;
        this.xmlFiles = fileNames;
        this.flagRootNode = flagRootNode;
        this.value = value;
        if (namespace != null) {
            this.namespace = namespace;
        }
        this.documentNamespace = docNamespace;
        this.documentNamespaceToValidate = validateNamespace;
        this.onlyValidateDocumentNamespaceIfPresent = onlyValidateDocumentNamespaceIfPresent;
        this.flagNoRootNode = flagNoRootNode;
        this.missingChildElement = missingChildElement;
        this.missingChildElementValue = missingChildElementValue;
        this.missingChildElementAttribute = missingChildElementAttribute;
        this.missingChildElementAttributeValue = missingChildElementAttributeValue;
        this.flagNotEmpty = flagNotEmpty;
        this.flagDuplicate = flagDuplicate;
        this.noTag = tags == null || tags.length == 0;
        this.xmlFileType = xmlFileType;
    }

    public DetectElement(String ruleName, String desc, String tag, String[] fileNames, String[] values, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        this(ruleName, desc, tag, fileNames, values, namespace, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    public DetectElement(String ruleName, String desc, String tag, String[] fileNames, String[] values, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        this(ruleName, desc, tag, fileNames, values, false, namespace, flagOnceType, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    public DetectElement(String ruleName, String desc, String tag, String[] fileNames, String[] values, boolean flagRootNode, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        this(ruleName, desc, tag, fileNames, DetectRule.XMLFileType.ALL, values, false, namespace, flagOnceType, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    public DetectElement(String ruleName, String desc, String tag, String[] fileNames, DetectRule.XMLFileType xmlFileType, String[] values, boolean flagRootNode, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, flagOnceType);
        this.tags = new String[]{tag};
        this.xmlFiles = fileNames;
        this.values = values;
        this.flagRootNode = flagRootNode;
        if (namespace != null) {
            this.namespace = namespace;
        }
        this.documentNamespace = docNamespace;
        this.missingChildElement = missingChildElement;
        this.missingChildElementValue = missingChildElementValue;
        this.flagNotEmpty = flagNotEmpty;
        this.noTag = tag == null;
        this.xmlFileType = xmlFileType;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        if (this.xmlFiles == null) {
            return new String[0];
        }
        return this.xmlFiles;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        block32: {
            Set<String> keys;
            block31: {
                if (detectOnce && !this.detailResults.isEmpty()) {
                    return;
                }
                keys = store.getDocumentKeys();
                if (keys.isEmpty() || this.flagNoRootNode) break block31;
                for (String key : keys) {
                    XMLResource resource = store.getDocument(key);
                    Document doc = resource.getDocument();
                    boolean validFile = true;
                    validFile = XMLRuleUtil.validateXMLFile(doc, this.xmlFileType);
                    if (!validFile || !this.shouldFlag(key)) continue;
                    if (this.value != null || this.values != null) {
                        int size = this.value == null ? this.values.length : 1;
                        String[] matchValues = new String[size];
                        matchValues = this.value != null ? new String[]{this.value} : this.values;
                        String[] stringArray = matchValues;
                        int n = matchValues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String nextValue = stringArray[n2];
                            List<Node> results = null;
                            results = this.noTag ? XMLRuleUtil.getTagDeclarationsByNodeOrAttributeValue(doc, key, this.xmlFiles, this.namespace, nextValue, false, true) : XMLRuleUtil.getTagDeclarationsByNodeValue(doc, key, this.xmlFiles, this.namespace, this.tags, nextValue, false);
                            if (!results.isEmpty()) {
                                boolean includeResults = true;
                                String docNamespace = null;
                                if (this.documentNamespaceToValidate != null) {
                                    docNamespace = this.getDocumentRootNamespace(doc);
                                    if (this.onlyValidateDocumentNamespaceIfPresent && (docNamespace == null || docNamespace.matches(this.documentNamespaceToValidate)) || docNamespace != null && docNamespace.matches(this.documentNamespaceToValidate)) {
                                        includeResults = false;
                                    }
                                } else if (this.documentNamespace != null) {
                                    docNamespace = this.getDocumentRootNamespace(doc);
                                    if (docNamespace == null || !docNamespace.matches(this.documentNamespace)) {
                                        includeResults = false;
                                    }
                                } else if (this.flagDuplicate && results.size() < 2) {
                                    includeResults = false;
                                }
                                if (includeResults) {
                                    for (Node node : results) {
                                        String nodeValue;
                                        boolean includeNode = true;
                                        if (this.flagRootNode && !doc.getDocumentElement().equals(node)) {
                                            includeNode = false;
                                        } else if (this.parentTags != null) {
                                            includeNode = this.checkParent(node);
                                        }
                                        if (!includeNode || !(includeNode = this.flagNotEmpty && !node.hasChildNodes() ? false : (this.missingChildElement != null ? this.includeForMissingChildElement(node) : this.includeInResults(node, key, resource)))) continue;
                                        String criteria = node.getLocalName();
                                        criteria = !this.noTag ? String.valueOf(criteria) + "=" + node.getTextContent() : ((nodeValue = node.getNodeValue()) != null ? String.valueOf(criteria) + "=" + nodeValue : String.valueOf(criteria) + "=" + node.getTextContent());
                                        if (this.flag(key)) {
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, criteria, 1, null, resource.getNodeLineNumber(node)));
                                        }
                                        if (!detectOnce && !this.flagOnce) continue;
                                        return;
                                    }
                                }
                            }
                            ++n2;
                        }
                        continue;
                    }
                    List<Node> results = XMLRuleUtil.getTagDeclarations(doc, key, this.xmlFiles, this.namespace, this.tags);
                    if (results.isEmpty()) continue;
                    boolean includeResults = true;
                    String docNamespace = null;
                    if (this.documentNamespaceToValidate != null) {
                        docNamespace = this.getDocumentRootNamespace(doc);
                        if (docNamespace != null && docNamespace.matches(this.documentNamespaceToValidate)) {
                            includeResults = false;
                        }
                    } else if (this.documentNamespace != null) {
                        docNamespace = this.getDocumentRootNamespace(doc);
                        if (docNamespace == null || !docNamespace.matches(this.documentNamespace)) {
                            includeResults = false;
                        }
                    } else if (this.flagDuplicate && results.size() < 2) {
                        includeResults = false;
                    }
                    if (!includeResults) continue;
                    for (Node node : results) {
                        boolean includeNode = true;
                        if (this.flagRootNode && !doc.getDocumentElement().equals(node)) {
                            includeNode = false;
                        } else if (this.parentTags != null) {
                            includeNode = this.checkParent(node);
                        }
                        if (!includeNode || !(includeNode = this.flagNotEmpty && !node.hasChildNodes() ? false : (this.missingChildElement != null ? this.includeForMissingChildElement(node) : this.includeInResults(node, key, resource)))) continue;
                        if (this.flag(key)) {
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, node.getLocalName(), 1, null, resource.getNodeLineNumber(node)));
                        }
                        if (!detectOnce && !this.flagOnce) continue;
                        return;
                    }
                }
                break block32;
            }
            if (!keys.isEmpty() || !this.flagNoRootNode) break block32;
            Set<String> malformedFiles = store.getEmptyXMLFiles();
            for (String file : malformedFiles) {
                if (!this.shouldFlag(file) || !XMLRuleUtil.isMatchingFile(file, this.getFileNames())) continue;
                this.detailResults.add(new DetailResult(this.ruleName, file, this.ruleDescription, "Missing root node", 1, null, 1));
            }
        }
    }

    protected boolean checkParent(Node node) {
        boolean flag = false;
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            String name2 = parentNode.getLocalName();
            return this.doesParentMatch(name2);
        }
        return flag;
    }

    protected boolean doesParentMatch(String name2) {
        String[] stringArray = this.parentTags;
        int n = this.parentTags.length;
        int n2 = 0;
        while (n2 < n) {
            String nextName = stringArray[n2];
            if (name2.equals(nextName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean includeForMissingChildElement(Node node) {
        boolean flag = true;
        if (!node.hasChildNodes()) return flag;
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.indexOf(58) > -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            if (nodeName.equalsIgnoreCase(this.missingChildElement)) {
                if (this.missingChildElementValue != null) {
                    String text = XMLRuleUtil.getTextWithoutWhitespace(child);
                    if (text != null && text.matches(this.missingChildElementValue)) {
                        return false;
                    }
                } else {
                    Node myAttr;
                    if (this.missingChildElementAttribute == null) return false;
                    NamedNodeMap attrs = child.getAttributes();
                    if (attrs != null && (myAttr = attrs.getNamedItem(this.missingChildElementAttribute)) != null) {
                        if (this.missingChildElementAttributeValue == null) return false;
                        String myAttrValue = myAttr.getNodeValue();
                        if (myAttrValue != null && myAttrValue.matches(this.missingChildElementAttributeValue)) {
                            return false;
                        }
                    }
                }
            }
            ++i;
        }
        return flag;
    }

    protected boolean includeInResults(Node result, String key, XMLResource resource) {
        return true;
    }

    protected String getDocumentRootNamespace(Document doc) {
        Element docElement = doc.getDocumentElement();
        String docNamespace = docElement.getNamespaceURI();
        return docNamespace;
    }
}

