/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.technology.DetailResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DetectDefaultMethod
extends DetectClass {
    private final String _interfaceName;
    protected static final String[] defaultMethodArgs = new String[]{""};
    protected DetectClass _classesDeclaringNewMethodAndMapInterfaceImplementedByClass = null;
    protected DetectMethod _classesInvokingNewMethod = null;
    protected HashMap<String, String[]> _implementedInterfacesByFileName = new HashMap();
    protected HashSet<String> _classesThatDeclareMethod = new HashSet();
    protected HashMap<String, String[]> _mapOfClassesToImplementedInterfaces = new HashMap();
    protected HashSet<String> _filesThatDeclareMethod = new HashSet();

    public DetectDefaultMethod(String ruleName, String desc, String interfaceName, String methodName) {
        super(ruleName, desc, null, false, false, false, null, new String[]{interfaceName}, new String[]{methodName}, defaultMethodArgs, null, null);
        this._interfaceName = interfaceName;
        this._classesInvokingNewMethod = new DetectMethod(ruleName, desc, new String[]{methodName}, new String[]{"*"}, null, null, new String[0], DetectRule.FlagOnce.FILE, false, null, null, null, false);
        this._classesDeclaringNewMethodAndMapInterfaceImplementedByClass = new DetectClass(ruleName, desc, new String[0], true, false, this.flagOnce, null, null, null, null, new String[]{methodName}, defaultMethodArgs){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                for (String key : store.getClassDataStoreKeys()) {
                    String[] implementedInterfaces;
                    ClassDataStore data = store.getClassDataStore(key);
                    if (this.flagImplementsMethods(data, null, null, null, false)) {
                        DetectDefaultMethod.this._classesThatDeclareMethod.add(data.getClassName());
                        DetectDefaultMethod.this._filesThatDeclareMethod.add(data.getClassNameWithContext());
                    }
                    if ((implementedInterfaces = data.getImplementedInterfaces()) == null) continue;
                    DetectDefaultMethod.this._mapOfClassesToImplementedInterfaces.put(data.getClassName(), implementedInterfaces);
                }
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._classesDeclaringNewMethodAndMapInterfaceImplementedByClass.clearResults();
        this._implementedInterfacesByFileName.clear();
        this._classesThatDeclareMethod.clear();
        this._mapOfClassesToImplementedInterfaces.clear();
        this._classesInvokingNewMethod.clearResults();
        this._filesThatDeclareMethod.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._classesDeclaringNewMethodAndMapInterfaceImplementedByClass.analyze(store, detectOnce);
        this._classesInvokingNewMethod.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(ClassDataStore data, String filename) {
        String[] implementedInterfaces = data.getImplementedInterfaces();
        this._implementedInterfacesByFileName.put(filename, implementedInterfaces);
        if (data.isInterface()) {
            return false;
        }
        return implementedInterfaces != null && implementedInterfaces.length > 1;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        String interfaceName;
        int i;
        List<DetailResult> results = super.getResults(store);
        Iterator<DetailResult> it = results.iterator();
        while (it.hasNext()) {
            DetailResult result = it.next();
            String className = result.getFileName();
            String[] implementedInterfaces = this._implementedInterfacesByFileName.get(className);
            boolean includeResult = false;
            if (implementedInterfaces == null) continue;
            i = 0;
            while (i < implementedInterfaces.length) {
                interfaceName = implementedInterfaces[i];
                if (!interfaceName.equals(this._interfaceName)) {
                    if (!this._classesThatDeclareMethod.contains(interfaceName)) {
                        if (!store.containsImplementedClassName(interfaceName)) {
                            includeResult = true;
                            break;
                        }
                        if (this.doesInterfaceImplementMethodOrNotExistInBinary(this._mapOfClassesToImplementedInterfaces.get(interfaceName), store)) {
                            includeResult = true;
                            break;
                        }
                    } else {
                        includeResult = true;
                        break;
                    }
                }
                ++i;
            }
            if (includeResult) continue;
            it.remove();
        }
        List<DetailResult> classesInvokingNewMethod = this._classesInvokingNewMethod.getResults(store);
        for (DetailResult result : classesInvokingNewMethod) {
            String[] implementedInterfaces;
            String className = result.getFileName();
            if (this._filesThatDeclareMethod.contains(className) || (implementedInterfaces = this._implementedInterfacesByFileName.get(className)) == null) continue;
            i = 0;
            while (i < implementedInterfaces.length) {
                interfaceName = implementedInterfaces[i];
                if (interfaceName.equals(this._interfaceName)) {
                    results.add(result);
                }
                ++i;
            }
        }
        return results;
    }

    public boolean doesInterfaceImplementMethodOrNotExistInBinary(String[] interfaceNames, SimpleDataStore store) {
        if (interfaceNames != null) {
            int i = 0;
            while (i < interfaceNames.length) {
                String interfaceName = interfaceNames[i];
                if (this._classesThatDeclareMethod.contains(interfaceName) || !store.containsImplementedClassName(interfaceName) || this.doesInterfaceImplementMethodOrNotExistInBinary(this._mapOfClassesToImplementedInterfaces.get(interfaceName), store)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

