/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.mutableconfig;

import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public final class MappedDataHelper {
    protected static SortedMap<String, String> _mappedVarsUsedInConfig = new TreeMap<String, String>();
    protected static final SortedMap<String, List<String>> _mappedConfigProperties = new TreeMap<String, List<String>>();

    public static void registerMappedPropertyNamebyClass(String dataType, String propertyName) {
        if (!SensitiveDataHelper.checkIfSensitiveProperty(dataType, propertyName)) {
            if (!_mappedConfigProperties.containsKey(dataType)) {
                ArrayList<String> props = new ArrayList<String>();
                props.add(propertyName);
                _mappedConfigProperties.put(dataType, props);
            } else if (!((List)_mappedConfigProperties.get(dataType)).contains(propertyName)) {
                ((List)_mappedConfigProperties.get(dataType)).add(propertyName);
            }
        } else {
            ReportUtility.logger.get().log(Level.FINEST, "The " + propertyName + " for " + dataType + " is already registered with the SensitiveData registry.");
        }
    }

    public static boolean checkIfMappedConfigProperty(String dataType, String propertyName) {
        return _mappedConfigProperties.containsKey(dataType) && ((List)_mappedConfigProperties.get(dataType)).contains(propertyName.toLowerCase());
    }

    public static void collectVarOutputForConfig() {
        _mappedVarsUsedInConfig.clear();
    }

    public static Set<String> getRegisteredVarKeys() {
        return _mappedVarsUsedInConfig.keySet();
    }

    public static String getValueForRegisteredVar(String varName) {
        String tmp = (String)_mappedVarsUsedInConfig.get(varName);
        return tmp != null ? tmp : "";
    }

    public static void updateValueForRegisteredVar(String varName, String newValue) {
        if (varName.startsWith("${") && varName.endsWith("}")) {
            varName = varName.substring(2, varName.length() - 1);
        }
        _mappedVarsUsedInConfig.put(varName, newValue);
    }
}

