/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.Application;
import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.generator.ConfigurationGenerator;
import com.ibm.ws.report.binary.configutility.generator.DeployedCluster;
import com.ibm.ws.report.binary.configutility.generator.DeploymentEnvironment;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXmlBuilder;
import com.ibm.ws.report.binary.configutility.generator.TwasCommandBuilder;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.VariablizedDataRegistry;
import com.ibm.ws.report.binary.configutility.resource.ActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.AdminObject;
import com.ibm.ws.report.binary.configutility.resource.ConnectionDefinition;
import com.ibm.ws.report.binary.configutility.resource.DataSource;
import com.ibm.ws.report.binary.configutility.resource.EnvironmentVariable;
import com.ibm.ws.report.binary.configutility.resource.J2CActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2CAdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2CConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIObjectFactory;
import com.ibm.ws.report.binary.configutility.resource.JNDIReferenceBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIURLBinding;
import com.ibm.ws.report.binary.configutility.resource.JdbcProvider;
import com.ibm.ws.report.binary.configutility.resource.MailProvider;
import com.ibm.ws.report.binary.configutility.resource.MailSession;
import com.ibm.ws.report.binary.configutility.resource.MqConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqQueue;
import com.ibm.ws.report.binary.configutility.resource.MqQueueConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqTopic;
import com.ibm.ws.report.binary.configutility.resource.MqTopicConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.SimpleResourceAdapter;
import com.ibm.ws.report.binary.configutility.security.AuthDataEntry;
import com.ibm.ws.report.binary.configutility.security.AuthMechanisms;
import com.ibm.ws.report.binary.configutility.security.LDAPUserRegistry;
import com.ibm.ws.report.binary.configutility.security.LTPAAuthMechanism;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.security.WIMUserRegistry;
import com.ibm.ws.report.binary.configutility.security.tls.ActiveSSLConfigGroups;
import com.ibm.ws.report.binary.configutility.security.tls.DynamicSSLConfigSelection;
import com.ibm.ws.report.binary.configutility.security.tls.SSLConfig;
import com.ibm.ws.report.binary.configutility.server.JpaService;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TraceService;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.server.WebContainer;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Cell;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.configutility.twas.Nodes;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.binary.configutility.twas.References;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class TargetConfig {
    protected final ConfigManager _configManager;
    private final String _appName;
    protected Apps.App _app;
    private boolean _isIdentifiersSet = false;
    private final boolean _isApplicationUsingSessionsSet = false;
    private final DeploymentEnvironment _deploymentEnvironment;
    protected Set<String> _configRulesFlagged = new HashSet<String>();

    TargetConfig(ConfigManager configManager, String appName) throws Exception {
        this._configManager = configManager;
        this._appName = appName;
        this._app = this._configManager.getApps().getApp(this._appName);
        if (this._app == null) {
            Exception failedAppError = this._configManager.getApps().getFailedAppError(this._appName);
            if (failedAppError != null) {
                ReportUtility.logger.get().log(Level.FINE, "Application " + this._appName + " had an exception during the config scan so it will not be migrated. The full stack trace was traced when the exception occured.");
                throw new Exception(failedAppError);
            }
            if (appName.endsWith(".war")) {
                for (Apps.App app : this._configManager.getApps().getApps()) {
                    if (!app.getAppBinaryName().equals(appName)) continue;
                    this._app = app;
                    break;
                }
            }
            if (this._app == null) {
                ReportUtility.logger.get().log(Level.FINE, "Application " + this._appName + " was not found in the configuration, so it will not be migrated. Config manager: " + this._configManager);
                throw new Exception(Messages.getString("Application_Not_Found"));
            }
        }
        this._deploymentEnvironment = new DeploymentEnvironment(this._app);
        ReportUtility.logger.get().log(Level.FINEST, "Created deployment environment for " + this._appName + System.getProperty("line.separator") + this._deploymentEnvironment);
    }

    public void setUsedIdentifierNames(Set<String> usedIdentifierNames) {
        if (this._isIdentifiersSet) {
            ReportUtility.logger.get().log(Level.FINEST, "Identifiers set on application " + this._appName + " after they had already been set before. Only set the identifiers once per TargetConfig instance. Config manager: " + this._configManager);
            throw new IllegalStateException("Identifiers set on application " + this._appName + " after they had already been set before. Only set the identifiers once per TargetConfig instance. Config manager: " + this._configManager);
        }
        this._app.addUsedIdentifierNames(usedIdentifierNames);
        this._app.mapDefaultResources();
        this._isIdentifiersSet = true;
    }

    public void setApplicationIsUsingSessions(boolean applicationIsUsingSessions) {
        ReportUtility.logger.get().log(Level.FINEST, "Setting that application " + this._appName + " is using sessions to " + applicationIsUsingSessions);
        for (DeployedCluster cluster : this._deploymentEnvironment.getDeployedClusters()) {
            cluster.setAppUsingSessions(applicationIsUsingSessions);
        }
    }

    public abstract void migrateConfig() throws Exception;

    public Set<String> getLibraryPaths() {
        return this._app.getLibraryPaths();
    }

    public Set<Library> getAppLibraries() {
        return this._app.getAppLibraries();
    }

    public Set<Library> getAllLibraries() {
        String result;
        ArrayList<String> resolvedClassPaths;
        HashSet<Library> libraries = new HashSet<Library>();
        Servers servers = this._configManager.getServers();
        for (Servers.Server server : servers.getServers()) {
            for (Library library : server.getLibraries().valuesIgnoreScopeConflicts()) {
                resolvedClassPaths = new ArrayList<String>();
                for (String string : library.getClassPath()) {
                    result = CommonUtilities.resolveVariables(string, server.getVariables());
                    if (result == null) continue;
                    resolvedClassPaths.add(result);
                }
                library.setResolvedClassPath(resolvedClassPaths);
                libraries.add(library);
            }
        }
        Clusters clusters = this._configManager.getClusters();
        for (Clusters.Cluster cluster : clusters.getClusters()) {
            for (Library lib : cluster.getLibraries().valuesIgnoreScopeConflicts()) {
                ArrayList<String> resolvedClassPaths2 = new ArrayList<String>();
                for (String classPath : lib.getClassPath()) {
                    String result2 = CommonUtilities.resolveVariables(classPath, cluster.getVariables());
                    if (result2 == null) continue;
                    resolvedClassPaths2.add(result2);
                }
                lib.setResolvedClassPath(resolvedClassPaths2);
                libraries.add(lib);
            }
        }
        Cell cell = this._configManager.getCell();
        for (Library library : cell.getLibraries().valuesIgnoreScopeConflicts()) {
            resolvedClassPaths = new ArrayList();
            for (String string : library.getClassPath()) {
                result = CommonUtilities.resolveVariables(string, cell.getVariables());
                if (result == null) continue;
                resolvedClassPaths.add(result);
            }
            library.setResolvedClassPath(resolvedClassPaths);
            libraries.add(library);
        }
        Nodes nodes = this._configManager.getNodes();
        for (Nodes.Node node : nodes.getNodes()) {
            for (Library library : node.getLibraries().valuesIgnoreScopeConflicts()) {
                ArrayList<String> resolvedClassPaths3 = new ArrayList<String>();
                for (String classPath : library.getClassPath()) {
                    String result3 = CommonUtilities.resolveVariables(classPath, node.getVariables());
                    if (result3 == null) continue;
                    resolvedClassPaths3.add(result3);
                }
                library.setResolvedClassPath(resolvedClassPaths3);
                libraries.add(library);
            }
        }
        return libraries;
    }

    public Set<Variable> getAllVariables() {
        HashSet<Variable> variables = new HashSet<Variable>();
        Servers servers = this._configManager.getServers();
        for (Servers.Server server : servers.getServers()) {
            for (Variable variable : server.getVariables().valuesIgnoreScopeConflicts()) {
                variable.setResolvedValue(CommonUtilities.resolveVariables(variable.getValue(), server.getVariables()));
                variables.add(variable);
            }
        }
        Clusters clusters = this._configManager.getClusters();
        for (Clusters.Cluster cluster : clusters.getClusters()) {
            for (Variable var : cluster.getVariables().valuesIgnoreScopeConflicts()) {
                var.setResolvedValue(CommonUtilities.resolveVariables(var.getValue(), cluster.getVariables()));
                variables.add(var);
            }
        }
        Cell cell = this._configManager.getCell();
        for (Variable variable : cell.getVariables().valuesIgnoreScopeConflicts()) {
            variable.setResolvedValue(CommonUtilities.resolveVariables(variable.getValue(), cell.getVariables()));
            variables.add(variable);
        }
        Nodes nodes = this._configManager.getNodes();
        for (Nodes.Node node : nodes.getNodes()) {
            for (Variable var : node.getVariables().valuesIgnoreScopeConflicts()) {
                var.setResolvedValue(CommonUtilities.resolveVariables(var.getValue(), node.getVariables()));
                variables.add(var);
            }
        }
        return variables;
    }

    public Map<Servers.Server, Set<String>> getServerLibraryNamesMap() {
        return this._app.getServerLibraryNamesMap();
    }

    void migrateConfig(ConfigurationGenerator configGenerator) throws Exception {
        Reference<UserRegistry> activeUserRegistrRef;
        Reference<AuthMechanisms> authRef;
        JpaService jpaService;
        TraceService traceService;
        TransactionService transactionService;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && !javaVersion.startsWith("1.")) {
            System.setProperty("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true");
            ReportUtility.logger.get().log(Level.FINE, "Set com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize to true to remove warning messages");
        }
        ReportUtility.logger.get().log(Level.FINE, "Migrating app " + this._appName + ", destination: " + (configGenerator instanceof LibertyServerXmlBuilder ? "Liberty" : "tWAS"));
        if (!this._isIdentifiersSet) {
            ReportUtility.logger.get().log(Level.FINE, "migrateConfig called for application " + this._appName + " but no list of used identifiers were set.");
            throw new IllegalStateException("migrateConfig called for application " + this._appName + " but no list of used identifiers were set.");
        }
        VariablizedDataRegistry.setTargetFormatIsLiberty(configGenerator instanceof LibertyServerXmlBuilder);
        SensitiveDataHelper.collectVarOutputForConfig();
        MappedDataHelper.collectVarOutputForConfig();
        configGenerator.addHttpEndpoint(this._app.getPorts());
        configGenerator.addIIOPElement(this._app.getPorts());
        configGenerator.addVirtualHosts(this._app.getVirtualHosts());
        configGenerator.addMimeTypes(this._app.getMimeTypes());
        configGenerator.addApplication(this._app);
        configGenerator.setModulesWithSessionManagerConfig(this._app.getModulesWithSessionManagerConfig());
        for (AuthDataEntry authDataEntry : this._app.getAuthDataEntries()) {
            configGenerator.addAuthData(authDataEntry);
        }
        LinkedHashMap<MailProvider, List<MailSession>> mailProviderMap = this._app.getMailSessionsByMailProviders();
        for (Map.Entry<MailProvider, List<MailSession>> entry : mailProviderMap.entrySet()) {
            if (ConfigManagerFactory.isLondon()) {
                if (!entry.getKey().getXmiId().startsWith("builtin_mailprovider")) continue;
                configGenerator.addMailSessions(entry.getValue());
                continue;
            }
            configGenerator.addMailSessions(entry.getValue());
        }
        LinkedHashMap<JdbcProvider, List<DataSource>> linkedHashMap = this._app.getDataSourcesByJdbcProviders();
        for (Map.Entry<JdbcProvider, List<DataSource>> entry : linkedHashMap.entrySet()) {
            configGenerator.addJdbcProvidersAndDataSources(entry.getKey(), entry.getValue(), this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
        }
        SessionManager sessionManager = this._app.getSessionManager();
        if (sessionManager != null) {
            configGenerator.addSessionManager(this._app.getSessionManager(), this._app.getDataSources());
        }
        if (!(configGenerator instanceof TwasCommandBuilder) && (transactionService = this._app.getTransactionService()) != null) {
            configGenerator.addTransactionService(this._app.getTransactionService(), this._app.getDataSources());
        }
        for (JNDIBinding jNDIBinding : this._app.getJNDIBinding()) {
            configGenerator.addJNDIBinding(jNDIBinding, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
        }
        for (JNDIURLBinding jNDIURLBinding : this._app.getJNDIURLBindings()) {
            configGenerator.addJNDIURLBinding(jNDIURLBinding);
        }
        for (JNDIReferenceBinding jNDIReferenceBinding : this._app.getJNDIReferenceBindings()) {
            configGenerator.addJNDIReferenceBinding(jNDIReferenceBinding);
        }
        for (JNDIObjectFactory jNDIObjectFactory : this._app.getJNDIObjectFactories()) {
            configGenerator.addJNDIObjectFactory(jNDIObjectFactory);
        }
        if (ConfigManagerFactory.isLondon()) {
            for (SimpleResourceAdapter simpleResourceAdapter : this._app.getResourceAdapters()) {
                String archivePath = simpleResourceAdapter.getArchivePath();
                if (!CommonUtilities.getBuiltInRAPaths().contains(archivePath) || !archivePath.equals(CommonUtilities.getMqResourceAdapterPath()) || simpleResourceAdapter.getScope().getLevel() == Scope.Level.APPLICATION) continue;
                configGenerator.addWmqJmsClient(simpleResourceAdapter.getPropertySet());
            }
        }
        for (J2CConnectionFactory j2CConnectionFactory : this._app.getJ2CConnectionFactories()) {
            Reference<ConnectionDefinition> connectionDefinitionRef = j2CConnectionFactory.getConnectionDefinition();
            if (connectionDefinitionRef != null) {
                ConnectionDefinition connectionDefinition = connectionDefinitionRef.getValue();
                if (connectionDefinition != null) {
                    String connectionFactoryInterface = connectionDefinition.getConnectionFactoryInterface();
                    if (connectionFactoryInterface.equals("javax.jms.QueueConnectionFactory")) {
                        configGenerator.addJmsQueueConnectionFactory(j2CConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
                        continue;
                    }
                    if (connectionFactoryInterface.equals("javax.jms.TopicConnectionFactory")) {
                        configGenerator.addJmsTopicConnectionFactory(j2CConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
                        continue;
                    }
                    if (connectionFactoryInterface.equals("javax.jms.ConnectionFactory")) {
                        configGenerator.addJmsConnectionFactory(j2CConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
                        continue;
                    }
                    if (!ConfigManagerFactory.isLondon()) continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "The J2CConnectionFactory " + j2CConnectionFactory.getName() + " had a null ConnectionDefinition reference " + connectionDefinitionRef + ". No config will be added for this J2CConnectionFactory.");
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "The J2CConnectionFactory " + j2CConnectionFactory.getName() + " did not reference a ConnectionDefinition. No config will be added for this J2CConnectionFactory.");
        }
        List<J2CAdminObject> list = this._app.getJmsAdminObjects();
        for (J2CAdminObject object : list) {
            Reference<AdminObject> adminObjectRef = object.getAdminObject();
            if (adminObjectRef != null) {
                AdminObject adminObject = adminObjectRef.getValue();
                if (adminObject != null) {
                    String adminObjectInterface = adminObject.getAdminObjectInterface();
                    if (adminObjectInterface.equals("javax.jms.Queue")) {
                        configGenerator.addJmsQueue(object);
                        continue;
                    }
                    if (adminObjectInterface.equals("javax.jms.Topic")) {
                        configGenerator.addJmsTopic(object);
                        continue;
                    }
                    if (ConfigManagerFactory.isLondon() && object.getJndiName() != null && object.getJndiName().isEmpty()) continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "The J2CAdminObject " + object.getName() + " had a null AdminObject reference " + adminObjectRef + ". No config will be added for this J2CAdminObject.");
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "The J2CAdminObject " + object.getName() + " did not reference an AdminObject. No config will be added for this J2CAdminObject.");
        }
        WebContainer webContainer = this._app.getWebContainer();
        if (webContainer != null) {
            configGenerator.addWebContainerAndJspEngine(webContainer);
        }
        if ((traceService = this._app.getTraceService()) != null) {
            configGenerator.addTrace(traceService);
        }
        if ((jpaService = this._app.getJpaService()) != null) {
            configGenerator.addJpaService(jpaService);
        }
        boolean isUsingMq = false;
        Security security = this._app.getResolvedSecurity();
        if (ConfigManagerFactory.isLondon() && security.getEnabled().equals("true") && (authRef = security.getActiveAuthMechanisms()) != null) {
            AuthMechanisms activeAuthMechanism = (AuthMechanisms)References.lookup(authRef.getId());
            if (activeAuthMechanism instanceof LTPAAuthMechanism) {
                configGenerator.addLTPA((LTPAAuthMechanism)activeAuthMechanism);
            }
            configGenerator.addWebAppSecurity(security, activeAuthMechanism);
        }
        List<J2CActivationSpec> activationSpecs = this._app.getJ2CActivationSpecs();
        for (J2CActivationSpec j2CActivationSpec : activationSpecs) {
            String destinationRef = "";
            String specDestinationJndiName = j2CActivationSpec.getUsedDestinationName();
            if (configGenerator instanceof LibertyServerXmlBuilder && !specDestinationJndiName.equals("")) {
                String newLine;
                for (J2CAdminObject j2CAdminObject : this._app.getJmsAdminObjects()) {
                    if (!j2CAdminObject.getJndiName().equals(specDestinationJndiName)) continue;
                    destinationRef = !j2CAdminObject.getName().equals("") ? j2CAdminObject.getName() : j2CAdminObject.getJndiName();
                    newLine = System.getProperty("line.separator");
                    ReportUtility.logger.get().log(Level.FINEST, "Associating activation spec " + j2CActivationSpec.getName() + ": " + newLine + j2CActivationSpec + newLine + " with destination reference " + destinationRef + ": " + newLine + j2CAdminObject);
                    break;
                }
                if (destinationRef.isEmpty()) {
                    for (MqQueue mqQueue : this._app.getMqQueues()) {
                        if (!mqQueue.getJndiName().equals(specDestinationJndiName)) continue;
                        destinationRef = !mqQueue.getLibertyId().equals("") ? mqQueue.getLibertyId() : mqQueue.getJndiName();
                        newLine = System.getProperty("line.separator");
                        ReportUtility.logger.get().log(Level.FINEST, "Associating activation spec " + j2CActivationSpec.getName() + ": " + newLine + j2CActivationSpec + newLine + " with destination reference " + destinationRef + ": " + newLine + mqQueue);
                        break;
                    }
                }
            } else if (configGenerator instanceof TwasCommandBuilder) {
                destinationRef = specDestinationJndiName;
            }
            String specClass = "";
            if (j2CActivationSpec.getActivationSpec() != null) {
                ActivationSpec activationSpec = j2CActivationSpec.getActivationSpec().getValue();
                if (activationSpec != null && activationSpec.getActivationSpecClass() != null) {
                    specClass = activationSpec.getActivationSpecClass();
                    configGenerator.addJmsActivationSpec(j2CActivationSpec, destinationRef, security);
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "The J2CActivationSpec " + j2CActivationSpec.getName() + " had a null ActivationSpec reference " + j2CActivationSpec.getActivationSpec() + ". No config will be added for this J2CActivationSpec.");
                }
            } else {
                ReportUtility.logger.get().log(Level.FINE, "The J2CActivationSpec " + j2CActivationSpec.getName() + " did not reference an ActivationSpec. No config will be added for this J2CActivationSpec.");
            }
            if (!specClass.equals("com.ibm.mq.connector.inbound.ActivationSpecImpl")) continue;
            isUsingMq = true;
        }
        for (MqQueueConnectionFactory mqQueueConnectionFactory : this._app.getMqQueueConnectionFactories()) {
            configGenerator.addMqQueueConnectionFactory(mqQueueConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
            isUsingMq = true;
        }
        for (MqTopicConnectionFactory mqTopicConnectionFactory : this._app.getMqTopicConnectionFactories()) {
            configGenerator.addMqTopicConnectionFactory(mqTopicConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
            isUsingMq = true;
        }
        for (MqConnectionFactory mqConnectionFactory : this._app.getMqConnectionFactories()) {
            configGenerator.addMqConnectionFactory(mqConnectionFactory, this._app.getSourceAppServer().equals((Object)Application.AppServer.TWAS));
            isUsingMq = true;
        }
        for (MqQueue mqQueue : this._app.getMqQueues()) {
            configGenerator.addMqQueue(mqQueue);
            isUsingMq = true;
        }
        for (MqTopic mqTopic : this._app.getMqTopics()) {
            configGenerator.addMqTopic(mqTopic);
            isUsingMq = true;
        }
        for (EnvironmentVariable environmentVariable : this._app.getEnvironmentVariables()) {
            configGenerator.addEnvVar(environmentVariable);
        }
        for (ProcessDefinition processDefinition : this._app.getProcessDefinitions()) {
            if (processDefinition.getJvmEntries() == null || processDefinition.getJvmEntries().size() < 1 || processDefinition.getJvmEntries().get(0) == null) {
                ReportUtility.logger.get().log(Level.FINEST, "Skipping process options for pd " + processDefinition + " as no jvmEntries were found.");
                continue;
            }
            configGenerator.addProcessDefinition(processDefinition);
            String genericJvmArguments = processDefinition.getJvmEntries().get(0).getGenericJvmArguments();
            List<Property> jvmSystemProps = processDefinition.getJvmEntries().get(0).getSystemProperties();
            String enableImplicitBeanArchives = CommonUtilities.getSystemProperty("com.ibm.ws.cdi.enableImplicitBeanArchives", this._app.getServerCustomProperties(), genericJvmArguments, jvmSystemProps);
            String string = CommonUtilities.getSystemProperty("com.ibm.ws.cdi.emptyBeansXmlCDI3Compatibility", this._app.getServerCustomProperties(), genericJvmArguments, jvmSystemProps);
            if (enableImplicitBeanArchives == null && string == null) break;
            configGenerator.addCDIContainer(enableImplicitBeanArchives, string);
            break;
        }
        if ((activeUserRegistrRef = security.getActiveUserRegistry()) != null && "true".equals(security.getEnabled()) && "true".equals(security.getAppEnabled())) {
            UserRegistry userRegistry = (UserRegistry)References.lookup(activeUserRegistrRef.getId());
            if (userRegistry != null) {
                if (userRegistry instanceof LDAPUserRegistry) {
                    configGenerator.addStandaloneLDAPUserRegistry((LDAPUserRegistry)userRegistry);
                } else if (userRegistry instanceof WIMUserRegistry) {
                    configGenerator.addFederatedUserRegistries((WIMUserRegistry)userRegistry);
                }
            } else {
                configGenerator.warnAboutSecurityConfigNotMigrated();
            }
        }
        Set<String> set = this._app.getReferencedSSLIds();
        Map<String, SSLConfig> sslConfigs = security.getRepertoires();
        for (String appReferencedSSLConfigAlias : set) {
            SSLConfig sSLConfig = sslConfigs.get(appReferencedSSLConfigAlias);
            if (sSLConfig != null) {
                configGenerator.addSSLConfig(sSLConfig, security);
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "Couldn't find SSL config with alias " + appReferencedSSLConfigAlias + ", so no coresponding SSL config will be migrated.");
        }
        ActiveSSLConfigGroups defaultSSLConfig = this._app.getDefaultSSLConfig();
        List<DynamicSSLConfigSelection> dynamicSSLConfigList = defaultSSLConfig.getActiveDynamicSSLConfigSelections();
        for (DynamicSSLConfigSelection dynamicSSLConfig : dynamicSSLConfigList) {
            configGenerator.addDynamicSSLConfig(dynamicSSLConfig, security);
        }
        configGenerator.addDefaultSSLConfig(defaultSSLConfig.getInboundGroup(), defaultSSLConfig.getOutboundGroup(), security);
        for (Variable v : this._app.getVariables().values(this._app.getScopeConflicts())) {
            if (v.getSymbolicName().equals("MLS_WMQ_JMS_CLIENT_RAR_LOCATION") && ConfigManagerFactory.isLondon()) {
                configGenerator.addVariable("wmqJmsClient.rar.location", v.getValue(), false);
                continue;
            }
            configGenerator.addVariable(v);
        }
        if (isUsingMq && !ConfigManagerFactory.isLondon()) {
            configGenerator.addMqResourceAdapter();
        }
        if (configGenerator instanceof LibertyServerXmlBuilder && !SensitiveDataHelper.getRegisteredVarKeys().isEmpty()) {
            for (String key : SensitiveDataHelper.getRegisteredVarKeys()) {
                configGenerator.addVariable(key, SensitiveDataHelper.getValueForRegisteredVar(key), true);
            }
            if (this instanceof LibertyServerXml && !((LibertyServerXml)this).getIncludeSensitiveDataVarsInServerXml()) {
                ((LibertyServerXmlBuilder)configGenerator).addIncludeType(((LibertyServerXml)this).getSensitiveDataXml().getName());
            }
        }
        if (configGenerator instanceof LibertyServerXmlBuilder && !((LibertyServerXmlBuilder)configGenerator).exportMimeTypesData().isEmpty()) {
            ((LibertyServerXmlBuilder)configGenerator).addIncludeType(((LibertyServerXml)this).getMimeTypesXml().getName());
        }
        if (configGenerator instanceof LibertyServerXmlBuilder && !MappedDataHelper.getRegisteredVarKeys().isEmpty()) {
            for (String key : MappedDataHelper.getRegisteredVarKeys()) {
                configGenerator.addVariable(key, MappedDataHelper.getValueForRegisteredVar(key), false);
            }
        }
        configGenerator.addSIBuses(this._app.getAllServiceIntegrationBuses());
        configGenerator.setScopeConflicts(this._app.getScopeConflicts());
    }

    public DeploymentEnvironment getDeploymentEnvironment() {
        return this._deploymentEnvironment;
    }

    public Set<String> getConfigRulesFlagged() {
        return this._configRulesFlagged;
    }

    public void setConfigRulesFlagged(Set<String> configRulesFlagged) {
        if (configRulesFlagged != null) {
            this._configRulesFlagged.clear();
            this._configRulesFlagged.addAll(configRulesFlagged);
        }
    }
}

