/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.generator.DeployedServer;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.List;
import java.util.logging.Level;

public class DeployedCluster {
    private final String _clusterName;
    private final String _clusterXmiId;
    private final List<DeployedServer> _serverMembers;
    private final QosSessionPersistenceType _clusterSessionPersistenceType;
    private Boolean _appUsingSessions = null;
    private final QosTransactionLogType _clusterTransactionLogType;
    private final boolean _dynamicCluster;
    private final String _minInstances;
    private final String _maxInstances;
    private final int _effectiveMinInstances;
    private final int _effectiveMaxInstances;
    private final boolean _isConfigDefault;

    public DeployedCluster(String clusterName, String clusterXmiId, List<DeployedServer> serverMembers, QosSessionPersistenceType clusterSessionPersistenceType, QosTransactionLogType clusterTransactionLogType, boolean isConfigDefault) {
        this(clusterName, clusterXmiId, serverMembers, clusterSessionPersistenceType, clusterTransactionLogType, false, null, null, -1, -1, isConfigDefault);
    }

    public DeployedCluster(String clusterName, String clusterXmiId, List<DeployedServer> serverMembers, QosSessionPersistenceType clusterSessionPersistenceType, QosTransactionLogType clusterTransactionLogType, boolean dynamicCluster, String minInstances, String maxInstances, int effectiveMinInstances, int effectiveMaxInstances, boolean isConfigDefault) {
        this._clusterName = clusterName;
        this._clusterXmiId = clusterXmiId;
        this._serverMembers = serverMembers;
        this._clusterSessionPersistenceType = clusterSessionPersistenceType;
        this._clusterTransactionLogType = clusterTransactionLogType;
        this._dynamicCluster = dynamicCluster;
        this._minInstances = minInstances;
        this._maxInstances = maxInstances;
        this._effectiveMinInstances = effectiveMinInstances;
        this._effectiveMaxInstances = effectiveMaxInstances;
        this._isConfigDefault = isConfigDefault;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public String getClusterXmiId() {
        return this._clusterXmiId;
    }

    public List<DeployedServer> getServerMembers() {
        return this._serverMembers;
    }

    public QosTransactionLogType getClusterTransactionLogType() {
        return this._clusterTransactionLogType;
    }

    public boolean isDynamicCluster() {
        return this._dynamicCluster;
    }

    public String getMinInstances() {
        return this._minInstances;
    }

    public String getMaxInstances() {
        return this._maxInstances;
    }

    public int getEffectiveMinInstances() {
        return this._effectiveMinInstances;
    }

    public int getEffectiveMaxInstances() {
        return this._effectiveMaxInstances;
    }

    public QosSessionPersistenceType getClusterSessionPersistenceType() {
        if (this._appUsingSessions == null) {
            ReportUtility.logger.get().log(Level.FINEST, "setApplicationIsUsingSessions must be called on TargetConfig before calling isUsingSessionReplication on cluster " + this._clusterName);
            throw new IllegalStateException("setApplicationIsUsingSessions must be called on TargetConfig before calling isUsingSessionReplication on cluster " + this._clusterName);
        }
        if (!this._appUsingSessions.booleanValue()) {
            return QosSessionPersistenceType.NONE;
        }
        return this._clusterSessionPersistenceType;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("DeployedCluster - Cluster Name: " + this._clusterName + ", Cluster ID: " + this._clusterXmiId + ", Server Members: ");
        for (DeployedServer server : this._serverMembers) {
            sb.append(nl + server);
        }
        if (this._dynamicCluster) {
            sb.append(nl + "Dynamic scaling is enabled. Minimum " + this._minInstances + " instances, maximum " + this._maxInstances + " instances.");
        }
        sb.append(nl + "Cluster session persistence type - " + (Object)((Object)this._clusterSessionPersistenceType));
        sb.append(nl + "Application is using sessions (Null indicates value not yet set) - " + this._appUsingSessions);
        sb.append(nl + "Cluster transaction log type - " + (Object)((Object)this._clusterTransactionLogType));
        sb.append(nl + "isConfigDefault - " + this._isConfigDefault);
        return sb.toString();
    }

    protected void setAppUsingSessions(boolean appUsingSessions) {
        this._appUsingSessions = appUsingSessions;
    }

    public boolean isConfigDefault() {
        return this._isConfigDefault;
    }
}

