/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.cli;

import com.ibm.ws.report.utilities.ReportUtility;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HouseKeeping {
    private static final char ANSI_ESCAPE = '\u001b';
    private static final Logger logger = ReportUtility.logger.get();

    public static void resizeConsoleScreen(int screenRows, int screenColumns) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u001b');
        stringBuilder.append('[');
        stringBuilder.append('8');
        stringBuilder.append(';');
        stringBuilder.append(String.valueOf(screenRows));
        stringBuilder.append(';');
        stringBuilder.append(String.valueOf(screenColumns));
        stringBuilder.append('t');
        System.out.print(stringBuilder.toString());
    }

    public static void eraseConsoleScreen() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u001b');
        stringBuilder.append('[');
        stringBuilder.append('2');
        stringBuilder.append('J');
        System.out.print(stringBuilder.toString());
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            ProcessBuilder processBuilder = new ProcessBuilder("cls");
            processBuilder.redirectErrorStream(true);
            try {
                processBuilder.start();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Failed to execute the Windows 'cls' command while running the progress indicator.");
            }
        }
    }

    public static void moveCursorToHome() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u001b');
        stringBuilder.append('[');
        stringBuilder.append('H');
        System.out.print(stringBuilder.toString());
    }

    public static void initialize(int screenRows, int screenColumns) {
        HouseKeeping.resizeConsoleScreen(screenRows, screenColumns);
        HouseKeeping.eraseConsoleScreen();
        HouseKeeping.moveCursorToHome();
    }
}

