/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.DriveScanInventory;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.generator.WSAdminScript;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.server.JvmEntry;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.binary.configutility.twas.Clusters;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.configutility.twas.Servers;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.binary.utilities.DataCollectionHelper;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.ta.ArchiveInfo;
import com.ibm.ws.report.ta.ProductInf;
import com.ibm.ws.report.ta.WebsphereProfile;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.FileComparator;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ManagedLibertyFeatureSets;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLDetailAnalysisStreamlinedReportWriter;
import com.ibm.ws.report.writer.html.HTMLEvaluationReportWriter;
import com.ibm.ws.report.writer.html.HTMLInventoryReportWriter;
import com.ibm.ws.report.writer.json.AssessmentUnitWriter;
import com.ibm.ws.report.writer.json.EnvironmentJsonWriter;
import com.ibm.ws.report.writer.json.JSONDetailAnalysisReportWriter;
import com.ibm.ws.report.writer.json.JSONEvaluationReportWriter;
import com.ibm.ws.report.writer.json.JSONInventoryReportWriter;
import com.ibm.ws.report.writer.json.ScanResult;
import com.ibm.ws.report.writer.xml.ServerXmlWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.time.StopWatch;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DriveScanTA
extends DriveScan {
    BinaryReportBuilder _analyze = null;
    BinaryReportBuilder _inventory = null;
    BinaryReportBuilder _generateConfig = null;
    DriveScanGenerateConfig driveScanGenerateConfig;
    Map<ReportInputData.ReportType, Collection<Rule>> _otherRules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
    TreeMap<String, WebsphereProfile> _sharedLibraryProfiles = new TreeMap();
    Map<File, Set<OrderedJSONObject>> _mapOfAppToLibrary = new HashMap<File, Set<OrderedJSONObject>>();
    TreeMap<String, OrderedJSONObject> _serverClassPaths = new TreeMap();
    TreeMap<String, OrderedJSONObject> _knownLibs = new TreeMap();
    TreeMap<String, OrderedJSONObject> _knownVars = new TreeMap();
    List<ProductInf> productInfs = new ArrayList<ProductInf>();
    String _cliFinalMessage = "";
    ScanResult result = null;

    public DriveScanTA(ReportInputData data) {
        super(data);
        this.driveScanGenerateConfig = new DriveScanGenerateConfig(data);
    }

    @Override
    public Map<String, String> getRuleHelp() {
        HashMap<String, String> helpFileNames = null;
        helpFileNames = this._analyze != null ? this._analyze._helpIds : new HashMap<String, String>();
        return helpFileNames;
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            super.getRules();
            this._analyze = ReportBuilderHelper.loadAnalyzeRules(_data, true);
            this.setReturnCode(this._analyze.getReturnCode());
            if (this._analyze._foundInvalidRule) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_No_Rules_Found"));
                if (!_hiddenJunitFlag) {
                    DriveScanTA.systemExitNoJunitSupport(2);
                }
                return null;
            }
            if (!this._analyze._foundInvalidRule && this._analyze._reportRules != null && !this._analyze._reportRules.isEmpty()) {
                this._otherRules.put(ReportInputData.ReportType.ANALYZE, this._analyze._reportRules.values());
            }
            this._inventory = ReportBuilderHelper.loadInventoryRules();
            if (this._inventory._reportRules != null && !this._inventory._reportRules.isEmpty()) {
                this._otherRules.put(ReportInputData.ReportType.INVENTORY, this._inventory._reportRules.values());
            }
            this._generateConfig = ReportBuilderHelper.loadConfigRules(true);
            this.addConfigRule(this._generateConfig._reportRules);
            if (this._generateConfig._reportRules != null && !this._generateConfig._reportRules.isEmpty()) {
                this._otherRules.put(ReportInputData.ReportType.GENERATE_CONFIG, this._generateConfig._reportRules.values());
            }
        }
        return this._rules;
    }

    @Override
    public BinaryReportReader getBinaryReportReader() {
        return this.getBinaryReportReader(null, null);
    }

    public BinaryReportReader getBinaryReportReader(Map<String, Map<String, IdentifierObject>> possibleIdentifierNames, Set<String> appsUsingSessions) {
        Map<String, Rule> myrules = this.getRules();
        if (myrules != null && !myrules.isEmpty()) {
            this._reader = new BinaryReportReader(_data, myrules, this.getTechnologyFactory().getListOfTechnologies(), this.getNonTechRules(), this._otherRules, this.configRules, possibleIdentifierNames, appsUsingSessions);
        }
        return this._reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runReport() {
        block65: {
            block64: {
                apps = DriveScanTA._data.getProjectFiles();
                binaryLocation = DriveScanTA._data.getBinaryLocations().iterator().next();
                Collections.sort(apps, new FileComparator());
                fileExtensions = DriveScanTA.createFileExtensionSet();
                clean = DriveScanTA._data.isClean();
                delete = DriveScanTA._data.isDelete();
                outputDir = DriveScanTA._data.getOutputDir();
                outputDirPath = outputDir == null ? "" : DriveScanTA.getOutputDirPath(outputDir);
                this.result = new ScanResult(new ArrayList<String>());
                includeApplications = DriveScanTA._data.getIncludeApplications();
                excludeApplications = DriveScanTA._data.getExcludeApplications();
                mapOfAppsToProfiles = DriveScanTA._data.getMapOfAppsToProfiles();
                outsideScan = mapOfAppsToProfiles == null || mapOfAppsToProfiles.isEmpty() != false;
                collectionUnitNamesToPaths = new HashMap<String, String>();
                sharedLibCollectionUnitNamesToPaths = new HashMap<String, String>();
                appStopWatch = new StopWatch();
                currentProfile = "";
                failedReport = false;
                createEnvJson = false;
                envJson = null;
                jars = DriveScanTA.separateJars(apps);
                if (!jars.isEmpty()) {
                    this.addJarsToSharedLibs(jars, binaryLocation);
                }
                DriveScanTA.cli.updateTotalApplications(apps.size());
                ReportUtility.logger.get().log(Level.FINE, "mapOfAppsToProfiles: " + mapOfAppsToProfiles);
                ReportUtility.logger.get().log(Level.FINE, "Apps to be processed: " + apps);
                try {
                    sensitiveDataFilesSB = new StringBuilder();
lbl29:
                    // 5 sources

                    for (File var22_24 : apps) {
                        appName = var22_24.getName();
                        ReportUtility.logger.get().log(Level.FINE, "Processing app: " + appName + ". Path: " + var22_24);
                        collectionUnitName = DriveScanTA.getCollectionUnitName(var22_24, mapOfAppsToProfiles, binaryLocation);
                        ReportUtility.logger.get().log(Level.FINE, "Collection unit name: " + collectionUnitName);
                        ReportUtility.logger.get().log(Level.FINE, "Current profile: " + currentProfile);
                        if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
                            if (var22_24.equals(apps.get(0))) {
                                currentProfile = collectionUnitName;
                                DriveScanTA.cli.updateProfileSection(new HashSet<String>(mapOfAppsToProfiles.values()).size(), currentProfile);
                            } else if (null != currentProfile && !currentProfile.equals(collectionUnitName)) {
                                currentProfile = collectionUnitName;
                                DriveScanTA.cli.updateProfileEvent(currentProfile);
                            }
                        }
                        if (envJson != null) ** GOTO lbl98
                        envJson = this.createEnvJson(mapOfAppsToProfiles, apps, var22_24, includeApplications, excludeApplications, outputDirPath, collectionUnitName, DriveScanTA._data.isRunFromTaDc(), DriveScanTA._data.getStopOnMissingBinary(), DriveScanTA._data.getStopOnMissingSharedLibrary());
                        if (this.getReturnCode() != 0) {
                            break block64;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl156
                }
                catch (Throwable var34_53) {
                    severeCount = ReportUtility.getSevereCount();
                    warningCount = ReportUtility.getWarningCount();
                    if (!this._cliFinalMessage.isEmpty()) {
                        DriveScanTA.cliFinishedWithMessage(this._cliFinalMessage);
                    } else if (failedReport) {
                        DriveScanTA.cliFinishedWithFailedReports(severeCount, warningCount);
                    } else if (severeCount > 0 || warningCount > 0) {
                        DriveScanTA.cliFinishedWithErrors(severeCount, warningCount);
                    } else {
                        DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.collect.done", " ", " ");
                    }
                    if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), new Object[]{ReportUtility.getFilesWithParsingError()}));
                    }
                    DriveScanTA.cli.finishOff();
                    DriveScan.setProgressIndicatorActive(false);
                    this.printUploadZipNames(collectionUnitNamesToPaths);
                    this.printUploadZipNames(sharedLibCollectionUnitNamesToPaths);
                    this.result.setReturnCode(this.getReturnCode());
                    if (delete != false) throw var34_53;
                    this.result.writeToJsonFile(outputDirPath);
                    throw var34_53;
                }
            }
            severeCount = ReportUtility.getSevereCount();
            warningCount = ReportUtility.getWarningCount();
            if (!this._cliFinalMessage.isEmpty()) {
                DriveScanTA.cliFinishedWithMessage(this._cliFinalMessage);
            } else if (failedReport) {
                DriveScanTA.cliFinishedWithFailedReports(severeCount, warningCount);
            } else if (severeCount > 0 || warningCount > 0) {
                DriveScanTA.cliFinishedWithErrors(severeCount, warningCount);
            } else {
                DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.collect.done", " ", " ");
            }
            if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), new Object[]{ReportUtility.getFilesWithParsingError()}));
            }
            DriveScanTA.cli.finishOff();
            DriveScan.setProgressIndicatorActive(false);
            this.printUploadZipNames(collectionUnitNamesToPaths);
            this.printUploadZipNames(sharedLibCollectionUnitNamesToPaths);
            this.result.setReturnCode(this.getReturnCode());
            if (delete != false) return;
            this.result.writeToJsonFile(outputDirPath);
            return;
lbl-1000:
            // 1 sources

            {
                if (!this._sharedLibraryProfiles.isEmpty()) {
                    DriveScanTA.cli.setHasSharedLibraries(true);
                    DriveScanTA.cli.updateTotalSharedLibraries(this._sharedLibraryProfiles.size());
                }
lbl98:
                // 4 sources

                if (!clean && !delete) ** GOTO lbl126
                DriveScanTA.clean(mapOfAppsToProfiles, outputDirPath, apps, binaryLocation, includeApplications, excludeApplications, fileExtensions, this._sharedLibraryProfiles);
                if (!delete) ** GOTO lbl-1000
                this.setReturnCode(0);
            }
            severeCount = ReportUtility.getSevereCount();
            warningCount = ReportUtility.getWarningCount();
            if (!this._cliFinalMessage.isEmpty()) {
                DriveScanTA.cliFinishedWithMessage(this._cliFinalMessage);
            } else if (failedReport) {
                DriveScanTA.cliFinishedWithFailedReports(severeCount, warningCount);
            } else if (severeCount > 0 || warningCount > 0) {
                DriveScanTA.cliFinishedWithErrors(severeCount, warningCount);
            } else {
                DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.collect.done", " ", " ");
            }
            if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), new Object[]{ReportUtility.getFilesWithParsingError()}));
            }
            DriveScanTA.cli.finishOff();
            DriveScan.setProgressIndicatorActive(false);
            this.printUploadZipNames(collectionUnitNamesToPaths);
            this.printUploadZipNames(sharedLibCollectionUnitNamesToPaths);
            this.result.setReturnCode(this.getReturnCode());
            if (delete != false) return;
            this.result.writeToJsonFile(outputDirPath);
            return;
lbl-1000:
            // 1 sources

            {
                if (clean) {
                    clean = false;
                }
lbl126:
                // 4 sources

                totalZips = 0;
                totalZips = mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty() ? (totalZips += new HashSet<String>(mapOfAppsToProfiles.values()).size()) : ++totalZips;
                DriveScanTA.cli.updateTotalZipFiles(totalZips += this._sharedLibraryProfiles.size());
                DriveScanTA.cli.updateApplicationEvent(appName);
                DriveScanTA.cli.updateCurrentOperationEventWithArgs("ta.dc.analyzing", new String[]{appName}, "ta.dc.gen.all.reports", null, " ", null);
                appStopWatch.reset();
                appStopWatch.start();
                try {
                    block66: {
                        collectionUnitNamesToPaths.put(collectionUnitName, null);
                        this.findSharedLibraries(var22_24);
                        if (!this.shouldScan(appName, mapOfAppsToProfiles != null && mapOfAppsToProfiles.isEmpty() == false ? mapOfAppsToProfiles.get(var22_24) : "", outputDirPath, collectionUnitName, false)) break block66;
                        createEnvJson = true;
                        ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Processing"), new Object[]{appName}));
                        this.generateReports(var22_24, var22_24.getAbsolutePath().replace("\\", "/"), outputDirPath, envJson, collectionUnitName, sensitiveDataFilesSB);
                        ** GOTO lbl29
                    }
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Skipping_Scan"), new Object[]{var22_24.getAbsolutePath()}));
                    ** GOTO lbl29
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                    this.setReturnCode(2);
                    failedReport = true;
                    ** GOTO lbl29
                }
                finally {
                    if (appStopWatch.isStarted()) {
                        appStopWatch.stop();
                    }
                    DriveScanTA.cli.updateApplicationCompletedEvent(appStopWatch.getTime());
                    ** GOTO lbl29
                }
lbl156:
                // 1 sources

                if (sensitiveDataFilesSB.length() > 0) {
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Sensitive_Data_Msg"), new Object[]{sensitiveDataFilesSB.toString()}));
                }
                if (apps.isEmpty() && !this._sharedLibraryProfiles.isEmpty()) {
                    DriveScanTA.cli.setHasSharedLibraries(true);
                    DriveScanTA.cli.updateTotalSharedLibraries(this._sharedLibraryProfiles.size());
                }
                if (envJson == null) {
                    createEnvJson = false;
                }
                DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.shared.libraries.processing", " ", " ");
                DriveScanTA._data.getSharedLibraryFiles().clear();
                if (this.productInfs.isEmpty()) {
                    this.addDefaultProductInfs();
                }
                for (WebsphereProfile var22_26 : this._sharedLibraryProfiles.values()) {
                    containsJarFile = false;
                    sharedLibCollectionUnitName = var22_26.getName();
                    sharedLibCollectionUnitNamesToPaths.put(sharedLibCollectionUnitName, null);
                    sharedLibStopWatch = new StopWatch();
                    try {
                        DriveScanTA.cli.updateSharedLibrariesEvent(sharedLibCollectionUnitName);
                        sharedLibStopWatch.reset();
                        sharedLibStopWatch.start();
                        scannedApp = false;
                        profiles = new ArrayList<WebsphereProfile>();
                        profiles.add(var22_26);
                        sharedLibEnvJson = new EnvironmentJsonWriter(this.productInfs, profiles, false, null, null, DriveScanTA._data.getStopOnMissingBinary(), DriveScanTA._data.getStopOnMissingSharedLibrary());
                        for (String filePath : var22_26.getAppPaths()) {
                            appFile = new File(filePath);
                            fileName = appFile.getName();
                            if (!fileName.endsWith(".jar")) continue;
                            containsJarFile = true;
                            if (this.shouldScan(fileName, "", outputDirPath, sharedLibCollectionUnitName, true)) {
                                DriveScanTA.cli.updateCurrentOperationEventWithArgs("ta.dc.analyzing", new String[]{fileName}, "ta.dc.gen.all.reports.sharedlibraries", null, " ", null);
                                this.generateSharedLibraryReports(sharedLibCollectionUnitName, outputDirPath, appFile, sharedLibEnvJson, var22_26.getLibraryName(), outsideScan);
                                scannedApp = true;
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Skipping_Scan"), new Object[]{filePath}));
                        }
                        if (scannedApp) {
                            sharedLibOutputDirPath = outputDirPath + sharedLibCollectionUnitName;
                            sharedLibEnvJson.writeToJsonFile(sharedLibOutputDirPath);
                        }
                        if (containsJarFile) continue;
                        ReportUtility.logger.get().log(Level.FINE, "Shared Library " + sharedLibCollectionUnitName + " does not have any jar files");
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_No_File"), new Object[]{e.getLocalizedMessage()}));
                        this.setReturnCode(2);
                    }
                    finally {
                        if (sharedLibStopWatch.isStarted()) {
                            sharedLibStopWatch.stop();
                        }
                        DriveScanTA.cli.updateSharedLibrariesCompletedEvent(sharedLibStopWatch.getTime());
                    }
                }
                if (createEnvJson) {
                    envJson.writeToJsonFile(outputDirPath);
                }
                DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.env.file.zip", " ", " ");
                for (Map.Entry var22_28 : collectionUnitNamesToPaths.entrySet()) {
                    collectionUnitName = (String)var22_28.getKey();
                    DriveScanTA.cli.updateZipFileEvent(collectionUnitName + ".zip");
                    collectionUnitPath = this.zipDir(collectionUnitName, outputDirPath, true, includeApplications, excludeApplications, fileExtensions);
                    var22_28.setValue(collectionUnitPath);
                    DriveScanTA.cli.updateZipFileCompletedEvent();
                }
                if (sharedLibCollectionUnitNamesToPaths.isEmpty()) break block65;
                for (Map.Entry var22_30 : sharedLibCollectionUnitNamesToPaths.entrySet()) {
                    sharedLibCollectionUnitName = (String)var22_30.getKey();
                    sharedLibDir = new File(outputDirPath + sharedLibCollectionUnitName);
                    if (!sharedLibDir.exists()) continue;
                    DriveScanTA.cli.updateZipFileEvent(sharedLibCollectionUnitName + ".zip");
                    sharedLibCollectionUnitPath = this.zipDir(sharedLibCollectionUnitName, outputDirPath, false, null, null, fileExtensions);
                    var22_30.setValue(sharedLibCollectionUnitPath);
                    DriveScanTA.cli.updateZipFileCompletedEvent();
                }
            }
        }
        severeCount = ReportUtility.getSevereCount();
        warningCount = ReportUtility.getWarningCount();
        if (!this._cliFinalMessage.isEmpty()) {
            DriveScanTA.cliFinishedWithMessage(this._cliFinalMessage);
        } else if (failedReport) {
            DriveScanTA.cliFinishedWithFailedReports(severeCount, warningCount);
        } else if (severeCount > 0 || warningCount > 0) {
            DriveScanTA.cliFinishedWithErrors(severeCount, warningCount);
        } else {
            DriveScanTA.cli.updateCurrentOperationEvent("ta.dc.collect.done", " ", " ");
        }
        if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), new Object[]{ReportUtility.getFilesWithParsingError()}));
        }
        DriveScanTA.cli.finishOff();
        DriveScan.setProgressIndicatorActive(false);
        this.printUploadZipNames(collectionUnitNamesToPaths);
        this.printUploadZipNames(sharedLibCollectionUnitNamesToPaths);
        this.result.setReturnCode(this.getReturnCode());
        if (delete != false) return;
        this.result.writeToJsonFile(outputDirPath);
    }

    public void printUploadZipNames(Map<String, String> collectionUnitNames) {
        for (Map.Entry<String, String> collectionUnit : collectionUnitNames.entrySet()) {
            File generatedZip;
            if (collectionUnit.getValue() == null || null == (generatedZip = new File(collectionUnit.getValue())) || !generatedZip.exists()) continue;
            try {
                System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_DataCollection_Written"), generatedZip.getCanonicalPath()));
            }
            catch (IOException e) {
                System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_DataCollection_Write_Error"), e.getMessage()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateSharedLibraryReports(String collectionUnitName, String outputDirPath, File appFile, EnvironmentJsonWriter sharedLibEnvJson, String libraryName, boolean outsideScan) throws Exception {
        BinaryReportReader brr;
        EnumMap resultMap = new EnumMap(ReportInputData.OutputType.class);
        String appPath = appFile.getAbsolutePath();
        String appName = appFile.getName();
        ArrayList<String> projectName = new ArrayList<String>();
        ArrayList<File> projectFile = new ArrayList<File>();
        projectName.add(appPath.replace("\\", "/"));
        if (appFile != null) {
            projectFile.add(appFile);
        }
        _data.setProjectData(projectFile, projectName);
        boolean dirCreated = false;
        File collectionUnitDir = outputDirPath.isEmpty() ? new File(collectionUnitName) : new File(outputDirPath + File.separator + collectionUnitName);
        if (!collectionUnitDir.exists()) {
            dirCreated = collectionUnitDir.mkdir();
            if (!dirCreated) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_CollectionUnit_Directory_Creation"), collectionUnitDir.getAbsolutePath()));
            }
        } else {
            dirCreated = true;
        }
        if (dirCreated && (brr = this.getBinaryReportReader(null, null)) != null) {
            void var24_28;
            brr.openFile();
            String checkSum = brr.getChecksumMap().get(projectName.get(0));
            Map costs = this._analyze._costs;
            SortedMap<String, TechSummary> listOfTechSummaries = brr.buildTechResults();
            Map<String, List<DetailResult>> projectsToDetailsFoundAnalyze = brr.getProjectsToDetailResults(ReportInputData.ReportType.ANALYZE);
            ReportInputData.AppServer originalTargetAppServer = _data.getTargetAppServer();
            ReportInputData.AppServer targetWAS = DataCollectionHelper.getTWASTarget(_data.getSourceAppServer(), _data.getTargetAppServer());
            ReportInputData.JavaVersion originalTargetJava = _data.getTargetJava();
            EnumMap<ReportInputData.AppServer, Map<String, Map<String, Map<String, List<String>>>>> rulesAnalyzedByCategory = new EnumMap<ReportInputData.AppServer, Map<String, Map<String, Map<String, List<String>>>>>(ReportInputData.AppServer.class);
            for (ReportInputData.AppServer appServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                rulesAnalyzedByCategory.put(appServer, this._analyze.getSortedRulesByCategories(appServer));
            }
            Map<String, String> helpFileNames = this.getRuleHelp();
            for (ReportInputData.AppServer targetServer : EnumSet.of(ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                boolean isEASe;
                boolean isWL = targetServer == ReportInputData.AppServer.LIBERTY;
                boolean isOL = targetServer == ReportInputData.AppServer.OPEN_LIBERTY;
                boolean isML = targetServer == ReportInputData.AppServer.MANAGED_LIBERTY;
                boolean bl = isEASe = targetServer == ReportInputData.AppServer.EASE;
                if (isWL) {
                    _data.setTargetJavaEE(_data.getSourceJavaEE());
                } else if (isML) {
                    _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE10);
                } else {
                    _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE7);
                }
                _data.setTargetAppServer(targetServer);
                this.driveScanGenerateConfig.clearLists();
                this.driveScanGenerateConfig.setIsOpenLiberty(isOL);
                this.driveScanGenerateConfig.setIsLibertyEASe(isEASe);
                DriveScanGenerateConfig.loadLists(this.getClass());
                TreeSet<String> coreFeatures = new TreeSet<String>();
                TreeSet<String> baseFeatures = new TreeSet<String>();
                TreeSet<String> configFeatures = new TreeSet<String>();
                boolean hasConflicts = false;
                hasConflicts = this.driveScanGenerateConfig.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appPath);
                Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures = this.driveScanGenerateConfig.getLibertyJavaEEJakartaFeatures();
                if (!_data.filterAnalysisRulesByFeatureList()) continue;
                HashSet<String> allFeatures = new HashSet<String>();
                if (!hasConflicts) {
                    allFeatures.addAll(coreFeatures);
                    allFeatures.addAll(baseFeatures);
                }
                ConfigFeatureVersionInfo cfvi = this.getConfigFeatureVersionInfo(_data.getSourceAppServer(), new HashMap<String, TargetConfig>());
                cfvi.setTargetJavaEE(_data.getTargetJavaEE());
                this.filterJavaEERules(projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), allFeatures, targetServer, cfvi, this._analyze, libertyJavaEEJakartaFeatures);
            }
            brr.closeFile();
            Object var24_26 = null;
            if (!outsideScan) {
                int firstIndexOfDash = collectionUnitName.indexOf(45);
                String string = collectionUnitName.substring(0, firstIndexOfDash);
            }
            this.generateAssessmentUnit(outputDirPath, collectionUnitName, appName, libraryName, (String)var24_28, checkSum, outsideScan);
            Map<ReportInputData.AppServer, List<String>> connectivityRulesAnalyzed = this._analyze.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity", targetWAS);
            ReportWriter allWriter = null;
            String nameForFile = collectionUnitName + File.separator + appName;
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        File outputFile;
                        TreeMap<String, String> scanOptions = new TreeMap<String, String>();
                        scanOptions.putAll(_data.getScanOptionsDisplay());
                        scanOptions.putAll(_data.getEvalReportOptions(true));
                        HashSet<String> setOfReports = new HashSet();
                        resultMap.put(outputType, setOfReports);
                        for (ReportInputData.AppServer targetServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                            _data.setTargetAppServer(targetServer);
                            _data.setTargetJavaEE(DataCollectionHelper.getTargetJavaEE(_data.getSourceAppServer(), targetServer));
                            _data.setTargetJava(DataCollectionHelper.getTargetJava(_data.getSourceAppServer(), targetServer, _data.getSourceJava(), originalTargetJava));
                            AnalysisResults analysisResults = new AnalysisResults(this._analyze._descToRuleIds, projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), connectivityRulesAnalyzed.get((Object)targetServer), this._analyze._severities, helpFileNames, brr.getRulesFlagged(), _data.showAllHelp(), (Set)this._analyze.targetToCategories.get(_data.getTargetAppServer().toString()), this._analyze.getRulesToRecipesMap());
                            allWriter = new HTMLDetailAnalysisStreamlinedReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptionsDisplay(), (Map)rulesAnalyzedByCategory.get((Object)targetServer), false, analysisResults, connectivityRulesAnalyzed.get((Object)targetServer), _data.showAllHelp(), _data.loadAllRules(), _data.getMaxUserDefinedRuleResults(), costs);
                            allWriter.writeReport();
                            setOfReports.add(allWriter.getResult());
                            outputFile = new File(outputDirPath + nameForFile + DriveScanTA.getTargetCloud(targetServer) + ".analyze" + outputType.getExtension());
                            this.openHtmlReport(outputFile, allWriter.getResult(), outputType, true);
                        }
                        allWriter = new HTMLEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(true));
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".eval" + outputType.getExtension());
                        this.openHtmlReport(outputFile, allWriter.getResult(), outputType, true);
                        outputFile = new File(outputDirPath + nameForFile + ".inventory" + outputType.getExtension());
                        this.openHtmlReport(outputFile, "<html>" + Messages.getString("DriveScanTA_No_Jar_Support") + "</html>", outputType, true);
                        break;
                    }
                    case JSON: {
                        File outputFile;
                        HashSet<String> setOfReports = new HashSet<String>();
                        resultMap.put(outputType, setOfReports);
                        TreeMap<String, String> jsonScanOptions = new TreeMap<String, String>();
                        jsonScanOptions.putAll(_data.getScanOptionsDisplay());
                        jsonScanOptions.putAll(_data.getEvalReportOptions(false));
                        for (ReportInputData.AppServer targetServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                            _data.setTargetAppServer(targetServer);
                            _data.setTargetJavaEE(DataCollectionHelper.getTargetJavaEE(_data.getSourceAppServer(), targetServer));
                            _data.setTargetJava(DataCollectionHelper.getTargetJava(_data.getSourceAppServer(), targetServer, _data.getSourceJava(), originalTargetJava));
                            AnalysisResults analysisResults = new AnalysisResults(this._analyze._descToRuleIds, projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), connectivityRulesAnalyzed.get((Object)targetServer), this._analyze._severities, helpFileNames, brr.getRulesFlagged(), _data.showAllHelp(), (Set)this._analyze.targetToCategories.get(_data.getTargetAppServer().toString()), this._analyze.getRulesToRecipesMap());
                            allWriter = new JSONDetailAnalysisReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptions(), projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), false, helpFileNames, this._analyze._severities, this._analyze._costs, _data.getApplicationNames(), this._analyze.getCategoryNamesMappedToKeys(), _data.includeHelpLocation(), _data.getMaxUserDefinedRuleResults(), analysisResults);
                            allWriter.writeReport();
                            setOfReports.add(allWriter.getResult());
                            outputFile = new File(outputDirPath + nameForFile + DriveScanTA.getTargetCloud(targetServer) + ".analyze" + outputType.getExtension());
                            this.setReturnCode(ReportUtility.writeOutStream(outputFile, allWriter.getResult()));
                        }
                        allWriter = new JSONEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(false), brr._descriptionsForNonTechRulesFlagged);
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".eval" + outputType.getExtension());
                        this.setReturnCode(ReportUtility.writeOutStream(outputFile, allWriter.getResult()));
                        outputFile = new File(outputDirPath + nameForFile + ".inventory" + outputType.getExtension());
                        this.setReturnCode(ReportUtility.writeOutStream(outputFile, "{ \"summary\": { \"sharedLibrary\": \"true\", \"bmpEntityBeans\": 0, \"cmpEntityBeans\": 0 } }"));
                        break;
                    }
                }
            }
            _data.setTargetAppServer(originalTargetAppServer);
            _data.setTargetJava(originalTargetJava);
        }
    }

    public EnvironmentJsonWriter createEnvJson(Map<File, String> mapOfAppsToProfiles, List<File> apps, File app, List<String> includeApplications, List<String> excludeApplications, String outputDirPath, String collectionUnitName, boolean runFromTaDc, boolean stopOnMissingBinary, boolean stopOnMissingSharedLibrary) {
        EnvironmentJsonWriter envJson;
        ConfigManager configMgr = this.getConfigManager(app);
        String sourceServerVersion = _data.getSourceAppServer().name().toLowerCase();
        String javaVersion = _data.getSourceJava().name().toLowerCase();
        if (configMgr != null && !mapOfAppsToProfiles.isEmpty()) {
            String wasPath = _data.getProjectDirPath(app.getAbsolutePath());
            List<ProductInf> products = this.getProductInfo(configMgr, wasPath);
            this.productInfs.addAll(products);
            List<WebsphereProfile> profiles = this.createProfiles(sourceServerVersion, javaVersion, mapOfAppsToProfiles, apps, outputDirPath, collectionUnitName, includeApplications, excludeApplications, runFromTaDc, stopOnMissingBinary, stopOnMissingSharedLibrary);
            envJson = new EnvironmentJsonWriter(this.productInfs, profiles, true, includeApplications, excludeApplications, _data.getStopOnMissingBinary(), _data.getStopOnMissingSharedLibrary());
        } else {
            this.addDefaultProductInfs();
            List<WebsphereProfile> profiles = this.createProfiles(sourceServerVersion, javaVersion, null, apps, outputDirPath, collectionUnitName, includeApplications, excludeApplications, runFromTaDc, stopOnMissingBinary, stopOnMissingSharedLibrary);
            envJson = new EnvironmentJsonWriter(this.productInfs, profiles, false, includeApplications, excludeApplications, _data.getStopOnMissingBinary(), _data.getStopOnMissingSharedLibrary());
        }
        return envJson;
    }

    public List<ProductInf> getProductInfo(ConfigManager configMgr, String wasPath) {
        ArrayList<ProductInf> products = new ArrayList<ProductInf>();
        String versionsDirPath = wasPath + File.separator + "properties" + File.separator + "version" + File.separator;
        File versionsDir = new File(versionsDirPath);
        for (File file : versionsDir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".product")) continue;
            try {
                NodeList buildInfoNodes;
                int buildInfoSize;
                NodeList versionNodes;
                int versionNodesSize;
                NodeList idNodes;
                int idNodesSize;
                FileInputStream xmlFile = new FileInputStream(file);
                Document xmlDoc = FileHelper.getParsedDocument(xmlFile);
                if (xmlDoc == null) continue;
                String name2 = null;
                String id = null;
                String version = null;
                String date = null;
                String level = null;
                NodeList productNodes = xmlDoc.getElementsByTagName("product");
                int productNodesSize = productNodes.getLength();
                if (productNodesSize > 0) {
                    Node product = productNodes.item(0);
                    name2 = XMLRuleUtil.getAttributeValue(product.getAttributes(), "*", "name");
                }
                if ((idNodesSize = (idNodes = xmlDoc.getElementsByTagName("id")).getLength()) > 0) {
                    Node idNode = idNodes.item(0);
                    id = XMLRuleUtil.getNodeValue(idNode.getParentNode(), idNode.getNodeName());
                }
                if ((versionNodesSize = (versionNodes = xmlDoc.getElementsByTagName("version")).getLength()) > 0) {
                    Node versionNode = versionNodes.item(0);
                    version = XMLRuleUtil.getNodeValue(versionNode.getParentNode(), versionNode.getNodeName());
                }
                if ((buildInfoSize = (buildInfoNodes = xmlDoc.getElementsByTagName("build-info")).getLength()) > 0) {
                    Node buildInfoNode = buildInfoNodes.item(0);
                    NamedNodeMap attrs = buildInfoNode.getAttributes();
                    date = XMLRuleUtil.getAttributeValue(attrs, "*", "date");
                    level = XMLRuleUtil.getAttributeValue(attrs, "*", "level");
                }
                products.add(new ProductInf(name2, id, version, date, level));
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parse_Exception"), file.getAbsolutePath(), e.toString()));
            }
        }
        return products;
    }

    public boolean validLibraryPaths(File app, String profileName, String outputDirPath, String collectionUnitName, List<String> paths, boolean runFromTaDc) {
        String failedPath = "";
        StringBuilder emptyPaths = new StringBuilder();
        if (this.shouldScan(app.getName(), profileName, outputDirPath, collectionUnitName, false)) {
            for (String path : paths) {
                File filePath = new File(path);
                if (filePath.exists()) {
                    String[] dirFiles;
                    if (!filePath.isDirectory() || (dirFiles = filePath.list()).length != 0) continue;
                    if (emptyPaths.length() > 0) {
                        emptyPaths.append(", ");
                    }
                    emptyPaths.append(path);
                    continue;
                }
                failedPath = path;
                break;
            }
        }
        boolean isValid = true;
        if (!failedPath.isEmpty()) {
            if (_data.getStopOnMissingSharedLibrary()) {
                String message = "";
                message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("DriveScan_No_Shared_Library_Error_TA"), failedPath) : Messages.getFormattedMessage(Messages.getString("DriveScan_No_Shared_Library_Error"), failedPath);
                this._cliFinalMessage = message;
                isValid = false;
            } else {
                ReportUtility.logger.get().log(Level.FINE, "Could not resolve the following shared library path: " + failedPath);
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_App_Config_Error"), app.getAbsolutePath()));
            }
        }
        if (emptyPaths.length() > 0) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Empty_Shared_Library_Dir"), "", emptyPaths.toString()));
        }
        return isValid;
    }

    public List<WebsphereProfile> createProfiles(String sourceServerName, String javaVersion, Map<File, String> mapOfAppsToProfiles, List<File> apps, String outputDirPath, String collectionUnitName, List<String> includeApplications, List<String> excludeApplications, boolean runFromTaDc, boolean stopOnMissingBinary, boolean stopOnMissingSharedLibrary) {
        ArrayList<WebsphereProfile> profiles = new ArrayList<WebsphereProfile>();
        String hostname = DriveScanTA.getHostname();
        String archiveType = DriveScanTA.getArchiveType(sourceServerName);
        String middleware = DriveScanTA.getMiddleware(sourceServerName);
        String domain = "javaAppServer";
        String version = "25.0.0.2";
        String profileDir = null;
        if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
            String scopeString;
            String profileName;
            WebsphereProfile wasProfile;
            HashMap<String, WebsphereProfile> profilesToApp = new HashMap<String, WebsphereProfile>();
            HashMap<String, Set<Library>> profileToAllLibraries = new HashMap<String, Set<Library>>();
            HashMap<String, Set<Variable>> profileToAllVariables = new HashMap<String, Set<Variable>>();
            HashSet serverLibraryNames = null;
            for (File file : apps) {
                String profile = mapOfAppsToProfiles.get(file);
                if (profile == null) continue;
                ConfigManager configMgr = this.getConfigManager(file);
                wasProfile = (WebsphereProfile)profilesToApp.get(profile);
                if (wasProfile == null && configMgr != null) {
                    TreeSet<String> assessUnitNames = new TreeSet<String>();
                    String cellName = configMgr.getCell().getCellName();
                    String cellType = configMgr.getCell().getCellType();
                    boolean isStandAlone = false;
                    if (cellType.toLowerCase().equals("standalone")) {
                        isStandAlone = true;
                    }
                    Servers servers = configMgr.getServers();
                    Clusters clusters = configMgr.getClusters();
                    TreeSet<String> appPaths = new TreeSet<String>();
                    profileDir = _data.getProfilePath(profile);
                    ArchiveInfo archiveInfo = new ArchiveInfo(domain, profile, archiveType, version, middleware, hostname, assessUnitNames);
                    wasProfile = new WebsphereProfile(profile, profileDir, cellName, appPaths, isStandAlone, sourceServerName, javaVersion, assessUnitNames, archiveInfo, true, stopOnMissingBinary, stopOnMissingSharedLibrary);
                    profilesToApp.put(profile, wasProfile);
                    profiles.add(wasProfile);
                    for (Servers.Server server : servers.getServers()) {
                        OrderedJSONObject json = new OrderedJSONObject();
                        json.put("name", server.getServerName());
                        json.put("displayName", "");
                        json.put("serverType", server.getServerType());
                        wasProfile.addServer(json);
                    }
                    for (Clusters.Cluster cluster : clusters.getClusters()) {
                        String clusterName = cluster.getClusterName();
                        wasProfile.addCluster(clusterName);
                        OrderedJSONObject clusterInfoJson = new OrderedJSONObject();
                        JSONArray deployedAppsJsonArray = new JSONArray();
                        for (Apps.App deployedApp : cluster.getApps()) {
                            String deployedAppName = deployedApp.getAppName();
                            if (_missingBinaries.contains(deployedAppName) || DataCollectionHelper.isSystemApp(deployedAppName) || DriveScanTA.excludedApp(deployedAppName, includeApplications, excludeApplications)) continue;
                            deployedAppsJsonArray.add(deployedAppName);
                        }
                        clusterInfoJson.put("clusterName", clusterName);
                        clusterInfoJson.put("clusterId", clusterName + "_" + cluster.getClusterXmiId());
                        clusterInfoJson.put("deployedApps", deployedAppsJsonArray);
                        ReportUtility.addClusterTypeAndMinMaxToClusterJson(clusterInfoJson, cluster.getDynamicCluster() != null, String.valueOf(cluster.getMinReplicasValueForCluster()), String.valueOf(cluster.getMaxReplicasValueForCluster()), String.valueOf(cluster.getServerCount()));
                        ReportUtility.addSessionPersistenceTypeToClusterJson(clusterInfoJson, cluster.getClusterSessionPersistenceType());
                        ReportUtility.addTransactionLogTypeToClusterJson(clusterInfoJson, cluster.getClusterTransactionLogType());
                        wasProfile.addClusterInfo(clusterInfoJson);
                    }
                }
                wasProfile.addApp(file);
                try {
                    String appName = file.getName();
                    String appPath = file.getAbsolutePath();
                    LibertyServerXml targetConfig = new LibertyServerXml(configMgr, appName, null, false);
                    if (targetConfig == null) continue;
                    OrderedJSONObject appInfoJson = new OrderedJSONObject();
                    if (profileToAllLibraries.get(profile) == null) {
                        profileToAllLibraries.put(profile, targetConfig.getAllLibraries());
                    }
                    Set<Library> libraries = targetConfig.getAppLibraries();
                    Map<Servers.Server, Set<String>> serverToLibrarynames = targetConfig.getServerLibraryNamesMap();
                    Servers.Server server = null;
                    if (!serverToLibrarynames.isEmpty()) {
                        serverLibraryNames = new HashSet();
                        server = serverToLibrarynames.keySet().iterator().next();
                        serverLibraryNames.addAll(serverToLibrarynames.get(server));
                    }
                    HashSet<OrderedJSONObject> librariesJson = new HashSet<OrderedJSONObject>();
                    this._mapOfAppToLibrary.put(file, librariesJson);
                    for (Library library : libraries) {
                        String libName = library.getName();
                        Scope scope = library.getScope();
                        String scopeString2 = scope.getDirectory() != null ? scope.getDirectory().getAbsolutePath() : scope.getName();
                        String mapKey = this.getMapKeyForResource(scopeString2, libName);
                        WebsphereProfile sharedLibProfile = this._sharedLibraryProfiles.get(mapKey);
                        if (sharedLibProfile == null) {
                            String sharedLibProfileName = profile + "-" + (String)libName;
                            TreeSet<String> assessUnitNames = new TreeSet<String>();
                            ArchiveInfo archiveInfo = new ArchiveInfo("java", sharedLibProfileName, "sharedLibrary", version, middleware, hostname, assessUnitNames);
                            sharedLibProfile = new WebsphereProfile(sharedLibProfileName, null, assessUnitNames, archiveInfo, libName, stopOnMissingBinary, stopOnMissingSharedLibrary);
                            this._sharedLibraryProfiles.put(mapKey, sharedLibProfile);
                            boolean isServerLevelSL = serverLibraryNames == null ? false : serverLibraryNames.contains(libName);
                            boolean validPaths = this.validLibraryPaths(file, profile, outputDirPath, collectionUnitName, library.getResolvedClassPath(), runFromTaDc);
                            if (!validPaths) {
                                this.setReturnCode(4);
                                return null;
                            }
                            OrderedJSONObject sharedLibJson = new OrderedJSONObject();
                            JSONArray classPathEntries = new JSONArray();
                            classPathEntries.addAll(library.getResolvedClassPath());
                            sharedLibJson.put("name", libName);
                            sharedLibJson.put("scope", scopeString2);
                            sharedLibJson.put("classPathEntries", classPathEntries);
                            sharedLibJson.put("applicationName", new JSONArray());
                            sharedLibJson.put("isServerLevelSL", (Object)isServerLevelSL);
                            wasProfile.addSharedLibrary(sharedLibJson);
                            if (isServerLevelSL) {
                                OrderedJSONObject serverPathJson = new OrderedJSONObject();
                                JSONArray serverClassPathEntries = new JSONArray();
                                for (ProcessDefinition processDefinition : server.getProcessDefinitions()) {
                                    for (JvmEntry jvmEntry : processDefinition.getJvmEntries()) {
                                        List<String> entryClassPaths = jvmEntry.getClasspath();
                                        if (entryClassPaths.isEmpty()) continue;
                                        serverClassPathEntries.addAll(entryClassPaths);
                                    }
                                }
                                serverPathJson.put("server", server.getLocalServerName());
                                serverPathJson.put("classpath", serverClassPathEntries);
                                wasProfile.addServerClassPath(serverPathJson);
                                this._serverClassPaths.put(scopeString2, serverPathJson);
                            }
                            this._knownLibs.put(mapKey, sharedLibJson);
                            librariesJson.add(sharedLibJson);
                            continue;
                        }
                        librariesJson.add(this._knownLibs.get(mapKey));
                    }
                    appInfoJson.put("name", appName);
                    appInfoJson.put("path", appPath);
                    boolean hasSharedLibrary = librariesJson != null && !librariesJson.isEmpty();
                    appInfoJson.put("hasSharedLibrary", (Object)hasSharedLibrary);
                    appInfoJson.put("server", "");
                    if (hasSharedLibrary) {
                        TreeSet<String> setOfLibraryNames = new TreeSet<String>();
                        for (Library library : libraries) {
                            setOfLibraryNames.add(library.getName());
                        }
                        JSONArray jsonArr = new JSONArray();
                        jsonArr.addAll(setOfLibraryNames);
                        appInfoJson.put("sharedLibraries", jsonArr);
                    }
                    wasProfile.addAppToClusterInfo(appInfoJson);
                    if (profileToAllVariables.get(profile) != null) continue;
                    profileToAllVariables.put(profile, targetConfig.getAllVariables());
                }
                catch (Exception appName) {}
            }
            for (Map.Entry entry : profileToAllLibraries.entrySet()) {
                profileName = (String)entry.getKey();
                Set libraries = (Set)entry.getValue();
                wasProfile = (WebsphereProfile)profilesToApp.get(profileName);
                for (Library library : libraries) {
                    String libName = library.getName();
                    Scope scope = library.getScope();
                    scopeString = scope.getDirectory() != null ? scope.getDirectory().getAbsolutePath() : scope.getName();
                    String mapKey = this.getMapKeyForResource(scopeString, libName);
                    if (this._knownLibs.containsKey(mapKey)) continue;
                    boolean isServerLevelSL = serverLibraryNames == null ? false : serverLibraryNames.contains(libName);
                    OrderedJSONObject sharedLibJson = new OrderedJSONObject();
                    sharedLibJson.put("name", libName);
                    sharedLibJson.put("scope", scopeString);
                    JSONArray classPathEntries = new JSONArray();
                    classPathEntries.addAll(library.getResolvedClassPath());
                    sharedLibJson.put("classPathEntries", classPathEntries);
                    sharedLibJson.put("applicationName", new JSONArray());
                    sharedLibJson.put("isServerLevelSL", (Object)isServerLevelSL);
                    wasProfile.addSharedLibrary(sharedLibJson);
                    this._knownLibs.put(mapKey, sharedLibJson);
                }
            }
            for (Map.Entry entry : profileToAllVariables.entrySet()) {
                profileName = (String)entry.getKey();
                Set variables = (Set)entry.getValue();
                wasProfile = (WebsphereProfile)profilesToApp.get(profileName);
                for (Variable variable : variables) {
                    String variableName = variable.getSymbolicName();
                    Scope scope = variable.getScope();
                    String string = scopeString = scope.getDirectory() != null ? scope.getDirectory().getAbsolutePath() : scope.getName();
                    String scopeName = scope.getName();
                    String mapKey = this.getMapKeyForResource(scopeName, variableName);
                    if (this._knownVars.containsKey(mapKey)) continue;
                    OrderedJSONObject variableJson = new OrderedJSONObject();
                    variableJson.put("name", variableName);
                    variableJson.put("scope", scopeString);
                    variableJson.put("value", variable.getResolvedValue());
                    wasProfile.addWebsphereVariable(variableJson);
                    this._knownVars.put(mapKey, variableJson);
                }
            }
        } else {
            TreeSet<String> assessUnitNames = new TreeSet<String>();
            TreeSet<String> appPaths = new TreeSet<String>();
            for (File app : apps) {
                String appPath = app.getAbsolutePath();
                String string = app.getName();
                assessUnitNames.add(string);
                appPaths.add(appPath);
                if (profileDir != null) continue;
                profileDir = appPath.replace(File.separator + string, "");
            }
            ArchiveInfo archiveInfo = new ArchiveInfo(domain, collectionUnitName, archiveType, version, middleware, hostname, assessUnitNames);
            profiles.add(new WebsphereProfile(collectionUnitName, profileDir, "", appPaths, true, sourceServerName, javaVersion, assessUnitNames, archiveInfo, false, stopOnMissingBinary, stopOnMissingSharedLibrary));
        }
        return profiles;
    }

    private String getMapKeyForResource(String scopeString, String libraryName) {
        return scopeString + "/" + libraryName;
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        return null;
    }

    public boolean shouldScan(String archiveName, String profileName, String outputDirPath, String collectionUnitName, boolean isSharedLibrary) {
        HashSet<File> expectedFile = new HashSet<File>();
        String nameForFileDir = outputDirPath + collectionUnitName + File.separator;
        String nameForFile = nameForFileDir + archiveName;
        if (isSharedLibrary) {
            expectedFile.add(new File(nameForFileDir + "environment.json"));
        } else {
            expectedFile.add(new File(nameForFile + "_" + "server" + ReportInputData.OutputType.XML.getExtension()));
            if (null != profileName && !profileName.isEmpty()) {
                expectedFile.add(new File(nameForFile + "_" + "server" + ReportInputData.OutputType.PY.getExtension()));
            }
            expectedFile.add(new File(nameForFile + ".assessmentUnit" + ReportInputData.OutputType.JSON.getExtension()));
            expectedFile.add(new File(nameForFile + ".WebSphereLiberty" + "_" + "server" + ReportInputData.OutputType.XML.getExtension()));
        }
        expectedFile.add(new File(nameForFile + ".eval" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + ".eval" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + ".inventory" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + ".inventory" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.WAS90) + ".analyze" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.WAS90) + ".analyze" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.OPEN_LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.OPEN_LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.EASE) + ".analyze" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.EASE) + ".analyze" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.MANAGED_LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.MANAGED_LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension()));
        expectedFile.add(new File(nameForFile + DriveScanTA.getTargetCloud(ReportInputData.AppServer.LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension()));
        Iterator itr = expectedFile.iterator();
        while (itr.hasNext()) {
            File file = (File)itr.next();
            if (!file.exists()) continue;
            itr.remove();
        }
        return !expectedFile.isEmpty();
    }

    public void findSharedLibraries(File appFile) {
        _data.getSharedLibraryFiles().clear();
        Set<OrderedJSONObject> libraries = this._mapOfAppToLibrary.get(appFile);
        ConfigManager configMgr = this.getConfigManager(appFile);
        Map<File, String> mapOfAppsToProfiles = _data.getMapOfAppsToProfiles();
        if (configMgr != null && !mapOfAppsToProfiles.isEmpty() && null != libraries) {
            HashSet<String> scopesProcessed = new HashSet<String>();
            for (OrderedJSONObject library : libraries) {
                if (library != null && library.containsKey("applicationName")) {
                    JSONArray associatedApps = (JSONArray)library.get("applicationName");
                    if (associatedApps.isEmpty()) {
                        String libName = (String)library.get("name");
                        String scope = (String)library.get("scope");
                        OrderedJSONObject serverClassPathObject = this._serverClassPaths.get(scope);
                        JSONArray serverfilePaths = new JSONArray();
                        HashSet<File> allServerSharedLibFiles = new HashSet<File>();
                        boolean sharedLibFailure = false;
                        if (serverClassPathObject != null && scopesProcessed.add(scope)) {
                            JSONArray serverClassPath = (JSONArray)serverClassPathObject.get("classpath");
                            serverClassPathObject.put("classpath", serverfilePaths);
                            for (int i = 0; i < serverClassPath.size(); ++i) {
                                String path = (String)serverClassPath.get(i);
                                File file = new File(path);
                                Set<File> sharedLibFiles = this.addSharedLibraries(file);
                                if (sharedLibFiles == null) {
                                    serverfilePaths.clear();
                                    library.put("classPath", serverClassPath);
                                    sharedLibFailure = true;
                                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_App_Config_Error"), appFile.getName()));
                                    break;
                                }
                                allServerSharedLibFiles.addAll(sharedLibFiles);
                            }
                        }
                        WebsphereProfile libProfile = this._sharedLibraryProfiles.get(this.getMapKeyForResource((String)library.get("scope"), libName));
                        JSONArray classPaths = (JSONArray)library.get("classPathEntries");
                        JSONArray filePaths = new JSONArray();
                        library.put("classPathEntries", filePaths);
                        HashSet<File> allSharedLibFiles = new HashSet<File>();
                        for (int i = 0; i < classPaths.size(); ++i) {
                            String path = (String)classPaths.get(i);
                            File file = new File(path);
                            Set<File> sharedLibFiles = this.addSharedLibraries(file);
                            if (sharedLibFiles == null) {
                                filePaths.clear();
                                library.put("classPathEntries", classPaths);
                                sharedLibFailure = true;
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_App_Config_Error"), appFile.getName()));
                                break;
                            }
                            allSharedLibFiles.addAll(sharedLibFiles);
                        }
                        if (!sharedLibFailure) {
                            String filePath;
                            for (File fileFound : allSharedLibFiles) {
                                filePath = fileFound.getAbsolutePath();
                                if (!filePath.endsWith(".jar")) continue;
                                libProfile.addApp(fileFound, true, false);
                                filePaths.add(fileFound.getAbsolutePath().replace("\\", "/"));
                            }
                            ReportUtility.sortStringJSONArray(filePaths);
                            for (File fileFound : allServerSharedLibFiles) {
                                filePath = fileFound.getAbsolutePath();
                                if (!filePath.endsWith(".jar")) continue;
                                serverfilePaths.add(fileFound.getAbsolutePath().replace("\\", "/"));
                            }
                            ReportUtility.sortStringJSONArray(serverfilePaths);
                            _sharedLibraryFiles.addAll(_tempSharedLibraryFiles);
                        }
                        _tempSharedLibraryFiles.clear();
                    } else {
                        JSONArray classPaths = (JSONArray)library.get("classPathEntries");
                        for (int i = 0; i < classPaths.size(); ++i) {
                            _sharedLibraryFiles.add(new File((String)classPaths.get(i)));
                        }
                    }
                    associatedApps.add(appFile.getName());
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "_mapOfAppToLibrary is somehow missing information about " + appFile.getAbsolutePath());
            }
        }
    }

    public File getServerXMLName(boolean isWL, boolean isEASe, boolean isML, String collectionUnitName, String appName, String outputDirPath) {
        String cloud = null;
        cloud = isWL ? ".WebSphereLiberty" : (isML ? ".ManagedLiberty" : (isEASe ? ".EASe" : ""));
        String nameForFile = collectionUnitName + File.separator + appName + cloud + "_" + "server";
        return new File(outputDirPath + nameForFile + ReportInputData.OutputType.XML.getExtension());
    }

    public Map<ReportInputData.OutputType, Set<String>> generateReports(File appFile, String appPath, String outputDirPath, EnvironmentJsonWriter envJson, String collectionUnitName, StringBuilder sensitiveDataFilesSB) throws Exception {
        BinaryReportReader brr;
        EnumMap<ReportInputData.OutputType, Set<String>> resultMap = new EnumMap<ReportInputData.OutputType, Set<String>>(ReportInputData.OutputType.class);
        ArrayList<String> projectName = new ArrayList<String>();
        ArrayList<File> projectFile = new ArrayList<File>();
        projectName.add(appPath);
        if (appFile != null) {
            projectFile.add(appFile);
        }
        _data.setProjectData(projectFile, projectName);
        Map<File, String> mapOfAppsToProfiles = _data.getMapOfAppsToProfiles();
        ConfigManager configMgr = this.getConfigManager(appFile);
        LibertyServerXml libertyServerXml = null;
        WSAdminScript wsAdminScript = null;
        HashSet<String> appsUsingSessions = new HashSet<String>();
        HashMap<String, TargetConfig> mapOfAppToTargetConfig = new HashMap<String, TargetConfig>();
        HashMap<String, Map<String, IdentifierObject>> possibleIdentifierNames = new HashMap<String, Map<String, IdentifierObject>>();
        String appName = appFile.getName();
        if (configMgr != null && !mapOfAppsToProfiles.isEmpty()) {
            possibleIdentifierNames.put(appName, configMgr.getPossibleIdentifierNames());
            libertyServerXml = new LibertyServerXml(configMgr, appFile.getName(), new File(outputDirPath + mapOfAppsToProfiles.get(appFile) + File.separator + appName + "_" + "server" + ReportInputData.OutputType.XML.getExtension()), true);
            wsAdminScript = new WSAdminScript(configMgr, appFile.getName(), new File(outputDirPath + mapOfAppsToProfiles.get(appFile) + File.separator + appName + "_" + "server" + ReportInputData.OutputType.PY.getExtension()));
            mapOfAppToTargetConfig.put(appName, libertyServerXml);
        }
        boolean dirCreated = false;
        File collectionUnitDir = new File(outputDirPath + collectionUnitName);
        if (!collectionUnitDir.exists()) {
            dirCreated = collectionUnitDir.mkdir();
            if (!dirCreated) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_CollectionUnit_Directory_Creation"), collectionUnitDir.getAbsolutePath()));
            }
        } else {
            dirCreated = true;
        }
        if (dirCreated && (brr = this.getBinaryReportReader(possibleIdentifierNames, appsUsingSessions)) != null) {
            ArchiveInventory ai;
            ArrayList<String> sharedLibProjectNames;
            Map costs;
            Map<String, String> helpFileNames;
            EnumMap<ReportInputData.AppServer, Map<String, Map<String, Map<String, List<String>>>>> rulesAnalyzedByCategory;
            ReportInputData.JavaVersion originalTargetJava;
            ReportInputData.AppServer targetWAS;
            ReportInputData.AppServer originalTargetAppServer;
            Map<String, List<DetailResult>> projectsToDetailsFoundAnalyze;
            SortedMap<String, TechSummary> listOfTechSummaries;
            String checkSum;
            block67: {
                brr.openFile();
                checkSum = brr.getChecksumMap().get(appPath);
                listOfTechSummaries = brr.buildTechResults();
                projectsToDetailsFoundAnalyze = brr.getProjectsToDetailResults(ReportInputData.ReportType.ANALYZE);
                originalTargetAppServer = _data.getTargetAppServer();
                targetWAS = DataCollectionHelper.getTWASTarget(_data.getSourceAppServer(), _data.getTargetAppServer());
                originalTargetJava = _data.getTargetJava();
                rulesAnalyzedByCategory = new EnumMap<ReportInputData.AppServer, Map<String, Map<String, Map<String, List<String>>>>>(ReportInputData.AppServer.class);
                for (ReportInputData.AppServer targetServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                    rulesAnalyzedByCategory.put(targetServer, this._analyze.getSortedRulesByCategories(targetServer));
                }
                helpFileNames = this.getRuleHelp();
                costs = this._analyze._costs;
                Map<String, List<DetailResult>> projectsToDetailsFoundInventory = brr.getProjectsToDetailResults(ReportInputData.ReportType.INVENTORY);
                sharedLibProjectNames = new ArrayList<String>();
                if (_data.hasSharedLibraries()) {
                    for (File nextFile : _data.getSharedLibraryFiles()) {
                        sharedLibProjectNames.add(nextFile.getPath().replace("\\", "/"));
                    }
                    Collections.sort(sharedLibProjectNames);
                }
                ai = DriveScanInventory.createArchiveInventory(projectsToDetailsFoundInventory, sharedLibProjectNames, mapOfAppToTargetConfig, appsUsingSessions, brr.getChecksumMap());
                TreeSet<String> coreFeaturesML = new TreeSet<String>();
                TreeSet<String> baseFeaturesML = new TreeSet<String>();
                TreeSet coreFeaturesWL = new TreeSet();
                TreeSet baseFeaturesWL = new TreeSet();
                TreeSet coreFeaturesOL = new TreeSet();
                TreeSet baseFeaturesOL = new TreeSet();
                TreeSet coreFeaturesEASe = new TreeSet();
                TreeSet baseFeaturesEASe = new TreeSet();
                boolean hasConflictsWL = false;
                boolean hasConflictsML = false;
                boolean hasConflictsOL = false;
                if (libertyServerXml != null) {
                    libertyServerXml.setUsedIdentifierNames(brr.getFoundIdentifierNames(appName));
                    wsAdminScript.setUsedIdentifierNames(brr.getFoundIdentifierNames(appName));
                }
                for (ReportInputData.AppServer targetServer : EnumSet.of(ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                    boolean isEASe;
                    boolean isWL = targetServer == ReportInputData.AppServer.LIBERTY;
                    boolean isML = targetServer == ReportInputData.AppServer.MANAGED_LIBERTY;
                    boolean isOL = targetServer == ReportInputData.AppServer.OPEN_LIBERTY;
                    boolean bl = isEASe = targetServer == ReportInputData.AppServer.EASE;
                    if (isWL) {
                        _data.setTargetJavaEE(null);
                    } else if (isML) {
                        _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE10);
                    } else {
                        _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE7);
                    }
                    _data.setTargetAppServer(targetServer);
                    this.driveScanGenerateConfig.clearLists();
                    this.driveScanGenerateConfig.setIsOpenLiberty(isOL);
                    this.driveScanGenerateConfig.setIsLibertyEASe(isEASe);
                    DriveScanGenerateConfig.loadLists(this.getClass());
                    TreeSet<String> coreFeatures = null;
                    TreeSet<String> baseFeatures = null;
                    if (isML) {
                        coreFeatures = coreFeaturesML;
                        baseFeatures = baseFeaturesML;
                    } else if (isWL) {
                        coreFeatures = coreFeaturesWL;
                        baseFeatures = baseFeaturesWL;
                    } else if (isOL) {
                        coreFeatures = coreFeaturesOL;
                        baseFeatures = baseFeaturesOL;
                    } else if (isEASe) {
                        coreFeatures = coreFeaturesEASe;
                        baseFeatures = baseFeaturesEASe;
                    }
                    TreeSet<String> configFeatures = new TreeSet<String>();
                    if (libertyServerXml != null) {
                        configFeatures.addAll(libertyServerXml.getConfigFeatures());
                        libertyServerXml.setConfigRulesFlagged(brr.getConfigRulesFlagged());
                    }
                    boolean hasConflicts = false;
                    if (!isML) {
                        hasConflicts = this.driveScanGenerateConfig.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appPath);
                    } else {
                        ArrayList<String> currentFeatures = new ArrayList<String>();
                        currentFeatures.addAll(ManagedLibertyFeatureSets.LONDON_FEATURES_EE10);
                        hasConflicts = this.driveScanGenerateConfig.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appPath, currentFeatures);
                    }
                    if (isWL) {
                        hasConflictsWL = hasConflicts;
                    } else if (isML) {
                        hasConflictsML = hasConflicts;
                    } else {
                        hasConflictsOL = hasConflicts;
                    }
                    if (!_data.filterAnalysisRulesByFeatureList()) continue;
                    HashSet<String> allFeatures = new HashSet<String>();
                    if (!hasConflicts) {
                        allFeatures.addAll(coreFeatures);
                        allFeatures.addAll(baseFeatures);
                    }
                    Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures = this.driveScanGenerateConfig.getLibertyJavaEEJakartaFeatures();
                    ConfigFeatureVersionInfo cfvi = this.getConfigFeatureVersionInfo(_data.getSourceAppServer(), mapOfAppToTargetConfig);
                    cfvi.setTargetJavaEE(_data.getTargetJavaEE());
                    this.filterJavaEERules(projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), allFeatures, targetServer, cfvi, this._analyze, libertyJavaEEJakartaFeatures);
                }
                brr.closeFile();
                String migratedConfig = null;
                File sensitiveDataFile = null;
                String sensitiveData = null;
                File mimeTypesFile = null;
                String mimeTypes = null;
                File jvmOptionsFile = null;
                String jvmOptions = null;
                Map<String, String> filesToMigrate = null;
                if (configMgr != null && !mapOfAppToTargetConfig.isEmpty()) {
                    LibertyServerXml targetConfig = libertyServerXml;
                    ((TargetConfig)libertyServerXml).migrateConfig();
                    migratedConfig = targetConfig.getServerXmlContent();
                    filesToMigrate = targetConfig.getFilesToMigrate();
                    for (ReportInputData.AppServer targetServer : EnumSet.of(ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                        boolean isWL = targetServer == ReportInputData.AppServer.LIBERTY;
                        boolean isML = targetServer == ReportInputData.AppServer.MANAGED_LIBERTY;
                        boolean isOL = targetServer == ReportInputData.AppServer.OPEN_LIBERTY;
                        boolean isEASe = targetServer == ReportInputData.AppServer.EASE;
                        TreeSet<String> coreFeatures = null;
                        TreeSet<String> baseFeatures = null;
                        SortedSet<String> missingFeatures = null;
                        String platform = null;
                        if (isML) {
                            coreFeatures = coreFeaturesML;
                            baseFeatures = baseFeaturesML;
                            missingFeatures = DriveScanGenerateConfig.pruneUnsupportManagedLibertyFeatures(coreFeatures, baseFeatures);
                            platform = "jakartaee-10.0";
                        } else if (isWL) {
                            coreFeatures = coreFeaturesWL;
                            baseFeatures = baseFeaturesWL;
                        } else if (isOL) {
                            coreFeatures = coreFeaturesOL;
                            baseFeatures = baseFeaturesOL;
                        } else if (isEASe) {
                            coreFeatures = coreFeaturesEASe;
                            baseFeatures = baseFeaturesEASe;
                        }
                        try {
                            boolean hasConflicts = false;
                            String serverXmlContent = ServerXmlWriter.buildServerXML(coreFeatures, baseFeatures, missingFeatures, migratedConfig, isOL || isEASe, hasConflicts = isWL ? hasConflictsWL : (isML ? hasConflictsML : hasConflictsOL), platform);
                            if (serverXmlContent == null || serverXmlContent.equals("")) continue;
                            File outputFile = this.getServerXMLName(isWL, isEASe, isML, collectionUnitName, appName, outputDirPath);
                            ReportUtility.writeOutStream(outputFile, serverXmlContent);
                            if (jvmOptionsFile == null) {
                                jvmOptionsFile = targetConfig.getJvmOptions();
                                jvmOptions = targetConfig.getJvmOptionsContent();
                                sensitiveData = targetConfig.getSensitiveDataContent();
                                sensitiveDataFile = targetConfig.getSensitiveDataXml();
                                mimeTypes = targetConfig.getMimeTypesData();
                                mimeTypesFile = targetConfig.getMimeTypesXml();
                                if (sensitiveDataFile != null && sensitiveData != null) {
                                    ReportUtility.writeOutStream(sensitiveDataFile, sensitiveData);
                                    if (SensitiveDataHelper.isIncludeSensitiveData()) {
                                        sensitiveDataFilesSB.append(sensitiveDataFile).append("\n");
                                    }
                                }
                                if (jvmOptionsFile != null && jvmOptions != null) {
                                    ReportUtility.writeOutStream(jvmOptionsFile, jvmOptions);
                                }
                                if (mimeTypesFile != null && mimeTypes != null) {
                                    ReportUtility.writeOutStream(mimeTypesFile, mimeTypes);
                                }
                            }
                            this.migrateFilesForConfig(filesToMigrate);
                        }
                        catch (Exception e) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appFile.getName()), e);
                                continue;
                            }
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appFile.getName(), e.getMessage()));
                        }
                    }
                    try {
                        WSAdminScript targetConfigWas = wsAdminScript;
                        targetConfigWas.migrateConfig();
                        migratedConfig = targetConfigWas.getWSAdminScriptContent();
                        ReportUtility.writeOutStream(targetConfigWas.getWSAdminScript(), migratedConfig);
                        if (SensitiveDataHelper.isIncludeSensitiveData() && !SensitiveDataHelper.getRegisteredVarKeys().isEmpty()) {
                            sensitiveDataFilesSB.append(targetConfigWas.getWSAdminScript()).append("\n");
                        }
                    }
                    catch (Exception e) {
                        if (ReportUtility.isDebug()) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appFile.getName()), e);
                            break block67;
                        }
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appFile.getName(), e.getMessage()));
                    }
                } else {
                    for (ReportInputData.AppServer targetServer : EnumSet.of(ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                        boolean isWL = targetServer == ReportInputData.AppServer.LIBERTY;
                        boolean isML = targetServer == ReportInputData.AppServer.MANAGED_LIBERTY;
                        boolean isOL = targetServer == ReportInputData.AppServer.OPEN_LIBERTY;
                        boolean isEASe = targetServer == ReportInputData.AppServer.EASE;
                        TreeSet<String> coreFeatures = null;
                        TreeSet<String> baseFeatures = null;
                        Object missingFeatures = null;
                        String platform = null;
                        if (isML) {
                            coreFeatures = coreFeaturesML;
                            baseFeatures = baseFeaturesML;
                            missingFeatures = DriveScanGenerateConfig.pruneUnsupportManagedLibertyFeatures(coreFeatures, baseFeatures);
                            platform = "jakartaee-10.0";
                        } else if (isWL) {
                            coreFeatures = coreFeaturesWL;
                            baseFeatures = baseFeaturesWL;
                        } else if (isOL) {
                            coreFeatures = coreFeaturesOL;
                            baseFeatures = baseFeaturesOL;
                        } else if (isEASe) {
                            coreFeatures = coreFeaturesEASe;
                            baseFeatures = baseFeaturesEASe;
                        }
                        if ((isML || coreFeatures.isEmpty() && baseFeatures.isEmpty()) && (!isML || !_data.filterAnalysisRulesByFeatureList())) continue;
                        boolean hasConflicts = false;
                        hasConflicts = isWL ? hasConflictsWL : (isML ? hasConflictsML : hasConflictsOL);
                        String serverXml = ServerXmlWriter.buildServerXML(coreFeatures, baseFeatures, missingFeatures, migratedConfig, isEASe || isOL, hasConflicts, platform);
                        File outputFile = this.getServerXMLName(isWL, isEASe, isML, collectionUnitName, appName, outputDirPath);
                        ReportUtility.writeOutStream(outputFile, serverXml);
                    }
                }
            }
            this.generateAssessmentUnit(outputDirPath, collectionUnitName, appName, null, null, checkSum, false);
            Map<ReportInputData.AppServer, List<String>> connectivityRulesAnalyzed = this._analyze.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity", targetWAS);
            ReportWriter allWriter = null;
            String nameForFile = collectionUnitName + File.separator + appName;
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        File outputFile;
                        TreeMap<String, String> scanOptions = new TreeMap<String, String>();
                        scanOptions.putAll(_data.getScanOptionsDisplay());
                        scanOptions.putAll(_data.getEvalReportOptions(true));
                        HashSet<String> setOfReports = new HashSet();
                        resultMap.put(outputType, setOfReports);
                        for (ReportInputData.AppServer targetServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                            _data.setTargetAppServer(targetServer);
                            _data.setTargetJavaEE(DataCollectionHelper.getTargetJavaEE(_data.getSourceAppServer(), targetServer));
                            _data.setTargetJava(DataCollectionHelper.getTargetJava(_data.getSourceAppServer(), targetServer, _data.getSourceJava(), originalTargetJava));
                            AnalysisResults analysisResults = new AnalysisResults(this._analyze._descToRuleIds, projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), connectivityRulesAnalyzed.get((Object)targetServer), this._analyze._severities, helpFileNames, brr.getRulesFlagged(), _data.showAllHelp(), (Set)this._analyze.targetToCategories.get(_data.getTargetAppServer().toString()), this._analyze.getRulesToRecipesMap());
                            allWriter = new HTMLDetailAnalysisStreamlinedReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptionsDisplay(), (Map)rulesAnalyzedByCategory.get((Object)targetServer), false, analysisResults, connectivityRulesAnalyzed.get((Object)targetServer), _data.showAllHelp(), _data.loadAllRules(), _data.getMaxUserDefinedRuleResults(), costs);
                            allWriter.writeReport();
                            setOfReports.add(allWriter.getResult());
                            outputFile = new File(outputDirPath + nameForFile + DriveScanTA.getTargetCloud(targetServer) + ".analyze" + outputType.getExtension());
                            this.openHtmlReport(outputFile, allWriter.getResult(), outputType, true);
                        }
                        allWriter = new HTMLEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(true));
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".eval" + outputType.getExtension());
                        this.openHtmlReport(outputFile, allWriter.getResult(), outputType, true);
                        allWriter = new HTMLInventoryReportWriter(ai, _data.getProjectNames(), sharedLibProjectNames, _data.getScanOptionsDisplay());
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".inventory" + outputType.getExtension());
                        this.openHtmlReport(outputFile, allWriter.getResult(), outputType, true);
                        break;
                    }
                    case JSON: {
                        File outputFile;
                        HashSet<String> setOfReports = new HashSet<String>();
                        resultMap.put(outputType, setOfReports);
                        TreeMap<String, String> jsonScanOptions = new TreeMap<String, String>();
                        jsonScanOptions.putAll(_data.getScanOptionsDisplay());
                        jsonScanOptions.putAll(_data.getEvalReportOptions(false));
                        for (ReportInputData.AppServer targetServer : EnumSet.of(targetWAS, ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.MANAGED_LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE)) {
                            _data.setTargetAppServer(targetServer);
                            _data.setTargetJavaEE(DataCollectionHelper.getTargetJavaEE(_data.getSourceAppServer(), targetServer));
                            _data.setTargetJava(DataCollectionHelper.getTargetJava(_data.getSourceAppServer(), targetServer, _data.getSourceJava(), originalTargetJava));
                            AnalysisResults analysisResults = new AnalysisResults(this._analyze._descToRuleIds, projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), connectivityRulesAnalyzed.get((Object)targetServer), this._analyze._severities, helpFileNames, brr.getRulesFlagged(), _data.showAllHelp(), (Set)this._analyze.targetToCategories.get(_data.getTargetAppServer().toString()), this._analyze.getRulesToRecipesMap());
                            allWriter = new JSONDetailAnalysisReportWriter(_data.getProjectNames(), _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptions(), projectsToDetailsFoundAnalyze, (Map)rulesAnalyzedByCategory.get((Object)targetServer), false, helpFileNames, this._analyze._severities, this._analyze._costs, _data.getApplicationNames(), this._analyze.getCategoryNamesMappedToKeys(), _data.includeHelpLocation(), _data.getMaxUserDefinedRuleResults(), analysisResults);
                            allWriter.writeReport();
                            setOfReports.add(allWriter.getResult());
                            outputFile = new File(outputDirPath + nameForFile + DriveScanTA.getTargetCloud(targetServer) + ".analyze" + outputType.getExtension());
                            this.setReturnCode(ReportUtility.writeOutStream(outputFile, allWriter.getResult()));
                        }
                        allWriter = new JSONEvaluationReportWriter(_data.getProjectNames(), listOfTechSummaries, _data.getSpecifiedProducts(), _data.getEvalReportOptions(false), brr._descriptionsForNonTechRulesFlagged);
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".eval" + outputType.getExtension());
                        this.setReturnCode(ReportUtility.writeOutStream(outputFile, allWriter.getResult()));
                        allWriter = new JSONInventoryReportWriter(ai, _data.getProjectNames(), sharedLibProjectNames, _data.getScanOptions());
                        allWriter.writeReport();
                        outputFile = new File(outputDirPath + nameForFile + ".inventory" + outputType.getExtension());
                        this.setReturnCode(ReportUtility.writeOutStream(outputFile, allWriter.getResult()));
                        break;
                    }
                }
            }
            _data.setTargetJava(originalTargetJava);
            _data.setTargetAppServer(originalTargetAppServer);
        }
        return resultMap;
    }

    public void generateAssessmentUnit(String outputDirPath, String collectionUnitName, String appName, String libraryName, String profileName, String checksum, boolean outsideScan) throws UnknownHostException {
        String hostname = InetAddress.getLocalHost().getCanonicalHostName();
        String sourceServerName = _data.getSourceAppServer().name();
        String archiveType = DriveScanTA.getArchiveType(sourceServerName);
        String middleware = DriveScanTA.getMiddleware(sourceServerName);
        String domain = null;
        if (libraryName != null) {
            archiveType = "sharedLibrary";
            domain = "java";
        } else {
            domain = "javaAppServer";
        }
        String version = "25.0.0.2";
        AssessmentUnitWriter assUnit = new AssessmentUnitWriter(domain, middleware, version, hostname, appName, appName, archiveType, collectionUnitName, libraryName, profileName, checksum, outsideScan);
        String outputDir = outputDirPath + collectionUnitName;
        assUnit.writeToJsonFile(outputDir);
    }

    public static String getTargetCloud(ReportInputData.AppServer targetServer) {
        String targetCloud = targetServer == ReportInputData.AppServer.LIBERTY ? ".ICp_Liberty.WebSphereLiberty" : (targetServer == ReportInputData.AppServer.MANAGED_LIBERTY ? ".ManagedLiberty" : (targetServer == ReportInputData.AppServer.OPEN_LIBERTY ? ".ICp_Liberty" : (targetServer == ReportInputData.AppServer.EASE ? ".EASe" : ".WASaaS")));
        return targetCloud;
    }

    public static void clean(Map<File, String> mapOfAppsToProfiles, String outputDirPath, List<File> apps, File binaryLocation, List<String> includeApplications, List<String> excludeApplications, Set<String> fileExtensions, TreeMap<String, WebsphereProfile> sharedLibraryProfiles) {
        String environmentJsonPath = "environment.json";
        String scanStatusJsonPath = "scan_status.json";
        String scanResultsJsonPath = "scan_results.json";
        for (File app : apps) {
            String collectionUnitZipName;
            Object collectionUnitZip;
            File collectionUnit;
            String collectionUnitName = DriveScanTA.getCollectionUnitName(app, mapOfAppsToProfiles, binaryLocation);
            if (!outputDirPath.isEmpty()) {
                collectionUnitName = outputDirPath + collectionUnitName;
            }
            if ((collectionUnit = new File(collectionUnitName)).exists() && collectionUnit.isDirectory()) {
                File[] collectionUnitFiles;
                File[] fileArray = collectionUnitFiles = collectionUnit.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File collectionUnitFile = fileArray[i];
                    if (collectionUnitFile.isDirectory() || !DriveScanTA.isFileIncluded(collectionUnitFile.getAbsolutePath(), includeApplications, excludeApplications, fileExtensions)) continue;
                    collectionUnitFile.delete();
                }
                if (collectionUnit.listFiles().length == 0) {
                    collectionUnit.delete();
                }
            }
            if (!((File)(collectionUnitZip = new File(collectionUnitZipName = collectionUnitName + ".zip"))).exists()) continue;
            ((File)collectionUnitZip).delete();
        }
        for (WebsphereProfile sharedLibraryProfile : sharedLibraryProfiles.values()) {
            String sharedLibCollectionUnitZipName;
            File sharedLibCollectionUnitZip;
            File sharedLibCollectionUnit;
            String sharedLibCollectionUnitName = sharedLibraryProfile.getName();
            if (!outputDirPath.isEmpty()) {
                sharedLibCollectionUnitName = outputDirPath + sharedLibCollectionUnitName;
            }
            if ((sharedLibCollectionUnit = new File(sharedLibCollectionUnitName)).exists() && sharedLibCollectionUnit.isDirectory()) {
                File[] sharedLibCollectionUnitFiles = sharedLibCollectionUnit.listFiles();
                for (File sharedLibCollectionUnitFile : sharedLibCollectionUnitFiles) {
                    if (sharedLibCollectionUnitFile.isDirectory() || !DriveScanTA.isFileIncluded(sharedLibCollectionUnitFile.getAbsolutePath(), null, null, fileExtensions)) continue;
                    sharedLibCollectionUnitFile.delete();
                }
                String sharedLibEnvironmentJSONPath = sharedLibCollectionUnitName + File.separator + environmentJsonPath;
                File sharedLibEnvironmentJSON = new File(sharedLibEnvironmentJSONPath);
                if (sharedLibEnvironmentJSON.exists()) {
                    sharedLibEnvironmentJSON.delete();
                }
                if (sharedLibCollectionUnit.listFiles().length == 0) {
                    sharedLibCollectionUnit.delete();
                }
            }
            if (!(sharedLibCollectionUnitZip = new File(sharedLibCollectionUnitZipName = sharedLibCollectionUnitName + ".zip")).exists()) continue;
            sharedLibCollectionUnitZip.delete();
        }
        if (!outputDirPath.isEmpty()) {
            environmentJsonPath = outputDirPath + environmentJsonPath;
            scanStatusJsonPath = outputDirPath + scanStatusJsonPath;
            scanResultsJsonPath = outputDirPath + scanResultsJsonPath;
        }
        File environmentJson = new File(environmentJsonPath);
        File scanStatusJson = new File(scanStatusJsonPath);
        File scanResultsJson = new File(scanResultsJsonPath);
        if (environmentJson.exists()) {
            environmentJson.delete();
        }
        if (scanStatusJson.exists()) {
            scanStatusJson.delete();
        }
        if (scanResultsJson.exists()) {
            scanResultsJson.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zipDir(String collectionUnitName, String outputDirPath, boolean envJson, List<String> includeApplications, List<String> excludeApplications, Set<String> fileExtensions) {
        String string;
        FileOutputStream fos;
        block19: {
            fos = null;
            ZipOutputStream zipOut = null;
            String collectionUnitPath = null;
            try {
                File traceFile;
                String collectionUnitDirPath = outputDirPath + collectionUnitName;
                String envJsonName = "environment.json";
                String envJsonPath = outputDirPath + envJsonName;
                String traceName = "trace_" + ReportUtility.getTimestamp() + ".log";
                String tracePath = "logs" + File.separator + traceName;
                String zipTimestamp = "";
                if (includeApplications == null && excludeApplications == null) {
                    collectionUnitPath = collectionUnitDirPath + ".zip";
                } else {
                    zipTimestamp = String.valueOf(System.nanoTime());
                    collectionUnitPath = collectionUnitDirPath + "_" + zipTimestamp + ".zip";
                }
                this.result.addCollectionFileName(new File(collectionUnitPath).getName());
                fos = new FileOutputStream(collectionUnitPath);
                zipOut = new ZipOutputStream(fos);
                File collectionUnitDir = new File(collectionUnitDirPath);
                ArrayList<File> filesToZip = new ArrayList<File>(Arrays.asList(collectionUnitDir.listFiles()));
                File envJsonFile = new File(envJsonPath);
                if (envJsonFile.exists() && envJson) {
                    filesToZip.add(envJsonFile);
                }
                if ((traceFile = new File(tracePath)).exists()) {
                    filesToZip.add(traceFile);
                }
                for (File file : filesToZip) {
                    FileInputStream fis = null;
                    try {
                        int length;
                        fis = new FileInputStream(file);
                        String fileName = file.getName();
                        if (!fileName.equals(traceName) && !fileName.equals(envJsonName) && !DriveScanTA.isFileIncluded(fileName, includeApplications, excludeApplications, fileExtensions)) continue;
                        ZipEntry zipEntry = new ZipEntry(fileName);
                        zipOut.putNextEntry(zipEntry);
                        byte[] bytes = new byte[1024];
                        while ((length = fis.read(bytes)) >= 0) {
                            zipOut.write(bytes, 0, length);
                        }
                    }
                    finally {
                        if (fis == null) continue;
                        fis.close();
                    }
                }
                if (zipTimestamp.isEmpty()) {
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Zip"), collectionUnitName));
                } else {
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Zip"), collectionUnitName + "_" + zipTimestamp));
                }
                string = collectionUnitPath;
                if (zipOut == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (zipOut != null) {
                        zipOut.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Zip_Error"), collectionUnitName));
                    this.setReturnCode(2);
                    return null;
                }
            }
            zipOut.close();
        }
        if (fos != null) {
            fos.close();
        }
        return string;
    }

    public static String getCollectionUnitName(File app, Map<File, String> mapOfAppsToProfiles, File binaryLocation) {
        String collectionUnitName = "";
        if (mapOfAppsToProfiles != null && !mapOfAppsToProfiles.isEmpty()) {
            collectionUnitName = mapOfAppsToProfiles.get(app);
        } else if (binaryLocation.isDirectory()) {
            collectionUnitName = binaryLocation.getName();
        } else {
            collectionUnitName = app.getName();
            if (collectionUnitName.contains(".")) {
                collectionUnitName = collectionUnitName.substring(0, collectionUnitName.lastIndexOf("."));
            }
        }
        return collectionUnitName;
    }

    public static boolean isFileIncluded(String fileName, List<String> includeApplications, List<String> excludeApplications, Set<String> fileExtensions) {
        boolean isFileIncluded = false;
        String appName = "";
        String appNameWithoutExtension = "";
        if (fileName.endsWith("mime-types" + ReportInputData.OutputType.XML.getExtension())) {
            return true;
        }
        for (String fileExtension : fileExtensions) {
            if (!fileName.endsWith(fileExtension)) continue;
            appName = fileName.substring(0, fileName.lastIndexOf(fileExtension));
            if (appName.contains(File.separator)) {
                appName = appName.substring(appName.lastIndexOf(File.separator) + 1);
            }
            appNameWithoutExtension = appName.substring(0, appName.lastIndexOf("."));
            break;
        }
        if (!appName.isEmpty()) {
            if (includeApplications != null) {
                if (includeApplications.contains(appName) || includeApplications.contains(appNameWithoutExtension)) {
                    isFileIncluded = true;
                }
            } else if (excludeApplications != null) {
                if (!excludeApplications.contains(appName) && !excludeApplications.contains(appNameWithoutExtension)) {
                    isFileIncluded = true;
                }
            } else {
                isFileIncluded = true;
            }
        }
        return isFileIncluded;
    }

    public static void cliFinishedWithErrors(int severeCount, int warningCount) {
        if (severeCount > 0 && warningCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done", null, "ta.dc.collect.done.errors", new String[]{String.valueOf(severeCount)}, " ", null);
        } else if (severeCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done", null, "ta.dc.collect.done.severe", new String[]{String.valueOf(severeCount)}, " ", null);
        } else if (warningCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done", null, "ta.dc.collect.done.warning", null, " ", null);
        }
    }

    public static void cliFinishedWithFailedReports(int severeCount, int warningCount) {
        if (severeCount > 0 && warningCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done.report.failed", null, "ta.dc.collect.done.errors", new String[]{String.valueOf(severeCount)}, " ", null);
        } else if (severeCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done.report.failed", null, "ta.dc.collect.done.severe", new String[]{String.valueOf(severeCount)}, " ", null);
        } else if (warningCount > 0) {
            cli.updateCurrentOperationEventWithArgs("ta.dc.collect.done.report.failed", null, "ta.dc.collect.done.warning", null, " ", null);
        }
    }

    public static void cliFinishedWithMessage(String message) {
        cli.updateCurrentOperationEvent(message, "", "");
    }

    public static Set<String> createFileExtensionSet() {
        HashSet<String> fileExtensions = new HashSet<String>();
        fileExtensions.add("_server" + ReportInputData.OutputType.PY.getExtension());
        fileExtensions.add("_server" + ReportInputData.OutputType.XML.getExtension());
        fileExtensions.add(".assessmentUnit" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(".eval" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(".eval" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.OPEN_LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.OPEN_LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.EASE) + ".analyze" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.EASE) + ".analyze" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.MANAGED_LIBERTY) + ".analyze" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(DriveScanTA.getTargetCloud(ReportInputData.AppServer.MANAGED_LIBERTY) + ".analyze" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(".inventory" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(".inventory" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(".WASaaS.analyze" + ReportInputData.OutputType.HTML.getExtension());
        fileExtensions.add(".WASaaS.analyze" + ReportInputData.OutputType.JSON.getExtension());
        fileExtensions.add(".WebSphereLiberty_server" + ReportInputData.OutputType.XML.getExtension());
        fileExtensions.add(".ManagedLiberty_server" + ReportInputData.OutputType.XML.getExtension());
        fileExtensions.add(".EASe_server" + ReportInputData.OutputType.XML.getExtension());
        fileExtensions.add("_jvm.options");
        return fileExtensions;
    }

    public void addJarsToSharedLibs(List<File> jars, File binaryLocation) {
        String sourceServerVersion = _data.getSourceAppServer().name().toLowerCase();
        String version = "25.0.0.2";
        String middleware = DriveScanTA.getMiddleware(sourceServerVersion);
        String hostname = DriveScanTA.getHostname();
        String profilePath = DriveScanTA.getRealFilePath(binaryLocation);
        String sharedLibProfileName = null;
        if (binaryLocation.isDirectory()) {
            sharedLibProfileName = binaryLocation.getName() + "-CommonCode";
        } else {
            sharedLibProfileName = binaryLocation.getName();
            if (sharedLibProfileName.contains(".")) {
                sharedLibProfileName = sharedLibProfileName.substring(0, sharedLibProfileName.lastIndexOf("."));
            }
        }
        TreeSet<String> assessUnitNames = new TreeSet<String>();
        ArchiveInfo archiveInfo = new ArchiveInfo("java", sharedLibProfileName, "sharedLibrary", version, middleware, hostname, assessUnitNames);
        WebsphereProfile sharedLibProfile = new WebsphereProfile(sharedLibProfileName, profilePath, assessUnitNames, archiveInfo, sharedLibProfileName, false, false);
        for (File jar : jars) {
            sharedLibProfile.addApp(jar, true, true);
        }
        this._sharedLibraryProfiles.put(profilePath, sharedLibProfile);
    }

    public static String getMiddleware(String sourceServerName) {
        String middleware = "was";
        if (sourceServerName.equals("was")) {
            middleware = "was";
        } else if (sourceServerName.equals("weblogic")) {
            middleware = "weblogic";
        } else if (sourceServerName.equals("jboss")) {
            middleware = "jboss";
        } else if (sourceServerName.equals("tomcat")) {
            middleware = "tomcat";
        }
        return middleware;
    }

    public static String getArchiveType(String sourceServerName) {
        String archiveType = "profile";
        if (sourceServerName.equals("was")) {
            archiveType = "profile";
        } else if (sourceServerName.equals("weblogic")) {
            archiveType = "domain";
        } else if (sourceServerName.equals("jboss")) {
            archiveType = "domain";
        } else if (sourceServerName.equals("tomcat")) {
            archiveType = "instance";
        }
        return archiveType;
    }

    public static String getHostname() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            ReportUtility.logger.get().log(Level.FINE, "Hostname could not be detected.", e);
        }
        return hostname;
    }

    public void addDefaultProductInfs() {
        String sourceServerVersion = _data.getSourceAppServer().name().toLowerCase();
        String sourceServerName = _data.getSourceAppServer().isWAS_Traditional() ? "websphere" : sourceServerVersion;
        String version = _data.getSourceAppServer().isWAS_Traditional() ? _data.getSourceAppServer().getWasVersion() : sourceServerVersion;
        this.productInfs.add(new ProductInf(sourceServerName, "BASE", version, "", ""));
        this.productInfs.add(new ProductInf("Java", "Java", "1." + _data.getSourceJava().getVersionNumber(), "", ""));
    }

    public static List<File> separateJars(List<File> apps) {
        ArrayList<File> jars = new ArrayList<File>();
        Iterator<File> i = apps.iterator();
        while (i.hasNext()) {
            File app = i.next();
            String appName = app.getName();
            if (!appName.endsWith(".jar")) continue;
            jars.add(app);
            i.remove();
        }
        return jars;
    }
}

