/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.generator.DeployedCluster;
import com.ibm.ws.report.binary.configutility.generator.DeployedServer;
import com.ibm.ws.report.binary.configutility.generator.DeploymentEnvironment;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.binary.utilities.RuleHelper;
import com.ibm.ws.report.inventory.AppPackage;
import com.ibm.ws.report.inventory.ApplicationClientJar;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.inventory.EJBJar;
import com.ibm.ws.report.inventory.Ear;
import com.ibm.ws.report.inventory.Rar;
import com.ibm.ws.report.inventory.UtilityJar;
import com.ibm.ws.report.inventory.War;
import com.ibm.ws.report.inventory.WebFragment;
import com.ibm.ws.report.inventory.qos.QosClusterTarget;
import com.ibm.ws.report.inventory.qos.QosDeploymentTargets;
import com.ibm.ws.report.inventory.qos.QosServerTarget;
import com.ibm.ws.report.inventory.qos.QosSessionPersistenceType;
import com.ibm.ws.report.inventory.qos.QosTransactionLogType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLInventoryReportWriter;
import com.ibm.ws.report.writer.json.JSONInventoryReportWriter;
import com.ibm.ws.report.writer.text.TextInventoryReportWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DriveScanInventory
extends DriveScan {
    public DriveScanInventory(ReportInputData data) {
        super(data);
    }

    @Override
    public String getDefaultReportName() {
        return "InventoryReport";
    }

    @Override
    public BinaryReportReader getBinaryReportReader() {
        return this.getBinaryReportReader(null);
    }

    public BinaryReportReader getBinaryReportReader(Set<String> appsUsingSessions) {
        Map<String, Rule> myrules = this.getRules();
        if (myrules != null && !myrules.isEmpty()) {
            HashMap<ReportInputData.ReportType, Collection<Rule>> rules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
            rules.put(ReportInputData.ReportType.INVENTORY, myrules.values());
            this._reader = new BinaryReportReader(_data, rules, null, null, appsUsingSessions);
        }
        return this._reader;
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            this._builder = ReportBuilderHelper.loadInventoryRules();
            if (this._builder._foundInvalidRule) {
                return null;
            }
            this._rules = this._builder._reportRules;
        }
        return this._rules;
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        EnumMap<ReportInputData.OutputType, String> resultMap = new EnumMap<ReportInputData.OutputType, String>(ReportInputData.OutputType.class);
        List<String> uniqueProjectNames = _data.getProjectNames();
        List<File> apps = _data.getProjectFiles();
        HashSet<String> appsUsingSessions = new HashSet<String>();
        HashMap<String, TargetConfig> mapOfAppToTargetConfig = new HashMap<String, TargetConfig>();
        for (File file : apps) {
            ConfigManager configMgr = this.getConfigManager(file);
            LibertyServerXml appConfig = null;
            String appName = file.getName();
            if (configMgr == null) continue;
            try {
                appConfig = new LibertyServerXml(configMgr, appName, null, false);
                mapOfAppToTargetConfig.put(appName, appConfig);
                this.detectSharedLibraries(appConfig, configMgr.getProfileDir());
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Iventory_App_Config_Not_Created"), file.getAbsolutePath()), e);
                    continue;
                }
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Iventory_App_Config_Not_Created"), file.getAbsolutePath(), e.getMessage()));
            }
        }
        ArrayList<String> sharedLibProjectNames = new ArrayList<String>();
        if (_data.hasSharedLibraries()) {
            for (File projectFile : _data.getSharedLibraryFiles()) {
                sharedLibProjectNames.add(DriveScanInventory.getFileName(projectFile));
            }
        }
        Collections.sort(sharedLibProjectNames);
        BinaryReportReader binaryReportReader = this.getBinaryReportReader(appsUsingSessions);
        if (binaryReportReader != null) {
            binaryReportReader.openFile();
            Map<String, List<DetailResult>> projectsToRulesFound = binaryReportReader.getProjectsToDetailResults(ReportInputData.ReportType.INVENTORY);
            Map<String, String> checksumMap = binaryReportReader.getChecksumMap();
            binaryReportReader.closeFile();
            ArchiveInventory ai = DriveScanInventory.createArchiveInventory(projectsToRulesFound, sharedLibProjectNames, mapOfAppToTargetConfig, appsUsingSessions, checksumMap);
            ReportWriter writer = null;
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        writer = new HTMLInventoryReportWriter(ai, uniqueProjectNames, sharedLibProjectNames, _data.getScanOptionsDisplay());
                        break;
                    }
                    case JSON: {
                        writer = new JSONInventoryReportWriter(ai, uniqueProjectNames, sharedLibProjectNames, _data.getScanOptions());
                        break;
                    }
                    case TEXT: {
                        writer = new TextInventoryReportWriter(ai, uniqueProjectNames, sharedLibProjectNames);
                    }
                }
                writer.writeReport();
                resultMap.put(outputType, writer.getResult());
            }
        }
        return resultMap;
    }

    public static ArchiveInventory createArchiveInventory(Map<String, List<DetailResult>> projectsToRulesFound, List<String> sharedLibProjectNames, Map<String, TargetConfig> mapOfAppToTargetConfig, Set<String> appsUsingSessions, Map<String, String> checksumMap) {
        HashMap<String, Archive> allArchives = new HashMap<String, Archive>();
        ArchiveInventory ai = new ArchiveInventory();
        Set<String> archiveNames = projectsToRulesFound.keySet();
        for (String nextArchiveName : archiveNames) {
            String archiveName;
            TargetConfig targetConfig;
            File archiveFile;
            String dirPath = "";
            dirPath = _data.isGenerateTA() ? nextArchiveName.substring(0, nextArchiveName.lastIndexOf("/")) : _data.getProjectDirPathNormalized(nextArchiveName);
            List<DetailResult> resultsForArchive = projectsToRulesFound.get(nextArchiveName);
            Archive nextArchive = DriveScanInventory.createArchive(allArchives, nextArchiveName);
            if (nextArchive == null) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Archive_Found"), nextArchiveName));
                continue;
            }
            String fullFileName = nextArchive.getFullName();
            String checksum = checksumMap.get(fullFileName);
            if (checksum != null) {
                nextArchive.setChecksum(checksum);
            }
            if (!(archiveFile = new File(fullFileName)).exists()) {
                String uppercaseExt = fullFileName.substring(fullFileName.length() - 4).toUpperCase();
                String fileName = fullFileName.substring(0, fullFileName.length() - 4) + uppercaseExt;
                nextArchive.setArchiveSize(new File(fileName).length());
            } else {
                nextArchive.setArchiveSize(archiveFile.length());
            }
            if (!mapOfAppToTargetConfig.isEmpty() && (targetConfig = mapOfAppToTargetConfig.get(archiveName = nextArchive.getName())) != null) {
                DeploymentEnvironment deploymentEnvironment = targetConfig.getDeploymentEnvironment();
                boolean usesSessions = appsUsingSessions.contains(archiveName) || archiveNames.size() == 1 && !appsUsingSessions.isEmpty();
                targetConfig.setApplicationIsUsingSessions(usesSessions);
                if (deploymentEnvironment != null) {
                    ArrayList<QosClusterTarget> deployedClusters = new ArrayList<QosClusterTarget>();
                    ArrayList<QosServerTarget> deployedServers = new ArrayList<QosServerTarget>();
                    for (DeployedCluster cluster : deploymentEnvironment.getDeployedClusters()) {
                        String clusterName = cluster.getClusterName();
                        String xmiId = cluster.getClusterXmiId();
                        QosSessionPersistenceType sessionReplication = cluster.getClusterSessionPersistenceType();
                        QosTransactionLogType transactionLog = cluster.getClusterTransactionLogType();
                        ArrayList<QosServerTarget> clusterMembers = new ArrayList<QosServerTarget>();
                        for (DeployedServer server : cluster.getServerMembers()) {
                            clusterMembers.add(new QosServerTarget(server.getServerName(), server.getNodeName(), server.getServerType()));
                        }
                        if (cluster.isDynamicCluster()) {
                            deployedClusters.add(new QosClusterTarget(clusterName, xmiId, clusterMembers, sessionReplication, transactionLog, true, cluster.getMinInstances(), cluster.getMaxInstances(), String.valueOf(cluster.getEffectiveMinInstances()), String.valueOf(cluster.getEffectiveMaxInstances()), cluster.isConfigDefault()));
                            continue;
                        }
                        deployedClusters.add(new QosClusterTarget(clusterName, xmiId, clusterMembers, sessionReplication, transactionLog, cluster.isConfigDefault()));
                    }
                    for (DeployedServer server : deploymentEnvironment.getDeployedServers()) {
                        deployedServers.add(new QosServerTarget(server.getServerName(), server.getNodeName(), server.getServerType()));
                    }
                    nextArchive.setQoSVariables(deploymentEnvironment.getCellAdminWASEdition(), deploymentEnvironment.getCellAdminWASVersion(), deploymentEnvironment.getCellAdminHost(), deploymentEnvironment.getCellAdminPort(), deploymentEnvironment.getCellName(), deploymentEnvironment.isCellZos(), new QosDeploymentTargets(deployedClusters, deployedServers), deploymentEnvironment.getRecommendedNumberOfReplicas(), deploymentEnvironment.getRecommendedMinimumNumberOfReplicas(), deploymentEnvironment.getRecommendedMaximumNumberOfReplicas());
                }
            }
            for (String sharedLib : sharedLibProjectNames) {
                ai.putSharedLibChecksum(sharedLib, checksumMap.get(sharedLib));
            }
            DriveScanInventory.addResultsToArchive(allArchives, dirPath, nextArchiveName, nextArchive, resultsForArchive, sharedLibProjectNames, checksumMap);
            ai.put(nextArchive);
        }
        return ai;
    }

    private static String getFileName(DetailResult nextResult, String dirPath) {
        String nextFile = nextResult.getFileName();
        if (nextFile.matches("^(?=[A-Z]:\\/|\\/).*")) {
            return nextFile;
        }
        return dirPath + "/" + nextResult.getFileName();
    }

    /*
     * WARNING - void declaration
     */
    public static void addResultsToArchive(Map<String, Archive> allArchives, String dirPath, String archiveName, Archive appArchive, List<DetailResult> results, List<String> sharedLibProjects, Map<String, String> checksumMap) {
        List<DetailResult> list;
        Archive targetArchive;
        List<DetailResult> list2;
        List<DetailResult> warsWithAnnotations;
        List<DetailResult> jarsWithAnnotations;
        List<DetailResult> utilityJARsWithAnnotations;
        List<DetailResult> resultUtilityJarPackages;
        Map<String, List<DetailResult>> resultsByRule = DriveScanInventory.getResultsByRule(results);
        HashMap<String, Set<Archive>> orphanArchives = new HashMap<String, Set<Archive>>();
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.WAR, resultsByRule.get("CountWarFiles"), results);
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.RAR, resultsByRule.get("CountRarFiles"), results);
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.APP_CLIENT_JAR, resultsByRule.get("CountApplicationClients"), results);
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.EJB_JAR, resultsByRule.get("CountEJBJarFiles"), results);
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.WEB_FRAGMENT_JAR, resultsByRule.get("CountWebFragmentFiles"), results);
        DriveScanInventory.createContainedArchives(allArchives, orphanArchives, dirPath, archiveName, appArchive, ArchiveInventory.ArchiveTypes.UTILITY_JAR, resultsByRule.get("CountUtilityJarFiles"), results);
        if (!orphanArchives.isEmpty()) {
            for (Object orphan : orphanArchives.keySet()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive"), orphan));
            }
        }
        if ((resultUtilityJarPackages = resultsByRule.get("CountUtilityJarPackages")) != null) {
            for (DetailResult nextResult : resultUtilityJarPackages) {
                void var13_13;
                String string;
                String fileName = DriveScanInventory.getFileName(nextResult, dirPath);
                String string2 = ReportUtility.getLastArchiveFileName(fileName);
                if (!allArchives.containsKey(string2) && string2.endsWith(".jar") && (string = string2.substring(0, string2.indexOf(".jar") + 4)).length() < string2.length()) {
                    String string3 = string;
                }
                if (allArchives.containsKey(var13_13)) {
                    Archive archive = allArchives.get(var13_13);
                    if (archive.getArchiveType() != ArchiveInventory.ArchiveTypes.UTILITY_JAR) continue;
                    UtilityJar utilityJar = (UtilityJar)archive;
                    String string4 = nextResult.getCriteria();
                    String[] stringArray = RuleHelper.splitArgs(string4);
                    utilityJar.addPackages(stringArray);
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Found"), nextResult.getRuleDesc(), var13_13));
            }
            results.removeAll(resultUtilityJarPackages);
        }
        if ((utilityJARsWithAnnotations = resultsByRule.get("DetectUtiltyJARsWithAnnotations")) != null) {
            results.removeAll(utilityJARsWithAnnotations);
        }
        if ((jarsWithAnnotations = resultsByRule.get("DetectJARsWithAnnotations")) != null) {
            for (DetailResult detailResult : jarsWithAnnotations) {
                String string = DriveScanInventory.getFileName(detailResult, dirPath);
                if (!allArchives.containsKey(string)) continue;
                Archive archive = allArchives.get(string);
                archive.setHasAnnotations(detailResult);
            }
            results.removeAll(jarsWithAnnotations);
        }
        if ((warsWithAnnotations = resultsByRule.get("DetectWARsWithAnnotations")) != null) {
            for (DetailResult detailResult : warsWithAnnotations) {
                String string = DriveScanInventory.getFileName(detailResult, dirPath);
                if (!allArchives.containsKey(string)) continue;
                Archive archive = allArchives.get(string);
                archive.setHasAnnotations(detailResult);
            }
            results.removeAll(warsWithAnnotations);
        }
        if ((list2 = resultsByRule.get("DetectJavaEEVersion")) != null) {
            for (DetailResult detailResult : list2) {
                String string = DriveScanInventory.getFileName(detailResult, dirPath);
                String string5 = ReportUtility.getLastArchiveFileName(string);
                if (allArchives.containsKey(string5)) {
                    targetArchive = allArchives.get(string5);
                    if (!targetArchive.getArchiveType().isCorrectDescriptor(string)) continue;
                    String javaEEVersion = detailResult.getCriteria();
                    int indexOfEquals = javaEEVersion.indexOf(61);
                    if (indexOfEquals != -1) {
                        javaEEVersion = javaEEVersion.substring(indexOfEquals + 1);
                    } else {
                        int indexOfDotDtd = javaEEVersion.indexOf(".dtd");
                        javaEEVersion = javaEEVersion.substring(indexOfDotDtd - 3, indexOfDotDtd);
                        javaEEVersion = javaEEVersion.replace("_", ".");
                    }
                    if (javaEEVersion == null || javaEEVersion.isEmpty()) continue;
                    targetArchive.setVersion(javaEEVersion);
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Found"), detailResult.getRuleDesc(), string5));
            }
            results.removeAll(list2);
        }
        if ((list = resultsByRule.get("DetectSpringVersion")) != null) {
            for (DetailResult detailResult : list) {
                String string = DriveScanInventory.getFileName(detailResult, dirPath);
                String lastArchiveName = ReportUtility.getLastArchiveFileName(string);
                if (allArchives.containsKey(lastArchiveName)) {
                    Archive targetSchemaArchive = allArchives.get(lastArchiveName);
                    String springVersion = detailResult.getCriteria();
                    if (springVersion.contains("Implementation-Version")) {
                        int indexOfEquals = springVersion.indexOf(61);
                        springVersion = springVersion.substring(indexOfEquals + 1);
                        Archive targetManifestArchive = allArchives.get(ReportUtility.getLastPreviousArchivePath(lastArchiveName));
                        if (targetManifestArchive == null) {
                            if (!sharedLibProjects.isEmpty()) {
                                targetManifestArchive = allArchives.get(archiveName);
                            } else {
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_File_Unresolved"), lastArchiveName));
                            }
                        }
                        targetManifestArchive.addSpringManifestVersion(springVersion);
                        continue;
                    }
                    String[] versionArr = springVersion.split("spring-beans-");
                    if (versionArr.length <= 1) continue;
                    Matcher m = Pattern.compile("\\d+").matcher(versionArr[1]);
                    StringBuilder versionStringBuilder = new StringBuilder();
                    boolean matchFound = m.find();
                    if (!matchFound) continue;
                    String firstVersionNumber = m.group();
                    matchFound = m.find();
                    if (!matchFound) continue;
                    versionStringBuilder.append(firstVersionNumber);
                    versionStringBuilder.append('.');
                    versionStringBuilder.append(m.group());
                    targetSchemaArchive.addSpringSchemaVersion(versionStringBuilder.toString());
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Found"), detailResult.getRuleDesc(), lastArchiveName));
            }
            results.removeAll(list);
        }
        DriveScanInventory.excessFileResults(allArchives, Archive.ExcessFileType.EXCESS_CLASS, resultsByRule, dirPath, results);
        DriveScanInventory.excessFileResults(allArchives, Archive.ExcessFileType.EXCESS_WEB_MODULE_RESOURCE, resultsByRule, dirPath, results);
        Set<String> set = allArchives.keySet();
        for (String string : set) {
            File archiveFile;
            String fullFileName;
            String checksum;
            targetArchive = allArchives.get(string);
            if (targetArchive.getVersion() != null) {
                try {
                    double versionNum = Double.parseDouble(targetArchive.getVersion());
                    switch (targetArchive.getArchiveType()) {
                        case APP_CLIENT_JAR: {
                            if (!(versionNum < 5.0)) break;
                            targetArchive.setMetadataComplete("true");
                            break;
                        }
                        case EJB_JAR: {
                            if (targetArchive.getFullName().contains("WEB-INF/lib")) {
                                targetArchive.setMetadataComplete("ignored");
                                break;
                            }
                            if (!(versionNum < 3.0)) break;
                            targetArchive.setMetadataComplete("true");
                            break;
                        }
                        case RAR: {
                            if (!(versionNum < 1.6)) break;
                            targetArchive.setMetadataComplete("true");
                            break;
                        }
                        case WAR: {
                            if (!(versionNum < 2.5)) break;
                            targetArchive.setMetadataComplete("true");
                            break;
                        }
                    }
                }
                catch (NumberFormatException versionNum) {
                    // empty catch block
                }
            }
            if ((checksum = checksumMap.get(fullFileName = targetArchive.getFullName())) != null) {
                targetArchive.setChecksum(checksum);
            }
            if (!(archiveFile = new File(fullFileName)).exists()) {
                String uppercaseExt = fullFileName.substring(fullFileName.length() - 4).toUpperCase();
                String fileName = fullFileName.substring(0, fullFileName.length() - 4) + uppercaseExt;
                long size = new File(fileName).length();
                targetArchive.setArchiveSize(size);
                continue;
            }
            targetArchive.setArchiveSize(archiveFile.length());
        }
        List<DetailResult> list3 = resultsByRule.get("DetectMetaDataComplete");
        if (list3 != null) {
            for (DetailResult nextResult : list3) {
                String metadataComplete;
                Archive targetArchive5;
                String metadataForTargetArchive;
                String fileName = DriveScanInventory.getFileName(nextResult, dirPath);
                String lastArchiveName = ReportUtility.getLastArchiveFileName(fileName);
                if (!allArchives.containsKey(lastArchiveName) || (metadataForTargetArchive = (targetArchive5 = allArchives.get(lastArchiveName)).getMetadataComplete()) != null && metadataForTargetArchive.equals("ignored") || !(metadataComplete = nextResult.getCriteria()).contains("=")) continue;
                if (fileName.contains("WEB-INF/ejb-jar.xml")) {
                    targetArchive5.setEjbJarMetadataComplete(metadataComplete.substring(metadataComplete.indexOf(61) + 1));
                    targetArchive5.setEjbJarXmlFound(true);
                    continue;
                }
                targetArchive5.setMetadataComplete(metadataComplete.substring(metadataComplete.indexOf(61) + 1));
            }
            results.removeAll(list3);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String reg = "(?<=" + dirPath + ").*(?=" + appArchive.getName() + ")";
        Pattern p = Pattern.compile(reg);
        String subDir = "";
        for (String archivePath : allArchives.keySet()) {
            if (sharedLibProjects.contains(archivePath)) continue;
            Matcher m = p.matcher(archivePath);
            if (m.find()) {
                subDir = m.group();
            }
            hashMap.put(subDir + ReportUtility.getArchiveNamePath(archivePath, true), archivePath);
        }
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.DUPLICATE_CLASS, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.JAVA_EE_SE_CLASS, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.WAS_CLASS, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.OSS_CLASS, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.MISSING_DEP, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.UNUSED_ARCHIVES, hashMap, appArchive, resultsByRule, results, subDir, checksumMap);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.SHARED_LIB_DEPENDENCIES, hashMap, appArchive, resultsByRule, results, subDir);
        DriveScanInventory.processProblemSectionResults(allArchives, AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES, hashMap, appArchive, resultsByRule, results, subDir);
        appArchive.calculateArchiveCountsPerIssueType();
        appArchive.sortPackages();
        for (DetailResult nextResult : results) {
            String fileName = DriveScanInventory.getFileName(nextResult, dirPath);
            String ruleName = nextResult.getRuleName();
            Archive.Fields targetField = Archive.Fields.getField(ruleName);
            if (targetField != null) {
                String topLevelJar;
                String lastArchiveName = ReportUtility.getLastArchiveFileName(fileName);
                if (!allArchives.containsKey(lastArchiveName) && lastArchiveName.endsWith(".jar") && (topLevelJar = lastArchiveName.substring(0, lastArchiveName.indexOf(".jar") + 4)).length() < lastArchiveName.length()) {
                    lastArchiveName = topLevelJar;
                }
                if (allArchives.containsKey(lastArchiveName)) {
                    Archive targetArchive6 = allArchives.get(lastArchiveName);
                    targetArchive6.incrementField(targetField);
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Found"), nextResult.getRuleDesc(), lastArchiveName));
                continue;
            }
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Result_Found"), nextResult.getRuleDesc(), fileName));
        }
    }

    public static void excessFileResults(Map<String, Archive> allArchives, Archive.ExcessFileType type, Map<String, List<DetailResult>> resultsByRule, String dirPath, List<DetailResult> results) {
        List<DetailResult> archivesWithExcessFiles = resultsByRule.get(type.getRuleName());
        if (archivesWithExcessFiles != null) {
            for (DetailResult nextResult : archivesWithExcessFiles) {
                String fileName = dirPath + "/" + nextResult.getFileName();
                String lastArchiveName = ReportUtility.getLastArchiveFileName(fileName);
                if (!allArchives.containsKey(lastArchiveName)) continue;
                Archive targetArchive = allArchives.get(lastArchiveName);
                targetArchive.setNumExcessFiles(type, nextResult.getCriteria());
            }
            results.removeAll(archivesWithExcessFiles);
        }
    }

    public static void processProblemSectionResults(Map<String, Archive> allArchives, AppPackage.Issue issue, Map<String, String> mapShortArchivePathToFullArchivePath, Archive appArchive, Map<String, List<DetailResult>> resultsByRule, List<DetailResult> results, String subDir) {
        DriveScanInventory.processProblemSectionResults(allArchives, issue, mapShortArchivePathToFullArchivePath, appArchive, resultsByRule, results, subDir, null);
    }

    public static void processProblemSectionResults(Map<String, Archive> allArchives, AppPackage.Issue issue, Map<String, String> mapShortArchivePathToFullArchivePath, Archive appArchive, Map<String, List<DetailResult>> resultsByRule, List<DetailResult> results, String subDir, Map<String, String> checksumMap) {
        List<DetailResult> resultList = resultsByRule.get(issue.getRuleName());
        if (resultList != null) {
            for (DetailResult nextResult : resultList) {
                String archiveName;
                if (AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                    archiveName = ReportUtility.getArchiveNamePath(nextResult.getFileName());
                    DriveScanInventory.updateArchiveIssueCount(allArchives, issue, mapShortArchivePathToFullArchivePath, subDir, archiveName);
                } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    archiveName = ReportUtility.getArchiveNamePath(nextResult.getReference());
                    DriveScanInventory.updateArchiveIssueCount(allArchives, issue, mapShortArchivePathToFullArchivePath, subDir, archiveName);
                } else {
                    String archiveNames = nextResult.getCriteria();
                    for (String archiveName2 : archiveNames.split(",")) {
                        DriveScanInventory.updateArchiveIssueCount(allArchives, issue, mapShortArchivePathToFullArchivePath, subDir, archiveName2);
                    }
                }
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    String criteria = nextResult.getCriteria();
                    String archivePath = criteria;
                    File archiveFile = new File(archivePath);
                    if (!archiveFile.isAbsolute()) {
                        archivePath = mapShortArchivePathToFullArchivePath.get('/' + archivePath);
                    }
                    appArchive.addUnusedArchive(criteria, nextResult.getReference(), checksumMap.get(archivePath));
                    continue;
                }
                if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    appArchive.addSharedLibDependencies(nextResult.getReference(), nextResult.getCriteria());
                    continue;
                }
                if (AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                    archiveName = ReportUtility.getFirstArchiveName(nextResult.getFileName());
                    String classResultLocation = nextResult.getFileName();
                    int archiveNameIndex = classResultLocation.indexOf(archiveName) + archiveName.length() + 1;
                    classResultLocation = classResultLocation.substring(archiveNameIndex);
                    appArchive.addToMapOfSystemProperties(classResultLocation, nextResult.getCriteria());
                    continue;
                }
                DriveScanInventory.addPackage(appArchive, nextResult, issue);
            }
            results.removeAll(resultList);
        }
    }

    private static void updateArchiveIssueCount(Map<String, Archive> allArchives, AppPackage.Issue issue, Map<String, String> mapShortArchivePathToFullArchivePath, String subDir, String archiveName) {
        String fileName = mapShortArchivePathToFullArchivePath.get(subDir + archiveName);
        if (allArchives.containsKey(fileName)) {
            Archive targetArchive = allArchives.get(fileName);
            targetArchive.updateArchiveIssueCount(issue);
        } else if (allArchives.containsKey(archiveName)) {
            Archive targetArchive = allArchives.get(archiveName);
            targetArchive.updateArchiveIssueCount(issue);
        }
    }

    private static void addPackage(Archive appArchive, DetailResult nextResult, AppPackage.Issue issue) {
        String packageName = nextResult.getReference();
        AppPackage pack = appArchive.getPackage(packageName);
        if (pack == null) {
            pack = new AppPackage(packageName);
        }
        if (issue == AppPackage.Issue.OSS_CLASS) {
            pack.setAffectServers(nextResult.getFileName());
        }
        appArchive.addPackage(pack, issue, nextResult.getCriteria());
    }

    public static Archive createArchive(Map<String, Archive> allArchives, String archiveName) {
        Archive thisArchive = null;
        if (archiveName.endsWith(".ear")) {
            thisArchive = new Ear(archiveName);
            allArchives.put(archiveName, thisArchive);
        } else if (archiveName.endsWith(".war")) {
            thisArchive = new War(archiveName);
            allArchives.put(archiveName, thisArchive);
        }
        return thisArchive;
    }

    public static void createContainedArchives(Map<String, Archive> allArchives, Map<String, Set<Archive>> orphanArchives, String dirPath, String archiveName, Archive theArchive, ArchiveInventory.ArchiveTypes type, List<DetailResult> resultsForRule, List<DetailResult> results) {
        Archive thisArchive = null;
        if (resultsForRule != null) {
            for (DetailResult nextArchive : resultsForRule) {
                String nextArchName = nextArchive.getFileName();
                boolean isSharedLib = Constants.MATCH_FULLY_PATHD_DIR_REG.matcher(nextArchName).matches();
                String fileName = DriveScanInventory.getFileName(nextArchive, dirPath);
                if (archiveName.equals(fileName)) continue;
                if (isSharedLib) {
                    thisArchive = new UtilityJar(fileName);
                } else {
                    switch (type) {
                        case EJB_JAR: {
                            thisArchive = new EJBJar(fileName);
                            break;
                        }
                        case UTILITY_JAR: {
                            thisArchive = new UtilityJar(fileName);
                            break;
                        }
                        case APP_CLIENT_JAR: {
                            thisArchive = new ApplicationClientJar(fileName);
                            break;
                        }
                        case RAR: {
                            thisArchive = new Rar(fileName);
                            break;
                        }
                        case WAR: {
                            thisArchive = new War(fileName);
                            break;
                        }
                        case WEB_FRAGMENT_JAR: {
                            thisArchive = new WebFragment(fileName);
                            break;
                        }
                    }
                }
                DriveScanInventory.addOrphanedChildren(orphanArchives, thisArchive, fileName);
                String fileNameLastFolder = fileName.substring(0, fileName.lastIndexOf(47));
                String containingArchiveName = ReportUtility.getLastArchiveFileName(fileNameLastFolder);
                if (containingArchiveName.equals(archiveName)) {
                    try {
                        theArchive.addArchive(thisArchive);
                    }
                    catch (IllegalArgumentException e) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), fileName, theArchive.getFullName()));
                        ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                    }
                } else if (isSharedLib) {
                    if (containingArchiveName.endsWith(".jar")) continue;
                    theArchive.addSharedLibrary(thisArchive);
                } else if (containingArchiveName.startsWith(archiveName)) {
                    Archive containingArchive = null;
                    if (theArchive.containsArchive(containingArchiveName)) {
                        containingArchive = theArchive.getArchive(containingArchiveName);
                        try {
                            containingArchive.addArchive(thisArchive);
                        }
                        catch (IllegalArgumentException e) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), fileName, containingArchiveName));
                            ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                        }
                    } else if (allArchives.containsKey(containingArchiveName)) {
                        containingArchive = allArchives.get(containingArchiveName);
                        try {
                            containingArchive.addArchive(thisArchive);
                        }
                        catch (IllegalArgumentException e) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), fileName, containingArchiveName));
                            ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                        }
                    } else if (containingArchiveName.endsWith(".jar")) {
                        if (orphanArchives.containsKey(containingArchiveName)) {
                            orphanArchives.get(containingArchiveName).add(thisArchive);
                        } else {
                            HashSet<UtilityJar> children = new HashSet<UtilityJar>();
                            children.add((UtilityJar)thisArchive);
                            orphanArchives.put(containingArchiveName, children);
                        }
                    } else {
                        containingArchive = DriveScanInventory.createArchive(allArchives, containingArchiveName);
                        try {
                            theArchive.addArchive(containingArchive);
                        }
                        catch (IllegalArgumentException e) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), fileName, theArchive.getFullName()));
                            ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                        }
                        if (theArchive.containsArchive(containingArchiveName)) {
                            try {
                                containingArchive.addArchive(thisArchive);
                            }
                            catch (IllegalArgumentException e) {
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), fileName, containingArchiveName));
                                ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                            }
                        }
                    }
                }
                allArchives.put(fileName, thisArchive);
            }
            results.removeAll(resultsForRule);
        }
    }

    protected static void addOrphanedChildren(Map<String, Set<Archive>> orphanArchives, Archive thisArchive, String thisArchiveName) {
        if (orphanArchives.containsKey(thisArchiveName)) {
            Set<Archive> children = orphanArchives.get(thisArchiveName);
            for (Archive nextChild : children) {
                try {
                    thisArchive.addArchive(nextChild);
                }
                catch (IllegalArgumentException e) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Unexpected_Inventory_Archive_Invalid"), nextChild.getFullName(), thisArchive.getFullName()));
                    ReportUtility.logger.get().log(Level.FINE, "Exception: ", e);
                }
                DriveScanInventory.addOrphanedChildren(orphanArchives, nextChild, nextChild.getFullName());
            }
            orphanArchives.remove(thisArchiveName);
        }
    }

    protected static Map<String, List<DetailResult>> getResultsByRule(List<DetailResult> results) {
        HashMap<String, List<DetailResult>> resultsByRule = new HashMap<String, List<DetailResult>>();
        for (DetailResult result : results) {
            List<DetailResult> resultsForRule;
            String ruleName = result.getRuleName();
            if (resultsByRule.containsKey(ruleName)) {
                resultsForRule = (List)resultsByRule.get(ruleName);
                resultsForRule.add(result);
                continue;
            }
            resultsForRule = new ArrayList();
            resultsForRule.add(result);
            resultsByRule.put(ruleName, resultsForRule);
        }
        return resultsByRule;
    }
}

