/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import java.util.ArrayList;
import java.util.List;

public class ClassOrPackageOccurrence {
    private String _reference = null;
    private int _catchExceptionOccurrences = 0;
    private int _returnTypeOccurrences = 0;
    private int _throwsExceptionOccurrences = 0;
    private int _parameterOccurrences = 0;
    private int _annotationOccurrences = 0;
    private int _totalOccurrences = 0;
    private List<Integer> _lineNumbers = new ArrayList<Integer>();
    private List<String> _classNamesForParameters = new ArrayList<String>();
    private List<String> _classNamesForAnnotations = new ArrayList<String>();
    private List<String> _classNamesForCatchExceptions = new ArrayList<String>();
    private List<String> _classNamesForReturnTypes = new ArrayList<String>();
    private List<String> _classNamesForThrowsException = new ArrayList<String>();
    private List<String> _classNamesForLines = new ArrayList<String>();

    public ClassOrPackageOccurrence(String reference, int type, int line) {
        this._reference = reference;
        this.addOccurrence(type, line, null);
    }

    public ClassOrPackageOccurrence(String reference, int type, int line, String className) {
        this._reference = reference;
        this.addOccurrence(type, line, className);
    }

    public List<Integer> getLineNumbers() {
        return this._lineNumbers;
    }

    public void addOccurrence(int type, int line, String className) {
        ++this._totalOccurrences;
        this._lineNumbers.add(line);
        List<String> listToAddTo = null;
        switch (type) {
            case 2: {
                ++this._annotationOccurrences;
                listToAddTo = this._classNamesForAnnotations;
                break;
            }
            case 3: {
                ++this._parameterOccurrences;
                listToAddTo = this._classNamesForParameters;
                break;
            }
            case 1: {
                ++this._returnTypeOccurrences;
                listToAddTo = this._classNamesForReturnTypes;
                break;
            }
            case 6: {
                ++this._catchExceptionOccurrences;
                listToAddTo = this._classNamesForCatchExceptions;
                break;
            }
            case 5: {
                ++this._throwsExceptionOccurrences;
                listToAddTo = this._classNamesForThrowsException;
            }
        }
        if (className != null) {
            if (listToAddTo != null) {
                listToAddTo.add(className);
            }
            this._classNamesForLines.add(className);
        }
    }

    public int getTotalOccurrences() {
        return this._totalOccurrences;
    }

    public int getCatchExceptionOccurrences() {
        return this._catchExceptionOccurrences;
    }

    public int getReturnTypeOccurrences() {
        return this._returnTypeOccurrences;
    }

    public int getThrowsExceptionOccurrences() {
        return this._throwsExceptionOccurrences;
    }

    public int getParameterOccurrences() {
        return this._parameterOccurrences;
    }

    public int getAnnotationOccurrences() {
        return this._annotationOccurrences;
    }

    public String getReference() {
        return this._reference;
    }

    public List<String> getCatchExceptionClassNames() {
        return this._classNamesForCatchExceptions;
    }

    public List<String> getReturnTypeClassNames() {
        return this._classNamesForReturnTypes;
    }

    public List<String> getThrowsExceptionClassNames() {
        return this._classNamesForThrowsException;
    }

    public List<String> getParameterClassNames() {
        return this._classNamesForParameters;
    }

    public List<String> getAnnotationClassNames() {
        return this._classNamesForAnnotations;
    }

    public List<String> getLineNumberClassNames() {
        return this._classNamesForLines;
    }
}

