/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerI;
import com.sun.tools.ws.Invoker;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

public class WSImportUtil {
    private static CommonLoggerI log;

    public static void setLogger(CommonLoggerI logger) {
        log = logger;
    }

    public static boolean wsimport_file(String wsdlPath, String wsdlLocation, File destDir, File implDestDir, String packageName) {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("-generateJWS");
            command.add("-target");
            command.add("2.2");
            command.add("-keep");
            command.add("-wsdllocation");
            command.add(wsdlLocation);
            command.add("-d");
            command.add(destDir.getCanonicalPath());
            command.add("-s");
            command.add(implDestDir.getCanonicalPath());
            command.add("-implDestDir");
            command.add(implDestDir.getCanonicalPath());
            if (packageName != null) {
                command.add("-p");
                command.add(packageName);
            }
            command.add(wsdlPath);
            return WSImportUtil.wsimport(command);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
            return false;
        }
    }

    public static boolean wsimport_url(String wsdlURL, File destDir, String packageName) {
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("-generateJWS");
            command.add("-target");
            command.add("2.2");
            command.add("-keep");
            command.add("-wsdllocation");
            command.add(wsdlURL);
            command.add("-d");
            command.add(destDir.getCanonicalPath());
            if (packageName != null) {
                command.add("-p");
                command.add(packageName);
            }
            command.add(wsdlURL);
            return WSImportUtil.wsimport(command);
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage());
            return false;
        }
    }

    private static boolean wsimport(List<String> command) throws IOException {
        try {
            WSImportUtil.java11Support();
            log.info("wsimport command: wsimport " + command.toString().replaceAll("^.|.$|,", ""));
            Method invokeMethod = Invoker.class.getDeclaredMethod("invoke", String.class, String[].class);
            invokeMethod.setAccessible(true);
            Integer returnCode = (Integer)invokeMethod.invoke(null, "com.sun.tools.ws.wscompile.WsimportTool", command.toArray(new String[0]));
            return returnCode == 0;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    private static void java11Support() throws ClassNotFoundException {
        if (WSImportUtil.getMajorJavaVersion() > 8) {
            Class<?> JAXB2 = null;
            Class<?> WebService = null;
            Class<?> Service2 = null;
            try {
                JAXB2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.bind.JAXB");
                WebService = Thread.currentThread().getContextClassLoader().loadClass("javax.jws.WebService");
                Service2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.ws.Service");
            }
            catch (ClassNotFoundException e) {
                log.error("Could not find JAX-WS class dependencies needed to compile on Java 9+.");
                throw e;
            }
            String classpathValue = WSImportUtil.getJarFileOfClass(JAXB2);
            classpathValue = classpathValue + File.pathSeparator + WSImportUtil.getJarFileOfClass(WebService);
            classpathValue = classpathValue + File.pathSeparator + WSImportUtil.getJarFileOfClass(Service2);
            log.info("Detected Java version 9+, adding JAX-WS dependencies to java.class.path");
            String javaClassPath = System.getProperty("java.class.path");
            log.debug("Original java.class.path: " + javaClassPath);
            System.setProperty("java.class.path", javaClassPath + File.pathSeparator + classpathValue);
            log.debug("Modified java.class.path: " + System.getProperty("java.class.path"));
        }
    }

    private static String getJarFileOfClass(final Class<?> javaClass) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return javaClass.getProtectionDomain();
            }
        });
        String path = protectionDomain.getCodeSource().getLocation().getPath();
        if (WSImportUtil.isWindows() && path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("win");
    }

    public static int getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }
}

