/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ctc.wstx.evt.WstxEventReader;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ibm.websphere.appserver.tools.jaxrpc.common.ArchiveResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerI;
import com.ibm.websphere.appserver.tools.jaxrpc.common.DocumentUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.JavaAssistHelperUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.WsdlDocumentElement;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ClassResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ClientServiceEndpointInterface;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.Param;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ServiceEndpointMethod;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.XMLResources;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PredeployUtil {
    static CommonLoggerI log;
    static final String WS_11_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    static final String WS_12_13_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    static final String WS_14_NAMESPACE = "http://xmlns.jcp.org/xml/ns/javaee";
    static final String[] WS_NAMESPACES;
    static final String JAR_WEBSERVICES_PATH = ".jar/META-INF/webservices.xml";
    static final String WAR_WEBSERVICES_PATH = ".war/WEB-INF/webservices.xml";
    static final String WAR_WEBXML_PATH = ".war/WEB-INF/web.xml";
    static final String JAR_WEBSERVICESCLIENT_PATH = ".jar/META-INF/webservicesclient.xml";
    static final String WAR_WEBSERVICESCLIENT_PATH = ".war/WEB-INF/webservicesclient.xml";
    static final String JAR_APPLICATION_CLIENT_PATH = ".jar/META-INF/application-client.xml";
    static final String JAR_EJB_XML_PATH = ".jar/META-INF/ejb-jar.xml";
    static final String JAR_EJB_MERGED_XML_PATH = ".jar/META-INF/ejb-jar_merged.xml";
    public static final String EJB_JAR_MERGED_XML = "ejb-jar_merged.xml";
    public static final String EJB_JAR_XML = "ejb-jar.xml";
    public static final String WEB_XML = "web.xml";
    static final String WAR_WEBINF_WSDL_PATH = ".war/WEB-INF/wsdl/";
    static final String JAR_METAINF_WSDL_PATH = ".jar/META-INF/wsdl/";
    static final String WEBINF_CLASSES = "WEB-INF/classes/";
    static final String CONVERTED_APPS_FOLDER = "jax-rpc-tools-apps/convertedApplications";
    static final String ORIGINAL_APPS_FOLDER = "jax-rpc-tools-apps/originalApplications";
    static final String EXTENSION_OR_BINDING_PATH = ".*(META-INF|WEB-INF)/ibm-webservices(client)?-(bnd|ext)\\.xmi";
    static final List<String> DATA_OBJECT_SUFFIXES;
    public static String lineFeed;
    private static List<ArchiveResources.ModificationType> changeLogTypes;

    public static boolean isWindows() {
        return !File.separator.equals("/");
    }

    public static void setLogger(CommonLoggerI logger) {
        log = logger;
    }

    public static ArchiveResources collectResourcesFromArchive(File applicationFile, File destDir) throws Exception {
        return PredeployUtil.collectResourcesFromArchive(applicationFile, destDir, false, null, true);
    }

    public static ArchiveResources collectResourcesFromArchive(File archive, File destDir, boolean archiveInAppWithWebServicesXml, ArchiveResources containingArchive, boolean fullScan) throws Exception {
        ArchiveResources ar = new ArchiveResources(archive, destDir, log);
        ClassResources cr = fullScan ? ar.getClassResources() : null;
        ArrayList<File> jarsToProcess = new ArrayList<File>();
        JarFile jarFile = null;
        boolean webservicesXmlExists = false;
        boolean isJarFile = ar.isJarArchive();
        HashSet<File> filesToDelete = new HashSet<File>();
        try {
            if (fullScan && isJarFile) {
                cr.addClassPath(ar.getExpandedResourceDirectoryPath());
            }
            jarFile = new JarFile(archive);
            Enumeration<JarEntry> entries = jarFile.entries();
            String jarFileName = jarFile.getName();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                File copyFile = new File(destDir, entryName);
                if (entry.isDirectory()) {
                    if (!entryName.equals(WEBINF_CLASSES)) continue;
                    if (!copyFile.exists()) {
                        copyFile.mkdirs();
                    }
                    if (!fullScan) continue;
                    cr.addClassPath(copyFile.getCanonicalPath());
                    continue;
                }
                String jarEntryPath = jarFileName + File.separator + entryName;
                jarEntryPath = jarEntryPath.replace('\\', '/');
                if (entryName.endsWith(".war")) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    String dirForWarPath = entryName.substring(0, entryName.length() - 4);
                    File dirForWar = new File(destDir + File.separator + dirForWarPath + "_war");
                    ArchiveResources currentWarFileArchive = PredeployUtil.collectResourcesFromArchive(copyFile, dirForWar, false, ar, fullScan);
                    ar.addContainedArchive(currentWarFileArchive);
                    continue;
                }
                if (entryName.endsWith(".jar")) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    JarFile containedJar = new JarFile(copyFile);
                    if (containedJar.getEntry("org/apache/axis") != null || containedJar.getEntry("javax/xml/rpc") != null) {
                        if (fullScan) {
                            ar.logWarn("The dependency `" + copyFile.getName() + "` contains a JAX-RPC implementation and will be removed from the application during conversion.\n\tIf any other classes from this jar are required by the application, you must remove all JAX-RPC implementation classes (contained in packages javax.xml.rpc and org.apache.axis) before converting the application.");
                        }
                        containedJar.close();
                        filesToDelete.add(copyFile);
                        continue;
                    }
                    if (containedJar.getEntry("org/apache/commons/io") != null) {
                        if (fullScan) {
                            log.debug("Skipping processing of third-party jar: " + copyFile.getCanonicalPath());
                        }
                        containedJar.close();
                        continue;
                    }
                    containedJar.close();
                    String dirForJarPath = entryName.substring(0, entryName.length() - 4);
                    File dirForJar = new File(destDir, dirForJarPath + "_jar");
                    dirForJar.mkdirs();
                    if (fullScan) {
                        cr.addClassPath(dirForJar.getCanonicalPath());
                    }
                    jarsToProcess.add(copyFile);
                    continue;
                }
                if (isJarFile && jarEntryPath.endsWith(JAR_WEBSERVICES_PATH)) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    PredeployUtil.collectResourcesFromXML(copyFile, ar, containingArchive.isEarArchive(), containingArchive.isWarArchive());
                    continue;
                }
                if (jarEntryPath.endsWith(WAR_WEBSERVICES_PATH)) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    webservicesXmlExists = true;
                    PredeployUtil.collectResourcesFromXML(copyFile, ar, false, true);
                    continue;
                }
                if (isJarFile && (jarEntryPath.endsWith(JAR_WEBSERVICESCLIENT_PATH) || jarEntryPath.endsWith(JAR_APPLICATION_CLIENT_PATH) || jarEntryPath.endsWith(JAR_EJB_XML_PATH) || jarEntryPath.endsWith(JAR_EJB_MERGED_XML_PATH))) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    PredeployUtil.collectResourcesFromXML(copyFile, ar, false, true);
                    continue;
                }
                if (jarEntryPath.endsWith(WAR_WEBXML_PATH) || jarEntryPath.endsWith(WAR_WEBSERVICESCLIENT_PATH)) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    PredeployUtil.collectResourcesFromXML(copyFile, ar, false, true);
                    continue;
                }
                if (entryName.endsWith(".wsdl")) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    continue;
                }
                if (entryName.endsWith(".SF")) {
                    ar.setArchiveSigned(true);
                    continue;
                }
                if (fullScan) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    if (entryName.endsWith(".mf") || entryName.endsWith(".MF")) {
                        ar.setManifestFile(copyFile);
                        continue;
                    }
                    if (entryName.endsWith(".xmi") && jarEntryPath.matches(EXTENSION_OR_BINDING_PATH)) {
                        ar.getXmlResources().addBindingOrExtensionFile(copyFile);
                        continue;
                    }
                    if (!entryName.endsWith(".class") || entryName.contains("jaxrpc-tools-wsimport")) continue;
                    cr.addToAllClassFilePath(copyFile.getCanonicalPath());
                    continue;
                }
                if (entryName.endsWith(".xsd")) {
                    PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
                    continue;
                }
                if (!entryName.endsWith(".xml")) continue;
                PredeployUtil.prepareAndcopyFiletoDestDir(jarFile, entry, copyFile);
            }
        }
        catch (Exception e) {
            ar.logError("Received exception while iterating through archive " + archive.getCanonicalPath() + ": " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        try {
            List<ArchiveResources> childArchives;
            PredeployUtil.processMappingFiles(ar);
            for (File f : filesToDelete) {
                ar.deleteFile(f);
            }
            if (!isJarFile) {
                for (File nextJar : jarsToProcess) {
                    String dirForJarPath = nextJar.getName().substring(0, nextJar.getName().length() - 4);
                    File dirForJar = new File(nextJar.getParentFile(), dirForJarPath + "_jar");
                    ArchiveResources currentJarFileArchive = PredeployUtil.collectResourcesFromArchive(nextJar, dirForJar, webservicesXmlExists, ar, fullScan);
                    ar.addContainedArchive(currentJarFileArchive);
                }
            }
            if (fullScan) {
                if (isJarFile || ar.isWarArchive() && containingArchive == null) {
                    log.debug("Resolving client SEI class file paths for archive " + ar.getArchiveName());
                    Map<String, ClientServiceEndpointInterface> clientSEIs = ar.getClientSeiMap();
                    for (ClientServiceEndpointInterface csei : clientSEIs.values()) {
                        String seiName = csei.getSeiName();
                        log.debug("Getting seiPath for client SEI with name: " + seiName);
                        String classFilePath = ar.retrieveClassFilePath(seiName);
                        if (classFilePath == null) {
                            ar.logError("Could not find class file for client SEI with name: " + seiName + " in archive " + archive.getCanonicalPath());
                            continue;
                        }
                        csei.setSeiPath(classFilePath);
                        if (csei.isGenericService()) continue;
                        String serviceName = csei.getServiceName();
                        log.debug("Getting path for client SEI Service with name: " + serviceName);
                        classFilePath = ar.retrieveClassFilePath(serviceName);
                        if (classFilePath == null) {
                            ar.logError("Could not find class file for client SEI Service with name: " + serviceName + " in archive " + archive.getCanonicalPath());
                            continue;
                        }
                        csei.setServicePath(classFilePath);
                    }
                } else if (ar.isEarArchive()) {
                    log.debug("Resolving client SEI class file paths for archive " + ar.getArchiveName());
                    childArchives = ar.getContainedArchives();
                    for (ArchiveResources childAr : childArchives) {
                        if (!childAr.isWarArchive()) continue;
                        log.debug("Resolving client SEI class file paths for archive " + childAr.getArchiveName());
                        Map<String, ClientServiceEndpointInterface> clientSEIs = childAr.getClientSeiMap();
                        for (ClientServiceEndpointInterface csei : clientSEIs.values()) {
                            String seiName = csei.getSeiName();
                            log.debug("Getting seiPath for client SEI with name: " + seiName);
                            String classFilePath = childAr.retrieveClassFilePath(seiName);
                            if (classFilePath == null) {
                                ar.logError("Could not find class file for client SEI with name: " + seiName + " in archive " + archive.getCanonicalPath());
                                continue;
                            }
                            csei.setSeiPath(classFilePath);
                            if (csei.isGenericService()) continue;
                            String serviceName = csei.getServiceName();
                            log.debug("Getting path for client SEI Service with name: " + serviceName);
                            classFilePath = childAr.retrieveClassFilePath(serviceName);
                            if (classFilePath == null) {
                                ar.logError("Could not find class file for client SEI Service with name: " + serviceName + " in archive " + archive.getCanonicalPath());
                                continue;
                            }
                            csei.setServicePath(classFilePath);
                        }
                    }
                }
            }
            if (ar.isEarArchive()) {
                childArchives = ar.getContainedArchives();
                for (ArchiveResources childAr : childArchives) {
                    if (!childAr.isWarArchive() || !childAr.getWsdlResources().hasService()) continue;
                    PredeployUtil.processAuxillaryXmls(childAr);
                }
            } else if (ar.getWsdlResources().hasService() && (ar.isWarArchive() && containingArchive == null || ar.isJarContainedInEar(containingArchive))) {
                PredeployUtil.processAuxillaryXmls(ar);
            }
        }
        catch (Exception e) {
            ar.logError("Received exception while iterating through archive " + archive.getCanonicalPath() + ": " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return ar;
    }

    private static void processMappingFiles(ArchiveResources ar) throws XMLStreamException, IOException {
        Map<String, ClientServiceEndpointInterface> mappingFilesClientSEI = ar.getMappingFilesToMapClientSEI();
        for (String string : mappingFilesClientSEI.keySet()) {
            File mappingFile = new File(string);
            if (!mappingFile.exists()) {
                ar.logError("Cannot process missing mapping file: " + string);
                return;
            }
            PredeployUtil.mapClientSeiFromMappingFile(ar, mappingFile, mappingFilesClientSEI.get(string));
        }
        Map<String, WSDLResource> mappingFilesWsdlClients = ar.getMappingFilesToCollectXsdTypesClient();
        for (String filePath : mappingFilesWsdlClients.keySet()) {
            File mappingFile = new File(filePath);
            if (!mappingFile.exists()) {
                ar.logError("Cannot process missing mapping file: " + filePath);
                return;
            }
            PredeployUtil.collectXsdTypes(ar, mappingFile, mappingFilesWsdlClients.get(filePath), false);
        }
        Map<String, WSDLResource> map = ar.getMappingFilesToCollectXsdTypesService();
        for (String filePath : map.keySet()) {
            File mappingFile = new File(filePath);
            if (!mappingFile.exists()) {
                ar.logError("Cannot process missing mapping file: " + filePath);
                return;
            }
            PredeployUtil.collectXsdTypes(ar, mappingFile, map.get(filePath), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectXsdTypes(ArchiveResources ar, File mappingFile, WSDLResource wsdl, boolean isService) throws XMLStreamException, IOException {
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        if (!mappingFile.exists()) {
            log.debug("Storing mapping file " + mappingFile.getCanonicalPath() + " for later processing for xsd types for wsdl: " + wsdl.getWsdlPath());
            ar.addMappingFileToCollectXsdTypes(mappingFile.getCanonicalPath(), wsdl, isService);
            return;
        }
        WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(mappingFile);
        String seiName = null;
        String methodName = null;
        String paramPosition = null;
        String paramType = null;
        String wsdlReferenceName = null;
        ArrayList<Param> params = new ArrayList<Param>();
        String returnValue = null;
        String returnXsd = null;
        String returnWsdlReferenceName = null;
        String packageType = "";
        try {
            XMLEvent event;
            while (xmler.hasNextEvent() && (event = xmler.nextEvent()) != null) {
                if (event.isEndDocument()) {
                    break;
                }
                if (event.isStartElement()) {
                    WsdlDocumentElement wde = new WsdlDocumentElement(event);
                    if (wde.ofElementType("method-param-parts-mapping")) continue;
                    if (wde.ofElementType("package-type")) {
                        packageType = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("param-position")) {
                        paramPosition = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("param-type")) {
                        paramType = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("wsdl-message-part-name")) {
                        wsdlReferenceName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("method-return-value")) {
                        returnValue = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("service-endpoint-interface")) {
                        seiName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (!wde.ofElementType("java-method-name")) continue;
                    methodName = PredeployUtil.getElementChars(xmler);
                    continue;
                }
                if (!event.isEndElement()) continue;
                QName qname = event.asEndElement().getName();
                if (PredeployUtil.matchElementMultipleNamespaces(qname, "method-param-parts-mapping", WS_NAMESPACES)) {
                    String paramXsd = wsdl.getXsdType(wsdlReferenceName);
                    params.add(new Param(paramPosition, paramType, paramXsd, wsdlReferenceName));
                    if (paramType.endsWith("[]") && paramType.startsWith(packageType)) {
                        wsdl.addXsdTypeName(wsdlReferenceName, paramType);
                    }
                    paramPosition = null;
                    paramType = null;
                    wsdlReferenceName = null;
                    continue;
                }
                if (PredeployUtil.matchElementMultipleNamespaces(qname, "wsdl-return-value-mapping", WS_NAMESPACES)) {
                    if (!returnValue.equals("void")) {
                        returnXsd = wsdl.getXsdType(wsdlReferenceName);
                    }
                    returnWsdlReferenceName = wsdlReferenceName;
                    wsdlReferenceName = null;
                    continue;
                }
                if (!PredeployUtil.matchElementMultipleNamespaces(qname, "service-endpoint-method-mapping", WS_NAMESPACES)) continue;
                ServiceEndpointMethod seiMethodInfo = new ServiceEndpointMethod(wsdl, methodName, params, returnValue, returnXsd, returnWsdlReferenceName);
                log.debug("Adding SEI method " + methodName + " to SEI name " + seiName);
                ar.addSeiMethodToInterface(isService, seiName, seiMethodInfo);
                if (returnValue.endsWith("[]") && returnValue.startsWith(packageType)) {
                    wsdl.addXsdTypeName(returnWsdlReferenceName, returnValue);
                }
                params = new ArrayList();
                returnValue = null;
                returnXsd = null;
                returnWsdlReferenceName = null;
                methodName = null;
            }
        }
        finally {
            xmler.close();
        }
    }

    private static boolean isServiceXML(String xmlFilePath) {
        return xmlFilePath.endsWith("webservices.xml");
    }

    private static boolean isClientXML(String xmlFilePath) {
        return xmlFilePath.endsWith(WEB_XML) || xmlFilePath.endsWith("webservicesclient.xml") || xmlFilePath.endsWith("application-client.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void collectResourcesFromXML(File xmlFileToScan, ArchiveResources ar, boolean collectEjbs, boolean collectServlets) throws XMLStreamException, Exception {
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(xmlFileToScan);
        XMLResources xr = ar.getXmlResources();
        String currentXmlFilePath = xmlFileToScan.getCanonicalPath();
        if (PredeployUtil.isServiceXML(currentXmlFilePath)) {
            xr.addServiceDD(currentXmlFilePath);
        } else if (PredeployUtil.isClientXML(currentXmlFilePath)) {
            xr.addClientDD(currentXmlFilePath);
        }
        log.debug("Collecting info from xml file " + currentXmlFilePath);
        try {
            XMLEvent event;
            File pathToAppDir = xmlFileToScan.getParentFile().getParentFile();
            String webInfDir = xmlFileToScan.getParentFile().getCanonicalPath();
            boolean hasJaxrpcMappingFileElement = false;
            File jaxRpcMappingFileElement = null;
            String wsdlFileValue = null;
            String wsdlReferenceFile = null;
            String xmlFile = null;
            String webDescriptionName = null;
            String portComponentName = null;
            String implLink = null;
            String serviceInterface = null;
            String serviceEndpointInterface = null;
            String ejbClass = null;
            String ejbName = null;
            boolean inSessionElement = false;
            while (xmler.hasNextEvent() && (event = xmler.nextEvent()) != null) {
                WSDLResource wsdl;
                if (event.isEndDocument()) {
                    break;
                }
                if (event.isStartElement()) {
                    WsdlDocumentElement wde = new WsdlDocumentElement(event);
                    if (!wde.ofNamespaces(WS_NAMESPACES)) continue;
                    if (wde.ofElementType("webservice-description")) {
                        hasJaxrpcMappingFileElement = false;
                        jaxRpcMappingFileElement = null;
                        wsdlFileValue = null;
                        xmlFile = null;
                        implLink = null;
                        webDescriptionName = null;
                        portComponentName = null;
                        serviceInterface = null;
                        serviceEndpointInterface = null;
                        continue;
                    }
                    if (wde.ofElementType("wsdl-file")) {
                        String parsedWsdlValue = PredeployUtil.getElementChars(xmler);
                        try {
                            new URL(parsedWsdlValue);
                            wsdlFileValue = parsedWsdlValue;
                        }
                        catch (MalformedURLException e) {
                            wsdlFileValue = new File(pathToAppDir, parsedWsdlValue).getCanonicalPath();
                        }
                        wsdlReferenceFile = currentXmlFilePath;
                        continue;
                    }
                    if (wde.ofElementType("jaxrpc-mapping-file")) {
                        hasJaxrpcMappingFileElement = true;
                        jaxRpcMappingFileElement = new File(ar.getExpandedResourceDirectory(), PredeployUtil.getElementChars(xmler));
                        continue;
                    }
                    if (wde.ofElementType("servlet-link") && collectServlets) {
                        xmlFile = webInfDir + File.separator + WEB_XML;
                        implLink = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("ejb-link") && collectEjbs) {
                        xmlFile = webInfDir + File.separator + EJB_JAR_XML;
                        implLink = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("webservice-description-name")) {
                        webDescriptionName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("port-component-name")) {
                        portComponentName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("service-ref")) {
                        hasJaxrpcMappingFileElement = false;
                        jaxRpcMappingFileElement = null;
                        wsdlFileValue = null;
                        xmlFile = null;
                        implLink = null;
                        serviceInterface = null;
                        serviceEndpointInterface = null;
                        continue;
                    }
                    if (wde.ofElementType("service-interface")) {
                        serviceInterface = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("service-endpoint-interface")) {
                        serviceEndpointInterface = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("session")) {
                        inSessionElement = true;
                        ejbClass = null;
                        ejbName = null;
                        continue;
                    }
                    if (wde.ofElementType("ejb-class")) {
                        ejbClass = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (!wde.ofElementType("ejb-name") || !inSessionElement) continue;
                    if (ejbName == null) {
                        ejbName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    ar.logError(MessageFormat.format("Encountered more than one ejb-name under one session element in file {0}. The application cannot be converted.", currentXmlFilePath));
                    ar.getXmlResources().setEjbXmlIsValid(false);
                    continue;
                }
                if (!event.isEndElement()) continue;
                QName qname = event.asEndElement().getName();
                if (PredeployUtil.matchElementMultipleNamespaces(qname, "webservice-description", WS_NAMESPACES)) {
                    if (!PredeployUtil.isServiceXML(currentXmlFilePath) || !hasJaxrpcMappingFileElement || wsdlFileValue == null || implLink == null) continue;
                    wsdl = ar.addServiceWsdl(wsdlFileValue, wsdlReferenceFile);
                    xr.addJaxRpcMappingFileElement(jaxRpcMappingFileElement);
                    if (xmlFile.endsWith(EJB_JAR_XML)) {
                        String altXmlFile = xmlFile.substring(0, xmlFile.length() - EJB_JAR_XML.length()) + EJB_JAR_MERGED_XML;
                        log.debug("Adding file " + altXmlFile + " in case the ejb-jar.xml does not exist.");
                        xr.addXmlFile(altXmlFile, implLink);
                    }
                    xr.addXmlFile(xmlFile, implLink);
                    if (serviceEndpointInterface != null) {
                        if (ar.getSeiObject(false, serviceEndpointInterface) != null) {
                            ar.addOverlappingSEI(serviceEndpointInterface);
                        }
                        log.debug("Adding service SEI with name " + serviceEndpointInterface + " and port component name " + portComponentName);
                        ar.addServiceSEI(serviceEndpointInterface, portComponentName, wsdl);
                    }
                    log.debug("Storing mapping file " + jaxRpcMappingFileElement.getCanonicalPath() + " for later processing for xsd types for wsdl: " + wsdl.getWsdlPath());
                    ar.addMappingFileToCollectXsdTypes(jaxRpcMappingFileElement.getCanonicalPath(), wsdl, PredeployUtil.isServiceXML(currentXmlFilePath));
                    if (webDescriptionName == null || portComponentName == null || serviceEndpointInterface == null) continue;
                    String assumedName = webDescriptionName + "_" + portComponentName + "Impl";
                    ar.getImplMigrationMap().put(implLink, assumedName);
                    ar.getServiceImplToSeiMap().put(assumedName, serviceEndpointInterface);
                    continue;
                }
                if (PredeployUtil.matchElementMultipleNamespaces(qname, "service-ref", WS_NAMESPACES)) {
                    if ((PredeployUtil.isClientXML(currentXmlFilePath) || currentXmlFilePath.endsWith(EJB_JAR_XML) || currentXmlFilePath.endsWith(EJB_JAR_MERGED_XML)) && hasJaxrpcMappingFileElement && wsdlFileValue != null) {
                        wsdl = ar.addClientWsdl(wsdlFileValue, wsdlReferenceFile);
                        xr.addJaxRpcMappingFileElement(jaxRpcMappingFileElement);
                        if (serviceInterface != null && serviceEndpointInterface != null) {
                            if (ar.getSeiObject(true, serviceEndpointInterface) != null) {
                                ar.addOverlappingSEI(serviceEndpointInterface);
                            }
                            log.debug("Adding client SEI with name " + serviceEndpointInterface + " and service name " + serviceInterface);
                            ClientServiceEndpointInterface csei = ar.addClientSEI(serviceEndpointInterface, serviceInterface, wsdl);
                            log.debug("Storing mapping file " + jaxRpcMappingFileElement.getCanonicalPath() + " for later processing for csei: " + csei.getSeiName());
                            ar.addMappingFileToMapClientSEI(jaxRpcMappingFileElement.getCanonicalPath(), csei);
                        }
                        log.debug("Storing mapping file " + jaxRpcMappingFileElement.getCanonicalPath() + " for later processing for xsd types for wsdl: " + wsdl.getWsdlPath());
                        ar.addMappingFileToCollectXsdTypes(jaxRpcMappingFileElement.getCanonicalPath(), wsdl, PredeployUtil.isServiceXML(currentXmlFilePath));
                    }
                    if (!currentXmlFilePath.endsWith(WEB_XML) && !currentXmlFilePath.endsWith(EJB_JAR_XML) && !currentXmlFilePath.endsWith(EJB_JAR_MERGED_XML)) continue;
                    xr.addXmlFile(currentXmlFilePath);
                    continue;
                }
                if (!PredeployUtil.matchElementMultipleNamespaces(qname, "session", WS_NAMESPACES)) continue;
                if (ejbClass != null && ejbName != null && serviceEndpointInterface != null) {
                    ClassResources cr = ar.getClassResources();
                    cr.addClientEjbWebServicesClass(ejbClass);
                    final String EJB_NAME = ejbName;
                    cr.addEjbClassToName(ejbClass, (Set<String>)new HashSet<String>(){
                        {
                            this.add(EJB_NAME);
                        }
                    });
                    if (serviceEndpointInterface != null) {
                        xr.addClientDD(currentXmlFilePath);
                    }
                }
                inSessionElement = false;
            }
        }
        finally {
            xmler.close();
        }
    }

    static void prepareAndcopyFiletoDestDir(JarFile jarFile, JarEntry entry, File copyFile) throws IOException {
        if (!copyFile.getParentFile().exists()) {
            copyFile.getParentFile().mkdirs();
        }
        PredeployUtil.copyFileToDestDir(jarFile, entry, copyFile);
    }

    static void copyFileToDestDir(JarFile jarFile, JarEntry entry, File copyFile) throws IOException {
        try {
            double fileSizeMB = (double)entry.getSize() / 1048576.0;
            if (fileSizeMB >= 1.0) {
                log.info("Copying large file: " + entry.getName() + " from app: " + jarFile.getName() + ".\n\tSize: " + String.format("%.2f", fileSizeMB) + "MB\n\tThis may take a while.");
            }
            InputStream is = jarFile.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(copyFile);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    static boolean matchElementMultipleNamespaces(QName element, String elementName, String ... namespaces) {
        String namespace = element.getNamespaceURI();
        for (String ns : namespaces) {
            if (!ns.equals(namespace) || !elementName.equals(element.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    private static String getElementChars(WstxEventReader xmler) throws XMLStreamException {
        XMLEvent event;
        String data = null;
        if (xmler.peek().isCharacters() && (data = (event = xmler.nextEvent()).asCharacters().getData()) != null) {
            data = data.trim();
        }
        return data;
    }

    private static void processAuxillaryXmls(ArchiveResources ar) throws XMLStreamException, IOException {
        ClassResources cr = ar.getClassResources();
        XMLResources xr = ar.getXmlResources();
        for (String xmlFilePath : xr.getWebXmlAndEjbPaths()) {
            XMLEvent event;
            String otherXmlFile;
            File otherXml;
            WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
            File xmlFile = new File(xmlFilePath);
            if (!xmlFile.exists()) {
                if ((xmlFilePath.endsWith(EJB_JAR_XML) || xmlFilePath.endsWith(EJB_JAR_MERGED_XML)) && (otherXml = new File(otherXmlFile = xmlFilePath.endsWith(EJB_JAR_XML) ? xmlFilePath.substring(0, xmlFilePath.length() - EJB_JAR_XML.length()) + EJB_JAR_MERGED_XML : xmlFilePath.substring(0, xmlFilePath.length() - EJB_JAR_MERGED_XML.length()) + EJB_JAR_XML)).exists()) {
                    log.debug("Skip processing missing file " + xmlFilePath + " since " + otherXml.getName() + " exists.");
                    xr.removeEjbDeploymentDescriptor(xmlFilePath);
                    continue;
                }
                ar.logError("File does not exist: " + xmlFilePath);
                xr.setXmlInvalid();
                continue;
            }
            if (xmlFilePath.endsWith(EJB_JAR_XML) && (otherXml = new File(otherXmlFile = xmlFilePath.substring(0, xmlFilePath.length() - EJB_JAR_XML.length()) + EJB_JAR_MERGED_XML)).exists()) {
                log.debug("Skip processing file " + xmlFilePath + " since " + otherXml.getName() + " exists.");
                xr.removeEjbDeploymentDescriptor(xmlFilePath);
                continue;
            }
            Set<String> nameLinks = ar.getXmlResources().getLinkNames(xmlFilePath);
            if (nameLinks == null) continue;
            WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(new File(xmlFilePath));
            HashSet<String> nameLinksFound = new HashSet<String>();
            HashSet<String> implClasses = new HashSet<String>();
            HashMap<String, Set<String>> classNameMap = new HashMap<String, Set<String>>();
            boolean isServlet = xmlFilePath.contains(WEB_XML);
            boolean ejbXmlIsValid = true;
            String defName = null;
            String defClass = null;
            String serviceEndpoint = null;
            while (xmler.hasNextEvent() && (event = xmler.nextEvent()) != null && !event.isEndDocument()) {
                QName qname;
                if (event.isStartElement()) {
                    WsdlDocumentElement wde = new WsdlDocumentElement(event);
                    if (wde.ofElementType(isServlet ? "servlet" : "session")) {
                        defName = null;
                        defClass = null;
                        serviceEndpoint = null;
                        continue;
                    }
                    if (wde.ofElementType(isServlet ? "servlet-name" : "ejb-name")) {
                        defName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType(isServlet ? "servlet-class" : "ejb-class")) {
                        defClass = PredeployUtil.getElementChars(xmler);
                        String classFilePath = cr != null ? ar.retrieveClassFilePath(defClass) : null;
                        if (classFilePath == null) continue;
                        if (isServlet) {
                            cr.addServletClassFilePath(classFilePath);
                            continue;
                        }
                        cr.addEjbClassFilePath(classFilePath);
                        continue;
                    }
                    if (isServlet || !wde.ofElementType("service-endpoint")) continue;
                    serviceEndpoint = PredeployUtil.getElementChars(xmler);
                    if (cr == null) continue;
                    cr.addEjbServiceEndpoint(serviceEndpoint);
                    continue;
                }
                if (!event.isEndElement() || !(qname = event.asEndElement().getName()).getLocalPart().equals(isServlet ? "servlet" : "session") || defName == null || defClass == null || defClass.isEmpty()) continue;
                nameLinksFound.add(defName);
                implClasses.add(defClass);
                if (classNameMap.containsKey(defClass)) {
                    if (isServlet) {
                        classNameMap.get(defClass).add(defName);
                    } else {
                        ar.logError(MessageFormat.format("The ejb-class {0} maps to more than one ejb-name in file {1}. The application cannot be converted.", defClass, xmlFilePath));
                        xr.setXmlInvalid();
                        ejbXmlIsValid = false;
                    }
                } else {
                    classNameMap.put(defClass, new LinkedHashSet<String>(Arrays.asList(defName)));
                }
                if (cr == null) continue;
                Map<String, String> implMigrationMap = ar.getImplMigrationMap();
                Map<String, String> implToSeiMap = ar.getServiceImplToSeiMap();
                String newImpl = implMigrationMap.get(defName);
                if (newImpl == null) continue;
                String origImpl = ar.retrieveClassFilePath(defClass);
                if (origImpl != null) {
                    WSDLResource firstWsdl;
                    String newImplPath = xmlFile.getParentFile().getCanonicalPath();
                    Set<WSDLResource> serviceWsdls = ar.getWsdlResources().getServiceWsdls_files();
                    if (serviceWsdls.isEmpty()) {
                        serviceWsdls = ar.getWsdlResources().getServiceWsdls_URL();
                        if (!serviceWsdls.isEmpty()) {
                            firstWsdl = serviceWsdls.iterator().next();
                            newImplPath = new File(firstWsdl.getWsdlReferencePath()).getParentFile().getCanonicalPath();
                        }
                    } else {
                        firstWsdl = serviceWsdls.iterator().next();
                        newImplPath = firstWsdl.getWsdlFile().getParentFile().getCanonicalPath();
                    }
                    log.debug("processAuxillaryXmls resolving path of wsdl dir: " + newImplPath);
                    String packageName = defClass.substring(0, defClass.lastIndexOf(".") + 1);
                    String newImplCanonicalPath = PredeployUtil.buildNewImplCanonicalPath(newImplPath, packageName, newImpl);
                    implMigrationMap.put(newImplCanonicalPath, origImpl);
                    String sei = implToSeiMap.get(newImpl);
                    if (sei != null && sei.equals(defClass)) {
                        ar.addBusinessImplFileRequiringSpecialConversion(newImplCanonicalPath);
                    }
                    if (!isServlet && serviceEndpoint == null && cr != null && sei != null) {
                        cr.addEjbServiceEndpoint(sei);
                    }
                    implToSeiMap.put(packageName + newImpl, sei);
                }
                implMigrationMap.remove(defName);
                implToSeiMap.remove(newImpl);
            }
            xmler.close();
            if (!nameLinksFound.containsAll(nameLinks)) {
                ar.logError(MessageFormat.format("Did not find all referenced servlet or ejb links from {0}", xmlFilePath));
                xr.setXmlInvalid();
                ejbXmlIsValid = false;
            }
            if (isServlet) {
                cr.putAllServletClassToNameMap(classNameMap);
            } else {
                cr.putAllEjbClassToNameMap(classNameMap);
                ar.getXmlResources().setEjbXmlIsValid(ejbXmlIsValid);
            }
            cr.addImplClasses(implClasses);
        }
    }

    private static String buildNewImplCanonicalPath(String newImplPath, String packageName, String newImpl) {
        String newImplCanonicalPath = "";
        newImplCanonicalPath = newImplCanonicalPath + newImplPath + File.separator + File.separator;
        newImplCanonicalPath = newImplCanonicalPath + packageName.replace(".", File.separator);
        newImplCanonicalPath = newImplCanonicalPath + newImpl + ".class";
        return newImplCanonicalPath;
    }

    private static File getExpandedClassDir(ArchiveResources ar) {
        if (ar.isWarArchive()) {
            return new File(ar.getExpandedResourceDirectory(), WEBINF_CLASSES);
        }
        return ar.getExpandedResourceDirectory();
    }

    public static void cleanupFileDeletions(ArchiveResources ar) throws Exception {
        boolean success = true;
        Set<String> filesToDelete = ar.getDeleteFailedCollection();
        for (String path : filesToDelete) {
            if (ar.deleteFile(new File(path))) {
                log.debug("Deleted application file: " + path);
                continue;
            }
            success = false;
            log.error("Could not delete application file: " + path);
        }
        if (!success) {
            throw new Exception("Application files no longer needed could not be deleted before repackaging.");
        }
    }

    private static void copyModifiedClassFiles(ArchiveResources ar) throws IOException {
        Set<File> migratedDirsInArchive = ar.getWsdlResources().getAllMigrateDirs();
        File destDir = PredeployUtil.getExpandedClassDir(ar);
        if (!ar.getContainedArchives().isEmpty()) {
            for (ArchiveResources subArchive : ar.getContainedArchives()) {
                migratedDirsInArchive.removeAll(subArchive.getWsdlResources().getAllMigrateDirs());
            }
        }
        HashSet<File> parentMigrateDirs = new HashSet<File>();
        for (File migrateDir : migratedDirsInArchive) {
            String migrateDirPath = migrateDir.getCanonicalPath();
            parentMigrateDirs.add(migrateDir.getParentFile());
            Iterator migrateDirIterator = FileUtils.iterateFiles((File)migrateDir, (String[])new String[]{"class"}, (boolean)true);
            while (migrateDirIterator.hasNext()) {
                File migratedClassFile = (File)migrateDirIterator.next();
                String migratedClassFilePath = migratedClassFile.getCanonicalPath();
                String classPathTopPackage = migratedClassFilePath.substring(migrateDirPath.length());
                File destClassFile = new File(destDir, classPathTopPackage);
                if (destClassFile.exists()) {
                    PredeployUtil.cleanupDataObjects(destDir, classPathTopPackage, ar);
                }
                log.debug("Copying class file " + migratedClassFilePath + "\nto " + destClassFile.getCanonicalPath());
                ar.moveFile(migratedClassFile, destClassFile);
            }
            log.debug("Deleting directory " + migrateDirPath);
            FileUtils.deleteDirectory((File)migrateDir);
        }
        for (File parentMigrateDir : parentMigrateDirs) {
            log.debug("Deleting wsimport directory " + parentMigrateDir);
            FileUtils.deleteDirectory((File)parentMigrateDir);
        }
    }

    private static void cleanupDataObjects(File destDir, String classPathTopPackage, ArchiveResources ar) throws IOException {
        String classPathTopPackageNoExtension = classPathTopPackage.substring(0, classPathTopPackage.length() - 6);
        for (String suffix : DATA_OBJECT_SUFFIXES) {
            PredeployUtil.cleanupDataObject(destDir, classPathTopPackageNoExtension + suffix + ".class", ar);
            PredeployUtil.cleanupDataObject(destDir, classPathTopPackageNoExtension + suffix + ".java", ar);
        }
    }

    private static void cleanupDataObject(File destDir, String fileName, ArchiveResources ar) throws IOException {
        File dataObject = new File(destDir, fileName);
        if (dataObject.exists()) {
            log.debug("Deleting file: " + dataObject.getCanonicalPath());
            ar.deleteFile(dataObject);
        }
    }

    public static boolean isRouterModule(ArchiveResources ar) throws Exception {
        File webXml;
        boolean isRouter = false;
        if (ar.isWarArchive() && ar.getXmlResources().getServiceDDList().isEmpty() && ar.getXmlResources().getWebXmlPaths().isEmpty() && (webXml = new File(ar.getExpandedResourceDirectory(), "WEB-INF/web.xml")).exists()) {
            try {
                Document doc = DocumentUtil.getDocument((File)webXml);
                NodeList servletClassElements = doc.getElementsByTagName("servlet-class");
                for (int i = 0; i < servletClassElements.getLength(); ++i) {
                    Node nextServletClass = servletClassElements.item(i);
                    String value = nextServletClass.getTextContent();
                    if (value == null || !value.equals("com.ibm.ws.webservices.engine.transport.http.WebServicesServlet")) continue;
                    isRouter = true;
                    break;
                }
            }
            catch (Exception e) {
                ar.logError("Error loading web.xml." + webXml.getCanonicalPath());
                throw e;
            }
        }
        return isRouter;
    }

    private static Document findApplicationXmlOrApplicationClientXml(ArchiveResources ar) throws Exception {
        Document appXmlDoc = PredeployUtil.findApplicationXml(ar);
        if (appXmlDoc != null) {
            return appXmlDoc;
        }
        Document appClientXmlDoc = PredeployUtil.findApplicationClientXml(ar);
        if (appClientXmlDoc != null) {
            return appClientXmlDoc;
        }
        return null;
    }

    private static Document findApplicationClientXml(ArchiveResources ar) throws Exception {
        Document appXmlDoc = null;
        File appXml = new File(ar.getExpandedResourceDirectory(), "META-INF/application-client.xml");
        if (!appXml.exists()) {
            File[] paths;
            File dir = new File(ar.getExpandedResourceDirectory(), "META-INF");
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            };
            for (File path : paths = dir.listFiles(filter)) {
                Document doc = DocumentUtil.getDocument((File)path);
                Element docElement = doc.getDocumentElement();
                if (!docElement.getTagName().equals("application-client")) continue;
                appXmlDoc = doc;
                ar.setApplicationClientXmlFile(path);
                break;
            }
        } else {
            appXmlDoc = DocumentUtil.getDocument((File)appXml);
            ar.setApplicationClientXmlFile(appXml);
        }
        return appXmlDoc;
    }

    private static Document findApplicationXml(ArchiveResources ar) throws Exception {
        Document appXmlDoc = null;
        File appXml = new File(ar.getExpandedResourceDirectory(), "META-INF/application.xml");
        if (!appXml.exists()) {
            File[] paths;
            File dir = new File(ar.getExpandedResourceDirectory(), "META-INF");
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
                }
            };
            for (File path : paths = dir.listFiles(filter)) {
                Document doc = DocumentUtil.getDocument((File)path);
                Element docElement = doc.getDocumentElement();
                if (!docElement.getTagName().equals("application")) continue;
                appXmlDoc = doc;
                ar.setApplicationXmlFile(path);
                break;
            }
        } else {
            appXmlDoc = DocumentUtil.getDocument((File)appXml);
            ar.setApplicationXmlFile(appXml);
        }
        return appXmlDoc;
    }

    public static void updateApplicationXmlOrClientXml(ArchiveResources ar, Set<String> warModulesToRemove) throws Exception {
        HashSet<String> removedModules = new HashSet<String>();
        try {
            Document doc = PredeployUtil.findApplicationXmlOrApplicationClientXml(ar);
            if (doc != null) {
                Element docElement = doc.getDocumentElement();
                NodeList webUriElements = doc.getElementsByTagName("web-uri");
                for (int i = 0; i < webUriElements.getLength(); ++i) {
                    Node grandParent;
                    Node parent;
                    Node nextWebUri = webUriElements.item(i);
                    String value = nextWebUri.getTextContent();
                    if (value == null || !warModulesToRemove.contains(value) || (parent = nextWebUri.getParentNode()) == null || !parent.getNodeName().equals("web") || (grandParent = parent.getParentNode()) == null || !grandParent.getNodeName().equals("module")) continue;
                    docElement.removeChild(grandParent);
                    removedModules.add(value);
                    log.info("Removing router web module " + value + " from application.xml." + doc.getDocumentURI());
                }
                if (!removedModules.isEmpty()) {
                    ar.createOrUpdateFile(doc, ar.getApplicationXmlFile());
                }
                if (removedModules.size() != warModulesToRemove.size()) {
                    log.debug("Some router web modules were not found in the application.xml." + doc.getDocumentURI());
                }
            } else {
                ar.logError("Could not locate the application.xml for archive: " + ar.getArchiveName());
            }
        }
        catch (Exception e) {
            ar.logError("Error loading application xml for archive: " + ar.getArchiveName());
            throw e;
        }
    }

    public static Boolean repackageApplication(ArchiveResources ar, File outputDir) throws Exception {
        Boolean repackageSuccess = false;
        File convertedApplicationsDir = new File(outputDir, CONVERTED_APPS_FOLDER);
        if (PredeployUtil.isWindows()) {
            try {
                File[] expandedArchivesFolderContent;
                repackageSuccess = ar.prepareAndRepackageArchive(log, convertedApplicationsDir, outputDir);
                if (repackageSuccess == null) {
                    log.info("There were no modifications made to the following archive. " + ar.getOriginalArchive().getName());
                    return null;
                }
                if (!repackageSuccess.booleanValue()) {
                    log.info("The archive" + ar.getOriginalArchive().getName() + "failed to repackage");
                    return false;
                }
                File originalApplicationsDir = new File(outputDir, ORIGINAL_APPS_FOLDER);
                if (!originalApplicationsDir.exists()) {
                    originalApplicationsDir.mkdirs();
                }
                FileUtils.copyFileToDirectory((File)ar.getOriginalArchive(), (File)originalApplicationsDir, (boolean)true);
                File expandedArchiveFolder = ar.getExpandedResourceDirectory();
                File expandedArchiveParentFolder = expandedArchiveFolder.getParentFile();
                File tmpDir = ar.getTmpDirectory();
                boolean deletionError = false;
                try {
                    FileUtils.deleteDirectory((File)expandedArchiveFolder);
                    log.debug("Deleting directory " + ar.getExpandedResourceDirectoryPath() + " after repackaging archive: " + ar.getArchiveName());
                }
                catch (Exception e) {
                    ar.logWarn("Could not delete the expanded application directory: " + ar.getExpandedResourceDirectoryPath());
                    deletionError = true;
                }
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                    log.debug("Deleting temp directory " + tmpDir.getCanonicalPath() + " after repackaging archive: " + ar.getArchiveName());
                }
                catch (Exception e) {
                    ar.logWarn("Could not delete the temp directory: " + ar.getExpandedResourceDirectoryPath());
                    deletionError = true;
                }
                if (!deletionError && (expandedArchivesFolderContent = expandedArchiveParentFolder.listFiles()) != null && expandedArchivesFolderContent.length == 0) {
                    FileUtils.deleteDirectory((File)expandedArchiveParentFolder);
                    log.debug("Deleting directory " + expandedArchiveParentFolder.getCanonicalPath());
                }
                PredeployUtil.writeArchiveModificationLog(ar, outputDir);
                return repackageSuccess;
            }
            catch (Exception e) {
                ar.logError("There was an error repackaging the archive: " + ar.getOriginalArchive().getName());
                ar.logError("The repackaging error received was: " + e.getMessage());
                throw e;
            }
        }
        try {
            boolean containedArchiveModified = PredeployUtil.repackageSubArchives(ar, outputDir);
            if (!convertedApplicationsDir.exists()) {
                convertedApplicationsDir.mkdirs();
            }
            if (containedArchiveModified) {
                if (PredeployUtil.repackageArchive(ar, convertedApplicationsDir, outputDir)) {
                    File[] expandedArchivesFolderContent;
                    File originalApplicationsDir = new File(outputDir, ORIGINAL_APPS_FOLDER);
                    if (!originalApplicationsDir.exists()) {
                        originalApplicationsDir.mkdirs();
                    }
                    FileUtils.copyFileToDirectory((File)ar.getOriginalArchive(), (File)originalApplicationsDir, (boolean)true);
                    File expandedArchiveFolder = ar.getExpandedResourceDirectory();
                    File expandedArchiveParentFolder = expandedArchiveFolder.getParentFile();
                    boolean deletionError = false;
                    try {
                        FileUtils.deleteDirectory((File)expandedArchiveFolder);
                        log.debug("Deleting directory " + ar.getExpandedResourceDirectoryPath() + " after repackaging archive: " + ar.getArchiveName());
                    }
                    catch (Exception e) {
                        ar.logWarn("Could not delete the expanded application directory: " + ar.getExpandedResourceDirectoryPath());
                        deletionError = true;
                    }
                    if (!deletionError && (expandedArchivesFolderContent = expandedArchiveParentFolder.listFiles()) != null && expandedArchivesFolderContent.length == 0) {
                        FileUtils.deleteDirectory((File)expandedArchiveParentFolder);
                        log.debug("Deleting directory " + expandedArchiveParentFolder.getCanonicalPath());
                    }
                    PredeployUtil.writeArchiveModificationLog(ar, outputDir);
                    return containedArchiveModified;
                }
                log.info(MessageFormat.format("The archive {0} was not repackaged due to missing class files.", ar.getOriginalArchive().getName()));
                return false;
            }
            log.info("There were no modifications made to the following archive. " + ar.getOriginalArchive().getName());
            return null;
        }
        catch (Exception e) {
            ar.logError("There was an error repackaging the archive: " + ar.getOriginalArchive().getName());
            ar.logError("The repackaging error received was: " + e.getMessage());
            throw e;
        }
    }

    private static boolean repackageSubArchives(ArchiveResources ar, File outputDir) throws Exception {
        List<ArchiveResources> containedArchives = ar.getContainedArchives();
        boolean containedArchiveModified = ar.archiveModified();
        HashSet<String> warModulesToRemove = new HashSet<String>();
        for (ArchiveResources currentContainedArchive : containedArchives) {
            List<ArchiveResources> ca = currentContainedArchive.getContainedArchives();
            if (!ca.isEmpty()) {
                containedArchiveModified |= PredeployUtil.repackageSubArchives(currentContainedArchive, outputDir);
            }
            if (ar.isEarArchive() && PredeployUtil.isRouterModule(currentContainedArchive)) {
                containedArchiveModified = true;
                File warFileToDelete = currentContainedArchive.getOriginalArchive();
                warModulesToRemove.add(warFileToDelete.getName());
                log.info("Found router module. Deleting file: " + warFileToDelete.getCanonicalPath());
                ar.deleteFile(warFileToDelete);
            } else if (currentContainedArchive.archiveModified() && PredeployUtil.repackageArchive(currentContainedArchive, null, outputDir)) {
                containedArchiveModified = true;
            }
            log.debug("Deleting directory " + currentContainedArchive.getExpandedResourceDirectoryPath());
            FileUtils.deleteDirectory((File)currentContainedArchive.getExpandedResourceDirectory());
        }
        if (!warModulesToRemove.isEmpty()) {
            PredeployUtil.updateApplicationXmlOrClientXml(ar, warModulesToRemove);
        }
        return containedArchiveModified;
    }

    private static void writeArchiveModificationLog(ArchiveResources ar, File outputDir) {
        File changeLog = new File(outputDir, ar.getConvertedArchiveLocation().getName() + ".change.log");
        String changeLogPath = null;
        String basePath = ar.getExpandedResourceDirectoryPath();
        String tmpPath = null;
        File tmpDir = ar.getTmpDirectory();
        if (tmpDir != null) {
            try {
                tmpPath = tmpDir.getCanonicalPath();
            }
            catch (IOException e) {
                tmpPath = tmpDir.getAbsolutePath();
            }
        }
        try {
            changeLogPath = changeLog.getCanonicalPath();
            if (changeLog.exists()) {
                if (changeLog.delete()) {
                    log.info(MessageFormat.format("Deleted preexisting {0} file so a new one could be created.", changeLogPath));
                } else {
                    ar.logError(MessageFormat.format("The preexisting {0} file could not be deleted. The new change log could not be written.", changeLogPath));
                    return;
                }
            }
            if (!changeLog.createNewFile()) {
                ar.logError(MessageFormat.format("The {0} file could not be created.", changeLogPath));
                return;
            }
            log.info(MessageFormat.format("The {0} file was successfully created.", changeLogPath));
            FileWriter writer = new FileWriter(changeLog);
            Map<ArchiveResources.ModificationType, Set<String>> mods = ar.getArchiveModifications();
            Map<String, String> destinations = ar.getMovedFileDestinations();
            for (ArchiveResources.ModificationType type : changeLogTypes) {
                switch (type) {
                    case CREATE: {
                        writer.write("The following files were created during conversion: " + lineFeed + lineFeed);
                        break;
                    }
                    case DELETE: {
                        writer.write("The following files were deleted during conversion: " + lineFeed + lineFeed);
                        break;
                    }
                    case UPDATE: {
                        writer.write("The following files were updated during conversion: " + lineFeed + lineFeed);
                        break;
                    }
                    case MOVE: {
                        writer.write("The following files were moved during repackaging of the application: " + lineFeed + lineFeed);
                    }
                }
                if (mods.containsKey((Object)type)) {
                    Set<String> paths = mods.get((Object)type);
                    ArrayList<String> sortedList = new ArrayList<String>(paths);
                    Collections.sort(sortedList);
                    for (String nextPath : sortedList) {
                        String printPath = null;
                        if (type == ArchiveResources.ModificationType.MOVE) {
                            String destPath = destinations.get(nextPath);
                            if (tmpPath != null && destPath.startsWith(tmpPath)) {
                                destPath = destPath.substring(tmpPath.length() + 1);
                            } else if (destPath.startsWith(basePath)) {
                                destPath = destPath.substring(basePath.length() + 1);
                            }
                            printPath = nextPath.startsWith(basePath) ? nextPath.substring(basePath.length() + 1) : nextPath;
                            printPath = printPath + lineFeed + "--> " + destPath;
                        } else {
                            printPath = nextPath.startsWith(basePath) ? nextPath.substring(basePath.length() + 1) : nextPath;
                        }
                        writer.write(printPath);
                        writer.write(lineFeed);
                    }
                }
                writer.write(lineFeed);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            ar.logError(MessageFormat.format("There was an exception while writing the {0} file: {1}", changeLogPath, e.getMessage()));
        }
    }

    public static boolean repackageArchive(ArchiveResources ar, File convertedApplicationsDir, File outputDir) throws Exception {
        ProcessBuilder pb;
        PredeployUtil.cleanupFileDeletions(ar);
        PredeployUtil.copyModifiedClassFiles(ar);
        File manifestFile = ar.getManifestFile();
        File pbDirectory = ar.getExpandedResourceDirectory();
        File repackageOutputLog = new File(outputDir, ar.getArchiveName() + ".repackage.log");
        StringBuilder jarPackagingFlags = new StringBuilder("-cvf");
        String originalArchiveName = ar.getOriginalArchive().getName();
        if (manifestFile != null) {
            jarPackagingFlags.append("m");
            pb = new ProcessBuilder("jar", jarPackagingFlags.toString(), originalArchiveName, ar.getManifestFile().getCanonicalPath(), ".");
        } else {
            jarPackagingFlags.append("M");
            pb = new ProcessBuilder("jar", jarPackagingFlags.toString(), originalArchiveName, ".");
        }
        pb.directory(pbDirectory);
        pb.redirectErrorStream(true);
        pb.redirectOutput(repackageOutputLog);
        Process proc = pb.start();
        log.info("Calling jar command to repackage archive: " + originalArchiveName);
        if (!proc.waitFor(60L, TimeUnit.SECONDS)) {
            ar.logError("Repackaging did not complete within the 60 second timeout. See the log for more details: " + repackageOutputLog.getCanonicalPath());
            proc.destroy();
            return false;
        }
        if (!PredeployUtil.isWindows() && !JavaAssistHelperUtil.postMigrateClassVerification((ArchiveResources)ar, (File)pbDirectory)) {
            return false;
        }
        PredeployUtil.warnModifyingSignedArchive(ar);
        File generatedAppLocation = new File(pbDirectory, originalArchiveName);
        if (convertedApplicationsDir != null) {
            log.info("Repackaging complete for archive: " + originalArchiveName);
            File convertedAppLocation = new File(convertedApplicationsDir, originalArchiveName);
            FileUtils.copyFile((File)generatedAppLocation, (File)convertedAppLocation);
            log.debug("Moved repackaged archive from: " + generatedAppLocation.getCanonicalPath() + " to: " + convertedAppLocation.getCanonicalPath());
            ar.setConvertedArchiveLocation(convertedAppLocation);
        } else {
            log.info("Repackaging complete for contained archive: " + originalArchiveName);
            File convertedAppLocation = new File(pbDirectory.getParentFile(), originalArchiveName);
            FileUtils.copyFile((File)generatedAppLocation, (File)convertedAppLocation);
            log.debug("Moved repackaged archive from: " + generatedAppLocation.getCanonicalPath() + " to: " + convertedAppLocation.getCanonicalPath());
        }
        return true;
    }

    private static boolean warnModifyingSignedArchive(ArchiveResources ar) throws Exception {
        if (ar.getArchiveSigned()) {
            ar.logWarn("The following signed archive was modified and will need to be re-signed. " + ar.getOriginalArchive().getName());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mapClientSeiFromMappingFile(ArchiveResources ar, File mappingFile, ClientServiceEndpointInterface csei) throws XMLStreamException, IOException {
        log.debug("Processing mapping file " + mappingFile.getCanonicalPath() + " for csei: " + csei.getSeiName());
        WstxInputFactory xmlif = (WstxInputFactory)WstxInputFactory.newInstance();
        WstxEventReader xmler = (WstxEventReader)xmlif.createXMLEventReader(mappingFile);
        String serviceInterface = null;
        boolean portMapping = false;
        String portName = null;
        String wsdlPortType = null;
        String cseiServiceName = csei.getServiceName();
        String cseiServiceNameNoPackage = cseiServiceName.substring(cseiServiceName.lastIndexOf("."));
        String cseiServiceNamePackage = cseiServiceName.substring(0, cseiServiceName.lastIndexOf(".") + 1);
        String cseiSeiName = csei.getSeiName();
        String cseiNameNoPackage = cseiSeiName.substring(cseiSeiName.lastIndexOf("."));
        String cseiSeiNamePackage = cseiSeiName.substring(0, cseiSeiName.lastIndexOf(".") + 1);
        try {
            XMLEvent event;
            while (xmler.hasNextEvent() && (event = xmler.nextEvent()) != null) {
                String key;
                String serviceInterfaceNoPackage;
                String packageName;
                if (event.isEndDocument()) {
                    break;
                }
                if (event.isStartElement()) {
                    WsdlDocumentElement wde = new WsdlDocumentElement(event);
                    if (wde.ofElementType("service-interface-mapping")) {
                        serviceInterface = null;
                        portMapping = false;
                        portName = null;
                        continue;
                    }
                    if (wde.ofElementType("service-endpoint-interface-mapping")) {
                        serviceInterface = null;
                        wsdlPortType = null;
                        continue;
                    }
                    if (wde.ofElementTypes("service-interface", "service-endpoint-interface")) {
                        serviceInterface = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (wde.ofElementType("port-mapping")) {
                        portMapping = true;
                        continue;
                    }
                    if (wde.ofElementType("port-name")) {
                        portName = PredeployUtil.getElementChars(xmler);
                        continue;
                    }
                    if (!wde.ofElementType("wsdl-port-type") || !(wsdlPortType = PredeployUtil.getElementChars(xmler)).contains(":")) continue;
                    wsdlPortType = wsdlPortType.substring(wsdlPortType.lastIndexOf(":") + 1, wsdlPortType.length());
                    continue;
                }
                if (!event.isEndElement()) continue;
                QName qname = event.asEndElement().getName();
                if (PredeployUtil.matchElementMultipleNamespaces(qname, "service-interface-mapping", WS_NAMESPACES) && portMapping) {
                    if (serviceInterface == null || portName == null) continue;
                    packageName = null;
                    if (!serviceInterface.equals(cseiServiceName)) {
                        serviceInterfaceNoPackage = serviceInterface.substring(serviceInterface.lastIndexOf("."));
                        if (serviceInterfaceNoPackage.equals(cseiServiceNameNoPackage)) {
                            packageName = cseiServiceNamePackage;
                            log.debug("Adding client sei with alternate sei service name: " + serviceInterface + " for: " + cseiServiceName);
                            ar.addClientSEI(csei, null, serviceInterface);
                        }
                    } else if (serviceInterface.equals("javax.xml.rpc.Service")) {
                        String seiName = csei.getSeiName();
                        packageName = seiName.substring(0, seiName.lastIndexOf(".") + 1);
                    } else {
                        packageName = serviceInterface.substring(0, serviceInterface.lastIndexOf(".") + 1);
                    }
                    if (packageName == null) continue;
                    key = packageName + portName;
                    csei.setSeiNameJaxws(key);
                    log.debug("Map client sei from mapping file with key: " + key + " and value: " + csei.getSeiName());
                    continue;
                }
                if (!PredeployUtil.matchElementMultipleNamespaces(qname, "service-endpoint-interface-mapping", WS_NAMESPACES) || serviceInterface == null) continue;
                packageName = null;
                if (!serviceInterface.equals(cseiSeiName)) {
                    serviceInterfaceNoPackage = serviceInterface.substring(serviceInterface.lastIndexOf("."));
                    if (serviceInterfaceNoPackage.equals(cseiNameNoPackage)) {
                        packageName = cseiSeiNamePackage;
                        log.debug("Adding client sei with alternate sei name: " + serviceInterface + " for: " + cseiSeiName);
                        ar.addClientSEI(csei, serviceInterface, null);
                    }
                } else {
                    packageName = serviceInterface.substring(0, serviceInterface.lastIndexOf(".") + 1);
                }
                if (csei.getSeiNameJaxws() != null || packageName == null) continue;
                key = packageName + wsdlPortType;
                csei.setSeiNameJaxws(key);
                log.debug("Fall back wsdl-port-type " + wsdlPortType + "");
            }
        }
        finally {
            xmler.close();
        }
    }

    static {
        WS_NAMESPACES = new String[]{WS_11_NAMESPACE, WS_12_13_NAMESPACE, WS_14_NAMESPACE};
        DATA_OBJECT_SUFFIXES = new ArrayList<String>(Arrays.asList("_Ser", "_Deser", "_DeserProxy", "_Helper"));
        lineFeed = "\n";
        changeLogTypes = new ArrayList<ArchiveResources.ModificationType>();
        changeLogTypes.add(ArchiveResources.ModificationType.CREATE);
        changeLogTypes.add(ArchiveResources.ModificationType.UPDATE);
        changeLogTypes.add(ArchiveResources.ModificationType.DELETE);
        changeLogTypes.add(ArchiveResources.ModificationType.MOVE);
        if (PredeployUtil.isWindows()) {
            lineFeed = "\r\n";
        }
    }
}

