/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.TraceFlag;
import com.informix.util.TraceOS;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Enumeration;

public class Trace {
    private static final Object logger = Trace.getLoggerForClass(Trace.class);
    static final boolean isSlf4jPresent;
    private static final int slf4jLoggerLevel;
    private final int DEF_TRACE_LEVEL = 0;
    private final int HEX_SIZE = 22;
    private final int HEX_ASCII_SIZE = 16;
    private int traceLevel = 0;
    private String traceFile = null;
    private TraceOS dataOS;
    private boolean printTraceToConsole = false;

    public static final Object getLoggerForClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class must not be null");
        }
        try {
            String className = clazz.getCanonicalName();
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Method getLoggerMethod = loggerFactoryClass.getMethod("getLogger", String.class);
            return getLoggerMethod.invoke(null, className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Trace() {
        this.traceLevel = 0;
        this.traceFile = null;
    }

    public void resetTrace() {
        this.closeTraceFile();
        this.traceFile = null;
        this.traceLevel = 0;
    }

    public Trace(int level, String fileName) {
        if (level == 0) {
            return;
        }
        if (fileName == null) {
            this.traceLevel = 0;
            System.err.println("Trace file is null, setting trace level to 0");
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName, true)), true));
        }
        catch (Exception e) {
            System.err.println("Cannot Open FileOutputStream for Trace" + e.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = level;
            this.traceFile = fileName;
        }
    }

    public void setTraceLevel(int level) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        this.traceLevel = level;
    }

    public synchronized void setNewTraceFile(int level, String fileName) {
        this.closeTraceFile();
        if (level == 0) {
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (fileName == null) {
            System.err.println("Filename is null, resetting Trace\n");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName, true)), true));
        }
        catch (Exception e) {
            System.err.println("Cannot reOpen FileOutputStream for Trace" + e.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = level;
            this.traceFile = fileName;
        }
    }

    public String getTraceFile() {
        if (TraceFlag.isTraceEnabled()) {
            return this.traceFile;
        }
        return null;
    }

    public int getTraceLevel() {
        if (TraceFlag.isTraceEnabled()) {
            return this.traceLevel;
        }
        return 0;
    }

    public synchronized void setTraceOS(TraceOS traceOS) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.dataOS != null && !this.dataOS.equals(traceOS)) {
            this.closeTraceFile();
        }
        this.dataOS = traceOS;
    }

    public TraceOS getTraceOS() {
        if (TraceFlag.isTraceEnabled()) {
            return this.dataOS;
        }
        return null;
    }

    public void closeTraceFile() {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.flush();
            this.dataOS.close();
        }
    }

    public void writeTrace(int levelNum, String stringInfo) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(stringInfo);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo) {
        this.printLog(logger, stringInfo, levelNum);
    }

    public void writeTrace(int levelNum, String stringInfo, String data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, String data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, String stringInfo, int data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, int data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, int data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, String stringInfo, short data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, short data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, short data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, String stringInfo, double data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, double data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, String stringInfo, float data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, float data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, String stringInfo, long data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, long data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, long data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, String stringInfo, boolean data) {
        this.writeTrace(levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, boolean data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(int levelNum, boolean data) {
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        this.println(String.valueOf(data));
    }

    public void writeTrace(int levelNum, byte[] byteData, char format) {
        this.writeTrace(levelNum, byteData, format, byteData.length);
    }

    public void writeTrace(int levelNum, byte[] byteData, char format, int size) {
        this.writeTrace(levelNum, byteData, 0, format, size);
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, char format) {
        this.writeTrace(logger, levelNum, byteData, format, byteData.length);
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, char format, int size) {
        this.writeTrace(logger, levelNum, byteData, 0, format, size);
    }

    public void writeTrace(int levelNum, byte[] byteData, int offset, char format, int size) {
        int j = 0;
        boolean hexOnly = true;
        StringBuffer strAscii = null;
        StringBuffer strHex = null;
        int bytesDisplayed = 22;
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < levelNum) {
            return;
        }
        if (format == 'b' || format == 'B') {
            hexOnly = false;
            bytesDisplayed = 16;
            strAscii = new StringBuffer(bytesDisplayed);
        }
        strHex = new StringBuffer(bytesDisplayed * 4);
        try {
            if (hexOnly) {
                this.println("=================================-========================================");
                this.println("Index:   Hex:");
            } else {
                this.println("========================================================      ================");
                this.println("Index:   Hex:                                                 Ascii:");
                this.println("");
            }
            if (this.dataOS == null) {
                this.println("   ***** NULL data *****  ");
                return;
            }
            int i = 0;
            while (i < size) {
                Byte byteValue = new Byte(byteData[i + offset]);
                int intValue = byteValue.intValue();
                if (j == 0) {
                    strHex.append("0x");
                    if (i < 16) {
                        strHex.append("000");
                    } else if (i < 256) {
                        strHex.append("00");
                    } else if (i < 4096) {
                        strHex.append("0");
                    }
                    strHex.append(Integer.toHexString(i));
                    strHex.append(":  ");
                }
                if ((intValue &= 0xFF) < 16) {
                    strHex.append("0");
                }
                strHex.append(Integer.toHexString(intValue));
                strHex.append(" ");
                if (!hexOnly) {
                    if ((intValue &= 0xFF) >= 32 && intValue <= 126) {
                        Character charValue = new Character((char)intValue);
                        strAscii.append(charValue.toString());
                    } else {
                        strAscii.append(".");
                    }
                }
                if (j == bytesDisplayed - 1) {
                    this.print(strHex.toString());
                    strHex = new StringBuffer(bytesDisplayed * 4);
                    if (!hexOnly) {
                        this.printNoHeader("     ");
                        this.printNoHeader(strAscii.toString());
                        strAscii = new StringBuffer(bytesDisplayed);
                    }
                    this.printlnNoHeader("");
                    j = -1;
                }
                ++i;
                ++j;
            }
            if (j > -1) {
                this.print(strHex.toString());
                if (!hexOnly) {
                    while (j < bytesDisplayed) {
                        this.printNoHeader("   ");
                        ++j;
                    }
                    this.printNoHeader("     ");
                    this.printNoHeader(strAscii.toString());
                }
            }
            this.printlnNoHeader("");
            if (hexOnly) {
                this.println("==========================================================================");
            } else {
                this.println("==============================================================================");
            }
            this.println("");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, int offset, char format, int size) {
        int j = 0;
        boolean hexOnly = true;
        StringBuffer strAscii = null;
        StringBuffer strHex = null;
        StringBuilder printString = null;
        int bytesDisplayed = 22;
        if (!TraceFlag.isTraceEnabled()) {
            return;
        }
        if (format == 'b' || format == 'B') {
            hexOnly = false;
            bytesDisplayed = 16;
            strAscii = new StringBuffer(bytesDisplayed);
        }
        strHex = new StringBuffer(bytesDisplayed * 4);
        printString = new StringBuilder();
        try {
            if (hexOnly) {
                printString.append("\n");
                printString.append("=================================-========================================");
                printString.append("\n");
                printString.append("Index:   Hex:");
                printString.append("\n");
            } else {
                printString.append("\n");
                printString.append("========================================================      ================");
                printString.append("\n");
                printString.append("Index:   Hex:                                                 Ascii:");
                printString.append("");
                printString.append("\n");
            }
            if (this.dataOS == null) {
                printString.append("   ***** NULL data *****  ");
                printString.append("\n");
                return;
            }
            int i = 0;
            while (i < size) {
                Byte byteValue = new Byte(byteData[i + offset]);
                int intValue = byteValue.intValue();
                if (j == 0) {
                    strHex.append("0x");
                    if (i < 16) {
                        strHex.append("000");
                    } else if (i < 256) {
                        strHex.append("00");
                    } else if (i < 4096) {
                        strHex.append("0");
                    }
                    strHex.append(Integer.toHexString(i));
                    strHex.append(":  ");
                }
                if ((intValue &= 0xFF) < 16) {
                    strHex.append("0");
                }
                strHex.append(Integer.toHexString(intValue));
                strHex.append(" ");
                if (!hexOnly) {
                    if ((intValue &= 0xFF) >= 32 && intValue <= 126) {
                        Character charValue = new Character((char)intValue);
                        strAscii.append(charValue.toString());
                    } else {
                        strAscii.append(".");
                    }
                }
                if (j == bytesDisplayed - 1) {
                    this.print(strHex.toString());
                    strHex = new StringBuffer(bytesDisplayed * 4);
                    if (!hexOnly) {
                        printString.append("     ");
                        printString.append(strAscii.toString());
                        strAscii = new StringBuffer(bytesDisplayed);
                    }
                    printString.append("");
                    printString.append("\n");
                    j = -1;
                }
                ++i;
                ++j;
            }
            if (j > -1) {
                printString.append(strHex.toString());
                if (!hexOnly) {
                    while (j < bytesDisplayed) {
                        printString.append("   ");
                        ++j;
                    }
                    printString.append("     ");
                    printString.append(strAscii.toString());
                }
            }
            printString.append("");
            printString.append("\n");
            if (hexOnly) {
                printString.append("==========================================================================");
            } else {
                printString.append("==============================================================================");
            }
            printString.append("");
            printString.append("\n");
            this.printLog(logger, printString.toString(), levelNum);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void print(String msg) {
        if (this.dataOS != null) {
            this.dataOS.print(msg);
        }
        if (this.printTraceToConsole) {
            System.out.print("[JDBC][TRACE][" + new Timestamp(System.currentTimeMillis()) + "] " + msg);
        }
    }

    private void printNoHeader(String msg) {
        if (this.dataOS != null) {
            this.dataOS.print(msg);
        }
        if (this.printTraceToConsole) {
            System.out.print(msg);
        }
    }

    private void println(String msg) {
        if (this.dataOS != null) {
            this.dataOS.println("[Time: " + new Timestamp(System.currentTimeMillis()) + "][Thread:" + Thread.currentThread().getName() + "]" + msg);
        }
        if (this.printTraceToConsole) {
            System.out.println("[JDBC][TRACE][" + new Timestamp(System.currentTimeMillis()) + "] " + msg);
        }
    }

    private void printlnNoHeader(String msg) {
        if (this.dataOS != null) {
            this.dataOS.println(msg);
        }
        if (this.printTraceToConsole) {
            System.out.println(msg);
        }
    }

    private void printLog(Object loggerFromClass, String msg, int levelNum) {
        if (isSlf4jPresent) {
            if (slf4jLoggerLevel >= levelNum) {
                if (levelNum == 1) {
                    Trace.logTrace(loggerFromClass, msg);
                } else if (levelNum == 2) {
                    Trace.logTrace(loggerFromClass, msg);
                } else if (levelNum == 3) {
                    Trace.logTrace(loggerFromClass, msg);
                } else {
                    Trace.logTrace(loggerFromClass, msg);
                }
            }
        } else if (TraceFlag.compiletrace) {
            if (this.traceLevel < levelNum) {
                return;
            }
            this.println(msg);
        }
    }

    private static final void logTrace(Object logger, String message) {
        if (logger == null) {
            return;
        }
        try {
            Method traceMethod = logger.getClass().getMethod("trace", String.class);
            if (traceMethod != null) {
                traceMethod.invoke(logger, message);
            } else assert (false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void legacyLoggerNote(Object loggerFromClass, String msg) {
        if (isSlf4jPresent && TraceFlag.compiletrace) {
            this.println(msg + " Both SLF4J and Legacy Logging(URL String with Filename) are enabled. SLF4J supercedes legacy logging. The log File details will be present in the configuration file");
        }
    }

    private static int retriveSlf4jLoggerLevel() {
        if (Trace.isLoggerTraceEnabled(logger)) {
            return 3;
        }
        if (Trace.isLoggerDebugEnabled(logger)) {
            return 2;
        }
        return 1;
    }

    private static final boolean isLoggerDebugEnabled(Object logger) {
        if (logger == null) {
            return false;
        }
        try {
            Method m = logger.getClass().getMethod("isDebugEnabled", new Class[0]);
            if (m == null) {
                return false;
            }
            Object enabled = m.invoke(logger, new Object[0]);
            return (Boolean)enabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean isLoggerTraceEnabled(Object logger) {
        if (logger == null) {
            return false;
        }
        try {
            Method m = logger.getClass().getMethod("isTraceEnabled", new Class[0]);
            if (m == null) {
                return false;
            }
            Object enabled = m.invoke(logger, new Object[0]);
            return (Boolean)enabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkSLF4jLoggingService() {
        return Trace.hasClass("org/slf4j/impl/StaticLoggerBinder.class") && Trace.hasClass("org/slf4j/LoggerFactory.class");
    }

    static boolean hasClass(String name) {
        try {
            return Trace.getURLs(name).hasMoreElements();
        }
        catch (IOException e) {
            return false;
        }
    }

    static Enumeration<URL> getURLs(String name) throws IOException {
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        if (threadCL != null) {
            return threadCL.getResources(name);
        }
        return ClassLoader.getSystemResources(name);
    }

    static {
        TraceFlag.compiletrace = false;
        isSlf4jPresent = Trace.checkSLF4jLoggingService();
        slf4jLoggerLevel = Trace.retriveSlf4jLoggerLevel();
    }
}

