/*
 * Decompiled with CFR 0.152.
 */
package com.informix.smartTrigger;

import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.smartTrigger.IfmxSmartTriggerCallback;
import com.informix.smartTrigger.IfmxThreadedSmartTrigger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;

public class IfxSmartTrigger
extends Thread
implements IfmxThreadedSmartTrigger {
    private static final int BUFFER_SIZE = 65536;
    private final AtomicLong counter = new AtomicLong(0L);
    private final AtomicBoolean isClosed = new AtomicBoolean(true);
    private final AtomicBoolean isWatching = new AtomicBoolean(false);
    private final Connection con;
    private String label = null;
    private int timeout = 60;
    private int bufferSize = 66560;
    private int fileDescriptor;
    private Queue<WatchTableInfo> registerTableQueue = new ConcurrentLinkedQueue<WatchTableInfo>();
    private Queue<WatchTableInfo> deregisterTableQueue = new ConcurrentLinkedQueue<WatchTableInfo>();
    private final ArrayList<WatchTableInfo> watchList = new ArrayList();
    private int maxPendingOperations = 0;
    private int maxRecordsPerRequest;
    private IfxSmartBlob blob = null;
    private Long transactionID = null;
    private Long commitTime = null;
    private boolean detachable;
    private String detachableSessionID = null;

    @Override
    public void run() {
        try {
            this.watch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public IfxSmartTrigger(DataSource source) throws SQLException {
        this.con = source.getConnection();
        this.setLockMode();
        this.isClosed.set(false);
        this.label = Thread.currentThread().getName() + "_push";
    }

    public IfxSmartTrigger(String connectionUrl) throws SQLException {
        this(connectionUrl, null);
    }

    public IfxSmartTrigger(String connectionUrl, Properties prop) throws SQLException {
        this.con = new IfxDriver().connect(connectionUrl, prop);
        this.setLockMode();
        this.isClosed.set(false);
        this.label = Thread.currentThread().getName() + "_push";
    }

    private void setLockMode() throws SQLException {
        try (Statement s = this.con.createStatement();){
            s.execute("SET LOCK MODE TO WAIT 30");
        }
    }

    @Override
    public IfxSmartTrigger detachable(boolean detachable) {
        this.detachable = detachable;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger label(String labelName) {
        this.label = labelName;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger buffer(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger operationsCacheSize(int size) {
        this.maxPendingOperations = size;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger maxRecordsPerRequest(int size) {
        this.maxRecordsPerRequest = size;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger commitTime(long time) {
        this.commitTime = time;
        return this;
    }

    @Override
    public IfmxThreadedSmartTrigger transactionID(long id) {
        this.transactionID = id;
        return this;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed.get()) {
            return;
        }
        if (!this.isWatching.get()) {
            this.watchList.clear();
            if (this.detachable) {
                try (Statement s = this.con.createStatement();){
                    s.execute("EXECUTE FUNCTION informix.task('pushdata delete', '{session_id:\"" + this.detachableSessionID + "\"}')");
                }
            }
            this.con.close();
        }
        this.isClosed.set(true);
    }

    @Override
    public String detach() throws SQLException {
        if (this.isClosed.get()) {
            return this.detachableSessionID;
        }
        if (!this.isWatching.get()) {
            this.watchList.clear();
            this.con.close();
        }
        this.isClosed.set(true);
        return this.detachableSessionID;
    }

    private void registerPushData() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("{timeout:\"" + this.timeout + "\", ");
        sb.append("max_pending_ops:\"" + this.maxPendingOperations + "\", ");
        sb.append("maxrecs:\"" + this.maxRecordsPerRequest + "\", ");
        if (this.transactionID != null) {
            sb.append("txnid:\"" + this.transactionID + "\", ");
        }
        if (this.commitTime != null) {
            sb.append("commit_time:\"" + this.commitTime + "\", ");
        }
        String s = sb.toString();
        s = s.substring(0, sb.length() - 2) + "}";
        PreparedStatement p = this.con.prepareStatement("EXECUTE FUNCTION informix.task('pushdata register', ?)");
        p.setString(1, s);
        ResultSet rs = p.executeQuery();
        if (rs.next() && !rs.getString(1).trim().equalsIgnoreCase("OK")) {
            throw new SQLException("Error executing task pushdata register: " + rs.getString(1));
        }
        rs.close();
        p.close();
    }

    @Override
    public void addTrigger(String tableName, String tableOwnerName, String databaseName, String sqlQuery, IfmxSmartTriggerCallback ... callback) throws SQLException {
        this.addTrigger(tableName, tableOwnerName, databaseName, sqlQuery, this.label + "_" + this.counter.incrementAndGet(), callback);
    }

    @Override
    public void addTrigger(String tableName, String tableOwnerName, String databaseName, String sqlQuery, String label, IfmxSmartTriggerCallback ... callback) throws SQLException {
        WatchTableInfo info = new WatchTableInfo();
        info.databaseName = databaseName;
        info.tableName = tableName;
        info.ownerName = tableOwnerName;
        info.query = sqlQuery;
        info.label = label;
        if (callback != null) {
            for (IfmxSmartTriggerCallback c : callback) {
                info.callBacks.add(c);
            }
        }
        this.registerTableQueue.add(info);
    }

    @Override
    public void removeTrigger(String tableName, String tableOwnerName, String databaseName) throws SQLException {
        WatchTableInfo info = new WatchTableInfo();
        info.databaseName = databaseName;
        info.tableName = tableName;
        info.ownerName = tableOwnerName;
        this.deregisterTableQueue.add(info);
    }

    @Override
    public void removeTrigger(String label) throws SQLException {
        WatchTableInfo info = new WatchTableInfo();
        info.label = label;
        this.deregisterTableQueue.add(info);
    }

    public synchronized void registerTriggers() throws SQLException {
        ResultSet rs;
        PreparedStatement p;
        while (!this.deregisterTableQueue.isEmpty()) {
            p = this.con.prepareStatement("EXECUTE FUNCTION informix.task('pushdata deregister', ?)");
            WatchTableInfo removeInfo = this.deregisterTableQueue.remove();
            p.setString(1, removeInfo.toJson());
            rs = p.executeQuery();
            if (rs.next() && !rs.getString(1).equalsIgnoreCase("OK")) {
                throw new SQLException("Error executing task pushdata deregister: " + rs.getString(1));
            }
            rs.close();
            Iterator<WatchTableInfo> i = this.watchList.iterator();
            while (i.hasNext()) {
                WatchTableInfo info = i.next();
                if (info.label != null && info.label.equals(removeInfo.label)) {
                    i.remove();
                    continue;
                }
                if (!info.tableName.equalsIgnoreCase(removeInfo.tableName) || !info.ownerName.equalsIgnoreCase(removeInfo.ownerName) || !info.databaseName.equalsIgnoreCase(removeInfo.databaseName)) continue;
                i.remove();
            }
            p.close();
        }
        while (!this.registerTableQueue.isEmpty()) {
            p = this.con.prepareStatement("EXECUTE FUNCTION informix.task('pushdata register', ?)");
            WatchTableInfo info = this.registerTableQueue.remove();
            p.setString(1, info.toJson());
            rs = p.executeQuery();
            if (rs.next() && !rs.getString(1).equalsIgnoreCase("OK")) {
                throw new SQLException("Error executing task pushdata register: " + rs.getString(1));
            }
            rs.close();
            this.watchList.add(info);
            p.close();
        }
    }

    @Override
    public List<String> getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (WatchTableInfo info : this.watchList) {
            labels.add(info.label);
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch() throws SQLException {
        this.open();
        try {
            this.isWatching.set(true);
            do {
                try {
                    if (this.checkForClose()) {
                        break;
                    }
                    this.registerTriggers();
                }
                catch (SQLException e) {
                    throw new SQLException("Error executing table registration", e);
                }
                this.processWatchData();
            } while (!Thread.interrupted());
        }
        finally {
            this.isWatching.set(false);
        }
    }

    public String readTriggerEvent() throws SQLException {
        byte[] bytes = this.blob.IfxLoRead(this.fileDescriptor, this.bufferSize);
        return new String(bytes).trim();
    }

    void processWatchData() throws SQLException {
        String str = this.readTriggerEvent();
        for (WatchTableInfo info : this.watchList) {
            if (!str.contains("\"label\":\"" + info.label) && !str.startsWith("{\"ifx_warn_total_skipcount\"") && !str.startsWith("{\"ifx_isTimeout\"")) continue;
            for (IfmxSmartTriggerCallback callback : info.callBacks) {
                callback.notify(str);
            }
        }
    }

    boolean checkForClose() throws SQLException {
        if (this.isClosed.get()) {
            this.watchList.clear();
            if (this.detachable) {
                try (Statement s = this.con.createStatement();){
                    s.execute("EXECUTE FUNCTION informix.task('pushdata delete', '{session_id:\"" + this.detachableSessionID + "\")");
                }
            }
            this.con.close();
            return true;
        }
        return false;
    }

    void removeCallback(String label) {
        Iterator<WatchTableInfo> i = this.watchList.iterator();
        while (i.hasNext()) {
            WatchTableInfo info = i.next();
            if (!info.label.equals(label)) continue;
            i.remove();
        }
    }

    void removeCallback(String label, IfmxSmartTriggerCallback e) {
        for (WatchTableInfo info : this.watchList) {
            if (!info.label.equalsIgnoreCase(label)) continue;
            info.callBacks.remove(e);
        }
    }

    public void open() throws SQLException {
        String sql;
        Statement s = this.con.createStatement();
        ResultSet rs = s.executeQuery(sql = this.detachableSessionID == null ? "EXECUTE FUNCTION informix.task('pushdata open')" : "EXECUTE FUNCTION informix.task('pushdata join', '{session_id:\"" + this.detachableSessionID + "\"}')");
        if (rs.next()) {
            this.fileDescriptor = rs.getInt(1);
        }
        rs.close();
        if (this.detachableSessionID == null && this.detachable && (rs = s.executeQuery("execute function informix.task('pushdata setdetach')")).next()) {
            this.detachableSessionID = rs.getString(1);
        }
        s.close();
        this.registerPushData();
        if (this.blob == null) {
            this.blob = new IfxSmartBlob(this.con);
        }
    }

    @Override
    public String getDetachableSesisonID() {
        return this.detachableSessionID;
    }

    @Override
    public IfmxThreadedSmartTrigger sessionID(String id) {
        this.detachableSessionID = id;
        this.detachable = true;
        return this;
    }

    @Override
    public void registerCallback(String label, IfmxSmartTriggerCallback callback) {
        for (WatchTableInfo info : this.watchList) {
            if (!info.label.equals(label)) continue;
            info.callBacks.add(callback);
            return;
        }
        WatchTableInfo info = new WatchTableInfo();
        info.label = label;
        info.callBacks.add(callback);
        this.watchList.add(info);
    }

    private class WatchTableInfo {
        String tableName;
        String ownerName;
        String databaseName;
        String query;
        String label;
        List<IfmxSmartTriggerCallback> callBacks = new ArrayList<IfmxSmartTriggerCallback>();

        private WatchTableInfo() {
        }

        public String toJson() {
            StringBuilder sb = new StringBuilder("{");
            if (this.tableName != null) {
                sb.append("table:\"" + this.tableName + "\", ");
            }
            if (this.ownerName != null) {
                sb.append("owner:\"" + this.ownerName + "\", ");
            }
            if (this.databaseName != null) {
                sb.append("database:\"" + this.databaseName + "\", ");
            }
            if (this.query != null) {
                sb.append("query:\"" + this.query + "\", ");
            }
            if (this.label != null) {
                sb.append("label:\"" + this.label + "\", ");
            }
            String s = sb.toString();
            return s.substring(0, sb.length() - 2) + "}";
        }

        public String toString() {
            return this.toJson();
        }
    }
}

