/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxXADataSource;
import com.informix.jdbcx.IfxXAResource;
import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXASqli;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class IfxXAPooledConnection
extends IfxPooledConnection
implements XAConnection {
    private final int TMMTSDTC = 4096;
    private IfxXADataSource xads;
    private IfxXAReusableConnection conn;
    protected IfxXAResource xaRes;
    protected boolean connOpen;
    private String url;
    private String dbName;
    private IfxXASqli proto;

    public IfxXAPooledConnection() throws SQLException {
        this.xads = null;
        this.conn = null;
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IfxXAPooledConnection(IfxXADataSource ds, String user, String passwd) throws SQLException {
        Properties props = new Properties();
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
        this.xads = ds;
        props.putAll((Map<?, ?>)this.xads.getDsProperties());
        Properties properties = props;
        synchronized (properties) {
            String host = props.getProperty("IFXHOST");
            String port = props.getProperty("PORTNO");
            if (host != null && port != null) {
                this.url = host + ":" + port;
            }
            if ((this.dbName = props.getProperty("DATABASE")) != null) {
                props.remove("DATABASE");
            }
            try {
                this.conn = new IfxXAReusableConnection(user, passwd, this, this.url, props);
            }
            catch (SQLException e) {
                this.conn = null;
                this.url = null;
                if (this.dbName != null) {
                    props.put("DATABASE", this.dbName);
                }
                try {
                    this.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                throw e;
            }
            if (this.dbName != null) {
                props.put("DATABASE", this.dbName);
            }
            this.proto = (IfxXASqli)this.conn.getProto();
            this.openDBforXA();
            this.conn.setServerIsolationLevel();
        }
        this.connOpen = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block6: {
            SQLException e = null;
            if (!this.connOpen) {
                return;
            }
            try {
                this.conn.hardClose();
            }
            catch (SQLException exc) {
                e = exc;
            }
            finally {
                this.conn = null;
                this.dbName = null;
                this.proto = null;
                this.xaRes = null;
                this.connOpen = false;
                if (e == null) break block6;
                throw e;
            }
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.xaRes == null) {
            this.xaRes = new IfxXAResource(this.conn);
        }
        return this.xaRes;
    }

    void openDBforXA() throws SQLException {
        String pValue = this.xads.getIfxIFX_XASPEC();
        this.proto.executeXAOpen(this.dbName, 1, pValue.equals("y") ? 4096 : 0);
        this.connOpen = true;
    }

    void closeDBforXA() throws SQLException {
        this.proto.executeXAClose(this.dbName, 1, 0);
        this.connOpen = false;
    }
}

