/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;

public class IfxSmallFloat
extends IfxObject {
    private static final Object logger = Trace.getLoggerForClass(IfxSmallFloat.class);
    private float value;
    private static final int IFX_SMFLOAT_SIZE = 4;

    IfxSmallFloat() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat() constructor called");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat() constructor exited");
        }
        this.setIfxType(4);
    }

    IfxSmallFloat(float f) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(float) constructor called");
        }
        this.setIfxType(4);
        this.value = f;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(float) constructor exited");
        }
    }

    IfxSmallFloat(Float F) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(Float) constructor called");
        }
        this.setIfxType(4);
        if (F != null) {
            this.value = F.floatValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(Float) constructor exited");
        }
    }

    IfxSmallFloat(double d) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(double) constructor called");
        }
        this.setIfxType(4);
        this.value = (float)d;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(double) constructor exited");
        }
    }

    IfxSmallFloat(Double D) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(Double) constructor called");
        }
        this.setIfxType(4);
        if (D != null) {
            this.value = (float)D.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat(Double) constructor exited");
        }
    }

    @Override
    public byte[] toIfx() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toIfx() called/exited");
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[4];
            Arrays.fill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        boolean null_flg = true;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromIfx() called");
        }
        if (!(null_flg = IfxSmallFloat.isIfxNull(b, offset, length))) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaReal(b, offset);
        } else {
            this.nullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromIfx() exited");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxSmallFloat) {
            IfxSmallFloat floatOther = (IfxSmallFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toByte() called");
        }
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toByte() exited");
        }
        return b;
    }

    @Override
    public void fromByte(Byte b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromByte((byte)b);
        }
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromByte() called");
        }
        this.value = b;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromByte() exited");
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toShort() called");
        }
        this.clearWarning();
        short s = this.isNull() ? (short)0 : (short)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toShort() exited");
        }
        return s;
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromShort() called");
        }
        this.value = s;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromShort() exited");
        }
    }

    @Override
    public int toInt() throws SQLException {
        int i;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toInt() called");
        }
        this.clearWarning();
        if (this.isNull()) {
            i = 0;
        } else {
            i = (int)this.value;
            if (i <= Integer.MIN_VALUE) {
                i = -2147483647;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toInt() exited");
        }
        return i;
    }

    @Override
    public void fromInt(Integer i) throws SQLException {
        if (i == null) {
            this.nullify();
        } else {
            this.fromInt((int)i);
        }
    }

    @Override
    public void fromInt(int i) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromInt() called");
        }
        this.value = i;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromInt() exited");
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toLong() called");
        }
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toLong() called");
        }
        return l;
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    @Override
    public void fromLong(long l) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromLong() called");
        }
        this.value = l;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromLong() exited");
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toDouble() called");
        }
        double d = this.isNull() ? 0.0 : (double)this.value;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toDouble() exited");
        }
        return d;
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromDouble() called");
        }
        this.value = (float)d;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromDouble() exited");
        }
    }

    @Override
    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toDecimal() called/exited");
        }
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromDecimal() called");
        }
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.floatValue();
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromDecimal() exited");
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean b;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toBoolean() called");
        }
        if (this.isNull()) {
            b = false;
        } else {
            boolean bl = b = this.value != 0.0f;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toBoolean() exited");
        }
        return b;
    }

    @Override
    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)b);
            this.unnullify();
        }
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromBoolean() called");
        }
        this.value = b ? 1 : 0;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromBoolean() exited");
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toString() called");
        }
        String s = this.isNull() ? null : Float.toString(this.value);
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: toString() exited");
        }
        return s;
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromString() called");
        }
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Float.valueOf(str.trim()).floatValue();
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmallFloat: fromString() called");
        }
    }

    static boolean isIfxNull(float f) {
        byte[] b = JavaToIfxType.JavaToIfxReal(f);
        return IfxSmallFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        return IfxSmallFloat.isIfxNull(b, 0, b.length);
    }

    static boolean isIfxNull(byte[] b, int offset, int length) {
        for (int i = 0; i < 4; ++i) {
            if (b[i + offset] == -1) continue;
            return false;
        }
        return true;
    }

    static float getIfxNull() {
        byte[] b = new byte[4];
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            b[i] = -1;
            f = IfxToJavaType.IfxToJavaReal(b);
        }
        return f;
    }
}

