/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.IfxCsmException;
import com.informix.csm.crypto.IfxCHash;
import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoSession;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import com.informix.csm.crypto.IfxEncPkt;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class IfxCryptoEngine {
    static final String PKCS5PADDINGSCHEME = "PKCS5Padding";
    static final String NOPADDINGSCHEME = "NoPadding";
    static final String TRANSFORM_SEPARATOR = "/";
    private static final String DH_ALGO = "DH";
    private static final String DH_MODULUS_string = "CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7";
    private static final BigInteger DH_MODULUS = new BigInteger("CB4AAD9AD0B42AF666B42B57463C7325B781EFA79B5063AB0CCE98D23B3AA975475549A99E3E75EC1DBC9503CD6C1303BA6184FC769ED599966DA4BD84558EB7", 16);
    private static final BigInteger DH_GENERATOR = BigInteger.valueOf(5L);
    static DHParameterSpec dhParamSpec = null;
    static KeyPairGenerator dhKeyPairGenerator = null;
    static KeyFactory dhKeyFactory = null;
    static final int ENCRYPT = 1;
    static final int DECRYPT = 2;
    private static final int DESX_KEY_LENGTH = 16;
    private static final int RC5_WORD_SIZE = 64;
    private static final int RC5_VERSION = 3;
    Cipher cipher;
    IfxEDPkt edPkt = null;
    int mode;
    IfxCipherElem cryptoEngineCipherElem;

    IfxCryptoEngine(IfxEncPkt encPkt, int mode) throws IfxCsmException {
        this.mode = mode;
        this.edPkt = mode == 1 ? encPkt.Encrypt : encPkt.Decrypt;
        this.cryptoEngineCipherElem = this.getCipherElem();
        this.instantiateCipher();
    }

    void initCipher() throws IfxCsmException {
        IfxCHash.generateHash(this.edPkt.IV, this.getBlockSize(), this.edPkt.SecretKey);
        this.initCipher(this.mode, this.cryptoEngineCipherElem, this.edPkt.SecretKey, this.edPkt.IV.Hash);
    }

    private void initCipher(int mode, IfxCipherElem cipherElem, byte[] secretKey, byte[] IV) throws IfxCsmException {
        try {
            switch (cipherElem.getCipherType()) {
                case 1: {
                    IvParameterSpec iv = new IvParameterSpec(IV);
                    SecretKeySpec desSecretKeySpec = new SecretKeySpec(secretKey, 0, 8, cipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(mode, (Key)desSecretKeySpec, iv);
                    break;
                }
                case 2: 
                case 8: {
                    IvParameterSpec iv = new IvParameterSpec(IV);
                    SecretKeySpec desEdeSecretKeySpec = new SecretKeySpec(secretKey, 0, 24, cipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(mode, (Key)desEdeSecretKeySpec, iv);
                    break;
                }
                case 3: {
                    IvParameterSpec iv = new IvParameterSpec(IV);
                    SecretKeySpec desXSecretKeySpec = new SecretKeySpec(secretKey, 0, 16, cipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(mode, (Key)desXSecretKeySpec, iv);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    IvParameterSpec iv = new IvParameterSpec(IV);
                    SecretKeySpec blowFishSecretKeySpec = new SecretKeySpec(secretKey, 0, cipherElem.getCipher().getKeySize(), cipherElem.getCipher().getAlgorithmName());
                    this.cipher.init(mode, (Key)blowFishSecretKeySpec, iv);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    SecretKeySpec rc2SecretKeySpec = new SecretKeySpec(secretKey, 0, cipherElem.getCipher().getKeySize(), cipherElem.getCipher().getAlgorithmName());
                    RC2ParameterSpec rc2Param = new RC2ParameterSpec(cipherElem.getCipher().getRC2Key(), IV);
                    this.cipher.init(mode, (Key)rc2SecretKeySpec, rc2Param);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    SecretKeySpec rc5SecretKeySpec = new SecretKeySpec(secretKey, 0, cipherElem.getCipher().getKeySize(), cipherElem.getCipher().getAlgorithmName());
                    RC5ParameterSpec rc5Param = new RC5ParameterSpec(3, cipherElem.getCipher().getRC5Rounds(), 64, IV);
                    this.cipher.init(mode, (Key)rc5SecretKeySpec, rc5Param);
                    break;
                }
            }
        }
        catch (InvalidKeyException ex) {
            throw IfxCryptoSession.getCsmErrException(-10, ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw IfxCryptoSession.getCsmErrException(-10, ex);
        }
    }

    byte[] updateCipher(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    byte[] updateCipher(byte[] input) {
        return this.cipher.update(input);
    }

    byte[] doFinal() throws IfxCsmException {
        try {
            return this.cipher.doFinal();
        }
        catch (IllegalStateException ex) {
            throw this.getGenericEDecryptException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw this.getGenericEDecryptException(ex);
        }
        catch (BadPaddingException ex) {
            throw this.getGenericEDecryptException(ex);
        }
    }

    byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IfxCsmException {
        try {
            return this.cipher.doFinal(input, inputOffset, inputLen);
        }
        catch (BadPaddingException ex) {
            throw this.getGenericEDecryptException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw this.getGenericEDecryptException(ex);
        }
        catch (IllegalStateException ex) {
            throw this.getGenericEDecryptException(ex);
        }
    }

    byte[] doFinal(byte[] input) throws IfxCsmException {
        return this.doFinal(input, 0, input.length);
    }

    int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    private void instantiateCipher() throws IfxCsmException {
        try {
            this.cipher = Cipher.getInstance(this.cryptoEngineCipherElem.getTransformString());
        }
        catch (Exception ex1) {
            try {
                this.cipher = Cipher.getInstance(this.cryptoEngineCipherElem.getTransformString());
            }
            catch (NoSuchAlgorithmException ex) {
                throw IfxCryptoSession.getCsmErrException(-10, ex);
            }
            catch (NoSuchPaddingException ex) {
                throw IfxCryptoSession.getCsmErrException(-10, ex);
            }
        }
    }

    static byte[] generateHMAC(byte[] input, IfxEDPkt edPkt) throws IfxCsmException {
        IfxCHash.generateHash(edPkt.MAC, 36, edPkt.MacKey);
        return IfxCryptoEngine.internalGenerateHMAC(edPkt.MAC.Hash, input, 0, input.length);
    }

    static byte[] internalGenerateHMAC(byte[] key, byte[] input) throws IfxCsmException {
        return IfxCryptoEngine.internalGenerateHMAC(key, input, 0, input.length);
    }

    static byte[] internalGenerateHMAC(byte[] key, byte[] input, int offset, int len) throws IfxCsmException {
        SecretKeySpec spec = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance(spec.getAlgorithm());
            mac.init(spec);
        }
        catch (NoSuchAlgorithmException ex) {
            throw IfxCryptoSession.getCsmErrException(-12, ex);
        }
        catch (InvalidKeyException ex) {
            throw IfxCryptoSession.getCsmErrException(-12, ex);
        }
        mac.update(input, offset, len);
        return mac.doFinal();
    }

    private IfxCsmException getGenericEDecryptException(Exception ex) {
        if (this.mode == 1) {
            return IfxCryptoSession.getCsmErrException(-6, ex);
        }
        return IfxCryptoSession.getCsmErrException(-7, ex);
    }

    static KeyAgreement generateDHKeyAgreement() throws IfxCsmException {
        KeyAgreement dh = null;
        try {
            dh = KeyAgreement.getInstance(DH_ALGO);
        }
        catch (Exception e) {
            try {
                dh = KeyAgreement.getInstance(DH_ALGO);
            }
            catch (NoSuchAlgorithmException ex) {
                throw IfxCryptoSession.getCsmErrException(-4, ex);
            }
        }
        return dh;
    }

    static byte[] generatePublicKey(IfxEncPkt encPkt) throws IfxCsmException {
        if (encPkt.DH == null) {
            encPkt.DH = IfxCryptoEngine.generateDHKeyAgreement();
        }
        return IfxCryptoEngine.generatePublicKey(encPkt.DH);
    }

    static byte[] generatePublicKey(IfxEDPkt edPkt) throws IfxCsmException {
        if (edPkt.DH == null) {
            edPkt.DH = IfxCryptoEngine.generateDHKeyAgreement();
        }
        return IfxCryptoEngine.generatePublicKey(edPkt.DH);
    }

    static synchronized byte[] generatePublicKey(KeyAgreement DH) throws IfxCsmException {
        if (dhKeyPairGenerator == null) {
            if (dhParamSpec == null) {
                dhParamSpec = new DHParameterSpec(DH_MODULUS, DH_GENERATOR);
            }
            try {
                dhKeyPairGenerator = KeyPairGenerator.getInstance(DH_ALGO);
                dhKeyPairGenerator.initialize(dhParamSpec);
            }
            catch (Exception e) {
                try {
                    dhKeyPairGenerator = KeyPairGenerator.getInstance(DH_ALGO);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw IfxCryptoSession.getCsmErrException(-4, ex);
                }
            }
        }
        KeyPair dhKeyPair = dhKeyPairGenerator.genKeyPair();
        DHPublicKey dhPubKey = (DHPublicKey)dhKeyPair.getPublic();
        try {
            DH.init(dhKeyPair.getPrivate());
        }
        catch (InvalidKeyException ex) {
            throw IfxCryptoSession.getCsmErrException(-4, ex);
        }
        BigInteger Y = dhPubKey.getY();
        return IfxCryptoUtils.bigIntegerToBinary(Y);
    }

    static byte[] acceptPublicKey(KeyAgreement DH, byte[] serverPubKeyBytes) throws IfxCsmException {
        if (dhKeyFactory == null) {
            try {
                dhKeyFactory = KeyFactory.getInstance(DH_ALGO);
            }
            catch (NoSuchAlgorithmException ex) {
                throw IfxCryptoSession.getCsmErrException(-5, ex);
            }
        }
        BigInteger Y = IfxCryptoUtils.binaryToBigInteger(serverPubKeyBytes);
        DHPublicKeySpec dhPkeySpec = new DHPublicKeySpec(Y, DH_MODULUS, DH_GENERATOR);
        PublicKey serverPubKey = null;
        try {
            serverPubKey = dhKeyFactory.generatePublic(dhPkeySpec);
        }
        catch (InvalidKeySpecException ex) {
            throw IfxCryptoSession.getCsmErrException(-5, ex);
        }
        try {
            DH.doPhase(serverPubKey, true);
        }
        catch (InvalidKeyException ex) {
            throw IfxCryptoSession.getCsmErrException(-5, ex);
        }
        catch (IllegalStateException ex) {
            throw IfxCryptoSession.getCsmErrException(-5, ex);
        }
        return DH.generateSecret();
    }

    private IfxCipherElem getCipherElem() {
        IfxCipherElem elem = this.edPkt.cipherElem;
        return elem;
    }
}

