/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class HeaderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final URLCodec CODEC = new URLCodec("UTF-8");

    public static Map<String, String> getHeaders(HttpServletRequest servletRequest) {
        Enumeration headerNames = servletRequest.getHeaderNames();
        LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = servletRequest.getHeaders(headerName);
            if (!headerValues.hasMoreElements()) continue;
            result.put(headerName, headerValues.nextElement());
        }
        return result;
    }

    public static Map<String, String> deserialize(String content) {
        if (!StringUtils.isEmpty((CharSequence)content)) {
            try {
                String json = CODEC.decode(content);
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (Exception e) {
                LOGGER.error("Create invocation context failed, build an empty one.", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public static String serialize(Map<String, String> content) {
        try {
            String json = MAPPER.writeValueAsString(content);
            return CODEC.encode(json);
        }
        catch (Exception e) {
            LOGGER.error("Serialize invocation context failed, build an empty one.", (Throwable)e);
            return "";
        }
    }
}

