/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.util;

import com.huaweicloud.common.util.Cipher;
import java.util.List;

public final class DefaultCipher
implements Cipher {
    public static final String CIPHER_NAME = "default";
    private static final DefaultCipher INSTANCE = new DefaultCipher();

    public static DefaultCipher getInstance() {
        return INSTANCE;
    }

    private DefaultCipher() {
    }

    @Override
    public String name() {
        return CIPHER_NAME;
    }

    @Override
    public char[] decrypt(char[] encrypted) {
        return encrypted;
    }

    public static Cipher findCipher(List<Cipher> ciphers, String cipher) {
        if (CIPHER_NAME.equals(cipher)) {
            return DefaultCipher.getInstance();
        }
        if (ciphers == null) {
            throw new IllegalArgumentException("failed to find cipher named " + cipher);
        }
        return ciphers.stream().filter(c -> c.name().equals(cipher)).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + cipher));
    }
}

