/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import com.huaweicloud.common.configration.bootstrap.ServiceCombAkSkProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpUtils;

public class AkSkRequestAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String X_SERVICE_AK = "X-Service-AK";
    public static final String X_SERVICE_SHA_AKSK = "X-Service-ShaAKSK";
    public static final String X_SERVICE_PROJECT = "X-Service-Project";
    private final ServiceCombAkSkProperties serviceCombAkSkProperties;

    public AkSkRequestAuthHeaderProvider(ServiceCombAkSkProperties serviceCombAkSkProperties) {
        this.serviceCombAkSkProperties = serviceCombAkSkProperties;
    }

    public Map<String, String> authHeaders() {
        if (AkSkRequestAuthHeaderProvider.isAKSKNotEnabled(this.serviceCombAkSkProperties)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(X_SERVICE_AK, this.serviceCombAkSkProperties.getAccessKey());
        headers.put(X_SERVICE_SHA_AKSK, this.serviceCombAkSkProperties.getSecretKey());
        headers.put(X_SERVICE_PROJECT, this.encode(this.serviceCombAkSkProperties.getProject()));
        return headers;
    }

    private String encode(String content) {
        try {
            return HttpUtils.encodeURLParam((String)content);
        }
        catch (IOException e) {
            return content;
        }
    }

    private static boolean isAKSKNotEnabled(ServiceCombAkSkProperties serviceCombAkSkProperties) {
        return serviceCombAkSkProperties == null || serviceCombAkSkProperties.isEmpty() || !serviceCombAkSkProperties.isEnabled();
    }
}

